/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.TempMetadataBuilder;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.platform.commons.support.AnnotationSupport;

public class MetadataExtension
implements BeforeEachCallback,
BeforeAllCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MetadataExtension.class});
    private static final String METADATA_INFO_KEY = "MetadataInfo";

    public void beforeAll(ExtensionContext context) throws Exception {
        this.readFromAnnotation(context.getElement()).ifPresent(x -> context.getStore(NAMESPACE).put((Object)METADATA_INFO_KEY, x));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.run(context, null);
    }

    private Optional<MetadataResource> readFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, MetadataInfo.class).map(MetadataResource::of);
    }

    private void run(ExtensionContext context, InvocationInterceptor.Invocation<Void> invocation) throws Throwable {
        this.readFromAnnotation(context.getElement()).orElse((MetadataResource)context.getStore(NAMESPACE).get((Object)METADATA_INFO_KEY, MetadataResource.class)).get();
        if (invocation != null) {
            invocation.proceed();
        }
    }

    private static class MetadataResource
    implements ExtensionContext.Store.CloseableResource {
        private TempMetadataBuilder metadataBuilder;
        private File tempMetadataDirectory;

        static MetadataResource of(MetadataInfo info) {
            MetadataResource resource = new MetadataResource();
            resource.metadataBuilder = TempMetadataBuilder.createBuilder((List)Lists.newArrayList((Object[])info.overlay()));
            resource.metadataBuilder.setProject(info.project());
            resource.metadataBuilder.setOnlyProps(info.onlyProps());
            return resource;
        }

        public File get() {
            String tempMetadataDir = this.metadataBuilder.build();
            KylinConfig.setKylinConfigForLocalTest((String)tempMetadataDir);
            this.tempMetadataDirectory = new File(tempMetadataDir);
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            MetadataResource.cleanSingletonInstances();
            String kylinHomePath = new File(MetadataResource.getTestConfig().getMetadataUrl().toString()).getParentFile().getAbsolutePath();
            SystemPropertiesCache.setProperty((String)"KYLIN_HOME", (String)kylinHomePath);
            File jobJar = org.apache.kylin.common.util.FileUtils.findFile((String)new File(kylinHomePath, "../../../assembly/target/").getAbsolutePath(), (String)"kylin-assembly(.?)\\.jar");
            KylinConfig testConfig = MetadataResource.getTestConfig();
            testConfig.setProperty("kylin.engine.spark.job-jar", jobJar == null ? "" : jobJar.getAbsolutePath());
            testConfig.setProperty("kylin.query.security.acl-tcr-enabled", "false");
            return this.tempMetadataDirectory;
        }

        public void close() throws Throwable {
            MetadataResource.cleanSingletonInstances();
            MetadataResource.clearTestConfig();
            SystemPropertiesCache.clearProperty((String)"KYLIN_HOME");
            QueryContext.reset();
            FileUtils.deleteQuietly((File)this.tempMetadataDirectory);
        }

        private static void cleanSingletonInstances() {
            try {
                MetadataResource.getInstances().clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MetadataResource.getGlobalInstances().clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MetadataResource.getInstancesFromSingleton().clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MetadataResource.getInstanceByProjectFromSingleton().clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MetadataResource.getInstanceByProject().clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static ConcurrentHashMap<Class, ConcurrentHashMap<String, Object>> getInstanceByProjectFromSingleton() throws Exception {
            Field instanceField = Singletons.class.getDeclaredField("instance");
            Unsafe.changeAccessibleObject((AccessibleObject)instanceField, (boolean)true);
            Field field = Singletons.class.getDeclaredField("instancesByPrj");
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            ConcurrentHashMap result = (ConcurrentHashMap)field.get(instanceField.get(null));
            if (result == null) {
                field.set(instanceField.get(null), Maps.newConcurrentMap());
            }
            return (ConcurrentHashMap)field.get(instanceField.get(null));
        }

        static ConcurrentHashMap<Class, ConcurrentHashMap<String, Object>> getInstanceByProject() throws Exception {
            Field singletonField = MetadataResource.getTestConfig().getClass().getDeclaredField("singletons");
            Unsafe.changeAccessibleObject((AccessibleObject)singletonField, (boolean)true);
            Field field = Singletons.class.getDeclaredField("instancesByPrj");
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            return (ConcurrentHashMap)field.get(singletonField.get(MetadataResource.getTestConfig()));
        }

        static ConcurrentHashMap<Class, Object> getInstancesFromSingleton() throws Exception {
            Field instanceField = Singletons.class.getDeclaredField("instance");
            Unsafe.changeAccessibleObject((AccessibleObject)instanceField, (boolean)true);
            Field field = Singletons.class.getDeclaredField("instancesByPrj");
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            ConcurrentHashMap result = (ConcurrentHashMap)field.get(instanceField.get(null));
            if (result == null) {
                field.set(instanceField.get(null), Maps.newConcurrentMap());
            }
            return (ConcurrentHashMap)field.get(instanceField.get(null));
        }

        static ConcurrentHashMap<Class, Object> getInstances() throws Exception {
            Field singletonField = MetadataResource.getTestConfig().getClass().getDeclaredField("singletons");
            Unsafe.changeAccessibleObject((AccessibleObject)singletonField, (boolean)true);
            Field filed = Singletons.class.getDeclaredField("instances");
            Unsafe.changeAccessibleObject((AccessibleObject)filed, (boolean)true);
            return (ConcurrentHashMap)filed.get(singletonField.get(MetadataResource.getTestConfig()));
        }

        static ConcurrentHashMap<Class, Object> getGlobalInstances() throws Exception {
            Field instanceFiled = Singletons.class.getDeclaredField("instance");
            Unsafe.changeAccessibleObject((AccessibleObject)instanceFiled, (boolean)true);
            Singletons instanceSingle = (Singletons)instanceFiled.get(instanceFiled);
            Field instancesField = instanceSingle.getClass().getDeclaredField("instances");
            Unsafe.changeAccessibleObject((AccessibleObject)instancesField, (boolean)true);
            return (ConcurrentHashMap)instancesField.get(instanceSingle);
        }

        static KylinConfig getTestConfig() {
            return KylinConfig.getInstanceFromEnv();
        }

        static void clearTestConfig() {
            try {
                ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            KylinConfig.destroyInstance();
        }

        @Generated
        public MetadataResource() {
        }
    }
}

