/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.ZipFileUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZipFileUtilTest {
    @Test
    public void testCompressAndDecompressZipFile(@TempDir File tempDir) throws IOException {
        String mainDir = tempDir.getAbsolutePath() + "/testCompressZipFile";
        File compressDir = new File(mainDir, "compress_dir");
        FileUtils.forceMkdir((File)compressDir);
        FileUtils.writeStringToFile((File)new File(compressDir, "a.txt"), (String)"111111111111");
        FileUtils.writeStringToFile((File)new File(compressDir, "b.txt"), (String)"222222222222");
        FileUtils.forceMkdir((File)new File(compressDir, "c"));
        FileUtils.writeStringToFile((File)new File(compressDir, "c/c1.txt"), (String)"333333333333");
        String zipFilename = compressDir.getAbsolutePath() + ".zip";
        ZipFileUtils.compressZipFile((String)compressDir.getAbsolutePath(), (String)zipFilename);
        Assert.assertTrue((new File(zipFilename).exists() && new File(zipFilename).length() > 200L ? 1 : 0) != 0);
        File decompressDir = new File(mainDir, "decompress_dir");
        FileUtils.forceMkdir((File)decompressDir);
        ZipFileUtils.decompressZipFile((String)zipFilename, (String)decompressDir.getAbsolutePath());
        File aFile = new File(decompressDir.getAbsolutePath(), "compress_dir/a.txt");
        File c1File = new File(decompressDir.getAbsolutePath(), "compress_dir/c/c1.txt");
        Assert.assertTrue((boolean)aFile.exists());
        Assert.assertEquals((Object)"111111111111", (Object)FileUtils.readFileToString((File)aFile));
        Assert.assertEquals((Object)"333333333333", (Object)FileUtils.readFileToString((File)c1File));
    }

    @Test
    public void testCompressEmptyDirZipFile(@TempDir File tempDir) throws IOException {
        String mainDir = tempDir.getAbsolutePath() + "/testCompressZipFile";
        File compressDir = new File(mainDir, "compress_dir");
        FileUtils.forceMkdir((File)compressDir);
        FileUtils.writeStringToFile((File)new File(compressDir, "a.txt"), (String)"111111111111");
        FileUtils.writeStringToFile((File)new File(compressDir, "b.txt"), (String)"222222222222");
        File emptyDirectory = new File(compressDir, "empty_directory");
        emptyDirectory.mkdir();
        String zipFilename = compressDir.getAbsolutePath() + ".zip";
        ZipFileUtils.compressZipFile((String)compressDir.getAbsolutePath(), (String)zipFilename);
        long fileCount = new ZipFile(zipFilename).stream().count();
        Assert.assertEquals((long)3L, (long)fileCount);
    }
}

