/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.junit.annotation.MultiTimezoneTest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;

public class DateFormatTest {
    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void testIsSupportedDateFormat() {
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"20100101"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010/01/01"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010.01.01"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01 01:01:01"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01 01:00:00.000"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01 01:00:00.1"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01T01:01:01.000Z"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010-1-1"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010/1/1"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010.1.1"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010-1-1 01:01:01"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010-1-1 01:00:00.000"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2010-01-01 1:1:1"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"abc"));
    }

    @MultiTimezoneTest(timezones={"GMT+8", "America/Chicago"})
    public void testGetFormattedDate() {
        String testDate = "2010-01-01";
        String zoneId = ZoneId.systemDefault().getId();
        String correctTime = null;
        switch (zoneId) {
            case "GMT+08:00": {
                correctTime = "1262275200000";
                break;
            }
            case "America/Chicago": {
                correctTime = "1262325600000";
                break;
            }
            case "America/Los_Angeles": {
                correctTime = "1262332800000";
                break;
            }
            case "UTC": {
                correctTime = "1262304000000";
                break;
            }
            default: {
                Assert.fail((String)("can not find the zoneId: " + zoneId));
            }
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        Date date = DateTime.parse((String)testDate, (DateTimeFormatter)dateTimeFormatter).withZone(DateTimeZone.getDefault()).toLocalDateTime().toDate();
        Assert.assertEquals((Object)correctTime, (Object)String.valueOf(date.getTime()));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"20100101", (String)"yyyyMMdd"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01-01", (String)"yyyy-MM-dd"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010/01/01", (String)"yyyy/MM/dd"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010.01.01", (String)"yyyy.MM.dd"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01-01 00:00:00.000", (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        Assert.assertNotEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01-01 02:02:02", (String)"yyyy-MM-dd HH:mm:ss"));
        Assert.assertNotEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01-01 02:02:02.333", (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"201001", (String)"yyyyMM"));
        Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"2010-01", (String)"yyyy-MM"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020-05-01 01:01:01.333"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020/05/01 01:01:01.333"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020.05.01 01:01:01.333"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020-05-01 01:01:01:333"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020/05/01 01:01:01:333"));
        Assert.assertTrue((boolean)DateFormat.isSupportedDateFormat((String)"2020.05.01 01:01:01:333"));
        Assert.assertFalse((boolean)DateFormat.isSupportedDateFormat((String)"2020 05 01 01:01:01:333"));
        try {
            Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"18:18", (String)"HH:mm"));
            Assert.fail();
        }
        catch (DateTimeException dateTimeException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"18:18:18", (String)"HH:mm:ss"));
            Assert.fail();
        }
        catch (DateTimeException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            Assert.assertEquals((Object)String.valueOf(date.getTime()), (Object)DateFormat.getFormattedDate((String)"18:18:18:888", (String)"HH:mm:ss:SSS"));
            Assert.fail();
        }
        catch (DateTimeException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        for (String tDate : Arrays.asList("20100101", "2010/01/01", "2010.01.01", "18:18:18", "18:18:18.888", "18:18", "2010-01-01 ", "2010-01-01 02:02:02", "2010-01-01 02:02:02.333", "2010-01-0", "010-01-01", "2010", "2010-01", "-2010-01-01")) {
            try {
                DateFormat.getFormattedDate((String)tDate, (String)"yyyy-MM-dd");
                Assert.fail();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
        for (String tDate : Arrays.asList("20100101", "2010/01/01", "2010.01.01", "18:18:18", "18:18:18.888", "18:18", "2010-01-01 00", "2010-01-01 02:02", "2010-01-01 02:02.333", "2010-01-0", "010-01-01", "2010", "2010-01", "-2010-01-01")) {
            try {
                DateFormat.getFormattedDate((String)tDate, (String)"yyyy-MM-dd HH:mm:ss");
                Assert.fail();
            }
            catch (DateTimeParseException e) {
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testStringToMillis() {
        long expectedMillis = 1669824000000L;
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
        boolean timeZone = false;
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01 00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"202212", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01 00:00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01 00:00:00:000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01 00:00:00:000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01 00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01 00:00:00.000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01 00:00:00:000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201 00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01 00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201 00:00:00:000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201 00:00:00", (boolean)timeZone));
    }

    @Test
    public void testStringToMillisSupplement() {
        long expectedMillis = 1669824000000L;
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
        boolean timeZone = false;
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01 00:00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201T00:00:00.000Z", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01T00:00:00.000Z", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01 00:00:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"20221201 00:00:00.000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01T00:00:00.000Z", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01T00:00:00.000Z", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022.12.01 00:00:00.000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022-12-01T00:00:00.000+08:00", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"2022/12/01 00:00:00.000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"1669824000000000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"1669824000000", (boolean)timeZone));
        Assert.assertEquals((long)expectedMillis, (long)DateFormat.stringToMillis((String)"1669824000", (boolean)timeZone));
    }

    @Test
    public void testUnsupportedStringToMillis() {
        Assert.assertThrows(KylinException.class, () -> DateFormat.stringToMillis((String)"12/01"));
        Assert.assertThrows(KylinException.class, () -> DateFormat.stringToMillis((String)"-12345"));
    }
}

