/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.metadata.cube.cuboid.CuboidStatus;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;

public class IndicesResponse {
    public static final String STORAGE_SIZE = "storage_size";
    public static final String QUERY_HIT_COUNT = "query_hit_count";
    public static final String LAST_MODIFY_TIME = "last_modify_time";
    @JsonProperty(value="start_time")
    private long startTime;
    @JsonProperty(value="end_time")
    private long endTime;
    @JsonProperty(value="indices")
    private List<Index> indices = Lists.newArrayList();
    @JsonProperty(value="size")
    private int size;
    @JsonIgnore
    private IndexPlan indexPlan;
    @JsonIgnore
    private NDataflow dataFlow;
    @JsonIgnore
    private Segments<NDataSegment> nonNewSegments;
    @JsonIgnore
    private boolean isAnySegReady;

    @JsonIgnore
    public boolean isAnySegReady() {
        return this.isAnySegReady;
    }

    @JsonIgnore
    public void setAnySegReady(boolean anySegReady) {
        this.isAnySegReady = anySegReady;
    }

    public IndicesResponse(IndexPlan indexPlan) {
        if (Objects.isNull(indexPlan)) {
            return;
        }
        this.indexPlan = indexPlan;
        this.dataFlow = NDataflowManager.getInstance((KylinConfig)indexPlan.getConfig(), (String)indexPlan.getProject()).getDataflow(indexPlan.getId());
        this.nonNewSegments = SegmentUtil.getSegmentsExcludeRefreshingAndMerging((Segments)this.dataFlow.getSegments()).stream().filter(seg -> SegmentStatusEnum.NEW != seg.getStatus()).collect(Collectors.toCollection(Segments::new));
        this.isAnySegReady = this.nonNewSegments.stream().map(NDataSegment::getStatus).anyMatch(status -> SegmentStatusEnum.READY == status);
        if (!this.isAnySegReady) {
            return;
        }
        this.startTime = Long.MAX_VALUE;
        for (NDataSegment seg2 : this.nonNewSegments) {
            long start = Long.parseLong(seg2.getSegRange().getStart().toString());
            long end = Long.parseLong(seg2.getSegRange().getEnd().toString());
            this.startTime = this.startTime < start ? this.startTime : start;
            this.endTime = this.endTime > end ? this.endTime : end;
        }
    }

    public boolean addIndexEntity(IndexEntity indexEntity) {
        if (Objects.isNull(this.indexPlan) || Objects.isNull(indexEntity)) {
            return false;
        }
        return this.indices.add(new Index(this, indexEntity));
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public List<Index> getIndices() {
        return this.indices;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    @Generated
    public NDataflow getDataFlow() {
        return this.dataFlow;
    }

    @Generated
    public Segments<NDataSegment> getNonNewSegments() {
        return this.nonNewSegments;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setIndices(List<Index> indices) {
        this.indices = indices;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public void setIndexPlan(IndexPlan indexPlan) {
        this.indexPlan = indexPlan;
    }

    @Generated
    public void setDataFlow(NDataflow dataFlow) {
        this.dataFlow = dataFlow;
    }

    @Generated
    public void setNonNewSegments(Segments<NDataSegment> nonNewSegments) {
        this.nonNewSegments = nonNewSegments;
    }

    public static class Index {
        @JsonProperty(value="id")
        private long id;
        @JsonProperty(value="storage_size")
        private long storageSize;
        @JsonProperty(value="index_type")
        private String indexType;
        @JsonProperty(value="query_hit_count")
        private long queryHitCount;
        @JsonProperty(value="dimensions")
        private List<String> dimensions = Lists.newArrayList();
        @JsonProperty(value="measures")
        private List<String> measures = Lists.newArrayList();
        @JsonProperty(value="status")
        private CuboidStatus status = CuboidStatus.AVAILABLE;
        @JsonProperty(value="last_modify_time")
        private long lastModifiedTime;
        @JsonManagedReference
        @JsonProperty(value="layouts")
        private List<LayoutEntity> layouts = Lists.newArrayList();
        private static final String INDEX_TYPE_AUTO = "AUTO";
        private static final String INDEX_TYPE_MANUAL = "MANUAL";

        public Index(IndicesResponse indicesResponse, IndexEntity indexEntity) {
            this.setId(indexEntity.getId());
            this.setLayouts(indexEntity.getLayouts());
            this.setDimensionsAndMeasures(indexEntity);
            if (!indicesResponse.isAnySegReady()) {
                this.status = CuboidStatus.EMPTY;
                return;
            }
            for (NDataSegment segment : indicesResponse.getNonNewSegments()) {
                for (LayoutEntity layout : this.layouts) {
                    NDataLayout dataLayout = segment.getLayout(layout.getId());
                    if (Objects.isNull(dataLayout)) {
                        this.status = CuboidStatus.EMPTY;
                        return;
                    }
                    if (Objects.isNull(this.indexType) && layout.isAuto()) {
                        this.indexType = INDEX_TYPE_AUTO;
                    }
                    this.storageSize += dataLayout.getByteSize();
                }
            }
            this.indexType = Objects.isNull(this.indexType) ? INDEX_TYPE_MANUAL : this.indexType;
            this.lastModifiedTime = this.layouts.stream().map(LayoutEntity::getUpdateTime).max(Comparator.naturalOrder()).orElse(0L);
            Set layoutSet = this.layouts.stream().map(LayoutEntity::getId).collect(Collectors.toSet());
            FavoriteRuleManager ruleManager = FavoriteRuleManager.getInstance((String)indicesResponse.getDataFlow().getProject());
            Integer timeWindow = FavoriteRule.getTimeWindowLength((String)ruleManager.getValue("frequency_time_window"));
            this.queryHitCount = indicesResponse.getDataFlow().getLayoutHitCount().entrySet().stream().filter(entry -> layoutSet.contains(entry.getKey())).map(Map.Entry::getValue).mapToInt(hit -> hit.getFrequency(timeWindow)).sum();
        }

        private void setDimensionsAndMeasures(IndexEntity indexEntity) {
            ImmutableSet measureSet;
            ImmutableSet dimensionSet = indexEntity.getDimensionSet();
            if (!CollectionUtils.isEmpty((Collection)dimensionSet)) {
                for (TblColRef dimension : dimensionSet) {
                    this.dimensions.add(dimension.getName());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(measureSet = indexEntity.getMeasureSet()))) {
                for (NDataModel.Measure measure : measureSet) {
                    this.measures.add(measure.getName());
                }
            }
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public long getStorageSize() {
            return this.storageSize;
        }

        @Generated
        public String getIndexType() {
            return this.indexType;
        }

        @Generated
        public long getQueryHitCount() {
            return this.queryHitCount;
        }

        @Generated
        public List<String> getDimensions() {
            return this.dimensions;
        }

        @Generated
        public List<String> getMeasures() {
            return this.measures;
        }

        @Generated
        public CuboidStatus getStatus() {
            return this.status;
        }

        @Generated
        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Generated
        public List<LayoutEntity> getLayouts() {
            return this.layouts;
        }

        @Generated
        public void setId(long id) {
            this.id = id;
        }

        @Generated
        public void setStorageSize(long storageSize) {
            this.storageSize = storageSize;
        }

        @Generated
        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }

        @Generated
        public void setQueryHitCount(long queryHitCount) {
            this.queryHitCount = queryHitCount;
        }

        @Generated
        public void setDimensions(List<String> dimensions) {
            this.dimensions = dimensions;
        }

        @Generated
        public void setMeasures(List<String> measures) {
            this.measures = measures;
        }

        @Generated
        public void setStatus(CuboidStatus status) {
            this.status = status;
        }

        @Generated
        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Generated
        public void setLayouts(List<LayoutEntity> layouts) {
            this.layouts = layouts;
        }
    }
}

