/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.ToolUtil;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInfoExtractor
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInfoExtractor.class);
    private static final Option OPTION_DEST;
    private static final Option OPTION_COMPRESS;
    private static final Option OPTION_SUBMODULE;
    private static final Option OPTION_PACKAGETYPE;
    private static final String DEFAULT_PACKAGE_TYPE = "base";
    private static final String[] COMMIT_SHA1_FILES;
    protected CliCommandExecutor cmdExecutor;
    protected final Options options = new Options();
    protected String packageType;
    protected File exportDir;

    public AbstractInfoExtractor() {
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_COMPRESS);
        this.options.addOption(OPTION_SUBMODULE);
        this.options.addOption(OPTION_PACKAGETYPE);
        this.packageType = DEFAULT_PACKAGE_TYPE;
        this.cmdExecutor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String exportDest = optionsHelper.getOptionValue(this.options.getOption("destDir"));
        boolean shouldCompress = optionsHelper.hasOption(OPTION_COMPRESS) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_COMPRESS)) : true;
        boolean isSubmodule = optionsHelper.hasOption(OPTION_SUBMODULE) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_SUBMODULE)) : false;
        this.packageType = optionsHelper.getOptionValue(OPTION_PACKAGETYPE);
        if (this.packageType == null) {
            this.packageType = DEFAULT_PACKAGE_TYPE;
        }
        if (StringUtils.isEmpty(exportDest)) {
            throw new RuntimeException("destDir is not set, exit directly without extracting");
        }
        if (!exportDest.endsWith("/")) {
            exportDest = exportDest + "/";
        }
        String packageName = this.packageType.toLowerCase(Locale.ROOT) + "_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.ROOT).format(new Date());
        if (!isSubmodule && new File(exportDest).exists()) {
            exportDest = exportDest + packageName + "/";
        }
        this.exportDir = new File(exportDest);
        FileUtils.forceMkdir(this.exportDir);
        if (!isSubmodule) {
            this.dumpBasicDiagInfo();
        }
        this.executeExtract(optionsHelper, this.exportDir);
        if (shouldCompress) {
            File tempZipFile = Files.createTempFile(this.packageType + "_", ".zip", new FileAttribute[0]).toFile();
            File tempZipDir = new File(exportDest + packageName + "/");
            FileUtils.forceMkdir(tempZipDir);
            for (File file : this.exportDir.listFiles()) {
                if (file.getAbsolutePath().equals(tempZipDir.getAbsolutePath())) continue;
                if (file.isDirectory()) {
                    FileUtils.moveDirectoryToDirectory(file, tempZipDir, false);
                    continue;
                }
                FileUtils.moveFileToDirectory(file, tempZipDir, false);
            }
            ZipFileUtils.compressZipFile(this.exportDir.getAbsolutePath(), tempZipFile.getAbsolutePath());
            FileUtils.cleanDirectory(this.exportDir);
            File zipFile = new File(this.exportDir, packageName + ".zip");
            FileUtils.moveFile(tempZipFile, zipFile);
            exportDest = zipFile.getAbsolutePath();
            this.exportDir = new File(exportDest);
        }
        if (!isSubmodule) {
            StringBuffer output = new StringBuffer();
            output.append("\n========================================");
            output.append("\nDump " + this.packageType + " package locates at: \n" + this.exportDir.getAbsolutePath());
            output.append("\n========================================");
            logger.info(output.toString());
            System.out.println(output.toString());
        }
    }

    private void dumpBasicDiagInfo() throws IOException {
        try {
            for (String commitSHA1File : COMMIT_SHA1_FILES) {
                File commitFile = new File(KylinConfig.getKylinHome(), commitSHA1File);
                if (!commitFile.exists()) continue;
                FileUtils.copyFileToDirectory(commitFile, this.exportDir);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to copy commit_SHA1 file.", e);
        }
        String output = KylinVersion.getKylinClientInformation() + "\n";
        FileUtils.writeStringToFile(new File(this.exportDir, "kylin_env"), output, Charset.defaultCharset());
        StringBuilder basicSb = new StringBuilder();
        basicSb.append("MetaStoreID: ").append(ToolUtil.getMetaStoreId()).append("\n");
        basicSb.append("PackageType: ").append(this.packageType.toUpperCase(Locale.ROOT)).append("\n");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
        basicSb.append("PackageTimestamp: ").append(format.format(new Date())).append("\n");
        basicSb.append("Host: ").append(ToolUtil.getHostName()).append("\n");
        FileUtils.writeStringToFile(new File(this.exportDir, "info"), basicSb.toString(), Charset.defaultCharset());
    }

    protected abstract void executeExtract(OptionsHelper var1, File var2) throws Exception;

    public String getExportDest() {
        return this.exportDir.getAbsolutePath();
    }

    public static String getKylinPid() {
        File pidFile = new File(AbstractInfoExtractor.getKylinHome(), "pid");
        if (pidFile.exists()) {
            try {
                return FileUtils.readFileToString(pidFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading KYLIN PID file.", e);
            }
        }
        throw new RuntimeException("Cannot find KYLIN PID file.");
    }

    public static String getKylinHome() {
        String path = System.getProperty("KYLIN_CONF");
        if (StringUtils.isNotEmpty(path)) {
            return path;
        }
        path = KylinConfig.getKylinHome();
        if (StringUtils.isNotEmpty(path)) {
            return path;
        }
        throw new RuntimeException("Cannot find KYLIN_HOME.");
    }

    public void addFile(File srcFile, File destDir) {
        logger.info("copy file " + srcFile.getName());
        try {
            FileUtils.forceMkdir(destDir);
        }
        catch (IOException e) {
            logger.error("Can not create" + destDir, e);
        }
        File destFile = new File(destDir, srcFile.getName());
        String copyCmd = String.format(Locale.ROOT, "cp -rL %s %s", srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        logger.info("The command is: " + copyCmd);
        try {
            this.cmdExecutor.execute(copyCmd);
        }
        catch (Exception e) {
            logger.debug("Failed to execute copyCmd", e);
        }
    }

    static {
        OptionBuilder.withArgName((String)"destDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the dest dir to save the related information");
        OPTION_DEST = OptionBuilder.create((String)"destDir");
        OptionBuilder.withArgName((String)"compress");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify whether to compress the output with zip. Default true.");
        OPTION_COMPRESS = OptionBuilder.create((String)"compress");
        OptionBuilder.withArgName((String)"submodule");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify whether this is a submodule of other CLI tool");
        OPTION_SUBMODULE = OptionBuilder.create((String)"submodule");
        OptionBuilder.withArgName((String)"packagetype");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify the package type");
        OPTION_PACKAGETYPE = OptionBuilder.create((String)"packagetype");
        COMMIT_SHA1_FILES = new String[]{"commit_SHA1", "commit.sha1"};
    }
}

