/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTStreamAggregateScanner;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.UnmodifiableIterator;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.CubeSegmentScanner;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryBase;
import org.apache.kylin.storage.gtrecord.ITupleConverter;
import org.apache.kylin.storage.gtrecord.SortMergedPartitionResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(deprecated=true, msg="Only for HBase storage")
public class SegmentCubeTupleIterator
implements ITupleIterator {
    private static final Logger logger = LoggerFactory.getLogger(SegmentCubeTupleIterator.class);
    protected final CubeSegmentScanner scanner;
    protected final Cuboid cuboid;
    protected final Set<TblColRef> selectedDimensions;
    protected final Set<FunctionDesc> selectedMetrics;
    protected final TupleInfo tupleInfo;
    protected final Tuple tuple;
    protected final StorageContext context;
    protected Iterator<Object[]> gtValues;
    protected ITupleConverter cubeTupleConverter;
    protected Tuple next;
    private List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    private int advMeasureRowsRemaining;
    private int advMeasureRowIndex;

    public SegmentCubeTupleIterator(CubeSegmentScanner scanner, Cuboid cuboid, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, TupleInfo returnTupleInfo, StorageContext context) {
        this.scanner = scanner;
        this.cuboid = cuboid;
        this.selectedDimensions = selectedDimensions;
        this.selectedMetrics = selectedMetrics;
        this.tupleInfo = returnTupleInfo;
        this.tuple = new Tuple(returnTupleInfo);
        this.context = context;
        CuboidToGridTableMapping mapping = context.getMapping();
        int[] gtDimsIdx = mapping.getDimIndexes(selectedDimensions);
        int[] gtMetricsIdx = mapping.getMetricsIndexes(selectedMetrics);
        int[] gtColIdx = new int[gtDimsIdx.length + gtMetricsIdx.length];
        System.arraycopy(gtDimsIdx, 0, gtColIdx, 0, gtDimsIdx.length);
        System.arraycopy(gtMetricsIdx, 0, gtColIdx, gtDimsIdx.length, gtMetricsIdx.length);
        this.gtValues = this.getGTValuesIterator(scanner.iterator(), scanner.getScanRequest(), gtDimsIdx, gtMetricsIdx);
        this.cubeTupleConverter = ((GTCubeStorageQueryBase)context.getStorageQuery()).newCubeTupleConverter(scanner.cubeSeg, cuboid, selectedDimensions, selectedMetrics, gtColIdx, this.tupleInfo);
    }

    private Iterator<Object[]> getGTValuesIterator(final Iterator<GTRecord> records, final GTScanRequest scanRequest, final int[] gtDimsIdx, final int[] gtMetricsIdx) {
        boolean hasMultiplePartitions = records instanceof SortMergedPartitionResultIterator;
        if (hasMultiplePartitions && this.context.isStreamAggregateEnabled()) {
            Iterator<Object[]> result;
            logger.info("Using GTStreamAggregateScanner to pre-aggregate storage partition.");
            IGTScanner inputScanner = new IGTScanner(){

                @Override
                public GTInfo getInfo() {
                    return scanRequest.getInfo();
                }

                @Override
                public void close() {
                }

                @Override
                public Iterator<GTRecord> iterator() {
                    return records;
                }
            };
            try (GTStreamAggregateScanner aggregator = new GTStreamAggregateScanner(inputScanner, scanRequest);){
                result = aggregator.valuesIterator(gtDimsIdx, gtMetricsIdx);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("IOException is not expected here.", ioe);
            }
            return result;
        }
        return new UnmodifiableIterator<Object[]>(){
            Object[] result;
            {
                this.result = new Object[gtDimsIdx.length + gtMetricsIdx.length];
            }

            @Override
            public boolean hasNext() {
                return records.hasNext();
            }

            @Override
            public Object[] next() {
                int i;
                GTRecord record = (GTRecord)records.next();
                for (i = 0; i < gtDimsIdx.length; ++i) {
                    this.result[i] = record.decodeValue(gtDimsIdx[i]);
                }
                for (i = 0; i < gtMetricsIdx.length; ++i) {
                    this.result[gtDimsIdx.length + i] = record.decodeValue(gtMetricsIdx[i]);
                }
                return this.result;
            }
        };
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.advMeasureRowsRemaining > 0) {
            for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
                filler.fillTuple(this.tuple, this.advMeasureRowIndex);
            }
            ++this.advMeasureRowIndex;
            --this.advMeasureRowsRemaining;
            this.next = this.tuple;
            return true;
        }
        if (!this.gtValues.hasNext()) {
            return false;
        }
        Object[] values = this.gtValues.next();
        this.advMeasureFillers = this.cubeTupleConverter.translateResult(values, this.tuple);
        if (this.advMeasureFillers == null) {
            this.next = this.tuple;
            return true;
        }
        this.advMeasureRowsRemaining = -1;
        for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
            if (this.advMeasureRowsRemaining < 0) {
                this.advMeasureRowsRemaining = filler.getNumOfRows();
            }
            if (this.advMeasureRowsRemaining == filler.getNumOfRows()) continue;
            throw new IllegalStateException();
        }
        if (this.advMeasureRowsRemaining < 0) {
            throw new IllegalStateException();
        }
        this.advMeasureRowIndex = 0;
        return this.hasNext();
    }

    @Override
    public ITuple next() {
        if (this.next == null) {
            this.hasNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        Tuple result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.close(this.scanner);
    }

    protected void close(CubeSegmentScanner scanner) {
        try {
            scanner.close();
            this.cubeTupleConverter.close();
        }
        catch (IOException e) {
            logger.error("Exception when close CubeScanner", e);
        }
    }
}

