/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.Map;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component(value="cacheService")
public class CacheService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    private CacheManager cacheManager;
    private Broadcaster.Listener cacheSyncListener = new Broadcaster.Listener(){

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CacheService.this.cleanAllDataCache();
            HBaseConnection.clearConnCache();
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            CacheService.this.cleanDataCache(project);
        }

        @Override
        public void onProjectDataChange(Broadcaster broadcaster, String project) throws IOException {
            CacheService.this.cleanDataCache(project);
        }

        @Override
        public void onProjectQueryACLChange(Broadcaster broadcaster, String project) throws IOException {
            CacheService.this.cleanDataCache(project);
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if ("cube".equals(entity) && event == Broadcaster.Event.UPDATE) {
                final String cubeName = cacheKey;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            CacheService.this.cubeService.updateOnNewSegmentReady(cubeName);
                        }
                        catch (Throwable ex) {
                            logger.error("Error in updateOnNewSegmentReady()", ex);
                        }
                    }
                }.start();
            }
        }
    };

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    public void afterPropertiesSet() throws Exception {
        Broadcaster.getInstance(this.getConfig()).registerStaticListener(this.cacheSyncListener, "cube");
    }

    public void wipeProjectCache(String project) {
        if (project == null) {
            this.annouceWipeCache("all", "update", "all");
        } else {
            this.annouceWipeCache("project", "update", project);
        }
    }

    public void annouceWipeCache(String entity, String event, String cacheKey) {
        Broadcaster broadcaster = Broadcaster.getInstance(this.getConfig());
        broadcaster.announce(entity, event, cacheKey);
    }

    public void notifyMetadataChange(String entity, Broadcaster.Event event, String cacheKey) throws IOException {
        Broadcaster broadcaster = Broadcaster.getInstance(this.getConfig());
        broadcaster.notifyListener(entity, event, cacheKey);
    }

    public void cleanDataCache(String project) {
        if (this.cacheManager != null) {
            if (this.getConfig().isQueryCacheSignatureEnabled()) {
                logger.info("cleaning cache for project " + project + " (currently remove nothing)");
            } else {
                logger.info("cleaning cache for project " + project + " (currently remove all entries)");
                this.cacheManager.getCache("StorageCache").clear();
            }
        } else {
            logger.warn("skip cleaning cache for project " + project);
        }
    }

    protected void cleanAllDataCache() {
        if (this.cacheManager != null) {
            logger.warn("cleaning all storage cache");
            for (String cacheName : this.cacheManager.getCacheNames()) {
                logger.warn("cleaning storage cache for {}", (Object)cacheName);
                this.cacheManager.getCache(cacheName).clear();
            }
        } else {
            logger.warn("skip cleaning all storage cache");
        }
    }

    public void clearCacheForCubeMigration(String cube, String project, String model, Map<String, String> tableToProjects) throws IOException {
        for (Map.Entry<String, String> entry : tableToProjects.entrySet()) {
            this.getTableManager().reloadSourceTableQuietly(entry.getKey(), entry.getValue());
            this.getTableManager().reloadTableExtQuietly(entry.getKey(), entry.getValue());
        }
        logger.info("reload table cache done");
        this.getProjectManager().reloadProjectQuietly(project);
        logger.info("reload project cache done");
        this.getDataModelManager().reloadDataModel(model);
        logger.info("reload model cache done");
        this.getCubeDescManager().reloadCubeDescLocal(cube);
        logger.info("reload cubeDesc cache done");
        this.getCubeManager().reloadCubeQuietly(cube);
        logger.info("reload cube cache done");
        this.getProjectManager().reloadProjectL2Cache(project);
        logger.info("reload project l2cache done");
    }
}

