/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.TableACLService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.ValidateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/acl"})
public class TableACLController
extends BasicController {
    @Autowired
    @Qualifier(value="TableAclService")
    private TableACLService tableACLService;
    @Autowired
    @Qualifier(value="validateUtil")
    private ValidateUtil validateUtil;
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;

    @RequestMapping(value={"/table/{project}/{type}/{table:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getUsersCanQueryTheTbl(@PathVariable String project, @PathVariable String type, @PathVariable String table) throws IOException {
        this.validateUtil.validateArgs(project, table);
        this.validateUtil.validateTable(project, table);
        Set<String> allIdentifiers = this.validateUtil.getAllIdentifiersInPrj(project, type);
        if (type.equals("user")) {
            allIdentifiers.addAll(this.userService.listAdminUsers());
        } else {
            allIdentifiers.add("ROLE_ADMIN");
        }
        return this.tableACLService.getCanAccessList(project, table, allIdentifiers, type);
    }

    @RequestMapping(value={"/table/{project}/{type}/{table:.+}/mdx"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<List<String>> getUsersOrGroupsCanQueryTheTblForMdx(@PathVariable String project, @PathVariable String type, @PathVariable String table) throws IOException {
        this.validateUtil.validateArgs(project, table);
        this.validateUtil.validateTable(project, table);
        Set<String> allIdentifiers = this.validateUtil.getAllIdentifiersInPrj(project, type);
        if (type.equals("user")) {
            allIdentifiers.addAll(this.userService.listAdminUsers());
        } else {
            allIdentifiers.add("ROLE_ADMIN");
        }
        List<String> usersOrGroups = this.tableACLService.getCanAccessList(project, table, allIdentifiers, type);
        return new EnvelopeResponse<List<String>>("000", usersOrGroups, "");
    }

    @RequestMapping(value={"/table/{project}/{type}/black/{table:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getUsersCannotQueryTheTbl(@PathVariable String project, @PathVariable String type, @PathVariable String table) throws IOException {
        this.validateUtil.validateArgs(project, table);
        this.validateUtil.validateTable(project, table);
        return this.tableACLService.getNoAccessList(project, table, type);
    }

    @RequestMapping(value={"/table/{project}/{type}/{table}/{name}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void putUserToTableBlackList(@PathVariable String project, @PathVariable String type, @PathVariable String table, @PathVariable String name) throws IOException {
        this.validateUtil.validateArgs(project, table, name);
        this.validateUtil.validateIdentifiers(project, name, type);
        this.validateUtil.validateTable(project, table);
        this.tableACLService.addToTableACL(project, name, table, type);
    }

    @RequestMapping(value={"/table/{project}/{type}/{table}/{name}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void deleteUserFromTableBlackList(@PathVariable String project, @PathVariable String type, @PathVariable String table, @PathVariable String name) throws IOException {
        this.validateUtil.validateArgs(project, table, name);
        this.validateUtil.validateIdentifiers(project, name, type);
        this.validateUtil.validateTable(project, table);
        this.tableACLService.deleteFromTableACL(project, name, table, type);
    }
}

