/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class QueryInfoCollector {
    private List<String> cubeNames = Lists.newArrayList();
    private static final ThreadLocal<QueryInfoCollector> queryInfoThreadLocal = ThreadLocal.withInitial(QueryInfoCollector::new);

    public static QueryInfoCollector current() {
        return queryInfoThreadLocal.get();
    }

    public static void reset() {
        queryInfoThreadLocal.remove();
    }

    private QueryInfoCollector() {
    }

    public List<String> getCubeNames() {
        return this.cubeNames;
    }

    public void setCubeNames(List<String> cubeNames) {
        this.cubeNames = cubeNames;
    }

    public String getCubeNameString() {
        return StringUtils.join(this.cubeNames, ",");
    }
}

