/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableValues;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPValuesRel
extends Values
implements OLAPRel {
    OLAPContext context;

    public OLAPValuesRel(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
        super(cluster, rowType, tuples, traitSet);
    }

    public static OLAPValuesRel create(RelOptCluster cluster, final RelDataType rowType, final ImmutableList<ImmutableList<RexLiteral>> tuples) {
        final RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)OLAPRel.CONVENTION).replaceIfs((RelTraitDef)RelCollationTraitDef.INSTANCE, (Supplier)new Supplier<List<RelCollation>>(){

            public List<RelCollation> get() {
                return RelMdCollation.values((RelMetadataQuery)mq, (RelDataType)rowType, (ImmutableList)tuples);
            }
        }).replaceIf((RelTraitDef)RelDistributionTraitDef.INSTANCE, (Supplier)new Supplier<RelDistribution>(){

            public RelDistribution get() {
                return RelMdDistribution.values((RelDataType)rowType, (ImmutableList)tuples);
            }
        });
        return new OLAPValuesRel(cluster, rowType, tuples, traitSet);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost = super.computeSelfCost(planner, mq).multiplyBy(0.05);
        return planner.getCostFactory().makeCost(relOptCost.getRows(), 0.0, 0.0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return OLAPValuesRel.create(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples);
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.buildColumnRowType();
    }

    ColumnRowType buildColumnRowType() {
        ArrayList colRefs = Lists.newArrayListWithCapacity((int)this.rowType.getFieldCount());
        for (RelDataTypeField r : this.rowType.getFieldList()) {
            colRefs.add(TblColRef.newInnerColumn(r.getName(), TblColRef.InnerDataTypeEnum.LITERAL));
        }
        return new ColumnRowType(colRefs);
    }

    @Override
    public boolean hasSubQuery() {
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.allocateContext();
        this.context = implementor.getContext();
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor rewriter) {
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return EnumerableValues.create((RelOptCluster)this.getCluster(), (RelDataType)this.getRowType(), (ImmutableList)this.getTuples());
    }
}

