/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;

public abstract class DataTypeOrder
implements Comparator<String> {
    public static final DataTypeOrder INTEGER_ORDER = new IntegerOrder();
    public static final DataTypeOrder DOUBLE_ORDER = new DoubleOrder();
    public static final DataTypeOrder DECIMAL_ORDER = new DecimalOrder();
    public static final DataTypeOrder DATETIME_ORDER = new DateTimeOrder();
    public static final DataTypeOrder STRING_ORDER = new StringOrder();
    public static final DataTypeOrder BOOLEAN_ORDER = new BooleanOrder();

    static DataTypeOrder getInstance(DataType type) throws IllegalArgumentException {
        if (type.isStringFamily()) {
            return STRING_ORDER;
        }
        if (type.isDateTimeFamily()) {
            return DATETIME_ORDER;
        }
        if (type.isIntegerFamily()) {
            return INTEGER_ORDER;
        }
        if (type.isFloat() || type.isDouble()) {
            return DOUBLE_ORDER;
        }
        if (type.isDecimal()) {
            return DECIMAL_ORDER;
        }
        if (type.isBoolean()) {
            return BOOLEAN_ORDER;
        }
        throw new IllegalArgumentException("Unsupported data type " + type);
    }

    public String max(Collection<String> values) {
        String max = null;
        for (String v : values) {
            max = this.max(max, v);
        }
        return max;
    }

    public String min(Collection<String> values) {
        String min = null;
        for (String v : values) {
            min = this.min(min, v);
        }
        return min;
    }

    public String min(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.compare(v1, v2) <= 0 ? v1 : v2;
    }

    public String max(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.compare(v1, v2) >= 0 ? v1 : v2;
    }

    @Override
    public int compare(String s1, String s2) {
        Comparable o2;
        Comparable o1 = this.toComparable(s1);
        if (o1 == (o2 = this.toComparable(s2))) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    abstract Comparable toComparable(String var1);

    private static class BooleanOrder
    extends DataTypeOrder {
        private BooleanOrder() {
        }

        public String toComparable(String s) {
            return s;
        }
    }

    private static class DateTimeOrder
    extends DataTypeOrder {
        private DateTimeOrder() {
        }

        @Override
        public Long toComparable(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            return DateFormat.stringToMillis(s);
        }
    }

    private static class DecimalOrder
    extends DataTypeOrder {
        private DecimalOrder() {
        }

        @Override
        public BigDecimal toComparable(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            return new BigDecimal(s);
        }
    }

    private static class DoubleOrder
    extends DataTypeOrder {
        private DoubleOrder() {
        }

        @Override
        public Double toComparable(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            return Double.parseDouble(s);
        }
    }

    private static class IntegerOrder
    extends DataTypeOrder {
        private IntegerOrder() {
        }

        @Override
        public Long toComparable(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            return Long.parseLong(s);
        }
    }

    private static class StringOrder
    extends DataTypeOrder {
        private StringOrder() {
        }

        public String toComparable(String s) {
            return s;
        }
    }
}

