/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class TopNCounter<T>
implements Iterable<Counter<T>>,
Serializable {
    public static final int EXTRA_SPACE_RATE = 50;
    protected int capacity;
    private HashMap<T, Counter<T>> counterMap;
    protected LinkedList<Counter<T>> counterList;
    private boolean ordered = true;
    private boolean descending = true;
    static final Comparator<Counter> ASC_COMPARATOR = (o1, o2) -> {
        if (o1.getCount() == null) {
            if (o2.getCount() == null) {
                return 0;
            }
            return -1;
        }
        if (o2.getCount() == null) {
            return 1;
        }
        return Double.compare(o1.getCount(), o2.getCount());
    };
    static final Comparator<Counter> DESC_COMPARATOR = (o1, o2) -> {
        if (o1.getCount() == null) {
            if (o2.getCount() == null) {
                return 0;
            }
            return 1;
        }
        if (o2.getCount() == null) {
            return -1;
        }
        return Double.compare(o2.getCount(), o1.getCount());
    };

    public TopNCounter(int capacity) {
        this.capacity = capacity;
        this.counterMap = Maps.newHashMap();
        this.counterList = Lists.newLinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public LinkedList<Counter<T>> getCounterList() {
        return this.counterList;
    }

    public void offer(T item) {
        this.offer(item, 1.0);
    }

    public void offer(T item, Double incrementCount) {
        Counter<T> counterNode = this.counterMap.get(item);
        if (counterNode == null) {
            if (this.size() < this.capacity) {
                counterNode = new Counter<T>(item, null);
                if (this.descending) {
                    this.counterList.addLast(counterNode);
                } else {
                    this.counterList.addFirst(counterNode);
                }
            } else {
                if (!this.ordered) {
                    this.sort();
                }
                counterNode = this.descending ? this.counterList.getLast() : this.counterList.getFirst();
                this.counterMap.remove(counterNode.getItem());
                counterNode.setItem(item);
            }
            this.counterMap.put(item, counterNode);
        }
        this.incrementCounter(counterNode, incrementCount);
        this.ordered = false;
    }

    public void sortAndRetain() {
        this.sort();
        this.retain(this.capacity);
    }

    public List<Counter<T>> topK(int k) {
        if (!this.ordered) {
            this.sortAndRetain();
        }
        ArrayList<Counter<T>> topK = new ArrayList<Counter<T>>(k);
        for (Counter counter : this.counterList) {
            if (topK.size() == k) {
                return topK;
            }
            topK.add(counter);
        }
        return topK;
    }

    public int size() {
        return this.counterMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Counter counter : this.counterList) {
            sb.append(counter.item);
            sb.append(':');
            sb.append(counter.count);
        }
        sb.append(']');
        return sb.toString();
    }

    public void offerToHead(T item, Double count) {
        Counter<T> c = new Counter<T>(item, count);
        this.counterList.addFirst(c);
        this.counterMap.put(c.item, c);
    }

    public TopNCounter<T> merge(TopNCounter<T> another) {
        double m2;
        boolean thisFull = this.size() >= this.capacity;
        boolean anotherFull = another.size() >= another.capacity;
        double m1 = thisFull ? this.counterList.getLast().count : 0.0;
        double d = m2 = anotherFull ? another.counterList.getLast().count : 0.0;
        if (anotherFull) {
            Iterator<Object> iterator = this.counterMap.values().iterator();
            while (iterator.hasNext()) {
                Counter counter;
                Counter counter2 = counter = (Counter)iterator.next();
                Double.valueOf(counter2.count + m2);
                counter2.count = counter2.count;
            }
        }
        for (Map.Entry entry : another.counterMap.entrySet()) {
            if (this.counterMap.containsKey(entry.getKey())) {
                this.offer(((Counter)entry.getValue()).getItem(), ((Counter)entry.getValue()).count - m2);
                continue;
            }
            this.offer(((Counter)entry.getValue()).getItem(), ((Counter)entry.getValue()).count + m1);
        }
        this.ordered = false;
        this.sortAndRetain();
        return this;
    }

    public void retain(int newCapacity) {
        this.capacity = newCapacity;
        if (this.size() > newCapacity) {
            int n = this.size() - newCapacity;
            for (int i = 0; i < n; ++i) {
                Counter<T> toRemoved = this.counterList.pollLast();
                this.counterMap.remove(toRemoved.item);
            }
        }
    }

    public double[] getCounters() {
        double[] counters = new double[this.size()];
        int index = 0;
        if (this.descending) {
            Iterator<Counter<T>> iterator = this.counterList.descendingIterator();
            while (iterator.hasNext()) {
                Counter<T> b = iterator.next();
                counters[index] = b.count;
                ++index;
            }
        } else {
            throw new IllegalStateException();
        }
        assert (index == this.size());
        return counters;
    }

    public TopNCounter<T> copy() {
        TopNCounter<T> result = new TopNCounter<T>(this.capacity);
        result.counterMap = Maps.newHashMap(this.counterMap);
        result.counterList = Lists.newLinkedList(this.counterList);
        return result;
    }

    @Override
    public Iterator<Counter<T>> iterator() {
        if (this.descending) {
            return this.counterList.descendingIterator();
        }
        throw new IllegalStateException();
    }

    private void incrementCounter(Counter<T> counterNode, Double incrementCount) {
        if (incrementCount == null) {
            return;
        }
        if (counterNode.getCount() == null) {
            counterNode.setCount(incrementCount);
        } else {
            counterNode.setCount(counterNode.getCount() + incrementCount);
        }
    }

    private void sort() {
        this.counterList.sort(this.descending ? DESC_COMPARATOR : ASC_COMPARATOR);
        this.ordered = true;
    }

    public void reset() {
        this.counterList.clear();
        this.counterMap.clear();
        this.ordered = false;
        this.descending = true;
    }
}

