/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.Closeable;
import java.io.IOException;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;

public class GTBuilder
implements Closeable {
    private final GTInfo info;
    private final IGTWriter storeWriter;
    private int writtenRowCount;

    GTBuilder(GTInfo info, int shard, IGTStore store) throws IOException {
        this(info, shard, store, false);
    }

    GTBuilder(GTInfo info, int shard, IGTStore store, boolean append) throws IOException {
        this.info = info;
        this.storeWriter = append ? store.append() : store.rebuild();
    }

    public void write(GTRecord r) throws IOException {
        this.storeWriter.write(r);
        ++this.writtenRowCount;
    }

    @Override
    public void close() throws IOException {
        this.storeWriter.close();
    }

    public int getWrittenRowCount() {
        return this.writtenRowCount;
    }
}

