/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.kylin.common.exceptions.ResourceLimitExceededException;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.gridtable.GTFilterScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTBypassChecker;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.StorageLimitLevel;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTAggregateScanner
implements IGTScanner,
IGTBypassChecker {
    private static final Logger logger = LoggerFactory.getLogger(GTAggregateScanner.class);
    private static final int MAX_BUFFER_SIZE = 0x4000000;
    final GTInfo info;
    final ImmutableBitSet dimensions;
    final ImmutableBitSet groupBy;
    final ImmutableBitSet metrics;
    final String[] metricsAggrFuncs;
    final IGTScanner inputScanner;
    final BufferedMeasureCodec measureCodec;
    final AggregationCache aggrCache;
    long spillThreshold;
    final int storagePushDownLimit;
    final StorageLimitLevel storageLimitLevel;
    final boolean spillEnabled;
    final TupleFilter havingFilter;
    private long inputRowCount = 0L;
    private MemoryBudgetController.MemoryWaterLevel memTracker;
    private boolean[] aggrMask;

    public GTAggregateScanner(IGTScanner inputScanner, GTScanRequest req) {
        this(inputScanner, req, true);
    }

    public GTAggregateScanner(IGTScanner input, GTScanRequest req, boolean spillEnabled) {
        if (!req.hasAggregation()) {
            throw new IllegalStateException();
        }
        if (input instanceof GTFilterScanner) {
            logger.info("setting IGTBypassChecker of child");
            ((GTFilterScanner)input).setChecker(this);
        } else {
            logger.info("applying a GTFilterScanner with IGTBypassChecker on top child");
            input = new GTFilterScanner(input, null, this);
        }
        this.inputScanner = input;
        this.info = this.inputScanner.getInfo();
        this.dimensions = req.getDimensions();
        this.groupBy = req.getAggrGroupBy();
        this.metrics = req.getAggrMetrics();
        this.metricsAggrFuncs = req.getAggrMetricsFuncs();
        this.measureCodec = req.createMeasureCodec();
        this.spillThreshold = (long)(req.getAggCacheMemThreshold() * 1.073741824E9);
        this.aggrMask = new boolean[this.metricsAggrFuncs.length];
        this.storagePushDownLimit = req.getStoragePushDownLimit();
        this.storageLimitLevel = req.getStorageLimitLevel();
        this.spillEnabled = spillEnabled;
        this.havingFilter = req.getHavingFilterPushDown();
        this.aggrCache = new AggregationCache();
        Arrays.fill(this.aggrMask, true);
    }

    public static long estimateSizeOfAggrCache(byte[] keySample, MeasureAggregator<?>[] aggrSample, int size) {
        return (GTAggregateScanner.estimateSizeOf(keySample) + GTAggregateScanner.estimateSizeOf(aggrSample) + 64L) * (long)size;
    }

    public static long estimateSizeOf(MeasureAggregator[] aggrs) {
        long est = (long)((aggrs.length + 1) / 2) * 8L + 4L + 4L;
        for (MeasureAggregator aggr : aggrs) {
            if (aggr == null) continue;
            est += (long)aggr.getMemBytesEstimate();
        }
        return est;
    }

    public static long estimateSizeOf(byte[] bytes) {
        return (long)((bytes.length + 7) / 8) * 8L + 4L + 4L;
    }

    public void trackMemoryLevel(MemoryBudgetController.MemoryWaterLevel tracker) {
        this.memTracker = tracker;
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    public long getInputRowCount() {
        return this.inputRowCount;
    }

    @Override
    public void close() throws IOException {
        this.inputScanner.close();
        this.aggrCache.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        long count = 0L;
        for (GTRecord r : this.inputScanner) {
            boolean ret = this.aggrCache.aggregate(r);
            if (!ret) {
                logger.info("abort reading inputScanner because storage push down limit is hit");
                break;
            }
            ++count;
        }
        logger.info("GTAggregateScanner input rows: " + count);
        return this.aggrCache.iterator();
    }

    public int getNumOfSpills() {
        return this.aggrCache.dumps.size();
    }

    public void setAggrMask(boolean[] aggrMask) {
        this.aggrMask = aggrMask;
    }

    public long getEstimateSizeOfAggrCache() {
        return this.aggrCache.estimatedMemSize();
    }

    @Override
    public boolean shouldBypass(GTRecord record) {
        return this.aggrCache.shouldBypass(record);
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K k;
        V v;

        SimpleEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            V oldV = this.v;
            this.v = value;
            return oldV;
        }
    }

    class AggregationCache
    implements Closeable {
        final List<Dump> dumps;
        final int keyLength;
        final boolean[] compareMask;
        boolean compareAll = true;
        long sumSpilledSize = 0L;
        ByPassChecker byPassChecker = null;
        final Comparator<byte[]> bytesComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (AggregationCache.this.compareAll) {
                    return Bytes.compareTo(o1, o2);
                }
                int result = 0;
                for (int i = 0; i < AggregationCache.this.keyLength; ++i) {
                    int b;
                    int a;
                    if (!AggregationCache.this.compareMask[i] || (result = (a = o1[i] & 0xFF) - (b = o2[i] & 0xFF)) == 0) continue;
                    return result;
                }
                return result;
            }
        };
        TreeMap<byte[], MeasureAggregator[]> aggBufMap;

        public AggregationCache() {
            for (boolean l : this.compareMask = this.createCompareMask()) {
                this.compareAll = this.compareAll && l;
            }
            this.keyLength = this.compareMask.length;
            this.dumps = Lists.newArrayList();
            this.aggBufMap = this.createBuffMap();
            if (GTAggregateScanner.this.storageLimitLevel == StorageLimitLevel.LIMIT_ON_RETURN_SIZE) {
                this.byPassChecker = new ByPassChecker(GTAggregateScanner.this.storagePushDownLimit);
            }
        }

        public boolean shouldBypass(GTRecord record) {
            if (this.byPassChecker == null) {
                return false;
            }
            boolean b = this.byPassChecker.shouldByPass(record);
            return b;
        }

        private boolean[] createCompareMask() {
            int keyLength = 0;
            for (int i = 0; i < GTAggregateScanner.this.dimensions.trueBitCount(); ++i) {
                int c = GTAggregateScanner.this.dimensions.trueBitAt(i);
                int l = GTAggregateScanner.this.info.codeSystem.maxCodeLength(c);
                keyLength += l;
            }
            boolean[] mask = new boolean[keyLength];
            int p = 0;
            for (int i = 0; i < GTAggregateScanner.this.dimensions.trueBitCount(); ++i) {
                int c = GTAggregateScanner.this.dimensions.trueBitAt(i);
                int l = GTAggregateScanner.this.info.codeSystem.maxCodeLength(c);
                boolean m = GTAggregateScanner.this.groupBy.get(c);
                for (int j = 0; j < l; ++j) {
                    mask[p++] = m;
                }
            }
            return mask;
        }

        private TreeMap<byte[], MeasureAggregator[]> createBuffMap() {
            return Maps.newTreeMap(this.bytesComparator);
        }

        private byte[] createKey(GTRecord record) {
            byte[] result = new byte[this.keyLength];
            int offset = 0;
            for (int i = 0; i < GTAggregateScanner.this.dimensions.trueBitCount(); ++i) {
                int c = GTAggregateScanner.this.dimensions.trueBitAt(i);
                ByteArray byteArray = record.cols[c];
                int columnLength = GTAggregateScanner.this.info.codeSystem.maxCodeLength(c);
                System.arraycopy(byteArray.array(), byteArray.offset(), result, offset, byteArray.length());
                offset += columnLength;
            }
            assert (offset == result.length);
            return result;
        }

        boolean aggregate(GTRecord r) {
            byte[] key;
            MeasureAggregator[] aggrs;
            if (++GTAggregateScanner.this.inputRowCount % 100000L == 0L) {
                if (GTAggregateScanner.this.memTracker != null) {
                    GTAggregateScanner.this.memTracker.markHigh();
                }
                long estMemSize = this.estimatedMemSize();
                if (GTAggregateScanner.this.spillThreshold > 0L && estMemSize > GTAggregateScanner.this.spillThreshold) {
                    if (!GTAggregateScanner.this.spillEnabled) {
                        throw new ResourceLimitExceededException("aggregation's memory consumption " + estMemSize + " exceeds threshold " + GTAggregateScanner.this.spillThreshold);
                    }
                    this.spillBuffMap(estMemSize);
                    this.aggBufMap = this.createBuffMap();
                }
            }
            if ((aggrs = this.aggBufMap.get(key = this.createKey(r))) == null) {
                if (GTAggregateScanner.this.getNumOfSpills() == 0 && GTAggregateScanner.this.storageLimitLevel == StorageLimitLevel.LIMIT_ON_SCAN && this.aggBufMap.size() >= GTAggregateScanner.this.storagePushDownLimit) {
                    return false;
                }
                aggrs = this.newAggregators();
                this.aggBufMap.put(key, aggrs);
            }
            for (int i = 0; i < aggrs.length; ++i) {
                if (!GTAggregateScanner.this.aggrMask[i]) continue;
                int col = GTAggregateScanner.this.metrics.trueBitAt(i);
                Object metrics = GTAggregateScanner.this.info.codeSystem.decodeColumnValue(col, r.cols[col].asBuffer());
                aggrs[i].aggregate(metrics);
            }
            if (this.byPassChecker != null) {
                this.byPassChecker.updateOnBufferChange();
            }
            return true;
        }

        private void spillBuffMap(long estMemSize) throws RuntimeException {
            try {
                Dump dump = new Dump(this.aggBufMap, estMemSize);
                dump.flush();
                this.dumps.add(dump);
                this.sumSpilledSize += (long)dump.size();
                if (this.sumSpilledSize > GTAggregateScanner.this.spillThreshold) {
                    for (Dump current : this.dumps) {
                        current.spill();
                    }
                    GTAggregateScanner.this.spillThreshold += this.sumSpilledSize;
                    this.sumSpilledSize = 0L;
                } else {
                    GTAggregateScanner.this.spillThreshold -= (long)dump.size();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("AggregationCache failed to spill", e);
            }
        }

        @Override
        public void close() throws RuntimeException {
            try {
                logger.info("closing aggrCache");
                if (this.byPassChecker != null) {
                    logger.info("AggregationCache byPassChecker helps to skip {} cuboid rows", (Object)this.byPassChecker.getByPassCounter());
                }
                for (Dump dump : this.dumps) {
                    dump.terminate();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("AggregationCache close failed: " + e.getMessage());
            }
        }

        private MeasureAggregator[] newAggregators() {
            return GTAggregateScanner.this.info.codeSystem.newMetricsAggregators(GTAggregateScanner.this.metrics, GTAggregateScanner.this.metricsAggrFuncs);
        }

        public long estimatedMemSize() {
            if (this.aggBufMap.isEmpty()) {
                return 0L;
            }
            byte[] sampleKey = this.aggBufMap.firstKey();
            MeasureAggregator[] sampleValue = this.aggBufMap.get(sampleKey);
            return GTAggregateScanner.estimateSizeOfAggrCache(sampleKey, sampleValue, this.aggBufMap.size());
        }

        public Iterator<GTRecord> iterator() {
            Iterator<Map.Entry<byte[], MeasureAggregator[]>> it = null;
            if (this.dumps.isEmpty()) {
                it = this.aggBufMap.entrySet().iterator();
            } else {
                if (!this.aggBufMap.isEmpty()) {
                    this.spillBuffMap(GTAggregateScanner.this.getEstimateSizeOfAggrCache());
                }
                DumpMerger merger = new DumpMerger(this.dumps);
                it = merger.iterator();
            }
            final Iterator<Map.Entry<byte[], MeasureAggregator[]>> input = it;
            return new Iterator<GTRecord>(){
                final ReturningRecord returningRecord;
                Map.Entry<byte[], MeasureAggregator[]> returningEntry;
                final HavingFilterChecker havingFilterChecker;
                {
                    this.returningRecord = new ReturningRecord();
                    this.returningEntry = null;
                    this.havingFilterChecker = GTAggregateScanner.this.havingFilter == null ? null : new HavingFilterChecker();
                }

                @Override
                public boolean hasNext() {
                    while (this.returningEntry == null && input.hasNext()) {
                        this.returningEntry = (Map.Entry)input.next();
                        if (this.havingFilterChecker == null) continue;
                        this.returningEntry = this.havingFilterChecker.check(this.returningEntry);
                    }
                    return this.returningEntry != null;
                }

                @Override
                public GTRecord next() {
                    this.returningRecord.load(this.returningEntry.getKey(), this.returningEntry.getValue());
                    this.returningEntry = null;
                    return this.returningRecord.record;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        class DumpMerger
        implements Iterable<Map.Entry<byte[], MeasureAggregator[]>> {
            final PriorityQueue<Map.Entry<byte[], Integer>> minHeap;
            final List<Iterator<Pair<byte[], byte[]>>> dumpIterators;
            final List<Object[]> dumpCurrentValues;
            final MeasureAggregator[] resultMeasureAggregators;
            final MeasureAggregators resultAggrs;

            public DumpMerger(List<Dump> dumps) {
                this.resultMeasureAggregators = AggregationCache.this.newAggregators();
                this.resultAggrs = new MeasureAggregators(this.resultMeasureAggregators);
                this.minHeap = new PriorityQueue<Map.Entry<byte[], Integer>>(dumps.size(), new Comparator<Map.Entry<byte[], Integer>>(){

                    @Override
                    public int compare(Map.Entry<byte[], Integer> o1, Map.Entry<byte[], Integer> o2) {
                        return AggregationCache.this.bytesComparator.compare(o1.getKey(), o2.getKey());
                    }
                });
                this.dumpIterators = Lists.newArrayListWithCapacity(dumps.size());
                this.dumpCurrentValues = Lists.newArrayListWithCapacity(dumps.size());
                for (int i = 0; i < dumps.size(); ++i) {
                    Iterator<Pair<byte[], byte[]>> it = dumps.get(i).iterator();
                    this.dumpCurrentValues.add(i, null);
                    if (it.hasNext()) {
                        this.dumpIterators.add(i, it);
                        this.enqueueFromDump(i);
                        continue;
                    }
                    this.dumpIterators.add(i, null);
                }
            }

            private void enqueueFromDump(int index) {
                if (this.dumpIterators.get(index) != null && this.dumpIterators.get(index).hasNext()) {
                    Pair<byte[], byte[]> pair = this.dumpIterators.get(index).next();
                    this.minHeap.offer(new SimpleEntry<byte[], Integer>(pair.getFirst(), index));
                    Object[] metricValues = new Object[GTAggregateScanner.this.metrics.trueBitCount()];
                    GTAggregateScanner.this.measureCodec.decode(ByteBuffer.wrap(pair.getSecond()), metricValues);
                    this.dumpCurrentValues.set(index, metricValues);
                }
            }

            @Override
            public Iterator<Map.Entry<byte[], MeasureAggregator[]>> iterator() {
                return new Iterator<Map.Entry<byte[], MeasureAggregator[]>>(){

                    @Override
                    public boolean hasNext() {
                        return !DumpMerger.this.minHeap.isEmpty();
                    }

                    private void internalAggregate() {
                        Map.Entry<byte[], Integer> peekEntry = DumpMerger.this.minHeap.poll();
                        DumpMerger.this.resultAggrs.aggregate(DumpMerger.this.dumpCurrentValues.get(peekEntry.getValue()));
                        DumpMerger.this.enqueueFromDump(peekEntry.getValue());
                    }

                    @Override
                    public Map.Entry<byte[], MeasureAggregator[]> next() {
                        DumpMerger.this.resultAggrs.reset();
                        byte[] peekKey = DumpMerger.this.minHeap.peek().getKey();
                        this.internalAggregate();
                        while (!DumpMerger.this.minHeap.isEmpty() && AggregationCache.this.bytesComparator.compare(peekKey, DumpMerger.this.minHeap.peek().getKey()) == 0) {
                            this.internalAggregate();
                        }
                        return new SimpleEntry<byte[], MeasureAggregator[]>(peekKey, DumpMerger.this.resultMeasureAggregators);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        class Dump
        implements Iterable<Pair<byte[], byte[]>> {
            final File dumpedFile = Files.createTempFile("KYLIN_SPILL_", ".tmp", new FileAttribute[0]).toFile();
            SortedMap<byte[], MeasureAggregator[]> buffMap;
            final long estMemSize;
            byte[] spillBuffer;
            DataInputStream dis;

            public Dump(SortedMap<byte[], MeasureAggregator[]> buffMap, long estMemSize) throws IOException {
                this.buffMap = buffMap;
                this.estMemSize = estMemSize;
            }

            @Override
            public Iterator<Pair<byte[], byte[]>> iterator() {
                try {
                    if (this.dumpedFile == null || !this.dumpedFile.exists()) {
                        throw new RuntimeException("Dumped file cannot be found at: " + (this.dumpedFile == null ? "<null>" : this.dumpedFile.getAbsolutePath()));
                    }
                    this.dis = this.spillBuffer == null ? new DataInputStream(new FileInputStream(this.dumpedFile)) : new DataInputStream(new ByteArrayInputStream(this.spillBuffer));
                    final int count = this.dis.readInt();
                    return new Iterator<Pair<byte[], byte[]>>(){
                        int cursorIdx = 0;

                        @Override
                        public boolean hasNext() {
                            return this.cursorIdx < count;
                        }

                        @Override
                        public Pair<byte[], byte[]> next() {
                            try {
                                ++this.cursorIdx;
                                int keyLen = Dump.this.dis.readInt();
                                byte[] key = new byte[keyLen];
                                Dump.this.dis.readFully(key);
                                int valueLen = Dump.this.dis.readInt();
                                byte[] value = new byte[valueLen];
                                Dump.this.dis.readFully(value);
                                return new Pair<byte[], byte[]>(key, value);
                            }
                            catch (Exception e) {
                                throw new NoSuchElementException("Cannot read AggregationCache from dumped file: " + e.getMessage());
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read dumped file: " + e.getMessage());
                }
            }

            public void spill() throws IOException {
                if (this.spillBuffer == null) {
                    return;
                }
                try (FileOutputStream ops = new FileOutputStream(this.dumpedFile);
                     ByteArrayInputStream ips = new ByteArrayInputStream(this.spillBuffer);){
                    IOUtils.copy((InputStream)ips, (OutputStream)ops);
                    this.spillBuffer = null;
                }
                logger.info("Spill buffer to disk, location: {}, size = {}.", (Object)this.dumpedFile.getAbsolutePath(), (Object)this.dumpedFile.length());
            }

            public int size() {
                return this.spillBuffer == null ? 0 : this.spillBuffer.length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() throws IOException {
                logger.info("AggregationCache(size={} est_mem_size={} threshold={}) will spill to {}", this.buffMap.size(), this.estMemSize, GTAggregateScanner.this.spillThreshold, this.dumpedFile.getAbsolutePath());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(0x4000000);
                if (this.buffMap != null) {
                    DataOutputStream bos = new DataOutputStream(baos);
                    Object[] aggrResult = null;
                    try {
                        bos.writeInt(this.buffMap.size());
                        for (Map.Entry<byte[], MeasureAggregator[]> entry : this.buffMap.entrySet()) {
                            MeasureAggregators aggs = new MeasureAggregators(entry.getValue());
                            aggrResult = new Object[GTAggregateScanner.this.metrics.trueBitCount()];
                            aggs.collectStates(aggrResult);
                            ByteBuffer metricsBuf = GTAggregateScanner.this.measureCodec.encode(aggrResult);
                            bos.writeInt(entry.getKey().length);
                            bos.write(entry.getKey());
                            bos.writeInt(metricsBuf.position());
                            bos.write(metricsBuf.array(), 0, metricsBuf.position());
                        }
                    }
                    finally {
                        this.buffMap = null;
                        IOUtils.closeQuietly(bos);
                    }
                }
                this.spillBuffer = baos.toByteArray();
                IOUtils.closeQuietly(baos);
                logger.info("Accurately spill data size = {}", (Object)this.spillBuffer.length);
            }

            public void terminate() throws IOException {
                this.buffMap = null;
                if (this.dis != null) {
                    IOUtils.closeQuietly(this.dis);
                }
                if (this.dumpedFile != null && this.dumpedFile.exists()) {
                    this.dumpedFile.delete();
                }
                this.spillBuffer = null;
            }
        }

        class ReturningRecord {
            final GTRecord record;
            final Object[] tmpValues;

            ReturningRecord() {
                this.record = new GTRecord(GTAggregateScanner.this.info);
                this.tmpValues = new Object[GTAggregateScanner.this.metrics.trueBitCount()];
            }

            void load(byte[] key, MeasureAggregator[] value) {
                int i;
                int offset = 0;
                for (i = 0; i < GTAggregateScanner.this.dimensions.trueBitCount(); ++i) {
                    int c = GTAggregateScanner.this.dimensions.trueBitAt(i);
                    int columnLength = GTAggregateScanner.this.info.codeSystem.maxCodeLength(c);
                    this.record.cols[c].reset(key, offset, columnLength);
                    offset += columnLength;
                }
                for (i = 0; i < value.length; ++i) {
                    this.tmpValues[i] = value[i].getState();
                }
                byte[] bytes = GTAggregateScanner.this.measureCodec.encode(this.tmpValues).array();
                int[] sizes = GTAggregateScanner.this.measureCodec.getMeasureSizes();
                offset = 0;
                for (int i2 = 0; i2 < value.length; ++i2) {
                    int col = GTAggregateScanner.this.metrics.trueBitAt(i2);
                    this.record.cols[col].reset(bytes, offset, sizes[i2]);
                    offset += sizes[i2];
                }
            }
        }

        private class HavingFilterTuple
        implements ITuple {
            MeasureAggregator[] aggrValues;

            private HavingFilterTuple() {
            }

            @Override
            public Object getValue(TblColRef col) {
                return this.aggrValues[col.getColumnDesc().getZeroBasedIndex()].getState();
            }

            @Override
            public List<String> getAllFields() {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<TblColRef> getAllColumns() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object[] getAllValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ITuple makeCopy() {
                throw new UnsupportedOperationException();
            }
        }

        private class HavingFilterCodeSys
        implements IFilterCodeSystem {
            Object o2Cache;
            double n2Cache;

            private HavingFilterCodeSys() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                double n2;
                double n1;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1 instanceof Number) {
                    n1 = ((Number)o1).doubleValue();
                } else if (o1 instanceof HLLCounter) {
                    n1 = ((HLLCounter)o1).getCountEstimate();
                } else if (o1 instanceof BitmapCounter) {
                    n1 = ((BitmapCounter)o1).getCount();
                } else if (o1 instanceof PercentileCounter) {
                    n1 = ((PercentileCounter)o1).getResultEstimate();
                } else {
                    throw new RuntimeException("Unknown datatype: value=" + o1 + ", class=" + o1.getClass());
                }
                double d = n2 = this.o2Cache == o2 ? this.n2Cache : Double.parseDouble((String)o2);
                if (this.o2Cache == null) {
                    this.o2Cache = o2;
                    this.n2Cache = n2;
                }
                return Double.compare(n1, n2);
            }

            public boolean isNull(Object code) {
                return code == null;
            }

            public void serialize(Object code, ByteBuffer buf) {
                throw new UnsupportedOperationException();
            }

            public Object deserialize(ByteBuffer buf) {
                throw new UnsupportedOperationException();
            }
        }

        class HavingFilterChecker {
            final HavingFilterTuple tuple;
            final IFilterCodeSystem cs;

            HavingFilterChecker() {
                this.tuple = new HavingFilterTuple();
                this.cs = new HavingFilterCodeSys();
                logger.info("Evaluating 'having' filter -- " + GTAggregateScanner.this.havingFilter);
            }

            public Map.Entry<byte[], MeasureAggregator[]> check(Map.Entry<byte[], MeasureAggregator[]> returningEntry) {
                this.tuple.aggrValues = returningEntry.getValue();
                boolean pass = GTAggregateScanner.this.havingFilter.evaluate(this.tuple, this.cs);
                return pass ? returningEntry : null;
            }
        }

        class ByPassChecker {
            private int aggregateBufferSizeLimit = -1;
            private byte[] currentLastKey = null;
            private int[] groupOffsetsInLastKey = null;
            private int byPassCounter = 0;

            ByPassChecker(int aggregateBufferSizeLimit) {
                this.aggregateBufferSizeLimit = aggregateBufferSizeLimit;
                int p = 0;
                int idx = 0;
                this.groupOffsetsInLastKey = new int[GTAggregateScanner.this.groupBy.trueBitCount()];
                for (int i = 0; i < GTAggregateScanner.this.dimensions.trueBitCount(); ++i) {
                    int c = GTAggregateScanner.this.dimensions.trueBitAt(i);
                    int l = GTAggregateScanner.this.info.codeSystem.maxCodeLength(c);
                    if (GTAggregateScanner.this.groupBy.get(c)) {
                        this.groupOffsetsInLastKey[idx++] = p;
                    }
                    p += l;
                }
            }

            boolean shouldByPass(GTRecord record) {
                if (AggregationCache.this.dumps.size() > 0) {
                    return false;
                }
                Preconditions.checkState(AggregationCache.this.aggBufMap.size() <= this.aggregateBufferSizeLimit);
                if (AggregationCache.this.aggBufMap.size() == this.aggregateBufferSizeLimit) {
                    Preconditions.checkNotNull(this.currentLastKey);
                    for (int i = 0; i < GTAggregateScanner.this.groupBy.trueBitCount(); ++i) {
                        int c = GTAggregateScanner.this.groupBy.trueBitAt(i);
                        ByteArray col = record.get(c);
                        int compare = Bytes.compareTo(col.array(), col.offset(), col.length(), this.currentLastKey, this.groupOffsetsInLastKey[i], col.length());
                        if (compare > 0) {
                            ++this.byPassCounter;
                            return true;
                        }
                        if (compare >= 0) continue;
                        return false;
                    }
                }
                return false;
            }

            void updateOnBufferChange() {
                if (AggregationCache.this.aggBufMap.size() > this.aggregateBufferSizeLimit) {
                    AggregationCache.this.aggBufMap.pollLastEntry();
                    Preconditions.checkState(AggregationCache.this.aggBufMap.size() == this.aggregateBufferSizeLimit);
                }
                this.currentLastKey = AggregationCache.this.aggBufMap.lastKey();
            }

            int getByPassCounter() {
                return this.byPassCounter;
            }
        }
    }
}

