/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.common.util;

import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.kylin.engine.spark.cross.CrossDateTimeUtils$;
import scala.Predef$;

public final class KylinDateTimeUtils$ {
    public static KylinDateTimeUtils$ MODULE$;
    private final long MICROS_PER_MILLIS;
    private final long MILLIS_PER_SECOND;
    private final long MILLIS_PER_MINUTE;
    private final long MILLIS_PER_HOUR;
    private final long MILLIS_PER_DAY;
    private final long DAYS_PER_WEEK;
    private final long MONTHS_PER_QUARTER;
    private final long QUARTERS_PER_YEAR;

    static {
        new KylinDateTimeUtils$();
    }

    public long MICROS_PER_MILLIS() {
        return this.MICROS_PER_MILLIS;
    }

    public long MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public long MILLIS_PER_MINUTE() {
        return this.MILLIS_PER_MINUTE;
    }

    public long MILLIS_PER_HOUR() {
        return this.MILLIS_PER_HOUR;
    }

    public long MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    public long DAYS_PER_WEEK() {
        return this.DAYS_PER_WEEK;
    }

    public long MONTHS_PER_QUARTER() {
        return this.MONTHS_PER_QUARTER;
    }

    public long QUARTERS_PER_YEAR() {
        return this.QUARTERS_PER_YEAR;
    }

    public long addMonths(long timestamp, int m) {
        long ms = timestamp / 1000L;
        int day0 = CrossDateTimeUtils$.MODULE$.millisToDays(ms);
        long millis = ms - (long)day0 * this.MILLIS_PER_DAY();
        int x = this.dateAddMonths(day0, m);
        return ((long)x * this.MILLIS_PER_DAY() + millis) * 1000L;
    }

    public int dateSubtractMonths(int date0, int date1) {
        if (date0 < date1) {
            return -this.dateSubtractMonths(date1, date0);
        }
        int m = (date0 - date1) / 31;
        int date2;
        while ((date2 = this.dateAddMonths(date1, m)) < date0) {
            int date3 = this.dateAddMonths(date1, m + 1);
            if (date3 > date0) {
                return m;
            }
            ++m;
        }
        return m;
    }

    public int subtractMonths(long t0, long t1) {
        int x;
        block1: {
            long millis0 = this.floorMod(t0, this.MILLIS_PER_DAY());
            int d0 = CrossDateTimeUtils$.MODULE$.millisToDays(t0);
            long millis1 = this.floorMod(t1, this.MILLIS_PER_DAY());
            int d1 = CrossDateTimeUtils$.MODULE$.millisToDays(t1);
            x = this.dateSubtractMonths(d0, d1);
            int d2 = this.dateAddMonths(d1, x);
            if (x > 0 && d2 == d0 && millis0 < millis1) {
                --x;
            }
            if (x >= 0 || d2 != d0 || millis0 <= millis1) break block1;
            ++x;
        }
        return x;
    }

    public int dayOfWeek(int date) {
        return (date + 4) % 7 + 1;
    }

    public int dateAddMonths(int date, int m) {
        int d0;
        int m0;
        int y0;
        block1: {
            int last;
            y0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.YEAR, (long)date);
            m0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.MONTH, (long)date);
            d0 = (int)DateTimeUtils.unixDateExtract((TimeUnitRange)TimeUnitRange.DAY, (long)date);
            int y = (m + m0) / 12;
            y0 += y;
            if ((m0 = m + m0 - y * 12) <= 0) {
                Predef$.MODULE$.assert((m0 += 12) > 0);
                --y0;
            }
            if (d0 <= (last = this.lastDay(y0, m0))) break block1;
            d0 = last;
        }
        return DateTimeUtils.ymdToUnixDate((int)y0, (int)m0, (int)d0);
    }

    public long floorDiv(long x, long y) {
        long r;
        block0: {
            r = x / y;
            if ((x ^ y) >= 0L || r * y == x) break block0;
            --r;
        }
        return r;
    }

    public long floorMod(long x, long y) {
        return x - this.floorDiv(x, y) * y;
    }

    private int lastDay(int y, int m) {
        int n;
        int n2 = m;
        switch (n2) {
            case 2: {
                if (y % 4 == 0 && (y % 100 != 0 || y % 400 == 0)) {
                    n = 29;
                    break;
                }
                n = 28;
                break;
            }
            case 4: {
                n = 30;
                break;
            }
            case 6: {
                n = 30;
                break;
            }
            case 9: {
                n = 30;
                break;
            }
            case 11: {
                n = 30;
                break;
            }
            default: {
                n = 31;
                break;
            }
        }
        return n;
    }

    private KylinDateTimeUtils$() {
        MODULE$ = this;
        this.MICROS_PER_MILLIS = 1000L;
        this.MILLIS_PER_SECOND = 1000L;
        this.MILLIS_PER_MINUTE = this.MILLIS_PER_SECOND() * 60L;
        this.MILLIS_PER_HOUR = this.MILLIS_PER_MINUTE() * 60L;
        this.MILLIS_PER_DAY = this.MILLIS_PER_HOUR() * 24L;
        this.DAYS_PER_WEEK = 7L;
        this.MONTHS_PER_QUARTER = 3L;
        this.QUARTERS_PER_YEAR = 4L;
    }
}

