/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidShardUtil {
    protected static final Logger logger = LoggerFactory.getLogger(CuboidShardUtil.class);

    public static void saveCuboidShards(CubeSegment segment, Map<Long, Short> cuboidShards, int totalShards) throws IOException {
        CubeManager cubeManager = CubeManager.getInstance(segment.getConfig());
        HashMap filtered = Maps.newHashMap();
        for (Map.Entry<Long, Short> entry : cuboidShards.entrySet()) {
            if (entry.getValue() <= 1) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        CubeInstance cubeCopy = segment.getCubeInstance().latestCopyForWrite();
        CubeSegment segCopy = cubeCopy.getSegmentById(segment.getUuid());
        segCopy.setCuboidShardNums(filtered);
        segCopy.setTotalShards(totalShards);
        CubeUpdate update = new CubeUpdate(cubeCopy);
        update.setToUpdateSegs(segCopy);
        cubeManager.updateCube(update);
    }
}

