/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.internal.BulkFuture;
import org.apache.kylin.cache.memcached.KeyHookLookup;
import org.apache.kylin.cache.memcached.MemcachedCache;
import org.apache.kylin.cache.memcached.MemcachedCacheConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.base.Charsets;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.base.Throwables;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedChunkingCache
extends MemcachedCache
implements KeyHookLookup {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedChunkingCache.class);

    public MemcachedChunkingCache(MemcachedCache cache) {
        super(cache);
        Preconditions.checkArgument(this.config.getMaxChunkSize() > 1, "maxChunkSize [%d] must be greater than 1", this.config.getMaxChunkSize());
        Preconditions.checkArgument(this.config.getMaxObjectSize() > 261, "maxObjectSize [%d] must be greater than 261", this.config.getMaxObjectSize());
    }

    protected static byte[][] splitBytes(byte[] data, int nSplit) {
        byte[][] dest = new byte[nSplit][];
        int splitSize = (data.length - 1) / nSplit + 1;
        for (int i = 0; i < nSplit - 1; ++i) {
            dest[i] = Arrays.copyOfRange(data, i * splitSize, (i + 1) * splitSize);
        }
        dest[nSplit - 1] = Arrays.copyOfRange(data, (nSplit - 1) * splitSize, data.length);
        return dest;
    }

    protected static int getValueSplit(MemcachedCacheConfig config, String keyS, int valueBLen) {
        int valueSize = config.getMaxObjectSize() - 2 - 4 - keyS.getBytes(Charsets.UTF_8).length - 6;
        int maxValueSize = config.getMaxChunkSize() * valueSize;
        Preconditions.checkArgument(valueBLen <= maxValueSize, "the value bytes length [%d] exceeds maximum value size [%d]", valueBLen, maxValueSize);
        return (valueBLen - 1) / valueSize + 1;
    }

    protected static Pair<KeyHookLookup.KeyHook, byte[][]> getKeyValuePair(int nSplit, String keyS, byte[] valueB) {
        KeyHookLookup.KeyHook keyHook;
        byte[][] splitValueB = null;
        if (nSplit > 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Enable chunking for putting large cached object values, chunk size = " + nSplit + ", original value bytes size = " + valueB.length);
            }
            String[] chunkKeySs = new String[nSplit];
            for (int i = 0; i < nSplit; ++i) {
                chunkKeySs[i] = keyS + i;
            }
            keyHook = new KeyHookLookup.KeyHook(chunkKeySs, null);
            splitValueB = MemcachedChunkingCache.splitBytes(valueB, nSplit);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Chunking not enabled, put the original value bytes to keyhook directly, original value bytes size = " + valueB.length);
            }
            keyHook = new KeyHookLookup.KeyHook(null, valueB);
        }
        return new Pair<KeyHookLookup.KeyHook, byte[][]>(keyHook, splitValueB);
    }

    @Override
    public byte[] getBinary(String keyS) {
        BulkFuture bulkFuture;
        if (Strings.isNullOrEmpty(keyS)) {
            return null;
        }
        KeyHookLookup.KeyHook keyHook = this.lookupKeyHook(keyS);
        if (keyHook == null) {
            return null;
        }
        if (keyHook.getChunkskey() == null || keyHook.getChunkskey().length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Chunking not enabled, return the value bytes in the keyhook directly, value bytes size = " + keyHook.getValues().length);
            }
            return keyHook.getValues();
        }
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Chunking enabled, chunk size = " + keyHook.getChunkskey().length);
        }
        Map<String, String> keyLookup = this.computeKeyHash(Arrays.asList(keyHook.getChunkskey()));
        try {
            bulkFuture = this.client.asyncGetBulk(keyLookup.keySet());
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation.", e);
            return null;
        }
        catch (Throwable t) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation.", t);
            return null;
        }
        try {
            Map bulkResult = (Map)bulkFuture.get(this.config.getTimeout(), TimeUnit.MILLISECONDS);
            this.cacheGetTime.addAndGet(System.currentTimeMillis() - start);
            if (bulkResult.size() != keyHook.getChunkskey().length) {
                this.missCount.incrementAndGet();
                logger.warn("Some paritial chunks missing for query key:" + keyS);
                for (String partitalKey : bulkResult.keySet()) {
                    this.client.delete(partitalKey);
                }
                this.deleteKeyHook(keyS);
                return null;
            }
            this.hitCount.getAndAdd(keyHook.getChunkskey().length);
            byte[][] bytesArray = new byte[keyHook.getChunkskey().length][];
            for (Map.Entry entry : bulkResult.entrySet()) {
                byte[] bytes = (byte[])entry.getValue();
                this.readBytes.addAndGet(bytes.length);
                String originalKeyS = keyLookup.get(entry.getKey());
                int idx = Integer.parseInt(originalKeyS.substring(keyS.length()));
                bytesArray[idx] = this.decodeValue(originalKeyS.getBytes(Charsets.UTF_8), bytes);
            }
            return this.concatBytes(bytesArray);
        }
        catch (TimeoutException e) {
            this.timeoutCount.incrementAndGet();
            bulkFuture.cancel(false);
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
        catch (ExecutionException e) {
            this.errorCount.incrementAndGet();
            logger.error("ExecutionException when pulling item from cache.", e);
            return null;
        }
    }

    @Override
    public void putBinary(String keyS, byte[] valueB, int expiration) {
        if (Strings.isNullOrEmpty(keyS)) {
            return;
        }
        int nSplit = MemcachedChunkingCache.getValueSplit(this.config, keyS, valueB.length);
        Pair<KeyHookLookup.KeyHook, byte[][]> keyValuePair = MemcachedChunkingCache.getKeyValuePair(nSplit, keyS, valueB);
        KeyHookLookup.KeyHook keyHook = keyValuePair.getFirst();
        byte[][] splitValueB = keyValuePair.getSecond();
        if (logger.isDebugEnabled()) {
            logger.debug("put key hook:{} to cache for hash key", (Object)keyHook);
        }
        super.putBinary(keyS, this.serializeValue(keyHook), expiration);
        if (nSplit > 1) {
            for (int i = 0; i < nSplit; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Chunk[" + i + "] bytes size before encoding  = " + splitValueB[i].length);
                }
                super.putBinary(keyHook.getChunkskey()[i], splitValueB[i], expiration);
            }
        }
    }

    @Override
    public void evict(String keyS) {
        if (Strings.isNullOrEmpty(keyS)) {
            return;
        }
        KeyHookLookup.KeyHook keyHook = this.lookupKeyHook(keyS);
        if (keyHook == null) {
            return;
        }
        if (keyHook.getChunkskey() != null && keyHook.getChunkskey().length > 0) {
            String[] chunkKeys;
            for (String chunkKey : chunkKeys = keyHook.getChunkskey()) {
                super.evict(chunkKey);
            }
        }
        super.evict(keyS);
    }

    protected Map<String, String> computeKeyHash(List<String> keySList) {
        return Maps.uniqueIndex(keySList, new Function<String, String>(){

            @Override
            public String apply(String keyS) {
                return MemcachedChunkingCache.this.computeKeyHash(keyS);
            }
        });
    }

    private void deleteKeyHook(String keyS) {
        try {
            super.evict(keyS);
        }
        catch (IllegalStateException e) {
            this.errorCount.incrementAndGet();
            logger.error("Unable to queue cache operation: ", e);
        }
    }

    private byte[] concatBytes(byte[] ... bytesArray) {
        int length = 0;
        for (byte[] bytes : bytesArray) {
            length += bytes.length;
        }
        byte[] result = new byte[length];
        int destPos = 0;
        for (byte[] bytes : bytesArray) {
            System.arraycopy(bytes, 0, result, destPos, bytes.length);
            destPos += bytes.length;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Original value bytes size for all chunks  = " + result.length);
        }
        return result;
    }

    @Override
    public KeyHookLookup.KeyHook lookupKeyHook(String keyS) {
        byte[] bytes = super.getBinary(keyS);
        if (bytes == null) {
            return null;
        }
        return (KeyHookLookup.KeyHook)SerializationUtils.deserialize(bytes);
    }
}

