/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;

public class GatewayTestConfig
extends Configuration
implements GatewayConfig {
    public static final boolean DEFAULT_WEBSOCKET_FEATURE_ENABLED = false;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_INPUT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_WEBSOCKET_ASYNC_WRITE_TIMEOUT = 60000;
    public static final int DEFAULT_WEBSOCKET_IDLE_TIMEOUT = 300000;
    public static final int DEFAULT_WEBSOCKET_MAX_WAIT_BUFFER_COUNT = 100;
    private static final boolean DEFAULT_WEBSHELL_FEATURE_ENABLED = false;
    private static final boolean DEFAULT_WEBSHELL_AUDIT_LOGGING_ENABLED = false;
    public static final int DEFAULT_WEBSHELL_MAX_CONCURRENT_SESSIONS = 3;
    public static final int DEFAULT_WEBSHELL_READ_BUFFER_SIZE = 1024;
    private Path gatewayHomePath = Paths.get("gateway-home", new String[0]);
    private String hadoopConfDir = "hadoop";
    private String gatewayHost = "localhost";
    private int gatewayPort;
    private String gatewayPath = "gateway";
    private boolean hadoopKerberosSecured;
    private String kerberosConfig;
    private boolean kerberosDebugEnabled;
    private String kerberosLoginConfig;
    private String frontendUrl;
    private boolean xForwardedEnabled = true;
    private String gatewayApplicationsDir;
    private String gatewayServicesDir;
    private String defaultTopologyName = "default";
    private List<String> includedSSLCiphers;
    private List<String> excludedSSLCiphers;
    private boolean sslEnabled;
    private String truststoreType = "jks";
    private String keystoreType = "jks";
    private boolean isTopologyPortMappingEnabled = true;
    private ConcurrentMap<String, Integer> topologyPortMapping = new ConcurrentHashMap<String, Integer>();
    private int backupVersionLimit = -1;
    private long backupAgeLimit = -1L;

    public GatewayTestConfig(Properties props) {
        super.getProps().putAll((Map<?, ?>)props);
    }

    public GatewayTestConfig() {
        Iterable<Path> paths = FileSystems.getDefault().getRootDirectories();
        Path rootPath = null;
        Iterator<Path> iterator = paths.iterator();
        while (iterator.hasNext()) {
            Path path;
            rootPath = path = iterator.next();
        }
        if (rootPath == null) {
            rootPath = Paths.get("/", new String[0]);
        }
        Path etcConfKnoxPath = rootPath.resolve("etc").resolve("knox").resolve("conf");
        this.kerberosConfig = etcConfKnoxPath.resolve("krb5.conf").toString();
        this.kerberosLoginConfig = etcConfKnoxPath.resolve("krb5JAASLogin.conf").toString();
    }

    public void setGatewayHomeDir(String gatewayHomeDir) {
        this.gatewayHomePath = Paths.get(gatewayHomeDir, new String[0]);
    }

    public String getGatewayHomeDir() {
        return this.gatewayHomePath.toString();
    }

    public String getGatewayConfDir() {
        return this.getGatewayConfPath().toString();
    }

    private Path getGatewayConfPath() {
        return this.gatewayHomePath.resolve("conf");
    }

    public String getGatewayDataDir() {
        return this.getGatewayDataPath().toString();
    }

    private Path getGatewayDataPath() {
        return this.gatewayHomePath.resolve("data");
    }

    public String getGatewayPIDDir() {
        return this.getGatewayPIDPath().toString();
    }

    private Path getGatewayPIDPath() {
        return this.gatewayHomePath.resolve("pid");
    }

    public String getGatewaySecurityDir() {
        return this.getGatewaySecurityPath().toString();
    }

    private Path getGatewaySecurityPath() {
        return this.getGatewayDataPath().resolve("security");
    }

    public String getGatewayKeystoreDir() {
        return this.getGatewayKeystorePath().toString();
    }

    private Path getGatewayKeystorePath() {
        return this.getGatewayDataPath().resolve("keystores");
    }

    public String getGatewayTopologyDir() {
        return this.gatewayHomePath.resolve("topologies").toString();
    }

    public String getGatewayDeploymentDir() {
        return this.gatewayHomePath.resolve("deployments").toString();
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public List<String> getGatewayHost() {
        ArrayList<String> hosts = new ArrayList<String>();
        hosts.add(this.gatewayHost);
        return hosts;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public String getGatewayPath() {
        return this.gatewayPath;
    }

    public void setGatewayPath(String gatewayPath) {
        this.gatewayPath = gatewayPath;
    }

    public List<InetSocketAddress> getGatewayAddress() throws UnknownHostException {
        List<String> hostIps = this.getGatewayHost();
        int port = this.getGatewayPort();
        ArrayList<InetSocketAddress> socketAddressList = new ArrayList<InetSocketAddress>();
        for (String host : hostIps) {
            socketAddressList.add(new InetSocketAddress(host, port));
        }
        return socketAddressList;
    }

    public long getGatewayIdleTimeout() {
        return 0L;
    }

    public String getIdentityKeystorePath() {
        return this.getGatewayKeystorePath().resolve("gateway.jks").toString();
    }

    public String getIdentityKeystoreType() {
        return DEFAULT_IDENTITY_KEYSTORE_TYPE;
    }

    public String getIdentityKeystorePasswordAlias() {
        return "gateway-identity-keystore-password";
    }

    public String getIdentityKeyAlias() {
        return "gateway-identity";
    }

    public String getIdentityKeyPassphraseAlias() {
        return "gateway-identity-passphrase";
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isHadoopKerberosSecured() {
        return this.hadoopKerberosSecured;
    }

    public void setHadoopKerberosSecured(boolean hadoopKerberosSecured) {
        this.hadoopKerberosSecured = hadoopKerberosSecured;
    }

    public String getKerberosConfig() {
        return this.kerberosConfig;
    }

    public void setKerberosConfig(String kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public boolean isKerberosDebugEnabled() {
        return this.kerberosDebugEnabled;
    }

    public void setKerberosDebugEnabled(boolean kerberosDebugEnabled) {
        this.kerberosDebugEnabled = kerberosDebugEnabled;
    }

    public String getKerberosLoginConfig() {
        return this.kerberosLoginConfig;
    }

    public String getDefaultTopologyName() {
        return this.defaultTopologyName;
    }

    public void setDefaultTopologyName(String defaultTopologyName) {
        this.defaultTopologyName = defaultTopologyName;
    }

    public String getDefaultAppRedirectPath() {
        if (StringUtils.isBlank((CharSequence)this.defaultTopologyName)) {
            return "/gateway/sandbox";
        }
        return "/gateway/" + this.defaultTopologyName;
    }

    public String getFrontendUrl() {
        return this.frontendUrl;
    }

    public void setFrontendUrl(String frontendUrl) {
        this.frontendUrl = frontendUrl;
    }

    public Set<String> getIncludedSSLProtocols() {
        return Collections.singleton("TLSv1.2");
    }

    public List<String> getExcludedSSLProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("SSLv3");
        return protocols;
    }

    public List<String> getIncludedSSLCiphers() {
        return this.includedSSLCiphers;
    }

    public void setIncludedSSLCiphers(List<String> list) {
        this.includedSSLCiphers = list;
    }

    public List<String> getExcludedSSLCiphers() {
        return this.excludedSSLCiphers;
    }

    public boolean isSSLRenegotiationAllowed() {
        return true;
    }

    public void setExcludedSSLCiphers(List<String> list) {
        this.excludedSSLCiphers = list;
    }

    public boolean isClientAuthNeeded() {
        return false;
    }

    public boolean isTopologyExcludedFromClientAuth(String topology) {
        return false;
    }

    public String getTruststorePath() {
        return null;
    }

    public boolean getTrustAllCerts() {
        return false;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststorePasswordAlias() {
        return null;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKerberosLoginConfig(String kerberosLoginConfig) {
        this.kerberosLoginConfig = kerberosLoginConfig;
    }

    public String getGatewayServicesDir() {
        if (this.gatewayServicesDir != null) {
            return this.gatewayServicesDir;
        }
        return Paths.get(System.getProperty("user.dir"), "target", "services").toString();
    }

    public void setGatewayServicesDir(String gatewayServicesDir) {
        this.gatewayServicesDir = gatewayServicesDir;
    }

    public String getGatewayApplicationsDir() {
        if (this.gatewayApplicationsDir != null) {
            return this.gatewayApplicationsDir;
        }
        return this.getGatewayConfPath().resolve("applications").toString();
    }

    public void setGatewayApplicationsDir(String gatewayApplicationsDir) {
        this.gatewayApplicationsDir = gatewayApplicationsDir;
    }

    public boolean isXForwardedEnabled() {
        return this.xForwardedEnabled;
    }

    public void setXForwardedEnabled(boolean enabled) {
        this.xForwardedEnabled = enabled;
    }

    public String getEphemeralDHKeySize() {
        return "2048";
    }

    public int getHttpClientMaxConnections() {
        return 16;
    }

    public int getHttpClientConnectionTimeout() {
        return -1;
    }

    public int getHttpClientSocketTimeout() {
        return -1;
    }

    public String getHttpClientTruststorePath() {
        return null;
    }

    public String getHttpClientTruststoreType() {
        return null;
    }

    public String getHttpClientTruststorePasswordAlias() {
        return null;
    }

    public String getCredentialStoreAlgorithm() {
        return "AES";
    }

    public String getSelfSigningCertificateAlgorithm() {
        return "SHA256withRSA";
    }

    public String getCredentialStoreType() {
        return "JCEKS";
    }

    public int getThreadPoolMax() {
        return 254;
    }

    public int getHttpServerRequestBuffer() {
        return 16384;
    }

    public int getHttpServerRequestHeaderBuffer() {
        return 8192;
    }

    public int getHttpServerResponseBuffer() {
        return 32768;
    }

    public int getHttpServerResponseHeaderBuffer() {
        return 8192;
    }

    public void setGatewayDeploymentsBackupVersionLimit(int newBackupVersionLimit) {
        this.backupVersionLimit = newBackupVersionLimit;
    }

    public int getGatewayDeploymentsBackupVersionLimit() {
        return this.backupVersionLimit;
    }

    public void setTopologyPortMapping(ConcurrentMap<String, Integer> topologyPortMapping) {
        this.topologyPortMapping = topologyPortMapping;
    }

    public void setGatewayPortMappingEnabled(boolean topologyPortMappingEnabled) {
        this.isTopologyPortMappingEnabled = topologyPortMappingEnabled;
    }

    public long getGatewayDeploymentsBackupAgeLimit() {
        return this.backupAgeLimit;
    }

    public void setGatewayDeploymentsBackupAgeLimit(long newBackupAgeLimit) {
        this.backupAgeLimit = newBackupAgeLimit;
    }

    public String getSigningKeystoreName() {
        return null;
    }

    public String getSigningKeystorePath() {
        return this.getGatewayKeystorePath().resolve("gateway.jks").toString();
    }

    public String getSigningKeystoreType() {
        return DEFAULT_SIGNING_KEYSTORE_TYPE;
    }

    public String getSigningKeyAlias() {
        return "gateway-identity";
    }

    public String getSigningKeystorePasswordAlias() {
        return "signing.keystore.password";
    }

    public String getSigningKeyPassphraseAlias() {
        return "signing.key.passphrase";
    }

    public List<String> getGlobalRulesServices() {
        ArrayList<String> services = new ArrayList<String>();
        services.add("WEBHDFS");
        services.add("HBASE");
        services.add("HIVE");
        services.add("OOZIE");
        services.add("RESOURCEMANAGER");
        services.add("STORM");
        return services;
    }

    public boolean isWebsocketEnabled() {
        return false;
    }

    public boolean isWebShellEnabled() {
        return false;
    }

    public boolean isWebShellAuditLoggingEnabled() {
        return false;
    }

    public int getMaximumConcurrentWebshells() {
        return 3;
    }

    public int getWebShellReadBufferSize() {
        return 1024;
    }

    public int getWebsocketMaxTextMessageSize() {
        return Integer.MAX_VALUE;
    }

    public int getWebsocketMaxBinaryMessageSize() {
        return Integer.MAX_VALUE;
    }

    public int getWebsocketMaxTextMessageBufferSize() {
        return 32768;
    }

    public int getWebsocketMaxBinaryMessageBufferSize() {
        return 32768;
    }

    public int getWebsocketInputBufferSize() {
        return 4096;
    }

    public int getWebsocketAsyncWriteTimeout() {
        return 60000;
    }

    public int getWebsocketIdleTimeout() {
        return 300000;
    }

    public int getWebsocketMaxWaitBufferCount() {
        return 100;
    }

    public boolean isMetricsEnabled() {
        return false;
    }

    public boolean isJmxMetricsReportingEnabled() {
        return false;
    }

    public boolean isGraphiteMetricsReportingEnabled() {
        return false;
    }

    public String getGraphiteHost() {
        return null;
    }

    public int getGraphitePort() {
        return 0;
    }

    public int getGraphiteReportingFrequency() {
        return 0;
    }

    public boolean isCookieScopingToPathEnabled() {
        return false;
    }

    public String getHeaderNameForRemoteAddress() {
        return "X-Forwarded-For";
    }

    public String getAlgorithm() {
        return null;
    }

    public String getPBEAlgorithm() {
        return null;
    }

    public String getTransformation() {
        return null;
    }

    public String getSaltSize() {
        return null;
    }

    public String getIterationCount() {
        return null;
    }

    public String getKeyLength() {
        return null;
    }

    public Map<String, Integer> getGatewayPortMappings() {
        return this.topologyPortMapping;
    }

    public boolean isGatewayPortMappingEnabled() {
        return this.isTopologyPortMappingEnabled;
    }

    public boolean isGatewayServerHeaderEnabled() {
        return false;
    }

    public String getDefaultDiscoveryAddress() {
        return null;
    }

    public String getDefaultDiscoveryCluster() {
        return null;
    }

    public boolean isClientAuthWanted() {
        return false;
    }

    public String getGatewayProvidersConfigDir() {
        return this.getGatewayConfPath().resolve("shared-providers").toString();
    }

    public String getGatewayDescriptorsDir() {
        return this.getGatewayConfPath().resolve("descriptors").toString();
    }

    public List<String> getRemoteRegistryConfigurationNames() {
        return Collections.emptyList();
    }

    public String getRemoteRegistryConfiguration(String s) {
        return null;
    }

    public String getRemoteConfigurationMonitorClientName() {
        return null;
    }

    public boolean isRemoteAliasServiceEnabled() {
        return true;
    }

    public String getRemoteAliasServiceConfigurationPrefix() {
        return null;
    }

    public Map<String, String> getRemoteAliasServiceConfiguration() {
        return Collections.emptyMap();
    }

    public int getClusterMonitorPollingInterval(String type) {
        return 600;
    }

    public boolean isClusterMonitorEnabled(String type) {
        return false;
    }

    public boolean allowUnauthenticatedRemoteRegistryReadAccess() {
        return false;
    }

    public List<String> getReadOnlyOverrideTopologyNames() {
        ArrayList<String> readOnly = new ArrayList<String>();
        String value = this.get("gateway.read.only.override.topologies");
        if (value != null && !value.isEmpty()) {
            readOnly.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return readOnly;
    }

    public List<String> getReadOnlyOverrideProviderNames() {
        ArrayList<String> readOnly = new ArrayList<String>();
        String value = this.get("gateway.read.only.override.providers");
        if (value != null && !value.isEmpty()) {
            readOnly.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return readOnly;
    }

    public String getKnoxAdminGroups() {
        return null;
    }

    public String getKnoxAdminUsers() {
        return null;
    }

    public String getFederationHeaderName() {
        return "SM_USER";
    }

    public List<String> getAutoDeployTopologyNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("manager");
        names.add("admin");
        return null;
    }

    public String getDispatchWhitelist() {
        return null;
    }

    public List<String> getDispatchWhitelistServices() {
        return Collections.emptyList();
    }

    public boolean isTopologyValidationEnabled() {
        return false;
    }

    public boolean topologyRedeploymentRequiresChanges() {
        return false;
    }

    public List<String> getXForwardContextAppendServices() {
        return null;
    }

    public Set<String> getServicesToIgnoreDoAs() {
        return null;
    }

    public long getClouderaManagerDescriptorsMonitoringInterval() {
        return 0L;
    }

    public long getClouderaManagerAdvancedServiceDiscoveryConfigurationMonitoringInterval() {
        return 0L;
    }

    public long getClouderaManagerServiceDiscoveryRepositoryEntryTTL() {
        return 0L;
    }

    public int getClouderaManagerServiceDiscoveryMaximumRetryAttempts() {
        return -1;
    }

    public Collection<String> getClouderaManagerServiceDiscoveryExcludedServiceTypes() {
        return Collections.emptySet();
    }

    public Collection<String> getClouderaManagerServiceDiscoveryExcludedRoleTypes() {
        return Collections.emptySet();
    }

    public String getClouderaManagerServiceDiscoveryApiVersion() {
        return "v32";
    }

    public String getClouderaManagerServiceDiscoveryRoleFetchStrategy() {
        return "byRole";
    }

    public boolean isServerManagedTokenStateEnabled() {
        return false;
    }

    public long getKnoxTokenEvictionInterval() {
        return 0L;
    }

    public long getKnoxTokenEvictionGracePeriod() {
        return 0L;
    }

    public long getKnoxTokenStateAliasPersistenceInterval() {
        return 0L;
    }

    public String getKnoxTokenHashAlgorithm() {
        return null;
    }

    public int getMaximumNumberOfTokensPerUser() {
        return 0;
    }

    public Set<String> getHiddenTopologiesOnHomepage() {
        return Collections.emptySet();
    }

    public Set<String> getPinnedTopologiesOnHomepage() {
        return Collections.emptySet();
    }

    public String getApiServicesViewVersionOnHomepage() {
        return "v1";
    }

    public boolean isKnoxTokenPermissiveValidationEnabled() {
        return false;
    }

    public String getServiceParameter(String service, String parameter) {
        return "";
    }

    public boolean homePageLogoutEnabled() {
        return false;
    }

    public String getGlobalLogoutPageUrl() {
        return null;
    }

    public long getKeystoreCacheSizeLimit() {
        return 0L;
    }

    public long getKeystoreCacheEntryTimeToLiveInMinutes() {
        return 0L;
    }

    public boolean isGatewayServerIncomingXForwardedSupportEnabled() {
        return true;
    }

    public Map<String, Collection<String>> getHomePageProfiles() {
        return null;
    }

    public String getDatabaseType() {
        return "derbydb";
    }

    public String getDatabaseConnectionUrl() {
        return null;
    }

    public String getDatabaseHost() {
        return null;
    }

    public int getDatabasePort() {
        return 0;
    }

    public String getDatabaseName() {
        return Paths.get(this.getGatewaySecurityDir(), "tokens").toString();
    }

    public boolean isDatabaseSslEnabled() {
        return false;
    }

    public boolean verifyDatabaseSslServerCertificate() {
        return false;
    }

    public String getDatabaseSslTruststoreFileName() {
        return null;
    }

    public int getJettyMaxFormContentSize() {
        return 0;
    }

    public int getJettyMaxFormKeys() {
        return 0;
    }

    public int getPrivilegedUsersConcurrentSessionLimit() {
        return 0;
    }

    public int getNonPrivilegedUsersConcurrentSessionLimit() {
        return 0;
    }

    public Set<String> getSessionVerificationPrivilegedUsers() {
        return null;
    }

    public Set<String> getSessionVerificationUnlimitedUsers() {
        return null;
    }

    public long getDbRemoteConfigMonitorPollingInterval() {
        return 30L;
    }

    public int getDbRemoteConfigMonitorCleanUpInterval() {
        return 1;
    }

    public long getConcurrentSessionVerifierExpiredTokensCleaningPeriod() {
        return 0L;
    }

    public Set<String> getHealthCheckTopologies() {
        return Collections.emptySet();
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean canSeeAllTokens(String userName) {
        return false;
    }

    public Map<String, Collection<String>> getApplicationPathAliases() {
        return Collections.emptyMap();
    }

    public long getServiceDiscoveryConnectTimeoutMillis() {
        return -1L;
    }

    public long getClouderaManagerServiceDiscoveryConnectTimeoutMillis() {
        return -1L;
    }

    public long getServiceDiscoveryReadTimeoutMillis() {
        return -1L;
    }

    public long getClouderaManagerServiceDiscoveryReadTimeoutMillis() {
        return -1L;
    }

    public long getServiceDiscoveryWriteTimeoutMillis() {
        return -1L;
    }

    public long getClouderaManagerServiceDiscoveryWriteTimeoutMillis() {
        return -1L;
    }

    public long getClouderaManagerServiceDiscoveryRoleConfigPageSize() {
        return 500L;
    }

    public boolean skipTokenMigration() {
        return true;
    }

    public boolean archiveMigratedTokens() {
        return false;
    }

    public boolean migrateExpiredTokens() {
        return false;
    }

    public boolean printVerboseTokenMigrationMessages() {
        return false;
    }

    public int getTokenMigrationProgressCount() {
        return 1;
    }

    public String getHttpClientCookieSpec() {
        return null;
    }

    public String getBannerText() {
        return null;
    }

    public long getJwksOutageCacheTTL() {
        return TimeUnit.HOURS.toMillis(2L);
    }

    public long getJwksCacheTimeToLive() {
        return 0L;
    }

    public long getJwksCacheRefreshTimeout() {
        return 0L;
    }

    public Set<String> getIssuersWithIgnoredTypeHeader() {
        return Collections.emptySet();
    }

    public boolean isStrictTransportEnabled() {
        return true;
    }

    public String getStrictTransportOption() {
        return "max-age=3001";
    }
}

