/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Arguments used for the collectDiagnosticData command.")
public class ApiCollectDiagnosticDataArguments {
    @SerializedName(value="collectCMDBDump")
    private Boolean collectCMDBDump = null;
    @SerializedName(value="bundleSizeBytes")
    private BigDecimal bundleSizeBytes = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="includeInfoLog")
    private Boolean includeInfoLog = null;
    @SerializedName(value="ticketNumber")
    private String ticketNumber = null;
    @SerializedName(value="comments")
    private String comments = null;
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="enableMonitorMetricsCollection")
    private Boolean enableMonitorMetricsCollection = null;
    @SerializedName(value="roles")
    private List<String> roles = null;
    @SerializedName(value="phoneHome")
    private Boolean phoneHome = null;

    public ApiCollectDiagnosticDataArguments collectCMDBDump(Boolean collectCMDBDump) {
        this.collectCMDBDump = collectCMDBDump;
        return this;
    }

    @Schema(description="")
    public Boolean isCollectCMDBDump() {
        return this.collectCMDBDump;
    }

    public void setCollectCMDBDump(Boolean collectCMDBDump) {
        this.collectCMDBDump = collectCMDBDump;
    }

    public ApiCollectDiagnosticDataArguments bundleSizeBytes(BigDecimal bundleSizeBytes) {
        this.bundleSizeBytes = bundleSizeBytes;
        return this;
    }

    @Schema(description="The maximum approximate bundle size of the output file. Defaults to 0.")
    public BigDecimal getBundleSizeBytes() {
        return this.bundleSizeBytes;
    }

    public void setBundleSizeBytes(BigDecimal bundleSizeBytes) {
        this.bundleSizeBytes = bundleSizeBytes;
    }

    public ApiCollectDiagnosticDataArguments startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(description="This parameter is ignored between CM 4.5 and CM 5.7 versions. For versions from CM 4.5 to CM 5.7, use endTime and bundleSizeBytes instead.  For CM 5.7+ versions, startTime is an optional parameter that is with endTime and bundleSizeBytes. This was introduced to perform diagnostic data estimation and collection of global diagnostics data for a certain time range. The start time (in ISO 8601 format) of the period to collection statistics for.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiCollectDiagnosticDataArguments endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(description="The end time (in ISO 8601 format) of the period to collection statistics for.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiCollectDiagnosticDataArguments includeInfoLog(Boolean includeInfoLog) {
        this.includeInfoLog = includeInfoLog;
        return this;
    }

    @Schema(description="This parameter is ignored as of CM 4.5. INFO logs are always collected. Whether to include INFO level logs. WARN, ERROR, and FATAL level logs are always included.")
    public Boolean isIncludeInfoLog() {
        return this.includeInfoLog;
    }

    public void setIncludeInfoLog(Boolean includeInfoLog) {
        this.includeInfoLog = includeInfoLog;
    }

    public ApiCollectDiagnosticDataArguments ticketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
        return this;
    }

    @Schema(description="The support ticket number to attach to this data collection.")
    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public ApiCollectDiagnosticDataArguments comments(String comments) {
        this.comments = comments;
        return this;
    }

    @Schema(description="Comments to include with this data collection.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ApiCollectDiagnosticDataArguments clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Schema(description="Name of the cluster to collect. If null, collects from all clusters.")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiCollectDiagnosticDataArguments enableMonitorMetricsCollection(Boolean enableMonitorMetricsCollection) {
        this.enableMonitorMetricsCollection = enableMonitorMetricsCollection;
        return this;
    }

    @Schema(description="Flag to enable collection of metrics for chart display.")
    public Boolean isEnableMonitorMetricsCollection() {
        return this.enableMonitorMetricsCollection;
    }

    public void setEnableMonitorMetricsCollection(Boolean enableMonitorMetricsCollection) {
        this.enableMonitorMetricsCollection = enableMonitorMetricsCollection;
    }

    public ApiCollectDiagnosticDataArguments roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public ApiCollectDiagnosticDataArguments addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Schema(description="List of roles for which to get logs and metrics.  If set, this restricts the roles for log and metrics collection to the list specified.  If empty, the default is to get logs for all roles (in the selected cluster, if one is selected).  Introduced in API v10 of the API.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public ApiCollectDiagnosticDataArguments phoneHome(Boolean phoneHome) {
        this.phoneHome = phoneHome;
        return this;
    }

    @Schema(description="Flag to enable or disable diagnostic bundle upload to EDH.  If not set, the PHONE_HOME setting decides whether the bundle will get uploaded or not.")
    public Boolean isPhoneHome() {
        return this.phoneHome;
    }

    public void setPhoneHome(Boolean phoneHome) {
        this.phoneHome = phoneHome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCollectDiagnosticDataArguments apiCollectDiagnosticDataArguments = (ApiCollectDiagnosticDataArguments)o;
        return Objects.equals(this.collectCMDBDump, apiCollectDiagnosticDataArguments.collectCMDBDump) && Objects.equals(this.bundleSizeBytes, apiCollectDiagnosticDataArguments.bundleSizeBytes) && Objects.equals(this.startTime, apiCollectDiagnosticDataArguments.startTime) && Objects.equals(this.endTime, apiCollectDiagnosticDataArguments.endTime) && Objects.equals(this.includeInfoLog, apiCollectDiagnosticDataArguments.includeInfoLog) && Objects.equals(this.ticketNumber, apiCollectDiagnosticDataArguments.ticketNumber) && Objects.equals(this.comments, apiCollectDiagnosticDataArguments.comments) && Objects.equals(this.clusterName, apiCollectDiagnosticDataArguments.clusterName) && Objects.equals(this.enableMonitorMetricsCollection, apiCollectDiagnosticDataArguments.enableMonitorMetricsCollection) && Objects.equals(this.roles, apiCollectDiagnosticDataArguments.roles) && Objects.equals(this.phoneHome, apiCollectDiagnosticDataArguments.phoneHome);
    }

    public int hashCode() {
        return Objects.hash(this.collectCMDBDump, this.bundleSizeBytes, this.startTime, this.endTime, this.includeInfoLog, this.ticketNumber, this.comments, this.clusterName, this.enableMonitorMetricsCollection, this.roles, this.phoneHome);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCollectDiagnosticDataArguments {\n");
        sb.append("    collectCMDBDump: ").append(this.toIndentedString(this.collectCMDBDump)).append("\n");
        sb.append("    bundleSizeBytes: ").append(this.toIndentedString(this.bundleSizeBytes)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    includeInfoLog: ").append(this.toIndentedString(this.includeInfoLog)).append("\n");
        sb.append("    ticketNumber: ").append(this.toIndentedString(this.ticketNumber)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    enableMonitorMetricsCollection: ").append(this.toIndentedString(this.enableMonitorMetricsCollection)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    phoneHome: ").append(this.toIndentedString(this.phoneHome)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

