/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="topology")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Topology {
    @XmlElement(name="provider")
    @XmlElementWrapper(name="gateway")
    public List<Provider> providers;
    @XmlElement(name="service")
    public List<Service> services;
    @XmlElement
    private URI uri;
    @XmlElement
    private String name;
    @XmlElement
    private String path;
    @XmlElement
    private long timestamp;
    @XmlElement(name="generated")
    private boolean isGenerated;
    @XmlElement(name="application")
    private List<Application> applications;

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String defaultServicePath) {
        this.path = defaultServicePath;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public List<Service> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public List<Application> getApplications() {
        if (this.applications == null) {
            this.applications = new ArrayList<Application>();
        }
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public List<Provider> getProviders() {
        if (this.providers == null) {
            this.providers = new ArrayList<Provider>();
        }
        return this.providers;
    }

    public void setProviders(List<Provider> providers) {
        this.providers = providers;
    }

    public static class ParamDeserializer
    extends JsonDeserializer<List> {
        final ObjectMapper mapper = new ObjectMapper();

        public List<Param> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Map result = (Map)this.mapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, String>>(){});
            ArrayList<Param> params = new ArrayList<Param>();
            result.forEach((k, v) -> params.add(new Param((String)k, (String)v)));
            return params;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Param {
        @XmlElement
        private String name;
        @XmlElement
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Application
    extends Service {
        @Override
        public String getRole() {
            return this.getName();
        }

        @Override
        public void setRole(String role) {
            this.setName(role);
        }
    }

    public static class Descriptor {
        @JsonProperty(value="discovery-type")
        private String discoveryType;
        @JsonProperty(value="discovery-address")
        private String discoveryAddress;
        @JsonProperty(value="discovery-user")
        private String discoveryUser;
        @JsonProperty(value="discovery-pwd-alias")
        private String discoveryPasswordAlias;
        @JsonProperty(value="provider-config-ref")
        private String providerConfig;
        @JsonProperty(value="cluster")
        private String cluster;
        @JsonProperty(value="services")
        private List<Service> services;
        @JsonProperty(value="applications")
        private List<Application> applications;
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDiscoveryType() {
            return this.discoveryType;
        }

        public void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        public String getDiscoveryAddress() {
            return this.discoveryAddress;
        }

        public void setDiscoveryAddress(String discoveryAddress) {
            this.discoveryAddress = discoveryAddress;
        }

        public String getDiscoveryUser() {
            return this.discoveryUser;
        }

        public void setDiscoveryUser(String discoveryUser) {
            this.discoveryUser = discoveryUser;
        }

        public String getDiscoveryPasswordAlias() {
            return this.discoveryPasswordAlias;
        }

        public void setDiscoveryPasswordAlias(String discoveryPasswordAlias) {
            this.discoveryPasswordAlias = discoveryPasswordAlias;
        }

        public String getProviderConfig() {
            return this.providerConfig;
        }

        public void setProviderConfig(String providerConfig) {
            this.providerConfig = providerConfig;
        }

        public String getCluster() {
            return this.cluster;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public List<Service> getServices() {
            return this.services;
        }

        public void setServices(List<Service> services) {
            this.services = services;
        }

        public List<Application> getApplications() {
            return this.applications;
        }

        public void setApplications(List<Application> applications) {
            this.applications = applications;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @JsonPropertyOrder(value={"role", "name", "enabled", "param"})
    public static class Provider {
        private static Map<String, Integer> SHIRO_PROVIDER_PARAM_ORDER = new HashMap<String, Integer>();
        @JsonProperty(value="role")
        @XmlElement
        private String role;
        @JsonProperty(value="name")
        @XmlElement
        private String name;
        @XmlElement
        private boolean enabled;
        @XmlElement(name="param")
        @JsonDeserialize(using=ParamDeserializer.class)
        private List<Param> params;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="enabled")
        public String isEnabled() {
            return Boolean.toString(this.enabled);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public List<Param> getParams() {
            if ("ShiroProvider".equalsIgnoreCase(this.name) && this.params != null && !this.params.isEmpty()) {
                this.params.sort(Comparator.comparing(p -> SHIRO_PROVIDER_PARAM_ORDER.getOrDefault(p.getName(), Integer.MAX_VALUE)).thenComparing(p -> SHIRO_PROVIDER_PARAM_ORDER.getOrDefault(p.getName(), Integer.MAX_VALUE)));
            }
            if (this.params == null) {
                this.params = new ArrayList<Param>();
            }
            return this.params;
        }

        public void setParams(List<Param> params) {
            this.params = params;
        }

        @JsonProperty(value="params")
        public Map<String, String> getJsonParams() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.getParams().forEach(p -> result.put(p.getName(), p.getValue()));
            return result;
        }

        static {
            SHIRO_PROVIDER_PARAM_ORDER.put("sessionTimeout", 0);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapRealm", 1);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapContextFactory", 2);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapGroupContextFactory", 3);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapRealm.contextFactory", 4);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapRealm.userDnTemplate", 5);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapRealm.contextFactory.url", 6);
            SHIRO_PROVIDER_PARAM_ORDER.put("main.ldapRealm.contextFactory.authenticationMechanism", 7);
            SHIRO_PROVIDER_PARAM_ORDER.put("urls./**", 8);
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Service {
        @XmlElement
        private String role;
        @XmlElement
        private String name;
        @JsonProperty(value="version")
        @XmlElement
        private String version;
        @XmlElement(name="param")
        @JsonDeserialize(using=ParamDeserializer.class)
        private List<Param> params;
        @JsonProperty(value="urls")
        @XmlElement(name="url")
        private List<String> urls;

        @JsonProperty(value="name")
        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getUrls() {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            return this.urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public List<Param> getParams() {
            if (this.params == null) {
                this.params = new ArrayList<Param>();
            }
            return this.params;
        }

        public void setParams(List<Param> params) {
            this.params = params;
        }

        @JsonProperty(value="params")
        public Map<String, String> getJsonParams() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.getParams().forEach(p -> result.put(p.getName(), p.getValue()));
            return result;
        }
    }
}

