/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.fips;

import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.fips.BCInterceptingConnectionSocketFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class FipsConnectionManagerFactory {
    private static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);

    public static PoolingHttpClientConnectionManager createConnectionManager(SSLContext sslContext, int maxConnections) {
        LOG.configureInterceptingSocket();
        BCInterceptingConnectionSocketFactory BCInterceptingConnectionSocketFactory2 = sslContext != null ? new BCInterceptingConnectionSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext)) : new BCInterceptingConnectionSocketFactory((ConnectionSocketFactory)SSLConnectionSocketFactory.getSocketFactory());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)new BCInterceptingConnectionSocketFactory((ConnectionSocketFactory)PlainConnectionSocketFactory.getSocketFactory())).register("https", (Object)BCInterceptingConnectionSocketFactory2).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(maxConnections);
        connManager.setDefaultMaxPerRoute(maxConnections);
        return connManager;
    }
}

