/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Provides metadata information about a command.")
public class ApiCommandMetadata {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="argSchema")
    private String argSchema = null;

    public ApiCommandMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of of the command.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCommandMetadata argSchema(String argSchema) {
        this.argSchema = argSchema;
        return this;
    }

    @Schema(description="The command arguments schema.  This is in the form of json schema and describes the structure of the command arguments. If null, the command does not take arguments.")
    public String getArgSchema() {
        return this.argSchema;
    }

    public void setArgSchema(String argSchema) {
        this.argSchema = argSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommandMetadata apiCommandMetadata = (ApiCommandMetadata)o;
        return Objects.equals(this.name, apiCommandMetadata.name) && Objects.equals(this.argSchema, apiCommandMetadata.argSchema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.argSchema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommandMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    argSchema: ").append(this.toIndentedString(this.argSchema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

