/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.security.impl.CLIMasterService;
import org.apache.knox.gateway.services.security.impl.CMFMasterService;
import org.apache.knox.gateway.services.security.impl.DefaultMasterService;

public class MasterServiceFactory
extends AbstractServiceFactory {
    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        CMFMasterService service = null;
        if (this.shouldCreateService(implementation)) {
            if (this.matchesImplementation(implementation, DefaultMasterService.class, true)) {
                service = new DefaultMasterService();
            } else if (this.matchesImplementation(implementation, CLIMasterService.class)) {
                service = new CLIMasterService();
            }
            this.logServiceUsage(implementation, serviceType);
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.MASTER_SERVICE;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.unmodifiableList(Arrays.asList(DefaultMasterService.class.getName(), CLIMasterService.class.getName()));
    }
}

