/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.interceptor.context.AbstractChangeOperationContext;

public class ModifyOperationContext
extends AbstractChangeOperationContext {
    private List<Modification> modItems;
    private Entry alteredEntry;

    public ModifyOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MODIFY));
        }
    }

    public ModifyOperationContext(CoreSession session, Dn dn, List<Modification> modItems) {
        super(session, dn);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MODIFY));
        }
        this.modItems = modItems;
    }

    public ModifyOperationContext(CoreSession session, ModifyRequest modifyRequest) throws LdapException {
        super(session, modifyRequest.getName());
        if (session == null) {
            throw new LdapOperationErrorException("Cannot proceed the operation with no session");
        }
        this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.MODIFY));
        this.modItems = ServerEntryUtils.toServerModification((Modification[])modifyRequest.getModifications().toArray(new DefaultModification[0]), session.getDirectoryService().getSchemaManager());
        this.requestControls = modifyRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public void setModItems(List<Modification> modItems) {
        this.modItems = modItems;
    }

    public List<Modification> getModItems() {
        return this.modItems;
    }

    public static List<Modification> createModItems(Entry serverEntry, ModificationOperation modOp) {
        ArrayList<Modification> items = new ArrayList<Modification>(serverEntry.size());
        for (Attribute attribute : serverEntry) {
            items.add((Modification)new DefaultModification(modOp, attribute));
        }
        return items;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.MODIFY_REQUEST.name();
    }

    public Entry getAlteredEntry() {
        return this.alteredEntry;
    }

    public void setAlteredEntry(Entry alteredEntry) {
        this.alteredEntry = alteredEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ModifyContext for Dn '").append(this.getDn().getName()).append("', modifications :\n");
        if (this.modItems != null) {
            for (Modification mod : this.modItems) {
                sb.append(mod).append('\n');
            }
        }
        return sb.toString();
    }
}

