/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;

public class WireTapReifier
extends ToDynamicReifier<WireTapDefinition<?>> {
    public WireTapReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ExecutorService threadPool = this.getConfiguredExecutorService("WireTap", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ((WireTapDefinition)this.definition).setPattern(ExchangePattern.InOnly.name());
        SendDynamicProcessor dynamicTo = (SendDynamicProcessor)super.createProcessor();
        Processor target = this.wrapInErrorHandler((Processor)dynamicTo, true);
        CamelInternalProcessor internal = new CamelInternalProcessor(this.camelContext, target);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(this.route, this.camelContext));
        boolean isCopy = this.parseBoolean(((WireTapDefinition)this.definition).getCopy(), true);
        WireTapProcessor answer = new WireTapProcessor(dynamicTo, (Processor)internal, this.parse(ExchangePattern.class, ((WireTapDefinition)this.definition).getPattern()), threadPool, shutdownThreadPool, this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true));
        answer.setCopy(isCopy);
        Processor newExchangeProcessor = ((WireTapDefinition)this.definition).getNewExchangeProcessor();
        if (((WireTapDefinition)this.definition).getNewExchangeProcessorRef() != null) {
            newExchangeProcessor = this.mandatoryLookup(this.parseString(((WireTapDefinition)this.definition).getNewExchangeProcessorRef()), Processor.class);
        }
        if (newExchangeProcessor != null) {
            answer.addNewExchangeProcessor(newExchangeProcessor);
        }
        if (((WireTapDefinition)this.definition).getNewExchangeExpression() != null) {
            answer.setNewExchangeExpression(this.createExpression(((WireTapDefinition)this.definition).getNewExchangeExpression()));
        }
        if (((WireTapDefinition)this.definition).getHeaders() != null && !((WireTapDefinition)this.definition).getHeaders().isEmpty()) {
            for (SetHeaderDefinition header : ((WireTapDefinition)this.definition).getHeaders()) {
                Processor processor = this.createProcessor(header);
                answer.addNewExchangeProcessor(processor);
            }
        }
        Processor onPrepare = ((WireTapDefinition)this.definition).getOnPrepare();
        if (((WireTapDefinition)this.definition).getOnPrepareRef() != null) {
            onPrepare = this.mandatoryLookup(this.parseString(((WireTapDefinition)this.definition).getOnPrepareRef()), Processor.class);
        }
        if (onPrepare != null) {
            answer.setOnPrepare(onPrepare);
        }
        return answer;
    }

    @Override
    protected Expression createExpression(String uri) {
        if (this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true)) {
            return super.createExpression(uri);
        }
        return ExpressionBuilder.constantExpression((Object)uri);
    }
}

