/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.terminal.SignalSupport;

public class JLineTerminal
extends SignalSupport
implements Terminal,
Closeable {
    private final jline.Terminal terminal;
    private final String type;

    public JLineTerminal(jline.Terminal terminal, String type) {
        this.terminal = terminal;
        this.type = type;
        this.registerSignalHandler();
    }

    public jline.Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getHeight() {
        return this.terminal.getHeight();
    }

    @Override
    public boolean isAnsiSupported() {
        return this.terminal.isAnsiSupported();
    }

    @Override
    public boolean isEchoEnabled() {
        return this.terminal.isEchoEnabled();
    }

    @Override
    public void setEchoEnabled(boolean enabled) {
        this.terminal.setEchoEnabled(enabled);
    }

    @Override
    public void close() throws IOException {
        this.unregisterSignalHandler();
    }

    private void registerSignalHandler() {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{signalHandlerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    JLineTerminal.this.signal(Signal.WINCH);
                    return null;
                }
            });
            signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), signalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unregisterSignalHandler() {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = signalHandlerClass.getField("SIG_DFL").get(null);
            signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), signalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

