/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.state.blueprint.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintStateService
implements BlueprintListener,
BundleListener,
BundleStateService {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintStateService.class);
    private final Map<Long, BlueprintEvent> states = new ConcurrentHashMap<Long, BlueprintEvent>();

    public String getName() {
        return "Blueprint";
    }

    public String getDiag(Bundle bundle) {
        BlueprintEvent event = this.states.get(bundle.getBundleId());
        if (event == null) {
            return null;
        }
        if (event.getType() != 5 && event.getType() != 6 && event.getType() != 7) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        Date date = new Date(event.getTimestamp());
        SimpleDateFormat df = new SimpleDateFormat();
        message.append(df.format(date) + "\n");
        if (event.getCause() != null) {
            message.append("Exception: \n");
            this.addMessages(message, event.getCause());
        }
        if (event.getDependencies() != null) {
            message.append("Missing dependencies: \n");
            for (String dep : event.getDependencies()) {
                message.append(dep + " ");
            }
            message.append("\n");
        }
        return message.toString();
    }

    public void addMessages(StringBuilder message, Throwable ex) {
        message.append(ex.getMessage());
        message.append("\n");
        StringWriter errorWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(errorWriter));
        message.append(errorWriter.toString());
        message.append("\n");
    }

    public BundleState getState(Bundle bundle) {
        BlueprintEvent event = this.states.get(bundle.getBundleId());
        BundleState state = this.getState(event);
        return bundle.getState() != 32 ? BundleState.Unknown : state;
    }

    public void blueprintEvent(BlueprintEvent blueprintEvent) {
        if (LOG.isDebugEnabled()) {
            BundleState state = this.getState(blueprintEvent);
            LOG.debug("Blueprint app state changed to " + state + " for bundle " + blueprintEvent.getBundle().getBundleId());
        }
        this.states.put(blueprintEvent.getBundle().getBundleId(), blueprintEvent);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.states.remove(event.getBundle().getBundleId());
        }
    }

    private BundleState getState(BlueprintEvent blueprintEvent) {
        if (blueprintEvent == null) {
            return BundleState.Unknown;
        }
        switch (blueprintEvent.getType()) {
            case 1: {
                return BundleState.Starting;
            }
            case 2: {
                return BundleState.Active;
            }
            case 3: {
                return BundleState.Stopping;
            }
            case 4: {
                return BundleState.Resolved;
            }
            case 5: {
                return BundleState.Failure;
            }
            case 6: {
                return BundleState.GracePeriod;
            }
            case 7: {
                return BundleState.Waiting;
            }
        }
        return BundleState.Unknown;
    }
}

