/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import jline.console.KeyMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.ansi.AnsiSplitter;
import org.jledit.jline.NonBlockingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="less", description="File pager.")
@Service
public class LessAction
implements Action,
SignalListener {
    private static final int ESCAPE = 27;
    public static final int ESCAPE_TIMEOUT = 100;
    public static final int READ_EXPIRED = -2;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-e", aliases={"--quit-at-eof"})
    boolean quitAtSecondEof;
    @Option(name="-E", aliases={"--QUIT-AT-EOF"})
    boolean quitAtFirstEof;
    @Option(name="-N", aliases={"--LINE-NUMBERS"})
    boolean printLineNumbers;
    @Option(name="-q", aliases={"--quiet", "--silent"})
    boolean quiet;
    @Option(name="-Q", aliases={"--QUIET", "--SILENT"})
    boolean veryQuiet;
    @Option(name="-S", aliases={"--chop-long-lines"})
    boolean chopLongLines;
    @Option(name="-i", aliases={"--ignore-case"})
    boolean ignoreCaseCond;
    @Option(name="-I", aliases={"--IGNORE-CASE"})
    boolean ignoreCaseAlways;
    @Option(name="-x", aliases={"--tabs"})
    int tabs = 4;
    @Argument(multiValued=true)
    List<File> files;
    @Reference(optional=true)
    Terminal terminal;
    @Reference
    Session session;
    BufferedReader reader;
    NonBlockingInputStream consoleInput;
    Reader consoleReader;
    KeyMap keys;
    int firstLineInMemory = 0;
    List<String> lines = new ArrayList<String>();
    int firstLineToDisplay = 0;
    int firstColumnToDisplay = 0;
    int offsetInLine = 0;
    String message;
    final StringBuilder buffer = new StringBuilder();
    final StringBuilder opBuffer = new StringBuilder();
    final Stack<Character> pushBackChar = new Stack();
    Thread displayThread;
    final AtomicBoolean redraw = new AtomicBoolean();
    final Map<String, Operation> options = new TreeMap<String, Operation>();
    int window;
    int halfWindow;
    int nbEof;
    String pattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        InputStream in;
        if (this.files != null && !this.files.isEmpty()) {
            this.message = this.files.get(0).toString();
            in = new FileInputStream(this.files.get(0));
        } else {
            in = System.in;
        }
        this.reader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(in)));
        try {
            if (this.terminal == null || !this.isTty(System.out)) {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    System.out.println(line);
                    LessAction.checkInterrupted();
                }
                Object var3_4 = null;
                return var3_4;
            }
            boolean echo = this.terminal.isEchoEnabled();
            this.terminal.setEchoEnabled(false);
            this.terminal.addSignalListener((SignalListener)this, new Signal[]{Signal.WINCH});
            try {
                Operation op;
                this.window = this.terminal.getHeight() - 1;
                this.halfWindow = this.window / 2;
                this.keys = new KeyMap("less", false);
                this.bindKeys(this.keys);
                this.consoleInput = new NonBlockingInputStream(this.session.getKeyboard(), true);
                this.consoleReader = new InputStreamReader((InputStream)this.consoleInput);
                System.out.print("\u001b[?1049h");
                System.out.flush();
                this.displayThread = new Thread(){

                    @Override
                    public void run() {
                        LessAction.this.redrawLoop();
                    }
                };
                this.displayThread.start();
                this.redraw();
                LessAction.checkInterrupted();
                this.options.put("-e", Operation.OPT_QUIT_AT_SECOND_EOF);
                this.options.put("--quit-at-eof", Operation.OPT_QUIT_AT_SECOND_EOF);
                this.options.put("-E", Operation.OPT_QUIT_AT_FIRST_EOF);
                this.options.put("-QUIT-AT-EOF", Operation.OPT_QUIT_AT_FIRST_EOF);
                this.options.put("-N", Operation.OPT_PRINT_LINES);
                this.options.put("--LINE-NUMBERS", Operation.OPT_PRINT_LINES);
                this.options.put("-q", Operation.OPT_QUIET);
                this.options.put("--quiet", Operation.OPT_QUIET);
                this.options.put("--silent", Operation.OPT_QUIET);
                this.options.put("-Q", Operation.OPT_VERY_QUIET);
                this.options.put("--QUIET", Operation.OPT_VERY_QUIET);
                this.options.put("--SILENT", Operation.OPT_VERY_QUIET);
                this.options.put("-S", Operation.OPT_CHOP_LONG_LINES);
                this.options.put("--chop-long-lines", Operation.OPT_CHOP_LONG_LINES);
                this.options.put("-i", Operation.OPT_IGNORE_CASE_COND);
                this.options.put("--ignore-case", Operation.OPT_IGNORE_CASE_COND);
                this.options.put("-I", Operation.OPT_IGNORE_CASE_ALWAYS);
                this.options.put("--IGNORE-CASE", Operation.OPT_IGNORE_CASE_ALWAYS);
                do {
                    LessAction.checkInterrupted();
                    op = null;
                    if (this.buffer.length() > 0 && this.buffer.charAt(0) == '-') {
                        int c = this.consoleReader.read();
                        this.message = null;
                        if (this.buffer.length() == 1) {
                            this.buffer.append((char)c);
                            if (c != 45 && (op = this.options.get(this.buffer.toString())) == null) {
                                this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                this.buffer.setLength(0);
                            }
                        } else if (c == 13) {
                            op = this.options.get(this.buffer.toString());
                            if (op == null) {
                                this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                this.buffer.setLength(0);
                            }
                        } else {
                            this.buffer.append((char)c);
                            HashMap<String, Operation> matching = new HashMap<String, Operation>();
                            for (Map.Entry<String, Operation> entry : this.options.entrySet()) {
                                if (!entry.getKey().startsWith(this.buffer.toString())) continue;
                                matching.put(entry.getKey(), entry.getValue());
                            }
                            switch (matching.size()) {
                                case 0: {
                                    this.buffer.setLength(0);
                                    break;
                                }
                                case 1: {
                                    this.buffer.setLength(0);
                                    this.buffer.append((String)matching.keySet().iterator().next());
                                }
                            }
                        }
                    } else if (this.buffer.length() > 0 && (this.buffer.charAt(0) == '/' || this.buffer.charAt(0) == '?')) {
                        int c = this.consoleReader.read();
                        this.message = null;
                        if (c == 13) {
                            this.pattern = this.buffer.toString().substring(1);
                            if (this.buffer.charAt(0) == '/') {
                                this.moveToNextMatch();
                            } else {
                                this.moveToPreviousMatch();
                            }
                            this.buffer.setLength(0);
                        } else {
                            this.buffer.append((char)c);
                        }
                    } else {
                        Object obj = this.readOperation();
                        this.message = null;
                        if (obj instanceof Character) {
                            char c = ((Character)obj).charValue();
                            if (c == '-' || c == '/' || c == '?') {
                                this.buffer.setLength(0);
                            }
                            this.buffer.append(((Character)obj).charValue());
                        } else if (obj instanceof Operation) {
                            op = (Operation)((Object)obj);
                        }
                    }
                    if (op != null) {
                        switch (op) {
                            case FORWARD_ONE_LINE: {
                                this.moveForward(this.getStrictPositiveNumberInBuffer(1));
                                break;
                            }
                            case BACKWARD_ONE_LINE: {
                                this.moveBackward(this.getStrictPositiveNumberInBuffer(1));
                                break;
                            }
                            case FORWARD_ONE_WINDOW_OR_LINES: {
                                this.moveForward(this.getStrictPositiveNumberInBuffer(this.window));
                                break;
                            }
                            case FORWARD_ONE_WINDOW_AND_SET: {
                                this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                this.moveForward(this.window);
                                break;
                            }
                            case FORWARD_ONE_WINDOW_NO_STOP: {
                                this.moveForward(this.window);
                                break;
                            }
                            case FORWARD_HALF_WINDOW_AND_SET: {
                                this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                this.moveForward(this.halfWindow);
                                break;
                            }
                            case BACKWARD_ONE_WINDOW_AND_SET: {
                                this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                this.moveBackward(this.window);
                                break;
                            }
                            case BACKWARD_ONE_WINDOW_OR_LINES: {
                                this.moveBackward(this.getStrictPositiveNumberInBuffer(this.window));
                                break;
                            }
                            case BACKWARD_HALF_WINDOW_AND_SET: {
                                this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                this.moveBackward(this.halfWindow);
                                break;
                            }
                            case GO_TO_FIRST_LINE_OR_N: {
                                this.firstLineToDisplay = this.firstLineInMemory;
                                this.offsetInLine = 0;
                                break;
                            }
                            case GO_TO_LAST_LINE_OR_N: {
                                this.moveForward(Integer.MAX_VALUE);
                                break;
                            }
                            case LEFT_ONE_HALF_SCREEN: {
                                this.firstColumnToDisplay = Math.max(0, this.firstColumnToDisplay - this.terminal.getWidth() / 2);
                                break;
                            }
                            case RIGHT_ONE_HALF_SCREEN: {
                                this.firstColumnToDisplay += this.terminal.getWidth() / 2;
                                break;
                            }
                            case REPEAT_SEARCH_BACKWARD: 
                            case REPEAT_SEARCH_BACKWARD_SPAN_FILES: {
                                this.moveToPreviousMatch();
                                break;
                            }
                            case REPEAT_SEARCH_FORWARD: 
                            case REPEAT_SEARCH_FORWARD_SPAN_FILES: {
                                this.moveToNextMatch();
                                break;
                            }
                            case UNDO_SEARCH: {
                                this.pattern = null;
                                break;
                            }
                            case OPT_PRINT_LINES: {
                                this.buffer.setLength(0);
                                this.printLineNumbers = !this.printLineNumbers;
                                this.message = this.printLineNumbers ? "Constantly display line numbers" : "Don't use line numbers";
                                break;
                            }
                            case OPT_QUIET: {
                                this.buffer.setLength(0);
                                this.quiet = !this.quiet;
                                this.veryQuiet = false;
                                this.message = this.quiet ? "Ring the bell for errors but not at eof/bof" : "Ring the bell for errors AND at eof/bof";
                                break;
                            }
                            case OPT_VERY_QUIET: {
                                this.buffer.setLength(0);
                                this.veryQuiet = !this.veryQuiet;
                                this.quiet = false;
                                this.message = this.veryQuiet ? "Never ring the bell" : "Ring the bell for errors AND at eof/bof";
                                break;
                            }
                            case OPT_CHOP_LONG_LINES: {
                                this.buffer.setLength(0);
                                this.offsetInLine = 0;
                                this.chopLongLines = !this.chopLongLines;
                                this.message = this.chopLongLines ? "Chop long lines" : "Fold long lines";
                                break;
                            }
                            case OPT_IGNORE_CASE_COND: {
                                this.ignoreCaseCond = !this.ignoreCaseCond;
                                this.ignoreCaseAlways = false;
                                this.message = this.ignoreCaseCond ? "Ignore case in searches" : "Case is significant in searches";
                                break;
                            }
                            case OPT_IGNORE_CASE_ALWAYS: {
                                this.ignoreCaseAlways = !this.ignoreCaseAlways;
                                this.ignoreCaseCond = false;
                                this.message = this.ignoreCaseAlways ? "Ignore case in searches and in patterns" : "Case is significant in searches";
                            }
                        }
                        this.buffer.setLength(0);
                    }
                    this.redraw();
                    if ((!this.quitAtFirstEof || this.nbEof <= 0) && (!this.quitAtSecondEof || this.nbEof <= 1)) continue;
                    op = Operation.EXIT;
                } while (op != Operation.EXIT);
            }
            catch (InterruptedException ie) {
                this.log.debug("Interrupted by user");
            }
            finally {
                this.terminal.setEchoEnabled(echo);
                this.terminal.removeSignalListener((SignalListener)this);
                this.consoleInput.shutdown();
                this.displayThread.interrupt();
                this.displayThread.join();
                System.out.print("\u001b[?1049l");
                System.out.println();
                System.out.flush();
            }
        }
        finally {
            this.reader.close();
        }
        return null;
    }

    private void moveToNextMatch() throws IOException {
        Pattern compiled = this.getPattern();
        if (compiled != null) {
            String line;
            int lineNumber = this.firstLineToDisplay + 1;
            while ((line = this.getLine(lineNumber)) != null) {
                if (compiled.matcher(line).find()) {
                    this.firstLineToDisplay = lineNumber;
                    this.offsetInLine = 0;
                    return;
                }
                ++lineNumber;
            }
        }
        this.message = "Pattern not found";
    }

    private void moveToPreviousMatch() throws IOException {
        Pattern compiled = this.getPattern();
        if (compiled != null) {
            String line;
            for (int lineNumber = this.firstLineToDisplay - 1; lineNumber >= this.firstLineInMemory && (line = this.getLine(lineNumber)) != null; --lineNumber) {
                if (!compiled.matcher(line).find()) continue;
                this.firstLineToDisplay = lineNumber;
                this.offsetInLine = 0;
                return;
            }
        }
        this.message = "Pattern not found";
    }

    private String printable(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u001b') {
                sb.append("ESC");
                continue;
            }
            if (c < ' ') {
                sb.append('^').append((char)(c + 64));
                continue;
            }
            if (c < '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(String.format("03o", new Object[0]));
        }
        return sb.toString();
    }

    void moveForward(int lines) throws IOException {
        int width = this.terminal.getWidth() - (this.printLineNumbers ? 8 : 0);
        int height = this.terminal.getHeight();
        while (--lines >= 0) {
            int lastLineToDisplay = this.firstLineToDisplay;
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                lastLineToDisplay += height - 1;
            } else {
                int off = this.offsetInLine;
                for (int l = 0; l < height - 1; ++l) {
                    String line = this.getLine(lastLineToDisplay);
                    if (this.ansiLength(line) > off + width) {
                        off += width;
                        continue;
                    }
                    off = 0;
                    ++lastLineToDisplay;
                }
            }
            if (this.getLine(lastLineToDisplay) == null) {
                this.eof();
                return;
            }
            String line = this.getLine(this.firstLineToDisplay);
            if (this.ansiLength(line) > width + this.offsetInLine) {
                this.offsetInLine += width;
                continue;
            }
            this.offsetInLine = 0;
            ++this.firstLineToDisplay;
        }
    }

    void moveBackward(int lines) throws IOException {
        int width = this.terminal.getWidth() - (this.printLineNumbers ? 8 : 0);
        while (--lines >= 0) {
            if (this.offsetInLine > 0) {
                this.offsetInLine = Math.max(0, this.offsetInLine - width);
                continue;
            }
            if (this.firstLineInMemory < this.firstLineToDisplay) {
                --this.firstLineToDisplay;
                String line = this.getLine(this.firstLineToDisplay);
                int length = this.ansiLength(line);
                this.offsetInLine = length - length % width;
                continue;
            }
            this.bof();
            return;
        }
    }

    private void eof() {
        ++this.nbEof;
        this.message = "(END)";
        if (!(this.quiet || this.veryQuiet || this.quitAtFirstEof || this.quitAtSecondEof)) {
            System.out.print('\u0007');
            System.out.flush();
        }
    }

    private void bof() {
        if (!this.quiet && !this.veryQuiet) {
            System.out.print('\u0007');
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStrictPositiveNumberInBuffer(int def) {
        try {
            int n = Integer.parseInt(this.buffer.toString());
            int n2 = n > 0 ? n : def;
            return n2;
        }
        catch (NumberFormatException e) {
            int n = def;
            return n;
        }
        finally {
            this.buffer.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redraw() {
        AtomicBoolean atomicBoolean = this.redraw;
        synchronized (atomicBoolean) {
            this.redraw.set(true);
            this.redraw.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redrawLoop() {
        AtomicBoolean atomicBoolean = this.redraw;
        synchronized (atomicBoolean) {
            try {
                while (true) {
                    if (this.redraw.compareAndSet(true, false)) {
                        this.display();
                        continue;
                    }
                    this.redraw.wait();
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    void display() throws IOException {
        System.out.println();
        int width = this.terminal.getWidth() - (this.printLineNumbers ? 8 : 0);
        int height = this.terminal.getHeight();
        int inputLine = this.firstLineToDisplay;
        String curLine = null;
        Pattern compiled = this.getPattern();
        for (int terminalLine = 0; terminalLine < height - 1; ++terminalLine) {
            String toDisplay;
            if (curLine == null) {
                if ((curLine = this.getLine(inputLine++)) == null) {
                    curLine = "";
                }
                if (compiled != null) {
                    curLine = compiled.matcher(curLine).replaceAll("\u001b[7m$1\u001b[27m");
                }
            }
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                int off = this.firstColumnToDisplay;
                if (terminalLine == 0 && this.offsetInLine > 0) {
                    off = Math.max(this.offsetInLine, off);
                }
                toDisplay = this.ansiSubstring(curLine, off, off + width);
                curLine = null;
            } else {
                if (terminalLine == 0 && this.offsetInLine > 0) {
                    curLine = this.ansiSubstring(curLine, this.offsetInLine, Integer.MAX_VALUE);
                }
                toDisplay = this.ansiSubstring(curLine, 0, width);
                if ((curLine = this.ansiSubstring(curLine, width, Integer.MAX_VALUE)).isEmpty()) {
                    curLine = null;
                }
            }
            if (this.printLineNumbers) {
                System.out.print(String.format("%7d ", inputLine));
            }
            System.out.println(toDisplay);
        }
        System.out.flush();
        if (this.message != null) {
            System.out.print("\u001b[7m" + this.message + " \u001b[0m");
        } else if (this.buffer.length() > 0) {
            System.out.print(" " + this.buffer);
        } else if (this.opBuffer.length() > 0) {
            System.out.print(" " + this.printable(this.opBuffer.toString()));
        } else {
            System.out.print(":");
        }
        System.out.flush();
    }

    private Pattern getPattern() {
        Pattern compiled = null;
        if (this.pattern != null) {
            boolean insensitive = this.ignoreCaseAlways || this.ignoreCaseCond && this.pattern.toLowerCase().equals(this.pattern);
            compiled = Pattern.compile("(" + this.pattern + ")", insensitive ? 66 : 0);
        }
        return compiled;
    }

    private int ansiLength(String curLine) throws IOException {
        return AnsiSplitter.length((String)curLine, (int)this.tabs);
    }

    private String ansiSubstring(String curLine, int begin, int end) throws IOException {
        return AnsiSplitter.substring((String)curLine, (int)begin, (int)end, (int)this.tabs);
    }

    String getLine(int line) throws IOException {
        String str;
        while (line <= this.lines.size() && (str = this.reader.readLine()) != null) {
            this.lines.add(str);
        }
        if (line < this.lines.size()) {
            return this.lines.get(line);
        }
        return null;
    }

    public void signal(Signal signal) {
        try {
            Field field = this.terminal.getClass().getDeclaredField("terminal");
            field.setAccessible(true);
            Object jlineTerminal = field.get(this.terminal);
            field = jlineTerminal.getClass().getSuperclass().getDeclaredField("settings");
            field.setAccessible(true);
            Object settings = field.get(jlineTerminal);
            field = settings.getClass().getDeclaredField("configLastFetched");
            field.setAccessible(true);
            field.setLong(settings, 0L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.redraw();
    }

    protected boolean isTty(OutputStream out) {
        try {
            Method mth = out.getClass().getDeclaredMethod("getCurrent", new Class[0]);
            mth.setAccessible(true);
            Object current = mth.invoke((Object)out, new Object[0]);
            return current == this.session.getConsole();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void checkInterrupted() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected Object readOperation() throws IOException {
        int c;
        int n = c = this.pushBackChar.isEmpty() ? this.consoleReader.read() : (int)this.pushBackChar.pop().charValue();
        if (c == -1) {
            return null;
        }
        this.opBuffer.append((char)c);
        Object o = this.keys.getBound((CharSequence)this.opBuffer);
        if (o == jline.console.Operation.DO_LOWERCASE_VERSION) {
            this.opBuffer.setLength(this.opBuffer.length() - 1);
            this.opBuffer.append(Character.toLowerCase((char)c));
            o = this.keys.getBound((CharSequence)this.opBuffer);
        }
        if (o instanceof KeyMap) {
            if (c == 27 && this.pushBackChar.isEmpty() && this.consoleInput.isNonBlockingEnabled() && this.consoleInput.peek(100L) == -2) {
                if ((o = ((KeyMap)o).getAnotherKey()) == null || o instanceof KeyMap) {
                    return null;
                }
                this.opBuffer.setLength(0);
            } else {
                return null;
            }
        }
        while (o == null && this.opBuffer.length() > 0) {
            c = this.opBuffer.charAt(this.opBuffer.length() - 1);
            this.opBuffer.setLength(this.opBuffer.length() - 1);
            Object o2 = this.keys.getBound((CharSequence)this.opBuffer);
            if (!(o2 instanceof KeyMap) || (o = ((KeyMap)o2).getAnotherKey()) == null) continue;
            this.pushBackChar.push(Character.valueOf((char)c));
        }
        if (o != null) {
            this.opBuffer.setLength(0);
            this.pushBackChar.clear();
        }
        return o;
    }

    private void bindKeys(KeyMap map) {
        map.bind((CharSequence)"\u001b[0A", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[0B", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b[0C", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b[0D", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u00e0H", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u00e0K", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u00e0M", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u00e0P", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u0000H", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u0000K", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u0000M", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u0000P", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[A", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[B", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[C", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b[D", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b[OA", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[OB", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u001b[OC", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b[OD", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001c0H", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"\u001c0P", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\u001c0M", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001c0K", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"h", (Object)Operation.HELP);
        map.bind((CharSequence)"H", (Object)Operation.HELP);
        map.bind((CharSequence)"q", (Object)Operation.EXIT);
        map.bind((CharSequence)":q", (Object)Operation.EXIT);
        map.bind((CharSequence)"Q", (Object)Operation.EXIT);
        map.bind((CharSequence)":Q", (Object)Operation.EXIT);
        map.bind((CharSequence)"ZZ", (Object)Operation.EXIT);
        map.bind((CharSequence)"e", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)this.ctrl('E'), (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"j", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)this.ctrl('N'), (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"\r", (Object)Operation.FORWARD_ONE_LINE);
        map.bind((CharSequence)"y", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)this.ctrl('Y'), (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"k", (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)this.ctrl('K'), (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)this.ctrl('P'), (Object)Operation.BACKWARD_ONE_LINE);
        map.bind((CharSequence)"f", (Object)Operation.FORWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)this.ctrl('F'), (Object)Operation.FORWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)this.ctrl('V'), (Object)Operation.FORWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)" ", (Object)Operation.FORWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)"b", (Object)Operation.BACKWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)this.ctrl('B'), (Object)Operation.BACKWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)"\u001bv", (Object)Operation.BACKWARD_ONE_WINDOW_OR_LINES);
        map.bind((CharSequence)"z", (Object)Operation.FORWARD_ONE_WINDOW_AND_SET);
        map.bind((CharSequence)"w", (Object)Operation.BACKWARD_ONE_WINDOW_AND_SET);
        map.bind((CharSequence)"\u001b ", (Object)Operation.FORWARD_ONE_WINDOW_NO_STOP);
        map.bind((CharSequence)"d", (Object)Operation.FORWARD_HALF_WINDOW_AND_SET);
        map.bind((CharSequence)this.ctrl('D'), (Object)Operation.FORWARD_HALF_WINDOW_AND_SET);
        map.bind((CharSequence)"u", (Object)Operation.BACKWARD_HALF_WINDOW_AND_SET);
        map.bind((CharSequence)this.ctrl('U'), (Object)Operation.BACKWARD_HALF_WINDOW_AND_SET);
        map.bind((CharSequence)"\u001b)", (Object)Operation.RIGHT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"\u001b(", (Object)Operation.LEFT_ONE_HALF_SCREEN);
        map.bind((CharSequence)"F", (Object)Operation.FORWARD_FOREVER);
        map.bind((CharSequence)"n", (Object)Operation.REPEAT_SEARCH_FORWARD);
        map.bind((CharSequence)"N", (Object)Operation.REPEAT_SEARCH_BACKWARD);
        map.bind((CharSequence)"\u001bn", (Object)Operation.REPEAT_SEARCH_FORWARD_SPAN_FILES);
        map.bind((CharSequence)"\u001bN", (Object)Operation.REPEAT_SEARCH_BACKWARD_SPAN_FILES);
        map.bind((CharSequence)"\u001bu", (Object)Operation.UNDO_SEARCH);
        map.bind((CharSequence)"g", (Object)Operation.GO_TO_FIRST_LINE_OR_N);
        map.bind((CharSequence)"<", (Object)Operation.GO_TO_FIRST_LINE_OR_N);
        map.bind((CharSequence)"\u001b<", (Object)Operation.GO_TO_FIRST_LINE_OR_N);
        map.bind((CharSequence)"G", (Object)Operation.GO_TO_LAST_LINE_OR_N);
        map.bind((CharSequence)">", (Object)Operation.GO_TO_LAST_LINE_OR_N);
        map.bind((CharSequence)"\u001b>", (Object)Operation.GO_TO_LAST_LINE_OR_N);
        for (char c : "-/0123456789?".toCharArray()) {
            map.bind((CharSequence)("" + c), (Object)Character.valueOf(c));
        }
    }

    String ctrl(char c) {
        return "" + (char)(c & 0x1F);
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(b, off, len);
        }
    }

    static enum Operation {
        HELP,
        EXIT,
        FORWARD_ONE_LINE,
        BACKWARD_ONE_LINE,
        FORWARD_ONE_WINDOW_OR_LINES,
        BACKWARD_ONE_WINDOW_OR_LINES,
        FORWARD_ONE_WINDOW_AND_SET,
        BACKWARD_ONE_WINDOW_AND_SET,
        FORWARD_ONE_WINDOW_NO_STOP,
        FORWARD_HALF_WINDOW_AND_SET,
        BACKWARD_HALF_WINDOW_AND_SET,
        LEFT_ONE_HALF_SCREEN,
        RIGHT_ONE_HALF_SCREEN,
        FORWARD_FOREVER,
        REPAINT,
        REPAINT_AND_DISCARD,
        REPEAT_SEARCH_FORWARD,
        REPEAT_SEARCH_BACKWARD,
        REPEAT_SEARCH_FORWARD_SPAN_FILES,
        REPEAT_SEARCH_BACKWARD_SPAN_FILES,
        UNDO_SEARCH,
        GO_TO_FIRST_LINE_OR_N,
        GO_TO_LAST_LINE_OR_N,
        GO_TO_PERCENT_OR_N,
        GO_TO_NEXT_TAG,
        GO_TO_PREVIOUS_TAG,
        FIND_CLOSE_BRACKET,
        FIND_OPEN_BRACKET,
        OPT_PRINT_LINES,
        OPT_CHOP_LONG_LINES,
        OPT_QUIT_AT_FIRST_EOF,
        OPT_QUIT_AT_SECOND_EOF,
        OPT_QUIET,
        OPT_VERY_QUIET,
        OPT_IGNORE_CASE_COND,
        OPT_IGNORE_CASE_ALWAYS;

    }
}

