/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPTarget;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;

public class BPReferenceListener
implements TransferObject {
    private String bindMethod;
    private String unbindMethod;
    private BPTarget listenerComponent;

    public BPReferenceListener(CompositeData listener) {
        this.bindMethod = (String)listener.get("BindMethod");
        this.unbindMethod = (String)listener.get("UnbindMethod");
        Byte[] buf = (Byte[])listener.get("ListenerComponent");
        this.listenerComponent = (BPTarget)Util.boxedBinary2BPMetadata(buf);
    }

    public BPReferenceListener(ReferenceListener listener) {
        this.bindMethod = listener.getBindMethod();
        this.unbindMethod = listener.getUnbindMethod();
        this.listenerComponent = (BPTarget)Util.metadata2BPMetadata((Metadata)listener.getListenerComponent());
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("BindMethod", this.bindMethod);
        items.put("UnbindMethod", this.unbindMethod);
        items.put("ListenerComponent", Util.bpMetadata2BoxedBinary(this.listenerComponent));
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.REFERENCE_LISTENER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBindMethod() {
        return this.bindMethod;
    }

    public BPTarget getListenerComponent() {
        return this.listenerComponent;
    }

    public String getUnbindMethod() {
        return this.unbindMethod;
    }
}

