/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootFeaturesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootFeaturesInstaller.class);
    public static String VERSION_PREFIX = "version=";
    private final BundleContext bundleContext;
    private final FeaturesService featuresService;
    private final String boot;
    private final boolean bootAsynchronous;

    public BootFeaturesInstaller(BundleContext bundleContext, FeaturesService featuresService, String boot, boolean bootAsynchronous) {
        this.bundleContext = bundleContext;
        this.featuresService = featuresService;
        this.boot = boot;
        this.bootAsynchronous = bootAsynchronous;
    }

    public void start() throws Exception {
        if (this.boot != null) {
            if (this.bootAsynchronous) {
                new Thread(){

                    @Override
                    public void run() {
                        BootFeaturesInstaller.this.installBootFeatures();
                        BootFeaturesInstaller.this.publishBootFinished();
                    }
                }.start();
            } else {
                this.installBootFeatures();
                this.publishBootFinished();
            }
        } else {
            this.publishBootFinished();
        }
    }

    void installBootFeatures() {
        List<Feature> installedFeatures = Arrays.asList(this.featuresService.listInstalledFeatures());
        List<Set<String>> stagedFeatureNames = this.parseBootFeatures(this.boot);
        List<Set<Feature>> stagedFeatures = this.toFeatureSetList(stagedFeatureNames);
        try {
            for (Set<Feature> features : stagedFeatures) {
                features.removeAll(installedFeatures);
                this.featuresService.installFeatures(features, EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles, FeaturesService.Option.NoCleanIfFailure, FeaturesService.Option.ContinueBatchOnFailure));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error installing boot features", (Throwable)e);
        }
    }

    private List<Set<Feature>> toFeatureSetList(List<Set<String>> stagedFeatures) {
        ArrayList<Set<Feature>> result = new ArrayList<Set<Feature>>();
        for (Set<String> features : stagedFeatures) {
            LinkedHashSet<Feature> featureSet = new LinkedHashSet<Feature>();
            for (String featureName : features) {
                try {
                    Feature feature = this.getFeature(featureName);
                    if (feature == null) {
                        LOGGER.error("Error Boot feature " + featureName + " not found");
                        continue;
                    }
                    featureSet.add(feature);
                }
                catch (Exception e) {
                    LOGGER.error("Error getting feature for feature string " + featureName, (Throwable)e);
                }
            }
            result.add(featureSet);
        }
        return result;
    }

    private Feature getFeature(String featureSt) throws Exception {
        String[] parts = featureSt.trim().split(";");
        String featureName = parts[0];
        String featureVersion = null;
        for (String part : parts) {
            if (!part.startsWith(VERSION_PREFIX)) continue;
            featureVersion = part.substring(VERSION_PREFIX.length());
        }
        if (featureVersion == null) {
            featureVersion = org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION;
        }
        return this.featuresService.getFeature(featureName, featureVersion);
    }

    protected List<Set<String>> parseBootFeatures(String bootFeatures) {
        Pattern pattern = Pattern.compile("(\\s*\\(([^)]+))\\s*\\)\\s*,\\s*|.+");
        Matcher matcher = pattern.matcher(bootFeatures);
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        while (matcher.find()) {
            String group = matcher.group(2) != null ? matcher.group(2) : matcher.group();
            result.add(this.parseFeatureList(group));
        }
        return result;
    }

    private Set<String> parseFeatureList(String group) {
        LinkedHashSet<String> features = new LinkedHashSet<String>();
        for (String feature : Arrays.asList(group.trim().split("\\s*,\\s*"))) {
            if (feature.length() <= 0) continue;
            features.add(feature);
        }
        return features;
    }

    private void publishBootFinished() {
        if (this.bundleContext != null) {
            BootFinished bootFinished = new BootFinished(){};
            this.bundleContext.registerService(BootFinished.class, (Object)bootFinished, new Hashtable());
        }
    }
}

