/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.fileinstall.internal.Watcher;
import org.osgi.framework.BundleContext;

public class WatcherScanner
extends Scanner {
    BundleContext bundleContext;
    PathMatcher fileMatcher;
    Watcher watcher;
    Set<File> changed = new HashSet<File>();

    public WatcherScanner(BundleContext bundleContext, File directory, String filterString, String subdirMode) throws IOException {
        super(directory, filterString, subdirMode);
        this.bundleContext = bundleContext;
        this.fileMatcher = filterString != null ? FileSystems.getDefault().getPathMatcher("regex:" + filterString) : null;
        this.watcher = new ScannerWatcher();
        this.watcher.setFileMatcher(this.fileMatcher);
        this.watcher.setRootDirectory(this.directory);
        this.watcher.init();
        this.watcher.rescan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<File> scan(boolean reportImmediately) {
        this.watcher.processEvents();
        Set<File> set = this.changed;
        synchronized (set) {
            if (this.changed.isEmpty()) {
                return new HashSet<File>();
            }
            HashSet<File> files = new HashSet<File>();
            HashSet<Object> removed = new HashSet<Object>();
            if (reportImmediately) {
                removed.addAll(this.storedChecksums.keySet());
            }
            Iterator<File> iterator = this.changed.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                long lastChecksum = this.lastChecksums.get(file) != null ? (Long)this.lastChecksums.get(file) : 0L;
                long storedChecksum = this.storedChecksums.get(file) != null ? (Long)this.storedChecksums.get(file) : 0L;
                long newChecksum = WatcherScanner.checksum(file);
                this.lastChecksums.put(file, newChecksum);
                if (file.exists()) {
                    if (newChecksum != lastChecksum && !reportImmediately) continue;
                    if (newChecksum != storedChecksum) {
                        this.storedChecksums.put(file, newChecksum);
                        files.add(file);
                    } else {
                        iterator.remove();
                    }
                    if (!reportImmediately) continue;
                    removed.remove(file);
                    continue;
                }
                if (reportImmediately) continue;
                removed.add(file);
            }
            for (File file : removed) {
                files.addAll(removed);
                this.lastChecksums.remove(file);
                this.storedChecksums.remove(file);
            }
            return files;
        }
    }

    @Override
    public void close() throws IOException {
        this.watcher.close();
    }

    class ScannerWatcher
    extends Watcher {
        ScannerWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(Path path) {
            File file = path.toFile();
            if (!file.getParentFile().equals(WatcherScanner.this.directory)) {
                if (WatcherScanner.this.skipSubdir) {
                    return;
                }
                if (WatcherScanner.this.jarSubdir) {
                    do {
                        if ((file = file.getParentFile()) != null) continue;
                        return;
                    } while (!file.getParentFile().equals(WatcherScanner.this.directory));
                }
            }
            Set<File> set = WatcherScanner.this.changed;
            synchronized (set) {
                WatcherScanner.this.changed.add(file);
            }
        }

        @Override
        protected void onRemove(Path path) {
            this.process(path);
        }

        @Override
        protected void debug(String message, Object ... args) {
            this.log(4, message, args);
        }

        @Override
        protected void warn(String message, Object ... args) {
            this.log(2, message, args);
        }

        protected void log(int level, String message, Object ... args) {
            String msg = String.format(message, args);
            Util.log(WatcherScanner.this.bundleContext, level, msg, null);
        }
    }
}

