/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.group.CoordinatorLoaderImpl$;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.common.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005eu!\u0002\u000b\u0016\u0011\u0003ab!\u0002\u0010\u0016\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0005\u0004%\t!\u000b\u0005\u0007[\u0005\u0001\u000b\u0011\u0002\u0016\t\u000f9\n\u0011\u0013!C\u0001_\u0019!a$\u0006\u0001E\u0011!)gA!A!\u0002\u00131\u0007\u0002\u00037\u0007\u0005\u0003\u0005\u000b\u0011B7\t\u0011M4!\u0011!Q\u0001\nQD\u0001b\u001e\u0004\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\tw\u001a\u0011\t\u0011)A\u0005U!)aE\u0002C\u0001y\"I\u0011q\u0001\u0004C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003?1\u0001\u0015!\u0003\u0002\f!I\u0011\u0011\u0005\u0004C\u0002\u0013%\u00111\u0005\u0005\t\u0003c1\u0001\u0015!\u0003\u0002&!9\u00111\u0007\u0004\u0005B\u0005U\u0002bBA@\r\u0011%\u0011\u0011\u0011\u0005\b\u0003+3A\u0011IAL\u0003U\u0019un\u001c:eS:\fGo\u001c:M_\u0006$WM]%na2T!AF\f\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005aI\u0012aC2p_J$\u0017N\\1u_JT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001!\ti\u0012!D\u0001\u0016\u0005U\u0019un\u001c:eS:\fGo\u001c:M_\u0006$WM]%na2\u001c\"!\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA$A\u0010E\u000b\u001a\u000bU\u000b\u0014+`\u0007>kU*\u0013+`\u0013:#VI\u0015,B\u0019~{eIR*F)N+\u0012A\u000b\t\u0003C-J!\u0001\f\u0012\u0003\t1{gnZ\u0001!\t\u00163\u0015)\u0016'U?\u000e{U*T%U?&sE+\u0012*W\u00032{vJ\u0012$T\u000bR\u001b\u0006%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003am*\u0012!\r\u0016\u0003UIZ\u0013a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005a\u0012\u0013AC1o]>$\u0018\r^5p]&\u0011!(\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002\u001f\u0006\u0005\u0004i$!\u0001+\u0012\u0005y\n\u0005CA\u0011@\u0013\t\u0001%EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005\u0012\u0015BA\"#\u0005\r\te._\u000b\u0003\u000bz\u001bBA\u0002$O?B\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005Y\u0006twMC\u0001L\u0003\u0011Q\u0017M^1\n\u00055C%AB(cU\u0016\u001cG\u000fE\u0002P5rk\u0011\u0001\u0015\u0006\u0003#J\u000bqA];oi&lWM\u0003\u0002T)\u000611m\\7n_:T!\u0001G+\u000b\u0005i1&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!a\u0017)\u0003#\r{wN\u001d3j]\u0006$xN\u001d'pC\u0012,'\u000f\u0005\u0002^=2\u0001A!\u0002\u001f\u0007\u0005\u0004i\u0004C\u00011d\u001b\u0005\t'B\u00012\u001a\u0003\u0015)H/\u001b7t\u0013\t!\u0017MA\u0004M_\u001e<\u0017N\\4\u0002\tQLW.\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003E&T!aU+\n\u0005-D'\u0001\u0002+j[\u0016\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002oc6\tqN\u0003\u0002q3\u000511/\u001a:wKJL!A]8\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006aA-Z:fe&\fG.\u001b>feB\u0019q*\u001e/\n\u0005Y\u0004&\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018A\u00047pC\u0012\u0014UO\u001a4feNK'0\u001a\t\u0003CeL!A\u001f\u0012\u0003\u0007%sG/A\u000bd_6l\u0017\u000e^%oi\u0016\u0014h/\u00197PM\u001a\u001cX\r^:\u0015\u0013utx0!\u0001\u0002\u0004\u0005\u0015\u0001cA\u000f\u00079\")Q\r\u0004a\u0001M\")A\u000e\u0004a\u0001[\")1\u000f\u0004a\u0001i\")q\u000f\u0004a\u0001q\"91\u0010\u0004I\u0001\u0002\u0004Q\u0013!C5t%Vtg.\u001b8h+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\r\u0005$x.\\5d\u0015\u0011\t)\"a\u0006\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\u001a)\u000bA!\u001e;jY&!\u0011QDA\b\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q\u0011n\u001d*v]:Lgn\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"\u0002BA\r\u0003WQ!\u0001]+\n\t\u0005=\u0012\u0011\u0006\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0005Y>\fG\r\u0006\u0004\u00028\u0005-\u0014q\u000f\t\u0007\u0003s\tY$a\u0010\u000e\u0005\u0005M\u0011\u0002BA\u001f\u0003'\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\t\t%!\u001a\u000f\t\u0005\r\u0013\u0011\r\b\u0005\u0003\u000b\nyF\u0004\u0003\u0002H\u0005uc\u0002BA%\u00037rA!a\u0013\u0002Z9!\u0011QJA,\u001d\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*7\u00051AH]8pizJ\u0011!W\u0005\u0003/bK!A\u0007,\n\u0005a)\u0016BA*U\u0013\t\t&+C\u0002\u0002dA\u000b\u0011cQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ3s\u0013\u0011\t9'!\u001b\u0003\u00171{\u0017\rZ*v[6\f'/\u001f\u0006\u0004\u0003G\u0002\u0006bBA7#\u0001\u0007\u0011qN\u0001\u0003iB\u0004B!!\u001d\u0002t5\t\u0011.C\u0002\u0002v%\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0019#\u0001\u0007\u0011\u0011\u0010\t\u0005\u001f\u0006mD,C\u0002\u0002~A\u00131cQ8pe\u0012Lg.\u0019;peBc\u0017-\u001f2bG.\fa\u0001Z8M_\u0006$GCCAB\u0003\u0013\u000bY)!$\u0002\u0012B\u0019\u0011%!\"\n\u0007\u0005\u001d%E\u0001\u0003V]&$\bbBA7%\u0001\u0007\u0011q\u000e\u0005\u00071I\u0001\r!!\u001f\t\u000f\u0005=%\u00031\u0001\u00028\u00051a-\u001e;ve\u0016Da!a%\u0013\u0001\u0004Q\u0013aC:uCJ$H+[7f\u001bN\fQa\u00197pg\u0016$\"!a!")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final long commitIntervalOffsets;
    private final AtomicBoolean isRunning;
    private final KafkaScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> long $lessinit$greater$default$5() {
        return CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS();
    }

    public static long DEFAULT_COMMIT_INTERVAL_OFFSETS() {
        return CoordinatorLoaderImpl$.MODULE$.DEFAULT_COMMIT_INTERVAL_OFFSETS();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        if (this.scheduler().scheduleOnce("Load coordinator from " + tp, () -> this.doLoad(tp, coordinator, future, startTimeMs)).isCancelled()) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block16: {
            long schedulerQueueTimeMs = this.time.milliseconds() - startTimeMs;
            try {
                Option<UnifiedLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally((Throwable)new NotLeaderOrFollowerException("Could not load records from " + tp + " because the log does not exist."));
                    break block16;
                }
                if (option instanceof Some) {
                    UnifiedLog log = (UnifiedLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef lastCommittedOffset = LongRef.create((long)-1L);
                    LongRef numRecords = LongRef.create((long)0L);
                    long numBytes = 0L;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        FetchDataInfo fetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true);
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Loaded metadata from " + tp + " with buffer larger (" + bytesNeeded + " bytes) than configured buffer size (" + $this.loadBufferSize + " bytes).");
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(this, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$7(this, numRecords, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > lastCommittedOffset$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    lastCommittedOffset$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                            if (currentOffset$1.elem - lastCommittedOffset$1.elem >= $this.commitIntervalOffsets) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                lastCommittedOffset$1.elem = currentOffset$1.elem;
                                return;
                            }
                        });
                        numBytes += (long)memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally((Throwable)new NotLeaderOrFollowerException("Stopped loading records from " + tp + " because the partition is not online or is no longer the leader."));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, schedulerQueueTimeMs, numRecords.elem, numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block16;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorLoaderImpl $this, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        block10: {
            block9: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block8: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        if ($this.isTraceEnabled()) {
                            $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying end transaction marker from " + tp$2 + " at offset " + record.offset() + " to commit transaction with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
                        }
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block8;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block9;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block10;
            }
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying end transaction marker from " + tp$2 + " at offset " + record.offset() + " to abort transaction with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$10(CoordinatorLoaderImpl $this, TopicPartition tp$2, Record record$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Object coordinatorRecord) {
        try {
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying record " + coordinatorRecord + " from " + tp$2 + " at offset " + record$2.offset() + " with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
            }
            coordinator$2.replay(record$2.offset(), batch$1.producerId(), batch$1.producerEpoch(), coordinatorRecord);
            return;
        }
        catch (RuntimeException ex) {
            String msg = "Replaying record " + coordinatorRecord + " from " + tp$2 + " at offset " + record$2.offset() + " with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + " failed due to: " + ex.getMessage();
            $this.error((Function0<String>)(Function0 & Serializable)() -> msg + ".");
            throw new RuntimeException(msg, ex);
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$7(CoordinatorLoaderImpl $this, LongRef numRecords$1, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        Some some;
        ++numRecords$1.elem;
        try {
            some = new Some($this.deserializer.deserialize(record.key(), record.value()));
        }
        catch (Deserializer.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Unknown record type " + ex.unknownType() + " while loading offsets and group metadata from " + tp$2 + ". Ignoring it. It could be a left over from an aborted upgrade.");
            some = None$.MODULE$;
        }
        catch (RuntimeException ex) {
            String msg = "Deserializing record " + record + " from " + tp$2 + " failed due to: " + ex.getMessage();
            $this.error((Function0<String>)(Function0 & Serializable)() -> msg + ".");
            throw new RuntimeException(msg, ex);
        }
        some.foreach((Function1 & Serializable)coordinatorRecord -> {
            CoordinatorLoaderImpl.$anonfun$doLoad$10($this, tp$2, record, batch$1, coordinator$2, coordinatorRecord);
            return BoxedUnit.UNIT;
        });
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, Deserializer<T> deserializer, int loadBufferSize, long commitIntervalOffsets) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.commitIntervalOffsets = commitIntervalOffsets;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new KafkaScheduler(1);
        this.scheduler().startup();
    }
}

