/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.util;

import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.EmptyArray;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongBinaryOperator;

public final class PackedArray {
    private static final long MAX_NUM_BITS = 0x3FFFFFFF8L;
    private static final PackedArrayHandler HANDLER_0 = new PackedArrayHandler(){

        @Override
        public int numBytes(int length) {
            return 0;
        }

        @Override
        public byte[] create(int length) {
            PackedArray.checkArrayLength(length, 0);
            return EmptyArray.EMPTY_BYTE_ARRAY;
        }

        @Override
        public byte[] create(IndexedLongValueProvider valueProvider, int length) {
            return this.create(length);
        }

        @Override
        public long get(byte[] array, int idx) {
            return 0L;
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return 0L;
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            Objects.requireNonNull(operator);
            return 0L;
        }

        @Override
        public int getBitSize() {
            return 0;
        }

        @Override
        public int numEqualComponents(byte[] array1, byte[] array2, int length) {
            return length;
        }

        @Override
        public void clear(byte[] array) {
        }

        @Override
        public PackedArrayReadIterator readIterator(byte[] array, final int length) {
            Objects.requireNonNull(array);
            return new PackedArrayReadIterator(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < length;
                }

                @Override
                public long next() {
                    ++this.idx;
                    return 0L;
                }
            };
        }
    };
    private static final PackedArrayHandler HANDLER_1 = new AbstractPackedArrayHandlerPeriod8(1){

        @Override
        public long get(byte[] array, int idx) {
            return this.get1(array, idx, 0, idx & 7);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set1(array, idx, 0, idx & 7, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update1(array, idx, 0, idx & 7, value, operator);
        }

        @Override
        public int numEqualComponents(byte[] array1, byte[] array2, int length) {
            int l2;
            int bytePos;
            int result = 0;
            int end = (length & 0xFFFFFFC0) >>> 3;
            for (bytePos = 0; bytePos < end; bytePos += 8) {
                long l1 = ByteArrayUtil.getLong(array1, bytePos);
                long l22 = ByteArrayUtil.getLong(array2, bytePos);
                result += Long.bitCount(l1 ^ l22);
            }
            if ((length & 0x20) != 0) {
                bytePos = end;
                int l1 = ByteArrayUtil.getInt(array1, bytePos);
                l2 = ByteArrayUtil.getInt(array2, bytePos);
                result += Integer.bitCount(l1 ^ l2);
            }
            if ((length & 0x10) != 0) {
                bytePos = (length & 0xFFFFFFE0) >>> 3;
                short l1 = ByteArrayUtil.getShort(array1, bytePos);
                l2 = ByteArrayUtil.getShort(array2, bytePos);
                result += Integer.bitCount((l1 ^ l2) & 0xFFFF);
            }
            if ((length & 8) != 0) {
                bytePos = (length & 0xFFFFFFF0) >>> 3;
                byte l1 = array1[bytePos];
                l2 = array2[bytePos];
                result += Integer.bitCount((l1 ^ l2) & 0xFF);
            }
            if ((length & 7) != 0) {
                bytePos = length >>> 3;
                byte l1 = array1[bytePos];
                l2 = array2[bytePos];
                result += Integer.bitCount((l1 ^ l2) & -1 >>> -(length & 7));
            }
            return length - result;
        }
    };
    private static final PackedArrayHandler HANDLER_2 = new AbstractPackedArrayHandlerPeriod4(2){

        @Override
        public long get(byte[] array, int idx) {
            return this.get1(array, idx, 0, (idx & 3) << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set1(array, idx, 0, (idx & 3) << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update1(array, idx, 0, (idx & 3) << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_3 = new AbstractPackedArrayHandlerPeriod8(3){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get1(array, idx, 0, 0);
                }
                case 1: {
                    return this.get1(array, idx, 0, 3);
                }
                case 2: {
                    return this.get2(array, idx, 0, 6);
                }
                case 3: {
                    return this.get1(array, idx, 1, 1);
                }
                case 4: {
                    return this.get1(array, idx, 1, 4);
                }
                case 5: {
                    return this.get2(array, idx, 1, 7);
                }
                case 6: {
                    return this.get1(array, idx, 2, 2);
                }
            }
            return this.get1(array, idx, 2, 5);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set1(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set1(array, idx, 0, 3, value);
                }
                case 2: {
                    return this.set2(array, idx, 0, 6, value);
                }
                case 3: {
                    return this.set1(array, idx, 1, 1, value);
                }
                case 4: {
                    return this.set1(array, idx, 1, 4, value);
                }
                case 5: {
                    return this.set2(array, idx, 1, 7, value);
                }
                case 6: {
                    return this.set1(array, idx, 2, 2, value);
                }
            }
            return this.set1(array, idx, 2, 5, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update1(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update1(array, idx, 0, 3, value, operator);
                }
                case 2: {
                    return this.update2(array, idx, 0, 6, value, operator);
                }
                case 3: {
                    return this.update1(array, idx, 1, 1, value, operator);
                }
                case 4: {
                    return this.update1(array, idx, 1, 4, value, operator);
                }
                case 5: {
                    return this.update2(array, idx, 1, 7, value, operator);
                }
                case 6: {
                    return this.update1(array, idx, 2, 2, value, operator);
                }
            }
            return this.update1(array, idx, 2, 5, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_4 = new AbstractPackedArrayHandlerPeriod2(4){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get1(array, idx, 0, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set1(array, idx, 0, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update1(array, idx, 0, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_5 = new AbstractPackedArrayHandlerPeriod8(5){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get1(array, idx, 0, 0);
                }
                case 1: {
                    return this.get2(array, idx, 0, 5);
                }
                case 2: {
                    return this.get1(array, idx, 1, 2);
                }
                case 3: {
                    return this.get2(array, idx, 1, 7);
                }
                case 4: {
                    return this.get2(array, idx, 2, 4);
                }
                case 5: {
                    return this.get1(array, idx, 3, 1);
                }
                case 6: {
                    return this.get2(array, idx, 3, 6);
                }
            }
            return this.get1(array, idx, 4, 3);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set1(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set2(array, idx, 0, 5, value);
                }
                case 2: {
                    return this.set1(array, idx, 1, 2, value);
                }
                case 3: {
                    return this.set2(array, idx, 1, 7, value);
                }
                case 4: {
                    return this.set2(array, idx, 2, 4, value);
                }
                case 5: {
                    return this.set1(array, idx, 3, 1, value);
                }
                case 6: {
                    return this.set2(array, idx, 3, 6, value);
                }
            }
            return this.set1(array, idx, 4, 3, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update1(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update2(array, idx, 0, 5, value, operator);
                }
                case 2: {
                    return this.update1(array, idx, 1, 2, value, operator);
                }
                case 3: {
                    return this.update2(array, idx, 1, 7, value, operator);
                }
                case 4: {
                    return this.update2(array, idx, 2, 4, value, operator);
                }
                case 5: {
                    return this.update1(array, idx, 3, 1, value, operator);
                }
                case 6: {
                    return this.update2(array, idx, 3, 6, value, operator);
                }
            }
            return this.update1(array, idx, 4, 3, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_6 = new AbstractPackedArrayHandlerPeriod4(6){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get1(array, idx, 0, 0);
                }
                case 1: {
                    return this.get2(array, idx, 0, 6);
                }
                case 2: {
                    return this.get2(array, idx, 1, 4);
                }
            }
            return this.get1(array, idx, 2, 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set1(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set2(array, idx, 0, 6, value);
                }
                case 2: {
                    return this.set2(array, idx, 1, 4, value);
                }
            }
            return this.set1(array, idx, 2, 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update1(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update2(array, idx, 0, 6, value, operator);
                }
                case 2: {
                    return this.update2(array, idx, 1, 4, value, operator);
                }
            }
            return this.update1(array, idx, 2, 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_7 = new AbstractPackedArrayHandlerPeriod8(7){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get1(array, idx, 0, 0);
                }
                case 1: {
                    return this.get2(array, idx, 0, 7);
                }
                case 2: {
                    return this.get2(array, idx, 1, 6);
                }
                case 3: {
                    return this.get2(array, idx, 2, 5);
                }
                case 4: {
                    return this.get2(array, idx, 3, 4);
                }
                case 5: {
                    return this.get2(array, idx, 4, 3);
                }
                case 6: {
                    return this.get2(array, idx, 5, 2);
                }
            }
            return this.get1(array, idx, 6, 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set1(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set2(array, idx, 0, 7, value);
                }
                case 2: {
                    return this.set2(array, idx, 1, 6, value);
                }
                case 3: {
                    return this.set2(array, idx, 2, 5, value);
                }
                case 4: {
                    return this.set2(array, idx, 3, 4, value);
                }
                case 5: {
                    return this.set2(array, idx, 4, 3, value);
                }
                case 6: {
                    return this.set2(array, idx, 5, 2, value);
                }
            }
            return this.set1(array, idx, 6, 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update1(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update2(array, idx, 0, 7, value, operator);
                }
                case 2: {
                    return this.update2(array, idx, 1, 6, value, operator);
                }
                case 3: {
                    return this.update2(array, idx, 2, 5, value, operator);
                }
                case 4: {
                    return this.update2(array, idx, 3, 4, value, operator);
                }
                case 5: {
                    return this.update2(array, idx, 4, 3, value, operator);
                }
                case 6: {
                    return this.update2(array, idx, 5, 2, value, operator);
                }
            }
            return this.update1(array, idx, 6, 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_8 = new AbstractPackedArrayHandlerPeriod1(8){

        @Override
        public long get(byte[] array, int idx) {
            return this.get1(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set1(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update1(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_9 = new AbstractPackedArrayHandlerPeriod8(9){

        @Override
        public long get(byte[] array, int idx) {
            int off = idx & 7;
            return this.get2(array, idx, off, off);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int off = idx & 7;
            return this.set2(array, idx, off, off, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int off = idx & 7;
            return this.update2(array, idx, off, off, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_10 = new AbstractPackedArrayHandlerPeriod4(10){

        @Override
        public long get(byte[] array, int idx) {
            int off = idx & 3;
            return this.get2(array, idx, off, off << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int off = idx & 3;
            return this.set2(array, idx, off, off << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int off = idx & 3;
            return this.update2(array, idx, off, off << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_11 = new AbstractPackedArrayHandlerPeriod8(11){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get2(array, idx, 0, 0);
                }
                case 1: {
                    return this.get2(array, idx, 1, 3);
                }
                case 2: {
                    return this.get4(array, idx, 1, 14);
                }
                case 3: {
                    return this.get2(array, idx, 4, 1);
                }
                case 4: {
                    return this.get2(array, idx, 5, 4);
                }
                case 5: {
                    return this.get4(array, idx, 5, 15);
                }
                case 6: {
                    return this.get2(array, idx, 8, 2);
                }
            }
            return this.get2(array, idx, 9, 5);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set2(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set2(array, idx, 1, 3, value);
                }
                case 2: {
                    return this.set4(array, idx, 1, 14, value);
                }
                case 3: {
                    return this.set2(array, idx, 4, 1, value);
                }
                case 4: {
                    return this.set2(array, idx, 5, 4, value);
                }
                case 5: {
                    return this.set4(array, idx, 5, 15, value);
                }
                case 6: {
                    return this.set2(array, idx, 8, 2, value);
                }
            }
            return this.set2(array, idx, 9, 5, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update2(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update2(array, idx, 1, 3, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 1, 14, value, operator);
                }
                case 3: {
                    return this.update2(array, idx, 4, 1, value, operator);
                }
                case 4: {
                    return this.update2(array, idx, 5, 4, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 5, 15, value, operator);
                }
                case 6: {
                    return this.update2(array, idx, 8, 2, value, operator);
                }
            }
            return this.update2(array, idx, 9, 5, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_12 = new AbstractPackedArrayHandlerPeriod2(12){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get2(array, idx, k, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set2(array, idx, k, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update2(array, idx, k, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_13 = new AbstractPackedArrayHandlerPeriod8(13){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get2(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 0, 13);
                }
                case 2: {
                    return this.get2(array, idx, 3, 2);
                }
                case 3: {
                    return this.get4(array, idx, 3, 15);
                }
                case 4: {
                    return this.get4(array, idx, 5, 12);
                }
                case 5: {
                    return this.get2(array, idx, 8, 1);
                }
                case 6: {
                    return this.get4(array, idx, 8, 14);
                }
            }
            return this.get2(array, idx, 11, 3);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set2(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 0, 13, value);
                }
                case 2: {
                    return this.set2(array, idx, 3, 2, value);
                }
                case 3: {
                    return this.set4(array, idx, 3, 15, value);
                }
                case 4: {
                    return this.set4(array, idx, 5, 12, value);
                }
                case 5: {
                    return this.set2(array, idx, 8, 1, value);
                }
                case 6: {
                    return this.set4(array, idx, 8, 14, value);
                }
            }
            return this.set2(array, idx, 11, 3, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update2(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 0, 13, value, operator);
                }
                case 2: {
                    return this.update2(array, idx, 3, 2, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 3, 15, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 5, 12, value, operator);
                }
                case 5: {
                    return this.update2(array, idx, 8, 1, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 8, 14, value, operator);
                }
            }
            return this.update2(array, idx, 11, 3, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_14 = new AbstractPackedArrayHandlerPeriod4(14){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get2(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 0, 14);
                }
                case 2: {
                    return this.get4(array, idx, 2, 12);
                }
            }
            return this.get2(array, idx, 5, 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set2(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 0, 14, value);
                }
                case 2: {
                    return this.set4(array, idx, 2, 12, value);
                }
            }
            return this.set2(array, idx, 5, 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update2(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 0, 14, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 2, 12, value, operator);
                }
            }
            return this.update2(array, idx, 5, 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_15 = new AbstractPackedArrayHandlerPeriod8(15){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get2(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 0, 15);
                }
                case 2: {
                    return this.get4(array, idx, 2, 14);
                }
                case 3: {
                    return this.get4(array, idx, 4, 13);
                }
                case 4: {
                    return this.get4(array, idx, 6, 12);
                }
                case 5: {
                    return this.get4(array, idx, 8, 11);
                }
                case 6: {
                    return this.get4(array, idx, 10, 10);
                }
            }
            return this.get2(array, idx, 13, 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set2(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 0, 15, value);
                }
                case 2: {
                    return this.set4(array, idx, 2, 14, value);
                }
                case 3: {
                    return this.set4(array, idx, 4, 13, value);
                }
                case 4: {
                    return this.set4(array, idx, 6, 12, value);
                }
                case 5: {
                    return this.set4(array, idx, 8, 11, value);
                }
                case 6: {
                    return this.set4(array, idx, 10, 10, value);
                }
            }
            return this.set2(array, idx, 13, 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update2(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 0, 15, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 2, 14, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 4, 13, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 6, 12, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 8, 11, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 10, 10, value, operator);
                }
            }
            return this.update2(array, idx, 13, 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_16 = new AbstractPackedArrayHandlerPeriod1(16){

        @Override
        public long get(byte[] array, int idx) {
            return this.get2(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set2(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update2(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_17 = new AbstractPackedArrayHandlerPeriod8(17){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get3(array, idx, k << 1, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set3(array, idx, k << 1, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update3(array, idx, k << 1, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_18 = new AbstractPackedArrayHandlerPeriod4(18){

        @Override
        public long get(byte[] array, int idx) {
            int k = (idx & 3) << 1;
            return this.get3(array, idx, k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = (idx & 3) << 1;
            return this.set3(array, idx, k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = (idx & 3) << 1;
            return this.update3(array, idx, k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_19 = new AbstractPackedArrayHandlerPeriod8(19){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get3(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 1, 11);
                }
                case 2: {
                    return this.get4(array, idx, 4, 6);
                }
                case 3: {
                    return this.get4(array, idx, 6, 9);
                }
                case 4: {
                    return this.get4(array, idx, 8, 12);
                }
                case 5: {
                    return this.get4(array, idx, 11, 7);
                }
                case 6: {
                    return this.get4(array, idx, 13, 10);
                }
            }
            return this.get4(array, idx, 15, 13);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set3(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 1, 11, value);
                }
                case 2: {
                    return this.set4(array, idx, 4, 6, value);
                }
                case 3: {
                    return this.set4(array, idx, 6, 9, value);
                }
                case 4: {
                    return this.set4(array, idx, 8, 12, value);
                }
                case 5: {
                    return this.set4(array, idx, 11, 7, value);
                }
                case 6: {
                    return this.set4(array, idx, 13, 10, value);
                }
            }
            return this.set4(array, idx, 15, 13, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update3(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 1, 11, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 4, 6, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 6, 9, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 8, 12, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 11, 7, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 13, 10, value, operator);
                }
            }
            return this.update4(array, idx, 15, 13, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_20 = new AbstractPackedArrayHandlerPeriod2(20){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get3(array, idx, k << 1, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set3(array, idx, k << 1, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update3(array, idx, k << 1, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_21 = new AbstractPackedArrayHandlerPeriod8(21){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get3(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 2, 5);
                }
                case 2: {
                    return this.get4(array, idx, 4, 10);
                }
                case 3: {
                    return this.get4(array, idx, 7, 7);
                }
                case 4: {
                    return this.get4(array, idx, 10, 4);
                }
                case 5: {
                    return this.get4(array, idx, 12, 9);
                }
                case 6: {
                    return this.get4(array, idx, 15, 6);
                }
            }
            return this.get4(array, idx, 17, 11);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set3(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 2, 5, value);
                }
                case 2: {
                    return this.set4(array, idx, 4, 10, value);
                }
                case 3: {
                    return this.set4(array, idx, 7, 7, value);
                }
                case 4: {
                    return this.set4(array, idx, 10, 4, value);
                }
                case 5: {
                    return this.set4(array, idx, 12, 9, value);
                }
                case 6: {
                    return this.set4(array, idx, 15, 6, value);
                }
            }
            return this.set4(array, idx, 17, 11, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update3(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 2, 5, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 4, 10, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 7, 7, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 10, 4, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 12, 9, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 15, 6, value, operator);
                }
            }
            return this.update4(array, idx, 17, 11, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_22 = new AbstractPackedArrayHandlerPeriod4(22){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get3(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 2, 6);
                }
                case 2: {
                    return this.get4(array, idx, 5, 4);
                }
            }
            return this.get4(array, idx, 7, 10);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set3(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 2, 6, value);
                }
                case 2: {
                    return this.set4(array, idx, 5, 4, value);
                }
            }
            return this.set4(array, idx, 7, 10, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update3(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 2, 6, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 5, 4, value, operator);
                }
            }
            return this.update4(array, idx, 7, 10, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_23 = new AbstractPackedArrayHandlerPeriod8(23){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get3(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 2, 7);
                }
                case 2: {
                    return this.get4(array, idx, 5, 6);
                }
                case 3: {
                    return this.get4(array, idx, 8, 5);
                }
                case 4: {
                    return this.get4(array, idx, 11, 4);
                }
                case 5: {
                    return this.get4(array, idx, 14, 3);
                }
                case 6: {
                    return this.get4(array, idx, 17, 2);
                }
            }
            return this.get4(array, idx, 19, 9);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set3(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 2, 7, value);
                }
                case 2: {
                    return this.set4(array, idx, 5, 6, value);
                }
                case 3: {
                    return this.set4(array, idx, 8, 5, value);
                }
                case 4: {
                    return this.set4(array, idx, 11, 4, value);
                }
                case 5: {
                    return this.set4(array, idx, 14, 3, value);
                }
                case 6: {
                    return this.set4(array, idx, 17, 2, value);
                }
            }
            return this.set4(array, idx, 19, 9, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update3(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 2, 7, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 5, 6, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 8, 5, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 11, 4, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 14, 3, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 17, 2, value, operator);
                }
            }
            return this.update4(array, idx, 19, 9, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_24 = new AbstractPackedArrayHandlerPeriod1(24){

        @Override
        public long get(byte[] array, int idx) {
            return this.get3(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set3(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update3(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_25 = new AbstractPackedArrayHandlerPeriod8(25){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get4(array, idx, 3 * k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set4(array, idx, 3 * k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update4(array, idx, 3 * k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_26 = new AbstractPackedArrayHandlerPeriod4(26){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 3;
            return this.get4(array, idx, 3 * k, k << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 3;
            return this.set4(array, idx, 3 * k, k << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 3;
            return this.update4(array, idx, 3 * k, k << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_27 = new AbstractPackedArrayHandlerPeriod8(27){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get4(array, idx, 0, 0);
                }
                case 1: {
                    return this.get4(array, idx, 3, 3);
                }
                case 2: {
                    return this.get8(array, idx, 3, 30);
                }
                case 3: {
                    return this.get4(array, idx, 10, 1);
                }
                case 4: {
                    return this.get4(array, idx, 13, 4);
                }
                case 5: {
                    return this.get8(array, idx, 13, 31);
                }
                case 6: {
                    return this.get4(array, idx, 20, 2);
                }
            }
            return this.get4(array, idx, 23, 5);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set4(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set4(array, idx, 3, 3, value);
                }
                case 2: {
                    return this.set8(array, idx, 3, 30, value);
                }
                case 3: {
                    return this.set4(array, idx, 10, 1, value);
                }
                case 4: {
                    return this.set4(array, idx, 13, 4, value);
                }
                case 5: {
                    return this.set8(array, idx, 13, 31, value);
                }
                case 6: {
                    return this.set4(array, idx, 20, 2, value);
                }
            }
            return this.set4(array, idx, 23, 5, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update4(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update4(array, idx, 3, 3, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 3, 30, value, operator);
                }
                case 3: {
                    return this.update4(array, idx, 10, 1, value, operator);
                }
                case 4: {
                    return this.update4(array, idx, 13, 4, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 13, 31, value, operator);
                }
                case 6: {
                    return this.update4(array, idx, 20, 2, value, operator);
                }
            }
            return this.update4(array, idx, 23, 5, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_28 = new AbstractPackedArrayHandlerPeriod2(28){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get4(array, idx, 3 * k, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set4(array, idx, 3 * k, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update4(array, idx, 3 * k, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_29 = new AbstractPackedArrayHandlerPeriod8(29){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get4(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 0, 29);
                }
                case 2: {
                    return this.get4(array, idx, 7, 2);
                }
                case 3: {
                    return this.get8(array, idx, 7, 31);
                }
                case 4: {
                    return this.get8(array, idx, 11, 28);
                }
                case 5: {
                    return this.get4(array, idx, 18, 1);
                }
                case 6: {
                    return this.get8(array, idx, 18, 30);
                }
            }
            return this.get4(array, idx, 25, 3);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set4(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 0, 29, value);
                }
                case 2: {
                    return this.set4(array, idx, 7, 2, value);
                }
                case 3: {
                    return this.set8(array, idx, 7, 31, value);
                }
                case 4: {
                    return this.set8(array, idx, 11, 28, value);
                }
                case 5: {
                    return this.set4(array, idx, 18, 1, value);
                }
                case 6: {
                    return this.set8(array, idx, 18, 30, value);
                }
            }
            return this.set4(array, idx, 25, 3, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update4(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 0, 29, value, operator);
                }
                case 2: {
                    return this.update4(array, idx, 7, 2, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 7, 31, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 11, 28, value, operator);
                }
                case 5: {
                    return this.update4(array, idx, 18, 1, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 18, 30, value, operator);
                }
            }
            return this.update4(array, idx, 25, 3, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_30 = new AbstractPackedArrayHandlerPeriod4(30){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get4(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 0, 30);
                }
                case 2: {
                    return this.get8(array, idx, 4, 28);
                }
            }
            return this.get4(array, idx, 11, 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set4(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 0, 30, value);
                }
                case 2: {
                    return this.set8(array, idx, 4, 28, value);
                }
            }
            return this.set4(array, idx, 11, 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update4(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 0, 30, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 4, 28, value, operator);
                }
            }
            return this.update4(array, idx, 11, 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_31 = new AbstractPackedArrayHandlerPeriod8(31){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get4(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 0, 31);
                }
                case 2: {
                    return this.get8(array, idx, 4, 30);
                }
                case 3: {
                    return this.get8(array, idx, 8, 29);
                }
                case 4: {
                    return this.get8(array, idx, 12, 28);
                }
                case 5: {
                    return this.get8(array, idx, 16, 27);
                }
                case 6: {
                    return this.get8(array, idx, 20, 26);
                }
            }
            return this.get4(array, idx, 27, 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set4(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 0, 31, value);
                }
                case 2: {
                    return this.set8(array, idx, 4, 30, value);
                }
                case 3: {
                    return this.set8(array, idx, 8, 29, value);
                }
                case 4: {
                    return this.set8(array, idx, 12, 28, value);
                }
                case 5: {
                    return this.set8(array, idx, 16, 27, value);
                }
                case 6: {
                    return this.set8(array, idx, 20, 26, value);
                }
            }
            return this.set4(array, idx, 27, 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update4(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 0, 31, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 4, 30, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 8, 29, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 12, 28, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 16, 27, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 20, 26, value, operator);
                }
            }
            return this.update4(array, idx, 27, 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_32 = new AbstractPackedArrayHandlerPeriod1(32){

        @Override
        public long get(byte[] array, int idx) {
            return this.get4(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set4(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update4(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_33 = new AbstractPackedArrayHandlerPeriod8(33){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get5(array, idx, k << 2, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set5(array, idx, k << 2, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update5(array, idx, k << 2, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_34 = new AbstractPackedArrayHandlerPeriod4(34){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 3;
            return this.get5(array, idx, k << 2, k << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 3;
            return this.set5(array, idx, k << 2, k << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 3;
            return this.update5(array, idx, k << 2, k << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_35 = new AbstractPackedArrayHandlerPeriod8(35){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get5(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 1, 27);
                }
                case 2: {
                    return this.get8(array, idx, 6, 22);
                }
                case 3: {
                    return this.get8(array, idx, 10, 25);
                }
                case 4: {
                    return this.get8(array, idx, 14, 28);
                }
                case 5: {
                    return this.get8(array, idx, 19, 23);
                }
                case 6: {
                    return this.get8(array, idx, 23, 26);
                }
            }
            return this.get8(array, idx, 27, 29);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set5(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 1, 27, value);
                }
                case 2: {
                    return this.set8(array, idx, 6, 22, value);
                }
                case 3: {
                    return this.set8(array, idx, 10, 25, value);
                }
                case 4: {
                    return this.set8(array, idx, 14, 28, value);
                }
                case 5: {
                    return this.set8(array, idx, 19, 23, value);
                }
                case 6: {
                    return this.set8(array, idx, 23, 26, value);
                }
            }
            return this.set8(array, idx, 27, 29, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update5(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 1, 27, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 6, 22, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 10, 25, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 14, 28, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 19, 23, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 23, 26, value, operator);
                }
            }
            return this.update8(array, idx, 27, 29, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_36 = new AbstractPackedArrayHandlerPeriod2(36){

        @Override
        public long get(byte[] array, int idx) {
            int k = (idx & 1) << 2;
            return this.get5(array, idx, k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = (idx & 1) << 2;
            return this.set5(array, idx, k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = (idx & 1) << 2;
            return this.update5(array, idx, k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_37 = new AbstractPackedArrayHandlerPeriod8(37){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get5(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 2, 21);
                }
                case 2: {
                    return this.get8(array, idx, 6, 26);
                }
                case 3: {
                    return this.get8(array, idx, 11, 23);
                }
                case 4: {
                    return this.get8(array, idx, 16, 20);
                }
                case 5: {
                    return this.get8(array, idx, 20, 25);
                }
                case 6: {
                    return this.get8(array, idx, 25, 22);
                }
            }
            return this.get8(array, idx, 29, 27);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set5(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 2, 21, value);
                }
                case 2: {
                    return this.set8(array, idx, 6, 26, value);
                }
                case 3: {
                    return this.set8(array, idx, 11, 23, value);
                }
                case 4: {
                    return this.set8(array, idx, 16, 20, value);
                }
                case 5: {
                    return this.set8(array, idx, 20, 25, value);
                }
                case 6: {
                    return this.set8(array, idx, 25, 22, value);
                }
            }
            return this.set8(array, idx, 29, 27, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update5(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 2, 21, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 6, 26, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 11, 23, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 16, 20, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 20, 25, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 25, 22, value, operator);
                }
            }
            return this.update8(array, idx, 29, 27, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_38 = new AbstractPackedArrayHandlerPeriod4(38){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get5(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 2, 22);
                }
                case 2: {
                    return this.get8(array, idx, 7, 20);
                }
            }
            return this.get8(array, idx, 11, 26);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set5(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 2, 22, value);
                }
                case 2: {
                    return this.set8(array, idx, 7, 20, value);
                }
            }
            return this.set8(array, idx, 11, 26, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update5(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 2, 22, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 7, 20, value, operator);
                }
            }
            return this.update8(array, idx, 11, 26, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_39 = new AbstractPackedArrayHandlerPeriod8(39){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get5(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 2, 23);
                }
                case 2: {
                    return this.get8(array, idx, 7, 22);
                }
                case 3: {
                    return this.get8(array, idx, 12, 21);
                }
                case 4: {
                    return this.get8(array, idx, 17, 20);
                }
                case 5: {
                    return this.get8(array, idx, 22, 19);
                }
                case 6: {
                    return this.get8(array, idx, 27, 18);
                }
            }
            return this.get8(array, idx, 31, 25);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set5(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 2, 23, value);
                }
                case 2: {
                    return this.set8(array, idx, 7, 22, value);
                }
                case 3: {
                    return this.set8(array, idx, 12, 21, value);
                }
                case 4: {
                    return this.set8(array, idx, 17, 20, value);
                }
                case 5: {
                    return this.set8(array, idx, 22, 19, value);
                }
                case 6: {
                    return this.set8(array, idx, 27, 18, value);
                }
            }
            return this.set8(array, idx, 31, 25, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update5(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 2, 23, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 7, 22, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 12, 21, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 17, 20, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 22, 19, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 27, 18, value, operator);
                }
            }
            return this.update8(array, idx, 31, 25, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_40 = new AbstractPackedArrayHandlerPeriod1(40){

        @Override
        public long get(byte[] array, int idx) {
            return this.get5(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set5(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update5(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_41 = new AbstractPackedArrayHandlerPeriod8(41){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get6(array, idx, 5 * k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set6(array, idx, 5 * k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update6(array, idx, 5 * k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_42 = new AbstractPackedArrayHandlerPeriod4(42){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 3;
            return this.get6(array, idx, 5 * k, k << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 3;
            return this.set6(array, idx, 5 * k, k << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 3;
            return this.update6(array, idx, 5 * k, k << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_43 = new AbstractPackedArrayHandlerPeriod8(43){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get6(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 3, 19);
                }
                case 2: {
                    return this.get8(array, idx, 9, 14);
                }
                case 3: {
                    return this.get8(array, idx, 14, 17);
                }
                case 4: {
                    return this.get8(array, idx, 19, 20);
                }
                case 5: {
                    return this.get8(array, idx, 25, 15);
                }
                case 6: {
                    return this.get8(array, idx, 30, 18);
                }
            }
            return this.get8(array, idx, 35, 21);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set6(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 3, 19, value);
                }
                case 2: {
                    return this.set8(array, idx, 9, 14, value);
                }
                case 3: {
                    return this.set8(array, idx, 14, 17, value);
                }
                case 4: {
                    return this.set8(array, idx, 19, 20, value);
                }
                case 5: {
                    return this.set8(array, idx, 25, 15, value);
                }
                case 6: {
                    return this.set8(array, idx, 30, 18, value);
                }
            }
            return this.set8(array, idx, 35, 21, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update6(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 3, 19, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 9, 14, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 14, 17, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 19, 20, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 25, 15, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 30, 18, value, operator);
                }
            }
            return this.update8(array, idx, 35, 21, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_44 = new AbstractPackedArrayHandlerPeriod2(44){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get6(array, idx, 5 * k, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set6(array, idx, 5 * k, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update6(array, idx, 5 * k, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_45 = new AbstractPackedArrayHandlerPeriod8(45){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get6(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 4, 13);
                }
                case 2: {
                    return this.get8(array, idx, 9, 18);
                }
                case 3: {
                    return this.get8(array, idx, 15, 15);
                }
                case 4: {
                    return this.get8(array, idx, 21, 12);
                }
                case 5: {
                    return this.get8(array, idx, 26, 17);
                }
                case 6: {
                    return this.get8(array, idx, 32, 14);
                }
            }
            return this.get8(array, idx, 37, 19);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set6(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 4, 13, value);
                }
                case 2: {
                    return this.set8(array, idx, 9, 18, value);
                }
                case 3: {
                    return this.set8(array, idx, 15, 15, value);
                }
                case 4: {
                    return this.set8(array, idx, 21, 12, value);
                }
                case 5: {
                    return this.set8(array, idx, 26, 17, value);
                }
                case 6: {
                    return this.set8(array, idx, 32, 14, value);
                }
            }
            return this.set8(array, idx, 37, 19, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update6(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 4, 13, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 9, 18, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 15, 15, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 21, 12, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 26, 17, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 32, 14, value, operator);
                }
            }
            return this.update8(array, idx, 37, 19, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_46 = new AbstractPackedArrayHandlerPeriod4(46){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get6(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 4, 14);
                }
                case 2: {
                    return this.get8(array, idx, 10, 12);
                }
            }
            return this.get8(array, idx, 15, 18);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set6(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 4, 14, value);
                }
                case 2: {
                    return this.set8(array, idx, 10, 12, value);
                }
            }
            return this.set8(array, idx, 15, 18, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update6(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 4, 14, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 10, 12, value, operator);
                }
            }
            return this.update8(array, idx, 15, 18, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_47 = new AbstractPackedArrayHandlerPeriod8(47){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get6(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 4, 15);
                }
                case 2: {
                    return this.get8(array, idx, 10, 14);
                }
                case 3: {
                    return this.get8(array, idx, 16, 13);
                }
                case 4: {
                    return this.get8(array, idx, 22, 12);
                }
                case 5: {
                    return this.get8(array, idx, 28, 11);
                }
                case 6: {
                    return this.get8(array, idx, 34, 10);
                }
            }
            return this.get8(array, idx, 39, 17);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set6(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 4, 15, value);
                }
                case 2: {
                    return this.set8(array, idx, 10, 14, value);
                }
                case 3: {
                    return this.set8(array, idx, 16, 13, value);
                }
                case 4: {
                    return this.set8(array, idx, 22, 12, value);
                }
                case 5: {
                    return this.set8(array, idx, 28, 11, value);
                }
                case 6: {
                    return this.set8(array, idx, 34, 10, value);
                }
            }
            return this.set8(array, idx, 39, 17, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update6(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 4, 15, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 10, 14, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 16, 13, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 22, 12, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 28, 11, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 34, 10, value, operator);
                }
            }
            return this.update8(array, idx, 39, 17, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_48 = new AbstractPackedArrayHandlerPeriod1(48){

        @Override
        public long get(byte[] array, int idx) {
            return this.get6(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set6(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update6(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_49 = new AbstractPackedArrayHandlerPeriod8(49){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get7(array, idx, 6 * k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set7(array, idx, 6 * k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update7(array, idx, 6 * k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_50 = new AbstractPackedArrayHandlerPeriod4(50){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 3;
            return this.get7(array, idx, 6 * k, k << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 3;
            return this.set7(array, idx, 6 * k, k << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 3;
            return this.update7(array, idx, 6 * k, k << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_51 = new AbstractPackedArrayHandlerPeriod8(51){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get7(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 5, 11);
                }
                case 2: {
                    return this.get8(array, idx, 12, 6);
                }
                case 3: {
                    return this.get8(array, idx, 18, 9);
                }
                case 4: {
                    return this.get8(array, idx, 24, 12);
                }
                case 5: {
                    return this.get8(array, idx, 31, 7);
                }
                case 6: {
                    return this.get8(array, idx, 37, 10);
                }
            }
            return this.get8(array, idx, 43, 13);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set7(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 5, 11, value);
                }
                case 2: {
                    return this.set8(array, idx, 12, 6, value);
                }
                case 3: {
                    return this.set8(array, idx, 18, 9, value);
                }
                case 4: {
                    return this.set8(array, idx, 24, 12, value);
                }
                case 5: {
                    return this.set8(array, idx, 31, 7, value);
                }
                case 6: {
                    return this.set8(array, idx, 37, 10, value);
                }
            }
            return this.set8(array, idx, 43, 13, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update7(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 5, 11, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 12, 6, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 18, 9, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 24, 12, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 31, 7, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 37, 10, value, operator);
                }
            }
            return this.update8(array, idx, 43, 13, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_52 = new AbstractPackedArrayHandlerPeriod2(52){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get7(array, idx, 6 * k, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set7(array, idx, 6 * k, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update7(array, idx, 6 * k, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_53 = new AbstractPackedArrayHandlerPeriod8(53){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get7(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 6, 5);
                }
                case 2: {
                    return this.get8(array, idx, 12, 10);
                }
                case 3: {
                    return this.get8(array, idx, 19, 7);
                }
                case 4: {
                    return this.get8(array, idx, 26, 4);
                }
                case 5: {
                    return this.get8(array, idx, 32, 9);
                }
                case 6: {
                    return this.get8(array, idx, 39, 6);
                }
            }
            return this.get8(array, idx, 45, 11);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set7(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 6, 5, value);
                }
                case 2: {
                    return this.set8(array, idx, 12, 10, value);
                }
                case 3: {
                    return this.set8(array, idx, 19, 7, value);
                }
                case 4: {
                    return this.set8(array, idx, 26, 4, value);
                }
                case 5: {
                    return this.set8(array, idx, 32, 9, value);
                }
                case 6: {
                    return this.set8(array, idx, 39, 6, value);
                }
            }
            return this.set8(array, idx, 45, 11, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update7(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 6, 5, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 12, 10, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 19, 7, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 26, 4, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 32, 9, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 39, 6, value, operator);
                }
            }
            return this.update8(array, idx, 45, 11, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_54 = new AbstractPackedArrayHandlerPeriod4(54){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get7(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 6, 6);
                }
                case 2: {
                    return this.get8(array, idx, 13, 4);
                }
            }
            return this.get8(array, idx, 19, 10);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set7(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 6, 6, value);
                }
                case 2: {
                    return this.set8(array, idx, 13, 4, value);
                }
            }
            return this.set8(array, idx, 19, 10, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update7(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 6, 6, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 13, 4, value, operator);
                }
            }
            return this.update8(array, idx, 19, 10, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_55 = new AbstractPackedArrayHandlerPeriod8(55){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get7(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 6, 7);
                }
                case 2: {
                    return this.get8(array, idx, 13, 6);
                }
                case 3: {
                    return this.get8(array, idx, 20, 5);
                }
                case 4: {
                    return this.get8(array, idx, 27, 4);
                }
                case 5: {
                    return this.get8(array, idx, 34, 3);
                }
                case 6: {
                    return this.get8(array, idx, 41, 2);
                }
            }
            return this.get8(array, idx, 47, 9);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set7(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 6, 7, value);
                }
                case 2: {
                    return this.set8(array, idx, 13, 6, value);
                }
                case 3: {
                    return this.set8(array, idx, 20, 5, value);
                }
                case 4: {
                    return this.set8(array, idx, 27, 4, value);
                }
                case 5: {
                    return this.set8(array, idx, 34, 3, value);
                }
                case 6: {
                    return this.set8(array, idx, 41, 2, value);
                }
            }
            return this.set8(array, idx, 47, 9, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update7(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 6, 7, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 13, 6, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 20, 5, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 27, 4, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 34, 3, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 41, 2, value, operator);
                }
            }
            return this.update8(array, idx, 47, 9, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_56 = new AbstractPackedArrayHandlerPeriod1(56){

        @Override
        public long get(byte[] array, int idx) {
            return this.get7(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set7(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update7(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_57 = new AbstractPackedArrayHandlerPeriod8(57){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 7;
            return this.get8(array, idx, 7 * k, k);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 7;
            return this.set8(array, idx, 7 * k, k, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 7;
            return this.update8(array, idx, 7 * k, k, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_58 = new AbstractPackedArrayHandlerPeriod4(58){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 3;
            return this.get8(array, idx, 7 * k, k << 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 3;
            return this.set8(array, idx, 7 * k, k << 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 3;
            return this.update8(array, idx, 7 * k, k << 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_59 = new AbstractPackedArrayHandlerPeriod8(59){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get8(array, idx, 0, 0);
                }
                case 1: {
                    return this.get8(array, idx, 7, 3);
                }
                case 2: {
                    return this.get9(array, idx, 14, 6);
                }
                case 3: {
                    return this.get8(array, idx, 22, 1);
                }
                case 4: {
                    return this.get8(array, idx, 29, 4);
                }
                case 5: {
                    return this.get9(array, idx, 36, 7);
                }
                case 6: {
                    return this.get8(array, idx, 44, 2);
                }
            }
            return this.get8(array, idx, 51, 5);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set8(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set8(array, idx, 7, 3, value);
                }
                case 2: {
                    return this.set9(array, idx, 14, 6, value);
                }
                case 3: {
                    return this.set8(array, idx, 22, 1, value);
                }
                case 4: {
                    return this.set8(array, idx, 29, 4, value);
                }
                case 5: {
                    return this.set9(array, idx, 36, 7, value);
                }
                case 6: {
                    return this.set8(array, idx, 44, 2, value);
                }
            }
            return this.set8(array, idx, 51, 5, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update8(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update8(array, idx, 7, 3, value, operator);
                }
                case 2: {
                    return this.update9(array, idx, 14, 6, value, operator);
                }
                case 3: {
                    return this.update8(array, idx, 22, 1, value, operator);
                }
                case 4: {
                    return this.update8(array, idx, 29, 4, value, operator);
                }
                case 5: {
                    return this.update9(array, idx, 36, 7, value, operator);
                }
                case 6: {
                    return this.update8(array, idx, 44, 2, value, operator);
                }
            }
            return this.update8(array, idx, 51, 5, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_60 = new AbstractPackedArrayHandlerPeriod2(60){

        @Override
        public long get(byte[] array, int idx) {
            int k = idx & 1;
            return this.get8(array, idx, 7 * k, k << 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            int k = idx & 1;
            return this.set8(array, idx, 7 * k, k << 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            int k = idx & 1;
            return this.update8(array, idx, 7 * k, k << 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_61 = new AbstractPackedArrayHandlerPeriod8(61){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get8(array, idx, 0, 0);
                }
                case 1: {
                    return this.get9(array, idx, 7, 5);
                }
                case 2: {
                    return this.get8(array, idx, 15, 2);
                }
                case 3: {
                    return this.get9(array, idx, 22, 7);
                }
                case 4: {
                    return this.get9(array, idx, 30, 4);
                }
                case 5: {
                    return this.get8(array, idx, 38, 1);
                }
                case 6: {
                    return this.get9(array, idx, 45, 6);
                }
            }
            return this.get8(array, idx, 53, 3);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set8(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set9(array, idx, 7, 5, value);
                }
                case 2: {
                    return this.set8(array, idx, 15, 2, value);
                }
                case 3: {
                    return this.set9(array, idx, 22, 7, value);
                }
                case 4: {
                    return this.set9(array, idx, 30, 4, value);
                }
                case 5: {
                    return this.set8(array, idx, 38, 1, value);
                }
                case 6: {
                    return this.set9(array, idx, 45, 6, value);
                }
            }
            return this.set8(array, idx, 53, 3, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update8(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update9(array, idx, 7, 5, value, operator);
                }
                case 2: {
                    return this.update8(array, idx, 15, 2, value, operator);
                }
                case 3: {
                    return this.update9(array, idx, 22, 7, value, operator);
                }
                case 4: {
                    return this.update9(array, idx, 30, 4, value, operator);
                }
                case 5: {
                    return this.update8(array, idx, 38, 1, value, operator);
                }
                case 6: {
                    return this.update9(array, idx, 45, 6, value, operator);
                }
            }
            return this.update8(array, idx, 53, 3, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_62 = new AbstractPackedArrayHandlerPeriod4(62){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 3) {
                case 0: {
                    return this.get8(array, idx, 0, 0);
                }
                case 1: {
                    return this.get9(array, idx, 7, 6);
                }
                case 2: {
                    return this.get9(array, idx, 15, 4);
                }
            }
            return this.get8(array, idx, 23, 2);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 3) {
                case 0: {
                    return this.set8(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set9(array, idx, 7, 6, value);
                }
                case 2: {
                    return this.set9(array, idx, 15, 4, value);
                }
            }
            return this.set8(array, idx, 23, 2, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 3) {
                case 0: {
                    return this.update8(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update9(array, idx, 7, 6, value, operator);
                }
                case 2: {
                    return this.update9(array, idx, 15, 4, value, operator);
                }
            }
            return this.update8(array, idx, 23, 2, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_63 = new AbstractPackedArrayHandlerPeriod8(63){

        @Override
        public long get(byte[] array, int idx) {
            switch (idx & 7) {
                case 0: {
                    return this.get8(array, idx, 0, 0);
                }
                case 1: {
                    return this.get9(array, idx, 7, 7);
                }
                case 2: {
                    return this.get9(array, idx, 15, 6);
                }
                case 3: {
                    return this.get9(array, idx, 23, 5);
                }
                case 4: {
                    return this.get9(array, idx, 31, 4);
                }
                case 5: {
                    return this.get9(array, idx, 39, 3);
                }
                case 6: {
                    return this.get9(array, idx, 47, 2);
                }
            }
            return this.get8(array, idx, 55, 1);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            switch (idx & 7) {
                case 0: {
                    return this.set8(array, idx, 0, 0, value);
                }
                case 1: {
                    return this.set9(array, idx, 7, 7, value);
                }
                case 2: {
                    return this.set9(array, idx, 15, 6, value);
                }
                case 3: {
                    return this.set9(array, idx, 23, 5, value);
                }
                case 4: {
                    return this.set9(array, idx, 31, 4, value);
                }
                case 5: {
                    return this.set9(array, idx, 39, 3, value);
                }
                case 6: {
                    return this.set9(array, idx, 47, 2, value);
                }
            }
            return this.set8(array, idx, 55, 1, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            switch (idx & 7) {
                case 0: {
                    return this.update8(array, idx, 0, 0, value, operator);
                }
                case 1: {
                    return this.update9(array, idx, 7, 7, value, operator);
                }
                case 2: {
                    return this.update9(array, idx, 15, 6, value, operator);
                }
                case 3: {
                    return this.update9(array, idx, 23, 5, value, operator);
                }
                case 4: {
                    return this.update9(array, idx, 31, 4, value, operator);
                }
                case 5: {
                    return this.update9(array, idx, 39, 3, value, operator);
                }
                case 6: {
                    return this.update9(array, idx, 47, 2, value, operator);
                }
            }
            return this.update8(array, idx, 55, 1, value, operator);
        }
    };
    private static final PackedArrayHandler HANDLER_64 = new AbstractPackedArrayHandlerPeriod1(64){

        @Override
        public long get(byte[] array, int idx) {
            return this.get8(array, idx, 0, 0);
        }

        @Override
        public long set(byte[] array, int idx, long value) {
            return this.set8(array, idx, 0, 0, value);
        }

        @Override
        public long update(byte[] array, int idx, long value, LongBinaryOperator operator) {
            return this.update8(array, idx, 0, 0, value, operator);
        }
    };
    private static final PackedArrayHandler[] HANDLER_INSTANCES = PackedArray.createHandlerInstances();

    private PackedArray() {
    }

    private static void checkArrayLength(int length, int bitSize) {
        if (length < 0 || Math.multiplyFull(length, bitSize) > 0x3FFFFFFF8L) {
            throw new IllegalArgumentException("Invalid array length");
        }
    }

    private static PackedArrayHandler[] createHandlerInstances() {
        PackedArrayHandler[] instances = new PackedArrayHandler[]{HANDLER_0, HANDLER_1, HANDLER_2, HANDLER_3, HANDLER_4, HANDLER_5, HANDLER_6, HANDLER_7, HANDLER_8, HANDLER_9, HANDLER_10, HANDLER_11, HANDLER_12, HANDLER_13, HANDLER_14, HANDLER_15, HANDLER_16, HANDLER_17, HANDLER_18, HANDLER_19, HANDLER_20, HANDLER_21, HANDLER_22, HANDLER_23, HANDLER_24, HANDLER_25, HANDLER_26, HANDLER_27, HANDLER_28, HANDLER_29, HANDLER_30, HANDLER_31, HANDLER_32, HANDLER_33, HANDLER_34, HANDLER_35, HANDLER_36, HANDLER_37, HANDLER_38, HANDLER_39, HANDLER_40, HANDLER_41, HANDLER_42, HANDLER_43, HANDLER_44, HANDLER_45, HANDLER_46, HANDLER_47, HANDLER_48, HANDLER_49, HANDLER_50, HANDLER_51, HANDLER_52, HANDLER_53, HANDLER_54, HANDLER_55, HANDLER_56, HANDLER_57, HANDLER_58, HANDLER_59, HANDLER_60, HANDLER_61, HANDLER_62, HANDLER_63, HANDLER_64};
        return instances;
    }

    public static PackedArrayHandler getHandler(int bitSize) {
        return HANDLER_INSTANCES[bitSize];
    }

    public static interface PackedArrayHandler {
        public int numBytes(int var1);

        public byte[] create(int var1);

        public byte[] create(IndexedLongValueProvider var1, int var2);

        public long get(byte[] var1, int var2);

        public long set(byte[] var1, int var2, long var3);

        public long update(byte[] var1, int var2, long var3, LongBinaryOperator var5);

        public int getBitSize();

        public int numEqualComponents(byte[] var1, byte[] var2, int var3);

        public void clear(byte[] var1);

        public PackedArrayReadIterator readIterator(byte[] var1, int var2);
    }

    private static abstract class AbstractPackedArrayHandlerPeriod8
    extends AbstractPackedArrayHandler {
        public AbstractPackedArrayHandlerPeriod8(int bitSize) {
            super(bitSize);
        }

        @Override
        protected int getOffset(int idx) {
            return (idx >>> 3) * this.bitSize;
        }
    }

    private static abstract class AbstractPackedArrayHandlerPeriod4
    extends AbstractPackedArrayHandler {
        public AbstractPackedArrayHandlerPeriod4(int bitSize) {
            super(bitSize);
        }

        @Override
        protected int getOffset(int idx) {
            return (idx >>> 2) * (this.bitSize >>> 1);
        }
    }

    private static abstract class AbstractPackedArrayHandlerPeriod2
    extends AbstractPackedArrayHandler {
        public AbstractPackedArrayHandlerPeriod2(int bitSize) {
            super(bitSize);
        }

        @Override
        protected int getOffset(int idx) {
            return (idx >>> 1) * (this.bitSize >>> 2);
        }
    }

    private static abstract class AbstractPackedArrayHandlerPeriod1
    extends AbstractPackedArrayHandler {
        public AbstractPackedArrayHandlerPeriod1(int bitSize) {
            super(bitSize);
        }

        @Override
        protected int getOffset(int idx) {
            return idx * (this.bitSize >>> 3);
        }
    }

    private static abstract class AbstractPackedArrayHandler
    implements PackedArrayHandler {
        protected final int bitSize;
        protected final long mask;

        private void checkArrayLength(int length) {
            PackedArray.checkArrayLength(length, this.bitSize);
        }

        private AbstractPackedArrayHandler(int bitSize) {
            this.bitSize = bitSize;
            this.mask = (2L << bitSize - 1) - 1L;
        }

        @Override
        public byte[] create(int length) {
            this.checkArrayLength(length);
            return new byte[this.numBytes(length)];
        }

        @Override
        public final int getBitSize() {
            return this.bitSize;
        }

        @Override
        public int numEqualComponents(byte[] array1, byte[] array2, int length) {
            ParallelXorPackedArrayReadIterator x = new ParallelXorPackedArrayReadIterator(array1, array2, length);
            int c = 0;
            for (int i = 0; i < length; ++i) {
                if (x.next() != 0L) continue;
                ++c;
            }
            return c;
        }

        @Override
        public int numBytes(int length) {
            return this.bitSize * length + 7 >>> 3;
        }

        @Override
        public void clear(byte[] array) {
            Arrays.fill(array, (byte)0);
        }

        protected abstract int getOffset(int var1);

        protected long get1(byte[] array, int idx, int off, int shift) {
            int offset = this.getOffset(idx) + off;
            return (long)(array[offset] >>> shift) & this.mask;
        }

        protected long set1(byte[] array, int idx, int off, int shift, long value) {
            int offset = this.getOffset(idx) + off;
            long current = array[offset];
            long ret = current >>> shift;
            array[offset] = (byte)(current ^= ((ret ^ value) & this.mask) << shift);
            return ret & this.mask;
        }

        protected long update1(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            int offset = this.getOffset(idx) + off;
            long current = array[offset];
            long ret = current >>> shift & this.mask;
            array[offset] = (byte)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift);
            return ret;
        }

        protected long get2(byte[] array, int idx, int off, int shift) {
            int offset = this.getOffset(idx) + off;
            return (long)(ByteArrayUtil.getShort(array, offset) >>> shift) & this.mask;
        }

        protected long set2(byte[] array, int idx, int off, int shift, long value) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getShort(array, offset);
            long ret = current >>> shift;
            ByteArrayUtil.setShort(array, offset, (short)(current ^= ((ret ^ value) & this.mask) << shift));
            return ret & this.mask;
        }

        protected long update2(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getShort(array, offset);
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setShort(array, offset, (short)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            return ret;
        }

        protected long get3(byte[] array, int idx, int off, int shift) {
            if (idx > 0) {
                return this.get4(array, idx, off - 1, shift + 8);
            }
            int offset = this.getOffset(idx) + off;
            return ((long)ByteArrayUtil.getShort(array, offset) & 0xFFFFL | (long)(array[offset + 2] << 16)) >>> shift & this.mask;
        }

        protected long set3(byte[] array, int idx, int off, int shift, long value) {
            if (idx > 0) {
                return this.set4(array, idx, off - 1, shift + 8, value);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getShort(array, offset) & 0xFFFFL | (long)(array[offset + 2] << 16);
            long ret = current >>> shift;
            ByteArrayUtil.setShort(array, offset, (short)(current ^= ((ret ^ value) & this.mask) << shift));
            array[offset + 2] = (byte)(current >>> 16);
            return ret & this.mask;
        }

        protected long update3(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            if (idx > 0) {
                return this.update4(array, idx, off - 1, shift + 8, value, operator);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getShort(array, offset) & 0xFFFFL | (long)(array[offset + 2] << 16);
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setShort(array, offset, (short)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            array[offset + 2] = (byte)(current >>> 16);
            return ret;
        }

        protected long get4(byte[] array, int idx, int off, int shift) {
            int offset = this.getOffset(idx) + off;
            return (long)(ByteArrayUtil.getInt(array, offset) >>> shift) & this.mask;
        }

        protected long set4(byte[] array, int idx, int off, int shift, long value) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getInt(array, offset);
            long ret = current >>> shift;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= ((ret ^ value) & this.mask) << shift));
            return ret & this.mask;
        }

        protected long update4(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getInt(array, offset);
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            return ret;
        }

        protected long get5(byte[] array, int idx, int off, int shift) {
            if (idx > 0) {
                return this.get8(array, idx, off - 3, shift + 24);
            }
            int offset = this.getOffset(idx) + off;
            return ((long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)array[offset + 4] << 32) >>> shift & this.mask;
        }

        protected long set5(byte[] array, int idx, int off, int shift, long value) {
            if (idx > 0) {
                return this.set8(array, idx, off - 3, shift + 24, value);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)array[offset + 4] << 32;
            long ret = current >>> shift;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= ((ret ^ value) & this.mask) << shift));
            array[offset + 4] = (byte)(current >>> 32);
            return ret & this.mask;
        }

        protected long update5(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            if (idx > 0) {
                return this.update8(array, idx, off - 3, shift + 24, value, operator);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)array[offset + 4] << 32;
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            array[offset + 4] = (byte)(current >>> 32);
            return ret;
        }

        protected long get6(byte[] array, int idx, int off, int shift) {
            if (idx > 0) {
                return this.get8(array, idx, off - 2, shift + 16);
            }
            int offset = this.getOffset(idx) + off;
            return ((long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)ByteArrayUtil.getShort(array, offset + 4) << 32) >>> shift & this.mask;
        }

        protected long set6(byte[] array, int idx, int off, int shift, long value) {
            if (idx > 0) {
                return this.set8(array, idx, off - 2, shift + 16, value);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)ByteArrayUtil.getShort(array, offset + 4) << 32;
            long ret = current >>> shift;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= ((ret ^ value) & this.mask) << shift));
            ByteArrayUtil.setShort(array, offset + 4, (short)(current >>> 32));
            return ret & this.mask;
        }

        protected long update6(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            if (idx > 0) {
                return this.update8(array, idx, off - 2, shift + 16, value, operator);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | (long)ByteArrayUtil.getShort(array, offset + 4) << 32;
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            ByteArrayUtil.setShort(array, offset + 4, (short)(current >>> 32));
            return ret;
        }

        protected long get7(byte[] array, int idx, int off, int shift) {
            if (idx > 0) {
                return this.get8(array, idx, off - 1, shift + 8);
            }
            int offset = this.getOffset(idx) + off;
            return ((long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | ((long)ByteArrayUtil.getShort(array, offset + 4) & 0xFFFFL) << 32 | (long)array[offset + 6] << 48) >>> shift & this.mask;
        }

        protected long set7(byte[] array, int idx, int off, int shift, long value) {
            if (idx > 0) {
                return this.set8(array, idx, off - 1, shift + 8, value);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | ((long)ByteArrayUtil.getShort(array, offset + 4) & 0xFFFFL) << 32 | (long)array[offset + 6] << 48;
            long ret = current >>> shift;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= ((ret ^ value) & this.mask) << shift));
            ByteArrayUtil.setShort(array, offset + 4, (short)(current >>> 32));
            array[offset + 6] = (byte)(current >>> 48);
            return ret & this.mask;
        }

        protected long update7(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            if (idx > 0) {
                return this.update8(array, idx, off - 1, shift + 8, value, operator);
            }
            int offset = this.getOffset(idx) + off;
            long current = (long)ByteArrayUtil.getInt(array, offset) & 0xFFFFFFFFL | ((long)ByteArrayUtil.getShort(array, offset + 4) & 0xFFFFL) << 32 | (long)array[offset + 6] << 48;
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setInt(array, offset, (int)(current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift));
            ByteArrayUtil.setShort(array, offset + 4, (short)(current >>> 32));
            array[offset + 6] = (byte)(current >>> 48);
            return ret;
        }

        protected long get8(byte[] array, int idx, int off, int shift) {
            int offset = this.getOffset(idx) + off;
            return ByteArrayUtil.getLong(array, offset) >>> shift & this.mask;
        }

        protected long set8(byte[] array, int idx, int off, int shift, long value) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getLong(array, offset);
            long ret = current >>> shift;
            ByteArrayUtil.setLong(array, offset, current ^= ((ret ^ value) & this.mask) << shift);
            return ret & this.mask;
        }

        protected long update8(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            int offset = this.getOffset(idx) + off;
            long current = ByteArrayUtil.getLong(array, offset);
            long ret = current >>> shift & this.mask;
            ByteArrayUtil.setLong(array, offset, current ^= (ret ^ operator.applyAsLong(ret, value) & this.mask) << shift);
            return ret;
        }

        protected long get9(byte[] array, int idx, int off, int shift) {
            int offset = this.getOffset(idx) + off;
            return (ByteArrayUtil.getLong(array, offset) >>> shift | (long)array[offset + 8] << -shift) & this.mask;
        }

        protected long set9(byte[] array, int idx, int off, int shift, long value) {
            int offset = this.getOffset(idx) + off;
            long currentLong = ByteArrayUtil.getLong(array, offset);
            long currentByte = array[offset + 8];
            long ret = currentLong >>> shift | currentByte << -shift;
            long changeMask = (ret ^ value) & this.mask;
            ByteArrayUtil.setLong(array, offset, currentLong ^ changeMask << shift);
            array[offset + 8] = (byte)(currentByte ^ changeMask >>> -shift);
            return ret & this.mask;
        }

        protected long update9(byte[] array, int idx, int off, int shift, long value, LongBinaryOperator operator) {
            int offset = this.getOffset(idx) + off;
            long currentLong = ByteArrayUtil.getLong(array, offset);
            long currentByte = array[offset + 8];
            long ret = (currentLong >>> shift | currentByte << -shift) & this.mask;
            long changeMask = ret ^ operator.applyAsLong(ret, value) & this.mask;
            ByteArrayUtil.setLong(array, offset, currentLong ^ changeMask << shift);
            array[offset + 8] = (byte)(currentByte ^ changeMask >>> -shift);
            return ret;
        }

        @Override
        public byte[] create(IndexedLongValueProvider valueProvider, int length) {
            byte[] array = this.create(length);
            long buffer = 0L;
            int bitsInBuffer = 0;
            int arrayOffset = 0;
            for (int idx = 0; idx < length; ++idx) {
                long value = valueProvider.getValue(idx) & this.mask;
                buffer |= value << bitsInBuffer;
                if ((bitsInBuffer += this.bitSize) < 64) continue;
                ByteArrayUtil.setLong(array, arrayOffset, buffer);
                arrayOffset += 8;
                buffer = value >>> 1 >>> this.bitSize - (bitsInBuffer -= 64) - 1;
            }
            if (bitsInBuffer > 56) {
                ByteArrayUtil.setLong(array, arrayOffset, buffer);
            } else {
                if (bitsInBuffer > 24) {
                    ByteArrayUtil.setInt(array, arrayOffset, (int)buffer);
                    bitsInBuffer -= 32;
                    arrayOffset += 4;
                    buffer >>>= 32;
                }
                if (bitsInBuffer > 8) {
                    ByteArrayUtil.setShort(array, arrayOffset, (short)buffer);
                    bitsInBuffer -= 16;
                    arrayOffset += 2;
                    buffer >>>= 16;
                }
                if (bitsInBuffer > 0) {
                    array[arrayOffset] = (byte)buffer;
                }
            }
            return array;
        }

        @Override
        public PackedArrayReadIterator readIterator(byte[] array, int length) {
            return new PackedArrayReadIteratorImpl(array, length);
        }

        private class ParallelXorPackedArrayReadIterator {
            private long buffer;
            private int availableBits;
            private int readPos;
            private final byte[] array1;
            private final byte[] array2;

            public ParallelXorPackedArrayReadIterator(byte[] array1, byte[] array2, int length) {
                Objects.requireNonNull(array1);
                this.array1 = array1;
                this.array2 = array2;
                int remainingBytes = AbstractPackedArrayHandler.this.numBytes(length) & 7;
                this.availableBits = remainingBytes << 3;
                if (array1.length >= 8) {
                    this.buffer = ByteArrayUtil.getLong(array1, 0) ^ ByteArrayUtil.getLong(array2, 0);
                    this.readPos = remainingBytes;
                } else {
                    this.readPos = 0;
                    this.buffer = 0L;
                    if (remainingBytes >= 4) {
                        this.buffer |= (long)(ByteArrayUtil.getInt(array1, this.readPos) ^ ByteArrayUtil.getInt(array2, this.readPos)) & 0xFFFFFFFFL;
                        this.readPos += 4;
                        remainingBytes -= 4;
                    }
                    if (remainingBytes >= 2) {
                        this.buffer |= ((long)(ByteArrayUtil.getShort(array1, this.readPos) ^ ByteArrayUtil.getShort(array2, this.readPos)) & 0xFFFFL) << (this.readPos << 3);
                        this.readPos += 2;
                        remainingBytes -= 2;
                    }
                    if (remainingBytes >= 1) {
                        this.buffer |= ((long)(array1[this.readPos] ^ array2[this.readPos]) & 0xFFL) << (this.readPos << 3);
                        ++this.readPos;
                    }
                }
            }

            public long next() {
                long result = this.buffer;
                this.buffer >>>= AbstractPackedArrayHandler.this.bitSize;
                if (this.availableBits < AbstractPackedArrayHandler.this.bitSize) {
                    this.buffer = ByteArrayUtil.getLong(this.array1, this.readPos) ^ ByteArrayUtil.getLong(this.array2, this.readPos);
                    result |= this.buffer << this.availableBits;
                    this.buffer >>>= 1;
                    this.buffer >>>= ~(this.availableBits - AbstractPackedArrayHandler.this.bitSize);
                    this.readPos += 8;
                    this.availableBits += 64;
                }
                this.availableBits -= AbstractPackedArrayHandler.this.bitSize;
                return result & AbstractPackedArrayHandler.this.mask;
            }
        }

        private class PackedArrayReadIteratorImpl
        implements PackedArrayReadIterator {
            private int idx = 0;
            private long buffer;
            private int availableBits;
            private int readPos;
            private final int length;
            private final byte[] array;

            public PackedArrayReadIteratorImpl(byte[] array, int length) {
                Objects.requireNonNull(array);
                this.length = length;
                this.array = array;
                int remainingBytes = AbstractPackedArrayHandler.this.numBytes(length) & 7;
                this.availableBits = remainingBytes << 3;
                if (array.length >= 8) {
                    this.buffer = ByteArrayUtil.getLong(array, 0);
                    this.readPos = remainingBytes;
                } else {
                    this.readPos = 0;
                    this.buffer = 0L;
                    if (remainingBytes >= 4) {
                        this.buffer |= (long)ByteArrayUtil.getInt(array, this.readPos) & 0xFFFFFFFFL;
                        this.readPos += 4;
                        remainingBytes -= 4;
                    }
                    if (remainingBytes >= 2) {
                        this.buffer |= ((long)ByteArrayUtil.getShort(array, this.readPos) & 0xFFFFL) << (this.readPos << 3);
                        this.readPos += 2;
                        remainingBytes -= 2;
                    }
                    if (remainingBytes >= 1) {
                        this.buffer |= ((long)array[this.readPos] & 0xFFL) << (this.readPos << 3);
                        ++this.readPos;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.length;
            }

            @Override
            public long next() {
                ++this.idx;
                long result = this.buffer;
                this.buffer >>>= AbstractPackedArrayHandler.this.bitSize;
                if (this.availableBits < AbstractPackedArrayHandler.this.bitSize) {
                    this.buffer = ByteArrayUtil.getLong(this.array, this.readPos);
                    result |= this.buffer << this.availableBits;
                    this.buffer >>>= 1;
                    this.buffer >>>= ~(this.availableBits - AbstractPackedArrayHandler.this.bitSize);
                    this.readPos += 8;
                    this.availableBits += 64;
                }
                this.availableBits -= AbstractPackedArrayHandler.this.bitSize;
                return result & AbstractPackedArrayHandler.this.mask;
            }
        }
    }

    public static interface PackedArrayReadIterator {
        public boolean hasNext();

        public long next();
    }

    @FunctionalInterface
    public static interface IndexedLongValueProvider {
        public long getValue(int var1);
    }
}

