/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Objects;
import org.apache.kafka.common.utils.BufferSupplier;

public class RequestLocal
implements AutoCloseable {
    private static final RequestLocal NO_CACHING = new RequestLocal(BufferSupplier.NO_CACHING);
    private final BufferSupplier bufferSupplier;

    public RequestLocal(BufferSupplier bufferSupplier) {
        this.bufferSupplier = bufferSupplier;
    }

    public static RequestLocal noCaching() {
        return NO_CACHING;
    }

    public static RequestLocal withThreadConfinedCaching() {
        return new RequestLocal(BufferSupplier.create());
    }

    public BufferSupplier bufferSupplier() {
        return this.bufferSupplier;
    }

    @Override
    public void close() {
        this.bufferSupplier.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestLocal that = (RequestLocal)o;
        return Objects.equals(this.bufferSupplier, that.bufferSupplier);
    }

    public int hashCode() {
        return Objects.hashCode(this.bufferSupplier);
    }

    public String toString() {
        return "RequestLocal(bufferSupplier=" + String.valueOf(this.bufferSupplier) + ")";
    }
}

