/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;

public class ShareGroupMetrics
implements AutoCloseable {
    private static final String RECORD_ACKNOWLEDGEMENTS_PER_SEC = "RecordAcknowledgementsPerSec";
    private static final String PARTITION_LOAD_TIME_MS = "PartitionLoadTimeMs";
    private static final String TOPIC_PARTITIONS_FETCH_RATIO = "RequestTopicPartitionsFetchRatio";
    private static final String TOPIC_PARTITIONS_ACQUIRE_TIME_MS = "TopicPartitionsAcquireTimeMs";
    private static final String ACK_TYPE_TAG = "ackType";
    private final Map<Byte, Meter> recordAcknowledgementMeterMap;
    private final Histogram partitionLoadTimeMs;
    private final Map<String, Histogram> topicPartitionsFetchRatio;
    private final Map<String, Histogram> topicPartitionsAcquireTimeMs;
    private final KafkaMetricsGroup metricsGroup;
    private final Time time;

    public ShareGroupMetrics(Time time) {
        this.time = time;
        this.metricsGroup = new KafkaMetricsGroup("kafka.server", "ShareGroupMetrics");
        this.recordAcknowledgementMeterMap = Arrays.stream(AcknowledgeType.values()).collect(Collectors.toMap(type -> type.id, type -> this.metricsGroup.newMeter(RECORD_ACKNOWLEDGEMENTS_PER_SEC, "records", TimeUnit.SECONDS, Map.of(ACK_TYPE_TAG, ShareGroupMetrics.capitalize(type.toString())))));
        this.partitionLoadTimeMs = this.metricsGroup.newHistogram(PARTITION_LOAD_TIME_MS);
        this.topicPartitionsFetchRatio = new ConcurrentHashMap<String, Histogram>();
        this.topicPartitionsAcquireTimeMs = new ConcurrentHashMap<String, Histogram>();
    }

    public void recordAcknowledgement(byte ackType) {
        this.recordAcknowledgement(ackType, 1L);
    }

    public void recordAcknowledgement(byte ackType, long count) {
        if (this.recordAcknowledgementMeterMap.containsKey(ackType)) {
            this.recordAcknowledgementMeterMap.get(ackType).mark(count);
        }
    }

    public void partitionLoadTime(long start) {
        this.partitionLoadTimeMs.update(this.time.hiResClockMs() - start);
    }

    public void recordTopicPartitionsFetchRatio(String groupId, long value) {
        this.topicPartitionsFetchRatio.computeIfAbsent(groupId, k -> this.metricsGroup.newHistogram(TOPIC_PARTITIONS_FETCH_RATIO, true, Map.of("group", groupId)));
        this.topicPartitionsFetchRatio.get(groupId).update(value);
    }

    public void recordTopicPartitionsAcquireTimeMs(String groupId, long timeMs) {
        this.topicPartitionsAcquireTimeMs.computeIfAbsent(groupId, k -> this.metricsGroup.newHistogram(TOPIC_PARTITIONS_ACQUIRE_TIME_MS, true, Map.of("group", groupId)));
        this.topicPartitionsAcquireTimeMs.get(groupId).update(timeMs);
    }

    public Meter recordAcknowledgementMeter(byte ackType) {
        return this.recordAcknowledgementMeterMap.get(ackType);
    }

    public Histogram partitionLoadTimeMs() {
        return this.partitionLoadTimeMs;
    }

    public Histogram topicPartitionsFetchRatio(String groupId) {
        return this.topicPartitionsFetchRatio.get(groupId);
    }

    public Histogram topicPartitionsAcquireTimeMs(String groupId) {
        return this.topicPartitionsAcquireTimeMs.get(groupId);
    }

    @Override
    public void close() throws Exception {
        Arrays.stream(AcknowledgeType.values()).forEach(m -> this.metricsGroup.removeMetric(RECORD_ACKNOWLEDGEMENTS_PER_SEC, Map.of(ACK_TYPE_TAG, m.toString())));
        this.metricsGroup.removeMetric(PARTITION_LOAD_TIME_MS);
        this.topicPartitionsFetchRatio.forEach((k, v) -> this.metricsGroup.removeMetric(TOPIC_PARTITIONS_FETCH_RATIO, Map.of("group", k)));
        this.topicPartitionsAcquireTimeMs.forEach((k, v) -> this.metricsGroup.removeMetric(TOPIC_PARTITIONS_ACQUIRE_TIME_MS, Map.of("group", k)));
    }

    private static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }
}

