/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\r\u001b\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\ne\u0001\u0011\t\u0011)A\u0005gYB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013)\u0003\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000be\u0003A\u0011\u0001.\t\u0011\u0011\u0004!\u0019!C\u00015\u0015Daa\u001d\u0001!\u0002\u00131\u0007\"\u0002;\u0001\t#*\b\"\u0002@\u0001\t#z\bbBA\u0005\u0001\u0011E\u00131\u0002\u0005\b\u0003\u001f\u0001A\u0011KA\t\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u00026\u0001!\t%!\f\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!9\u0011q\r\u0001\u0005\n\u00055\u0002bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\t\t\n\u0001C)\u0003'CQ\"a'\u0001!\u0003\r\t\u0011!C\u0005\u0003;3$\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\t!$\u0003\u0002$5\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"AJ\u0018\u000f\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001f\u0003\u0019a$o\\8u})\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3&\u0001\u0004mK\u0006$WM\u001d\t\u0003CQJ!!\u000e\u000e\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi&\u0011!GI\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003CeJ!A\u000f\u000e\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"!I\u001f\n\u0005yR\"\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003C\u0005K!A\u0011\u000e\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011\u0011%R\u0005\u0003\rj\u0011ABU3qY&\u001c\u0017-U;pi\u0006\f\u0011\u0002\\8h!J,g-\u001b=\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\bc\u0001&L\u001b6\t1&\u0003\u0002MW\tIa)\u001e8di&|g\u000e\r\t\u0003\u001d^k\u0011a\u0014\u0006\u0003!F\u000baaY8n[>t'BA\u000eS\u0015\ti2K\u0003\u0002U+\u00061\u0011\r]1dQ\u0016T\u0011AV\u0001\u0004_J<\u0017B\u0001-P\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017A\u0002\u001fj]&$h\bF\u0005\\9vsv\fY1cGB\u0011\u0011\u0005\u0001\u0005\u0006I%\u0001\r!\n\u0005\u0006e%\u0001\ra\r\u0005\u0006o%\u0001\r\u0001\u000f\u0005\u0006w%\u0001\r\u0001\u0010\u0005\u0006\u007f%\u0001\r\u0001\u0011\u0005\u0006\u0007&\u0001\r\u0001\u0012\u0005\u0006\u000f&\u0001\r!\n\u0005\u0006\u0011&\u0001\r!S\u0001\u001fa\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<\b*[4i/\u0006$XM]7be.,\u0012A\u001a\t\u0004O2tW\"\u00015\u000b\u0005%T\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003W.\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0007N\u0001\u0004Ck\u001a4WM\u001d\t\u0003_Fl\u0011\u0001\u001d\u0006\u0003!JK!A\u001d9\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006y\u0002/\u0019:uSRLwN\\:XSRDg*Z<IS\u001eDw+\u0019;fe6\f'o\u001b\u0011\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0003mr\u00042AS<z\u0013\tA8F\u0001\u0004PaRLwN\u001c\t\u0003\u0015jL!a_\u0016\u0003\u0007%sG\u000fC\u0003~\u0019\u0001\u0007a.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011\u0011AA\u0004!\rQ\u00151A\u0005\u0004\u0003\u000bY#\u0001\u0002'p]\u001eDQ!`\u0007A\u00029\fA\u0002\\8h\u000b:$wJ\u001a4tKR$B!!\u0001\u0002\u000e!)QP\u0004a\u0001]\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005M\u00111DA\u000f!\u0011Qu/!\u0006\u0011\u00079\u000b9\"C\u0002\u0002\u001a=\u0013ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0003~\u001f\u0001\u0007a\u000e\u0003\u0004\u0002 =\u0001\r!_\u0001\u0006KB|7\r[\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!!\n\u0011\u0007)\u000b9#C\u0002\u0002*-\u0012qAQ8pY\u0016\fg.A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u000b\u0003\u0003_\u00012ASA\u0019\u0013\r\t\u0019d\u000b\u0002\u0005+:LG/\u0001\u0004e_^{'o[\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0015\u0005m\u0012\u0011KA*\u0003/\nY\u0006\u0005\u0003Ko\u0006u\u0002\u0003BA \u0003\u001bj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0004Y><'\u0002BA$\u0003\u0013\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005-#+A\u0004ti>\u0014\u0018mZ3\n\t\u0005=\u0013\u0011\t\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000bu\u001c\u0002\u0019\u00018\t\u000f\u0005U3\u00031\u0001\u0002\u0002\u0005Ya-\u001a;dQ>3gm]3u\u0011\u0019\tIf\u0005a\u0001s\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"Dq!!\u0018\u0014\u0001\u0004\ty&A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003C\n\u0019'D\u0001\u0001\u0013\r\t)G\t\u0002\n\r\u0016$8\r\u001b#bi\u0006\fAdY8na2,G/\u001a#fY\u0006LX\r\u001a$fi\u000eD'+Z9vKN$8/A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003_\ti'! \t\u000f\u0005=T\u00031\u0001\u0002r\u00059!/Z2pe\u0012\u001c\b\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]\u0004/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003w\n)HA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0006{V\u0001\rA\\\u0001\tiJ,hnY1uKR1\u0011qFAB\u0003\u000fCa!!\"\u0017\u0001\u0004q\u0017A\u0001;q\u0011\u001d\tII\u0006a\u0001\u0003\u0017\u000bQc\u001c4gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002\"\u0003\u001bK1!a$\u001b\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005=\u0012QSAL\u0011\u0015ix\u00031\u0001o\u0011\u001d\tIj\u0006a\u0001\u0003\u0003\taa\u001c4gg\u0016$\u0018\u0001D:va\u0016\u0014H\u0005\\3bI\u0016\u0014X#A\u001a")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to initiate shutdown of " + this.super$leader() + " after initiating replica fetcher thread shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to close " + this.super$leader() + " after shutting down replica fetcher thread", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d bytes of messages and leader hw %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false, partitionLeaderEpoch);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        ObjectRef maybeUpdateHighWatermarkMessage = ObjectRef.create((Object)"but did not update replica high watermark");
        log.maybeUpdateHighWatermark(partitionData.highWatermark()).foreach((Function1 & Serializable)newHighWatermark -> ReplicaFetcherThread.$anonfun$processPartitionData$3(this, maybeUpdateHighWatermarkMessage, topicPartition, BoxesRunTime.unboxToLong((Object)newHighWatermark)));
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Follower received high watermark " + partitionData.highWatermark() + " from the leader " + (String)maybeUpdateHighWatermarkMessage$1.elem + " for partition " + topicPartition);
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn((long)records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn((long)records.sizeInBytes());
        return logAppendInfo;
    }

    private void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    private void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition " + topicPartition + ". This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be equal or larger than your settings for max.message.bytes, both at a broker and topic level.");
            return;
        }
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        UnifiedLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Truncating " + tp + " to offset " + offsetTruncationState.offset() + " below high watermark " + log.highWatermark());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
            return;
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ Buffer $anonfun$processPartitionData$3(ReplicaFetcherThread $this, ObjectRef maybeUpdateHighWatermarkMessage$1, TopicPartition topicPartition$1, long newHighWatermark) {
        maybeUpdateHighWatermarkMessage$1.elem = "and updated replica high watermark to " + newHighWatermark;
        return (Buffer)$this.partitionsWithNewHighWatermark().$plus$eq((Object)topicPartition$1);
    }

    public ReplicaFetcherThread(String name, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, String logPrefix, Function0<MetadataVersion> metadataVersionSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, false), Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.logIdent_$eq(logPrefix);
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }
}

