/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\f\u0019\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001b\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019y\u0007\u0001)A\u0005\u0013\"Q\u0001\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B9\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001bBA\u000b\u0001\u0001\u0006I\u0001\u001e\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033Aq!a\u0007\u0001A\u0003%!\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA=\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003w\u0002A\u0011IA?\u0005Q\u0011%o\\6fe\ncwnY6j]\u001e\u001cVM\u001c3fe*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005A\u0012BA\u0014\u0019\u00051\u0011En\\2lS:<7+\u001a8e\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tQ3'D\u0001,\u0015\taS&A\u0004oKR<xN]6\u000b\u0005eq#BA\u000e0\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005QZ#A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003K]J!\u0001\u000f\r\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\tYt(D\u0001=\u0015\tITH\u0003\u0002?]\u000511m\\7n_:L!\u0001\u0011\u001f\u0003\u000f5+GO]5dg\u0006!A/[7f!\t\u0019e)D\u0001E\u0015\t)U(A\u0003vi&d7/\u0003\u0002H\t\n!A+[7f\u0003%1W\r^2iKJLE\r\u0005\u0002 \u0015&\u00111\n\t\u0002\u0004\u0013:$\u0018\u0001C2mS\u0016tG/\u00133\u0011\u00059+fBA(T!\t\u0001\u0006%D\u0001R\u0015\t\u0011F$\u0001\u0004=e>|GOP\u0005\u0003)\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A\u000bI\u0001\u000bY><7i\u001c8uKb$\bCA\"[\u0013\tYFI\u0001\u0006M_\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003\u00030`A\u0006\u00147\rZ3\u0011\u0005\u0015\u0002\u0001\"\u0002\u0015\t\u0001\u0004I\u0003\"B\u001b\t\u0001\u00041\u0004\"B\u001d\t\u0001\u0004Q\u0004\"B!\t\u0001\u0004\u0011\u0005\"\u0002%\t\u0001\u0004I\u0005\"\u0002'\t\u0001\u0004i\u0005\"\u0002-\t\u0001\u0004I\u0016AC:pkJ\u001cWMT8eKV\t\u0001\u000e\u0005\u0002jU6\tQ(\u0003\u0002l{\t!aj\u001c3f\u0003-\u0019x.\u001e:dK:{G-\u001a\u0011\u0002\u001bM|7m[3u)&lWm\\;u+\u0005I\u0015AD:pG.,G\u000fV5nK>,H\u000fI\u0001\u0004q\u0012\n\u0004\u0003B\u0010sijL!a\u001d\u0011\u0003\rQ+\b\u000f\\33!\t)\b0D\u0001w\u0015\t9h&A\u0004dY&,g\u000e^:\n\u0005e4(!\u0004(fi^|'o[\"mS\u0016tG\u000fE\u0002 wvL!\u0001 \u0011\u0003\r=\u0003H/[8o%\u0015q\u0018\u0011AA\u0006\r\u0011y\b\u0001A?\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005\r\u0011qA\u0007\u0003\u0003\u000bQ!\u0001L\u001f\n\t\u0005%\u0011Q\u0001\u0002\u000f\u0007\"\fgN\\3m\u0005VLG\u000eZ3s!\rI\u0017QB\u0005\u0004\u0003\u001fi$A\u0004*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0016\u0003Q\faB\\3uo>\u00148n\u00117jK:$\b%\u0001\u000fsK\u000e|gNZ5hkJ\f'\r\\3DQ\u0006tg.\u001a7Ck&dG-\u001a:\u0016\u0003i\fQD]3d_:4\u0017nZ;sC\ndWm\u00115b]:,GNQ;jY\u0012,'\u000fI\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\u0005I\u0013aC:f]\u0012\u0014V-];fgR$B!!\n\u0002,A\u0019Q/a\n\n\u0007\u0005%bO\u0001\bDY&,g\u000e\u001e*fgB|gn]3\t\u000f\u000552\u00031\u0001\u00020\u0005q!/Z9vKN$()^5mI\u0016\u0014\b\u0007BA\u0019\u00037\u0002b!a\r\u0002R\u0005]c\u0002BA\u001b\u0003\u0017rA!a\u000e\u0002H9!\u0011\u0011HA#\u001d\u0011\tY$a\u0011\u000f\t\u0005u\u0012\u0011\t\b\u0004!\u0006}\u0012\"\u0001\u001a\n\u0005A\n\u0014BA\u000e0\u0013\tqd&C\u0002\u0002Ju\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u001b\ny%A\bBEN$(/Y2u%\u0016\fX/Z:u\u0015\r\tI%P\u0005\u0005\u0003'\n)FA\u0004Ck&dG-\u001a:\u000b\t\u00055\u0013q\n\t\u0005\u00033\nY\u0006\u0004\u0001\u0005\u0019\u0005u\u00131FA\u0001\u0002\u0003\u0015\t!a\u0018\u0003\u0007}##'\u0005\u0003\u0002b\u0005\u001d\u0004cA\u0010\u0002d%\u0019\u0011Q\r\u0011\u0003\u000f9{G\u000f[5oOB!\u0011\u0011NA6\u001b\t\ty%\u0003\u0003\u0002n\u0005=#aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\t\t\u0019\bE\u0002 \u0003kJ1!a\u001e!\u0005\u0011)f.\u001b;\u0002\u000b\rdwn]3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0014")
public class BrokerBlockingSender
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final int fetcherId;
    private final Node sourceNode;
    private final int socketTimeout;
    private final /* synthetic */ Tuple2 x$1;
    private final NetworkClient networkClient;
    private final Option<ChannelBuilder> reconfigurableChannelBuilder;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private Option<ChannelBuilder> reconfigurableChannelBuilder() {
        return this.reconfigurableChannelBuilder;
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                throw new SocketTimeoutException("Failed to connect within " + this.socketTimeout() + " ms");
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder().foreach((Function1 & Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public String toString() {
        return "BrokerBlockingSender(sourceBroker=" + this.sourceBroker + ", fetcherId=" + this.fetcherId + ")";
    }

    /*
     * WARNING - void declaration
     */
    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext) {
        void var9_9;
        None$ none$;
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.time = time;
        this.fetcherId = fetcherId;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)brokerConfig.interBrokerListenerName(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (Time)time, (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            brokerConfig.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMaxMs()), time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
        Option reconfigurableChannelBuilder2 = (Option)var9_9;
        this.x$1 = new Tuple2((Object)networkClient, (Object)reconfigurableChannelBuilder2);
        this.networkClient = (NetworkClient)this.x$1._1();
        this.reconfigurableChannelBuilder = (Option)this.x$1._2();
    }
}

