/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.DataPlaneAcceptor;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.ApiVersionManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-c\u0001B$I\u00015C\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005E\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003i\u0011!)\bA!b\u0001\n\u00031\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011u\u0004!Q1A\u0005\u0002yD\u0011\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u00055\u0001A!b\u0001\n\u0003\ty\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u0003#A!\"!\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000e\u0011)\t9\u0003\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\u000b\u0003S\u0001!Q1A\u0005\u0002\u0005-\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002.!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0011!\tI\u0007\u0001Q\u0001\n\u0005}\u0003\"CA6\u0001\t\u0007I\u0011BA7\u0011!\ty\b\u0001Q\u0001\n\u0005=\u0004\"CAA\u0001\t\u0007I\u0011CAB\u0011!\tY\t\u0001Q\u0001\n\u0005\u0015\u0005\"CAG\u0001\t\u0007I\u0011BAH\u0011!\t9\n\u0001Q\u0001\n\u0005E\u0005\"CAM\u0001\t\u0007I\u0011BAN\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005u\u0005\"CAS\u0001\t\u0007I\u0011BAT\u0011!\t\t\f\u0001Q\u0001\n\u0005%\u0006\"CAZ\u0001\t\u0007I\u0011BAT\u0011!\t)\f\u0001Q\u0001\n\u0005%\u0006\"CA\\\u0001\t\u0007I\u0011BA]\u0011!\t9\r\u0001Q\u0001\n\u0005m\u0006BCAe\u0001\t\u0007I\u0011\u0001%\u0002L\"A\u0011q\u001e\u0001!\u0002\u0013\ti\rC\u0005\u0002r\u0002\u0011\r\u0011\"\u0001\u0002t\"A\u00111 \u0001!\u0002\u0013\t)\u0010\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BA\u0000\u0011%\u0011Y\u0001\u0001b\u0001\n\u0003\u0011i\u0001\u0003\u0005\u0003\u0016\u0001\u0001\u000b\u0011\u0002B\b\u0011%\u00119\u0002\u0001b\u0001\n\u0013\u0011I\u0002\u0003\u0005\u0003(\u0001\u0001\u000b\u0011\u0002B\u000e\u0011%\u0011I\u0003\u0001a\u0001\n\u0013\u0011Y\u0003C\u0005\u00034\u0001\u0001\r\u0011\"\u0003\u00036!A!\u0011\t\u0001!B\u0013\u0011i\u0003C\u0004\u0002~\u0002!\tAa\u0011\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!\u0011\f\u0001\u0005\n\tm\u0003b\u0002B1\u0001\u0011%!1\r\u0005\b\u0005s\u0002A\u0011\u0003B>\u0011\u001d\u0011I\t\u0001C\u0001\u0005\u0017CqA!$\u0001\t\u0003\u0011Y\tC\u0004\u0003\u0010\u0002!\tA!%\t\u000f\t]\u0005\u0001\"\u0001\u0003\u001a\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BU\u0001\u0011\u0005#1\u0016\u0005\b\u0005\u0013\u0004A\u0011\tBf\u0011\u001d\u0011\t\u000e\u0001C!\u0005'D\u0001Ba7\u0001\t\u0003A%Q\u001c\u0005\b\u0005_\u0004A\u0011\u0001By\u000f\u001d\u0011Y\u0010\u0013E\u0001\u0005{4aa\u0012%\t\u0002\t}\bbBA#y\u0011\u00051\u0011\u0001\u0005\n\u0007\u0007a$\u0019!C\u0001\u0007\u000bA\u0001ba\u0003=A\u0003%1q\u0001\u0005\n\u0007\u001ba$\u0019!C\u0001\u0005WC\u0001ba\u0004=A\u0003%!Q\u0016\u0005\n\u0007#a$\u0019!C\u0001\u0005WC\u0001ba\u0005=A\u0003%!Q\u0016\u0005\b\u0007+aD\u0011AB\f\u0011%\u0019i\u0003PI\u0001\n\u0003\u0019y\u0003C\u0005\u0004Fq\n\n\u0011\"\u0001\u0004H\ta1k\\2lKR\u001cVM\u001d<fe*\u0011\u0011JS\u0001\b]\u0016$xo\u001c:l\u0015\u0005Y\u0015!B6bM.\f7\u0001A\n\u0005\u00019#&\f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/*\u000bQ!\u001e;jYNL!!\u0017,\u0003\u000f1{wmZ5oOB\u00111LX\u0007\u00029*\u0011QLS\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}c&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-\u0001\u0004d_:4\u0017nZ\u000b\u0002EB\u00111lY\u0005\u0003Ir\u00131bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aB7fiJL7m]\u000b\u0002QB\u0011\u0011N]\u0007\u0002U*\u0011am\u001b\u0006\u0003Y6\faaY8n[>t'BA&o\u0015\ty\u0007/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005MT'aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005!A/[7f+\u00059\bC\u0001={\u001b\u0005I(BA,l\u0013\tY\u0018P\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA7\u0002\u0011M,7-\u001e:jifLA!!\u0003\u0002\u0004\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003M\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:!\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM]\u000b\u0003\u0003#\u00012aWA\n\u0013\r\t)\u0002\u0018\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014\u0018AE1qSZ+'o]5p]6\u000bg.Y4fe\u0002\nQb]8dW\u0016$h)Y2u_JLXCAA\u000f!\u0011\ty\"a\t\u000e\u0005\u0005\u0005\"BA/n\u0013\u0011\t)#!\t\u0003'M+'O^3s'>\u001c7.\u001a;GC\u000e$xN]=\u0002\u001dM|7m[3u\r\u0006\u001cGo\u001c:zA\u0005i2m\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0002.A1\u0011qFA\u001b\u0003si!!!\r\u000b\u0007\u0005M\u0002+\u0001\u0006d_2dWm\u0019;j_:LA!a\u000e\u00022\t\u00191+Z9\u0011\t\u0005m\u0012qH\u0007\u0003\u0003{Q1!SA\u0011\u0013\u0011\t\t%!\u0010\u00039\r{gN\\3di&|g\u000eR5tG>tg.Z2u\u0019&\u001cH/\u001a8fe\u0006q2m\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005%\u0013QJA(\u0003#\n\u0019&!\u0016\u0002X\u0005e\u0003cAA&\u00015\t\u0001\nC\u0003a\u001f\u0001\u0007!\rC\u0003g\u001f\u0001\u0007\u0001\u000eC\u0003v\u001f\u0001\u0007q\u000fC\u0003~\u001f\u0001\u0007q\u0010C\u0004\u0002\u000e=\u0001\r!!\u0005\t\u0013\u0005eq\u0002%AA\u0002\u0005u\u0001\"CA\u0015\u001fA\u0005\t\u0019AA\u0017\u00031iW\r\u001e:jGN<%o\\;q+\t\ty\u0006\u0005\u0003\u0002b\u0005\u0015TBAA2\u0015\r1\u0017\u0011E\u0005\u0005\u0003O\n\u0019GA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013!E7bqF+X-^3e%\u0016\fX/Z:ugV\u0011\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0014\u0001\u00026bm\u0006LA!! \u0002t\t9\u0011J\u001c;fO\u0016\u0014\u0018AE7bqF+X-^3e%\u0016\fX/Z:ug\u0002\naA\\8eK&#WCAAC!\ry\u0015qQ\u0005\u0004\u0003\u0013\u0003&aA%oi\u00069an\u001c3f\u0013\u0012\u0004\u0013A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0013\t\u0004q\u0006M\u0015bAAKs\nQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\u0011[\u0016lwN]=Q_>d7+\u001a8t_J,\"!!(\u0011\u0007%\fy*C\u0002\u0002\"*\u0014aaU3og>\u0014\u0018!E7f[>\u0014\u0018\u0010U8pYN+gn]8sA\u0005\u0019S.Z7pef\u0004vn\u001c7EKBdW\r^3e!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,WCAAU!\u0011\tY+!,\u000e\u0003-L1!a,l\u0005)iU\r\u001e:jG:\u000bW.Z\u0001%[\u0016lwN]=Q_>dG)\u001a9mKR,G\rU3sG\u0016tG/T3ue&\u001cg*Y7fA\u0005\u0001S.Z7pef\u0004vn\u001c7EKBdW\r^3e)&lW-T3ue&\u001cg*Y7f\u0003\u0005jW-\\8ssB{w\u000e\u001c#fa2,G/\u001a3US6,W*\u001a;sS\u000et\u0015-\\3!\u0003)iW-\\8ssB{w\u000e\\\u000b\u0003\u0003w\u0003B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\\\u0017AB7f[>\u0014\u00180\u0003\u0003\u0002F\u0006}&AC'f[>\u0014\u0018\u0010U8pY\u0006YQ.Z7pef\u0004vn\u001c7!\u0003I!\u0017\r^1QY\u0006tW-Q2dKB$xN]:\u0016\u0005\u00055\u0007\u0003CAh\u00033\fi.!;\u000e\u0005\u0005E'\u0002BAj\u0003+\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\t9.a\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\f\tNA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003GT\u0015aB2mkN$XM]\u0005\u0005\u0003O\f\tO\u0001\u0005F]\u0012\u0004v.\u001b8u!\u0011\tY%a;\n\u0007\u00055\bJA\tECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\f1\u0003Z1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8sg\u0002\nq\u0003Z1uCBc\u0017M\\3SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0005\u0005U\b\u0003BA&\u0003oL1!!?I\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001\u0004Z1uCBc\u0017M\\3SKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003=qW\r\u001f;Qe>\u001cWm]:pe&#\u0007\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\t\t\u0015\u0011\u0011[\u0001\u0007CR|W.[2\n\t\t%!1\u0001\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002!\r|gN\\3di&|g.U;pi\u0006\u001cXC\u0001B\b!\u0011\tYE!\u0005\n\u0007\tM\u0001J\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\u00029\u0005dG.Q;uQ>\u0014\u0018N_3s\rV$XO]3t\u0007>l\u0007\u000f\\3uKV\u0011!1\u0004\t\u0007\u0003\u001f\u0014iB!\t\n\t\t}\u0011\u0011\u001b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA9\u0005GIAA!\n\u0002t\t!ak\\5e\u0003u\tG\u000e\\!vi\"|'/\u001b>fe\u001a+H/\u001e:fg\u000e{W\u000e\u001d7fi\u0016\u0004\u0013aB:u_B\u0004X\rZ\u000b\u0003\u0005[\u00012a\u0014B\u0018\u0013\r\u0011\t\u0004\u0015\u0002\b\u0005>|G.Z1o\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\t\t]\"Q\b\t\u0004\u001f\ne\u0012b\u0001B\u001e!\n!QK\\5u\u0011%\u0011yDKA\u0001\u0002\u0004\u0011i#A\u0002yIE\n\u0001b\u001d;paB,G\r\t\u000b\u0003\u0003\u000b\u000bq#\u001a8bE2,'+Z9vKN$\bK]8dKN\u001c\u0018N\\4\u0015\t\tm!\u0011\n\u0005\b\u0005\u0017j\u0003\u0019\u0001B'\u0003E\tW\u000f\u001e5pe&TXM\u001d$viV\u0014Xm\u001d\t\t\u0003_\u0011yEa\u0015\u0003\u001c%!!\u0011KA\u0019\u0005\ri\u0015\r\u001d\t\u0005\u0003W\u0013)&C\u0002\u0003X-\u0014\u0001\"\u00128ea>Lg\u000e^\u0001%GJ,\u0017\r^3ECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\fe\u000e\u001a)s_\u000e,7o]8sgR!!q\u0007B/\u0011\u001d\u0011yF\fa\u0001\u0003;\f\u0001\"\u001a8ea>Lg\u000e^\u0001\nK:$\u0007o\\5oiN,\"A!\u001a\u0011\u0011\t\u001d$Q\u000eB8\u0003;l!A!\u001b\u000b\t\t-\u0014\u0011G\u0001\nS6lW\u000f^1cY\u0016LAA!\u0015\u0003jA!!\u0011\u000fB;\u001b\t\u0011\u0019H\u0003\u0002JW&!!q\u000fB:\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]\u0019'/Z1uK\u0012\u000bG/\u0019)mC:,\u0017iY2faR|'\u000f\u0006\u0005\u0002j\nu$\u0011\u0011BC\u0011\u001d\u0011y\b\ra\u0001\u0003;\f\u0001\"\u001a8e!>Lg\u000e\u001e\u0005\b\u0005\u0007\u0003\u0004\u0019\u0001B\u0017\u0003QI7\u000f\u0015:jm&dWmZ3e\u0019&\u001cH/\u001a8fe\"9!q\u0011\u0019A\u0002\u0005U\u0018A\u0004:fcV,7\u000f^\"iC:tW\r\\\u0001\u0017gR|\u0007\u000f\u0015:pG\u0016\u001c8/\u001b8h%\u0016\fX/Z:ugR\u0011!qG\u0001\tg\",H\u000fZ8x]\u0006I!m\\;oIB{'\u000f\u001e\u000b\u0005\u0003\u000b\u0013\u0019\nC\u0004\u0003\u0016N\u0002\rAa\u001c\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0002\u0019\u0005$G\rT5ti\u0016tWM]:\u0015\t\t]\"1\u0014\u0005\b\u0005;#\u0004\u0019\u0001BP\u00039a\u0017n\u001d;f]\u0016\u00148/\u00113eK\u0012\u0004b!a\f\u00026\u0005u\u0017a\u0004:f[>4X\rT5ti\u0016tWM]:\u0015\t\t]\"Q\u0015\u0005\b\u0005O+\u0004\u0019\u0001BP\u0003Aa\u0017n\u001d;f]\u0016\u00148OU3n_Z,G-A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\t5\u0006CBA\u0018\u0005_\u0013\u0019,\u0003\u0003\u00032\u0006E\"aA*fiB!!Q\u0017Bb\u001d\u0011\u00119La0\u0011\u0007\te\u0006+\u0004\u0002\u0003<*\u0019!Q\u0018'\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\t\rU\u0001\u0007!J,G-\u001a4\n\t\t\u0015'q\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\u0005\u0007+A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!!q\u0007Bg\u0011\u0019\u0011ym\u000ea\u0001E\u0006Ia.Z<D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u00038\tU'\u0011\u001c\u0005\u0007\u0005/D\u0004\u0019\u00012\u0002\u0013=dGmQ8oM&<\u0007B\u0002Bhq\u0001\u0007!-A\bd_:tWm\u0019;j_:\u001cu.\u001e8u)\u0011\t)Ia8\t\u000f\t\u0005\u0018\b1\u0001\u0003d\u00069\u0011\r\u001a3sKN\u001c\b\u0003\u0002Bs\u0005Wl!Aa:\u000b\t\t%\u0018qO\u0001\u0004]\u0016$\u0018\u0002\u0002Bw\u0005O\u00141\"\u00138fi\u0006#GM]3tg\u0006\tB-\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:\u0015\t\tM(\u0011 \t\u0006\u001f\nU\u0018\u0011^\u0005\u0004\u0005o\u0004&AB(qi&|g\u000eC\u0004\u0003\u0016j\u0002\rAa-\u0002\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0011\u0007\u0005-Ch\u0005\u0002=\u001dR\u0011!Q`\u0001\r\u001b\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0007\u000f\u0001B!!\u001d\u0004\n%!!QYA:\u00035iU\r\u001e:jGN<%o\\;qA\u0005)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002;1K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\fa\u0004T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u0017\rdwn]3T_\u000e\\W\r\u001e\u000b\u0005\u0005o\u0019I\u0002C\u0004\u0004\u001c\u0011\u0003\ra!\b\u0002\u000f\rD\u0017M\u001c8fYB!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012\u0001C2iC:tW\r\\:\u000b\t\r\u001d\u0012qO\u0001\u0004]&|\u0017\u0002BB\u0016\u0007C\u0011QbU8dW\u0016$8\t[1o]\u0016d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u00042)\"\u0011QDB\u001aW\t\u0019)\u0004\u0005\u0003\u00048\r\u0005SBAB\u001d\u0015\u0011\u0019Yd!\u0010\u0002\u0013Ut7\r[3dW\u0016$'bAB !\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\r3\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0004J)\"\u0011QFB\u001a\u0001")
public class SocketServer
implements Logging,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final ServerSocketFactory socketFactory;
    private final Seq<ConnectionDisconnectListener> connectionDisconnectListeners;
    private final KafkaMetricsGroup metricsGroup;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private final CompletableFuture<Void> allAuthorizerFuturesComplete;
    private boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Seq<ConnectionDisconnectListener> $lessinit$greater$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static ServerSocketFactory $lessinit$greater$default$6() {
        return ServerSocketFactory.INSTANCE;
    }

    public static void closeSocket(SocketChannel channel) {
        SocketServer$.MODULE$.closeSocket(channel);
    }

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public ServerSocketFactory socketFactory() {
        return this.socketFactory;
    }

    public Seq<ConnectionDisconnectListener> connectionDisconnectListeners() {
        return this.connectionDisconnectListeners;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private CompletableFuture<Void> allAuthorizerFuturesComplete() {
        return this.allAuthorizerFuturesComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public synchronized CompletableFuture<Void> enableRequestProcessing(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        if (this.stopped()) {
            throw new RuntimeException("Can't enable request processing: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Enabling request processing.");
        this.dataPlaneAcceptors().values().forEach(acceptor -> this.chainAcceptorFuture$1((Acceptor)acceptor, (Map)authorizerFutures));
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), this.allAuthorizerFuturesComplete());
        CompletableFuture<Void> enableFuture = new CompletableFuture<Void>();
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.CollectionHasAsScala(this.dataPlaneAcceptors().values()).asScala().toArray(ClassTag$.MODULE$.apply(DataPlaneAcceptor.class))), (Function1 & Serializable)x$2 -> x$2.startedFuture(), ClassTag$.MODULE$.apply(CompletableFuture.class))), enableFuture);
        return enableFuture;
    }

    private synchronized void createDataPlaneAcceptorAndProcessors(EndPoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new data plane acceptor and processors: SocketServer is stopped.");
        }
        java.util.Map<String, Object> parsedConfigs = this.config().valuesFromThisConfigWithPrefixOverride(endpoint.listenerName().configPrefix());
        this.connectionQuotas().addListener(this.config(), endpoint.listenerName());
        ListenerName listenerName = this.config().interBrokerListenerName();
        ListenerName listenerName2 = endpoint.listenerName();
        boolean isPrivilegedListener = !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
        DataPlaneAcceptor dataPlaneAcceptor = this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, this.dataPlaneRequestChannel());
        this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Created data-plane acceptor and processors for endpoint : " + endpoint.listenerName());
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((IterableOnceOps)this.config().listeners().map((Function1 & Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(EndPoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public synchronized void stopProcessingRequests() {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping socket server request processors");
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.beginShutdown();
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped socket server request processors");
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down socket server");
        this.allAuthorizerFuturesComplete().completeExceptionally(new TimeoutException("The socket server was shut down before the Authorizer could be completely initialized."));
        synchronized (this) {
            this.stopProcessingRequests();
            this.dataPlaneRequestChannel().shutdown();
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                throw new KafkaException("Could not find listenerName : " + listenerName + " in data-plane.");
            }
            n = acceptor.localPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        if (this.stopped()) {
            throw new RuntimeException("can't add new listeners: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Adding data-plane listeners for endpoints " + listenersAdded);
        listenersAdded.foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors((EndPoint)endpoint);
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(endpoint);
            return this.allAuthorizerFuturesComplete().whenComplete((x$5, e) -> {
                if (e != null) {
                    acceptor.startedFuture().completeExceptionally((Throwable)e);
                    return;
                }
                acceptor.start();
            });
        });
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Removing data-plane listeners for endpoints " + listenersRemoved);
        listenersRemoved.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIp: " + maxConnectionsPerIp);
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIpOverrides: " + ((IterableOnceOps)maxConnectionsPerIpOverrides.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    int v = x0$1._2$mcI$sp();
                    return k + "=" + v;
                }
                throw new MatchError(null);
            })).mkString(","));
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnections: " + maxConnections);
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnectionCreationRate: " + maxConnectionRate);
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
            return;
        }
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$new$6(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$4(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$6(m))));
    }

    public static final /* synthetic */ double $anonfun$new$1(SocketServer $this) {
        synchronized ($this) {
            Iterable dataPlaneProcessors = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors());
            Iterable ioWaitRatioMetricNames = (Iterable)dataPlaneProcessors.map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "io-wait-ratio";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            });
            double d = dataPlaneProcessors.isEmpty() ? 1.0 : BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ioWaitRatioMetricNames.map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$4($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors.size();
            return d;
        }
    }

    public static final /* synthetic */ long $anonfun$new$7(SocketServer $this) {
        return $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ long $anonfun$new$8(SocketServer $this) {
        return $this.memoryPool().size() - $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$new$14(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$12(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$14(m))));
    }

    public static final /* synthetic */ double $anonfun$new$9(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((Iterable)((Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors())).map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "expired-connections-killed-count";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            })).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$12($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            return d;
        }
    }

    public static final /* synthetic */ boolean $anonfun$enableRequestProcessing$1(Acceptor acceptor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Endpoint endpoint = (Endpoint)x0$1._1();
            return acceptor$1.endPoint().listenerName().value().equals(endpoint.listenerName().get());
        }
        throw new MatchError(null);
    }

    private final void chainAcceptorFuture$1(Acceptor acceptor, Map authorizerFutures$1) {
        Tuple2 tuple2;
        CompletableFuture completableFuture;
        Option option = authorizerFutures$1.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$enableRequestProcessing$1(acceptor, x0$1)));
        if (None$.MODULE$.equals(option)) {
            completableFuture = this.allAuthorizerFuturesComplete();
        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            completableFuture = (CompletableFuture)tuple2._2();
        } else {
            throw new MatchError((Object)option);
        }
        completableFuture.whenComplete((x$1, e) -> {
            if (e != null) {
                acceptor.startedFuture().completeExceptionally((Throwable)e);
                return;
            }
            acceptor.start();
        });
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(SocketServer $this, DataPlaneAcceptor acceptor) {
        acceptor.beginShutdown();
        acceptor.close();
        $this.config().removeReconfigurable((Reconfigurable)acceptor);
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), endpoint.listenerName());
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().remove((Object)endpoint).foreach((Function1 & Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3($this, acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block5: {
            block8: {
                DataPlaneAcceptor acceptor;
                block7: {
                    String string;
                    block6: {
                        if (x0$1 == null) break block5;
                        EndPoint endPoint = (EndPoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listenerName().value();
                        if (string != null) break block6;
                        if (listenerName$1 != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!string.equals(listenerName$1)) break block8;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager, ServerSocketFactory socketFactory, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        void add_stat;
        void sensor_name;
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        this.socketFactory = socketFactory;
        this.connectionDisconnectListeners = connectionDisconnectListeners;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext("[SocketServer listenerType=" + apiVersionManager.listenerType() + ", nodeId=" + this.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        String string = "MemoryPoolUtilization";
        if (metrics == null) {
            throw null;
        }
        Sensor.RecordingLevel sensor_recordingLevel = Sensor.RecordingLevel.INFO;
        Object var10_9 = null;
        string = null;
        this.memoryPoolSensor = metrics.sensor((String)sensor_name, null, sensor_recordingLevel, (Sensor[])null);
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        Sensor sensor = this.memoryPoolSensor();
        Meter meter = new Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName());
        if (sensor == null) {
            throw null;
        }
        sensor.add((CompoundStat)add_stat, null);
        meter = null;
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), DataPlaneAcceptor$.MODULE$.MetricPrefix(), time, apiVersionManager.newRequestMetrics());
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.allAuthorizerFuturesComplete = new CompletableFuture();
        this.stopped = false;
        this.metricsGroup().newGauge(DataPlaneAcceptor$.MODULE$.MetricPrefix() + "NetworkProcessorAvgIdlePercent", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$1(this)));
        this.metricsGroup().newGauge("MemoryPoolAvailable", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$7(this)));
        this.metricsGroup().newGauge("MemoryPoolUsed", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$8(this)));
        this.metricsGroup().newGauge(DataPlaneAcceptor$.MODULE$.MetricPrefix() + "ExpiredConnectionsKilledCount", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$9(this)));
        if (apiVersionManager.listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER)) {
            config.controllerListeners().foreach((Function1 & Serializable)endpoint -> {
                this.createDataPlaneAcceptorAndProcessors(endpoint);
                return BoxedUnit.UNIT;
            });
            return;
        }
        config.dataPlaneListeners().foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors(endpoint);
            return BoxedUnit.UNIT;
        });
    }
}

