/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Optional;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class SeekUnvalidatedEvent
extends CompletableApplicationEvent<Void> {
    private final TopicPartition partition;
    private final long offset;
    private final Optional<Integer> offsetEpoch;

    public SeekUnvalidatedEvent(long deadlineMs, TopicPartition partition, long offset, Optional<Integer> offsetEpoch) {
        super(ApplicationEvent.Type.SEEK_UNVALIDATED, deadlineMs);
        this.partition = partition;
        this.offset = offset;
        this.offsetEpoch = offsetEpoch;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> offsetEpoch() {
        return this.offsetEpoch;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", partition=" + String.valueOf(this.partition) + ", offset=" + this.offset + this.offsetEpoch.map(integer -> ", offsetEpoch=" + integer).orElse("");
    }
}

