/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.UniformHeterogeneousAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.UniformHomogeneousAssignmentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformAssignor
implements ConsumerGroupPartitionAssignor {
    private static final Logger LOG = LoggerFactory.getLogger(UniformAssignor.class);
    public static final String NAME = "uniform";

    public String name() {
        return NAME;
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (groupSpec.memberIds().isEmpty()) {
            return new GroupAssignment(Collections.emptyMap());
        }
        if (groupSpec.subscriptionType().equals((Object)SubscriptionType.HOMOGENEOUS)) {
            LOG.debug("Detected that all members are subscribed to the same set of topics, invoking the homogeneous assignment algorithm");
            return new UniformHomogeneousAssignmentBuilder(groupSpec, subscribedTopicDescriber).build();
        }
        LOG.debug("Detected that the members are subscribed to different sets of topics, invoking the heterogeneous assignment algorithm");
        return new UniformHeterogeneousAssignmentBuilder(groupSpec, subscribedTopicDescriber).build();
    }
}

