/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.ThreadMetadata;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.internals.metrics.ClientMetrics;
import org.apache.kafka.streams.internals.metrics.StreamsThreadMetricsDelegatingReporter;
import org.apache.kafka.streams.processor.StandbyUpdateListener;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.ActiveTaskCreator;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.DefaultStateUpdater;
import org.apache.kafka.streams.processor.internals.ProcessingThread;
import org.apache.kafka.streams.processor.internals.StandbyTaskCreator;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateUpdater;
import org.apache.kafka.streams.processor.internals.StoreChangelogReader;
import org.apache.kafka.streams.processor.internals.StreamThreadTotalBlockedTime;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.StreamsRebalanceListener;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.TaskMetadataImpl;
import org.apache.kafka.streams.processor.internals.Tasks;
import org.apache.kafka.streams.processor.internals.ThreadMetadataImpl;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignorError;
import org.apache.kafka.streams.processor.internals.assignment.ReferenceContainer;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.processor.internals.tasks.DefaultTaskManager;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;

public class StreamThread
extends Thread
implements ProcessingThread {
    private static final String THREAD_ID_SUBSTRING = "-StreamThread-";
    private static final String STATE_UPDATER_ID_SUBSTRING = "-StateUpdater-";
    private final Time time;
    private final Logger log;
    private final String logPrefix;
    public final Object stateLock;
    private final Duration pollTime;
    private final long commitTimeMs;
    private final long purgeTimeMs;
    private final int maxPollTimeMs;
    private final String originalReset;
    private final TaskManager taskManager;
    private final StateUpdater stateUpdater;
    private final StreamsMetricsImpl streamsMetrics;
    private final Sensor commitSensor;
    private final Sensor pollSensor;
    private final Sensor pollRecordsSensor;
    private final Sensor punctuateSensor;
    private final Sensor processRecordsSensor;
    private final Sensor processLatencySensor;
    private final Sensor processRateSensor;
    private final Sensor pollRatioSensor;
    private final Sensor processRatioSensor;
    private final Sensor punctuateRatioSensor;
    private final Sensor commitRatioSensor;
    private final Sensor failedStreamThreadSensor;
    private final long logSummaryIntervalMs;
    private long lastLogSummaryMs = -1L;
    private long totalRecordsProcessedSinceLastSummary = 0L;
    private long totalPunctuatorsSinceLastSummary = 0L;
    private long totalPolledSinceLastSummary = 0L;
    private long totalCommittedSinceLastSummary = 0L;
    private long now;
    private long lastPollMs;
    private long lastCommitMs;
    private long lastPurgeMs;
    private long lastPartitionAssignedMs = -1L;
    private int numIterations;
    private volatile State state = State.CREATED;
    private volatile ThreadMetadata threadMetadata;
    private StateListener stateListener;
    private final Optional<String> groupInstanceID;
    private final ChangelogReader changelogReader;
    private final ConsumerRebalanceListener rebalanceListener;
    private final Consumer<byte[], byte[]> mainConsumer;
    private final Consumer<byte[], byte[]> restoreConsumer;
    private final Admin adminClient;
    private final TopologyMetadata topologyMetadata;
    private final java.util.function.Consumer<Long> cacheResizer;
    private BiConsumer<Throwable, Boolean> streamsUncaughtExceptionHandler;
    private final Runnable shutdownErrorHook;
    private final AtomicInteger assignmentErrorCode;
    private final AtomicLong nextProbingRebalanceMs;
    private final Queue<StreamsException> nonFatalExceptionsToHandle;
    private final AtomicLong cacheResizeSize = new AtomicLong(-1L);
    private final AtomicBoolean leaveGroupRequested = new AtomicBoolean(false);
    private final AtomicLong lastShutdownWarningTimestamp = new AtomicLong(0L);
    private final boolean eosEnabled;
    private final boolean stateUpdaterEnabled;
    private final boolean processingThreadsEnabled;
    private volatile long fetchDeadlineClientInstanceId = -1L;
    private volatile KafkaFutureImpl<Uuid> mainConsumerInstanceIdFuture = new KafkaFutureImpl();
    private volatile KafkaFutureImpl<Uuid> restoreConsumerInstanceIdFuture = new KafkaFutureImpl();
    private volatile KafkaFutureImpl<Uuid> producerInstanceIdFuture = new KafkaFutureImpl();

    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    public StateListener getStateListener() {
        return this.stateListener;
    }

    public State state() {
        return this.state;
    }

    void setPartitionAssignedTime(long lastPartitionAssignedMs) {
        this.lastPartitionAssignedMs = lastPartitionAssignedMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State setState(State newState) {
        State oldState;
        Object object = this.stateLock;
        synchronized (object) {
            oldState = this.state;
            if (this.state == State.PENDING_SHUTDOWN && newState != State.DEAD) {
                this.log.debug("Ignoring request to transit from PENDING_SHUTDOWN to {}: only DEAD state is a valid next state", (Object)newState);
                return null;
            }
            if (this.state == State.DEAD) {
                this.log.debug("Ignoring request to transit from DEAD to {}: no valid next state after DEAD", (Object)newState);
                return null;
            }
            if (!this.state.isValidTransition(newState)) {
                this.log.error("Unexpected state transition from {} to {}", (Object)oldState, (Object)newState);
                throw new StreamsException(this.logPrefix + "Unexpected state transition from " + String.valueOf(oldState) + " to " + String.valueOf(newState));
            }
            this.log.info("State transition from {} to {}", (Object)oldState, (Object)newState);
            this.state = newState;
            if (newState == State.RUNNING) {
                this.updateThreadMetadata(this.taskManager.activeTaskMap(), this.taskManager.standbyTaskMap());
            }
            this.stateLock.notifyAll();
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(this, this.state, oldState);
        }
        return oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStartingRunningOrPartitionAssigned() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.equals(State.RUNNING) || this.state.equals(State.STARTING) || this.state.equals(State.PARTITIONS_ASSIGNED);
        }
    }

    public static StreamThread create(TopologyMetadata topologyMetadata, StreamsConfig config, KafkaClientSupplier clientSupplier, Admin adminClient, UUID processId, String clientId, StreamsMetricsImpl streamsMetrics, Time time, StreamsMetadataState streamsMetadataState, long cacheSizeBytes, StateDirectory stateDirectory, StateRestoreListener userStateRestoreListener, StandbyUpdateListener userStandbyUpdateListener, int threadIdx, Runnable shutdownErrorHook, BiConsumer<Throwable, Boolean> streamsUncaughtExceptionHandler) {
        TaskManager taskManager;
        boolean stateUpdaterEnabled = StreamsConfig.InternalConfig.stateUpdaterEnabled(config.originals());
        String threadId = clientId + THREAD_ID_SUBSTRING + threadIdx;
        String stateUpdaterId = threadId.replace(THREAD_ID_SUBSTRING, STATE_UPDATER_ID_SUBSTRING);
        Object restorationThreadId = stateUpdaterEnabled ? stateUpdaterId : threadId;
        String logPrefix = String.format("stream-thread [%s] ", threadId);
        LogContext logContext = new LogContext(logPrefix);
        LogContext restorationLogContext = stateUpdaterEnabled ? new LogContext(String.format("state-updater [%s] ", restorationThreadId)) : logContext;
        Logger log = logContext.logger(StreamThread.class);
        ReferenceContainer referenceContainer = new ReferenceContainer();
        referenceContainer.adminClient = adminClient;
        referenceContainer.streamsMetadataState = streamsMetadataState;
        referenceContainer.time = time;
        referenceContainer.clientTags = config.getClientTags();
        log.info("Creating restore consumer client");
        Map<String, Object> restoreConsumerConfigs = config.getRestoreConsumerConfigs(ClientUtils.restoreConsumerClientId((String)restorationThreadId));
        Consumer<byte[], byte[]> restoreConsumer = clientSupplier.getRestoreConsumer(restoreConsumerConfigs);
        StoreChangelogReader changelogReader = new StoreChangelogReader(time, config, restorationLogContext, adminClient, restoreConsumer, userStateRestoreListener, userStandbyUpdateListener);
        ThreadCache cache = new ThreadCache(logContext, cacheSizeBytes, streamsMetrics);
        boolean proceessingThreadsEnabled = StreamsConfig.InternalConfig.processingThreadsEnabled(config.originals());
        ActiveTaskCreator activeTaskCreator = new ActiveTaskCreator(topologyMetadata, config, streamsMetrics, stateDirectory, changelogReader, cache, time, clientSupplier, threadId, threadIdx, processId, log, stateUpdaterEnabled, proceessingThreadsEnabled);
        StandbyTaskCreator standbyTaskCreator = new StandbyTaskCreator(topologyMetadata, config, streamsMetrics, stateDirectory, changelogReader, threadId, log, stateUpdaterEnabled);
        Tasks tasks = new Tasks(new LogContext(logPrefix));
        boolean processingThreadsEnabled = StreamsConfig.InternalConfig.processingThreadsEnabled(config.originals());
        DefaultTaskManager schedulingTaskManager = StreamThread.maybeCreateSchedulingTaskManager(processingThreadsEnabled, stateUpdaterEnabled, topologyMetadata, time, threadId, tasks);
        StateUpdater stateUpdater = StreamThread.maybeCreateAndStartStateUpdater(stateUpdaterEnabled, streamsMetrics, config, restoreConsumer, changelogReader, topologyMetadata, time, clientId, threadIdx);
        referenceContainer.taskManager = taskManager = new TaskManager(time, changelogReader, new ProcessId(processId), logPrefix, activeTaskCreator, standbyTaskCreator, tasks, topologyMetadata, adminClient, stateDirectory, stateUpdater, schedulingTaskManager);
        log.info("Creating consumer client");
        String applicationId = config.getString("application.id");
        Map<String, Object> consumerConfigs = config.getMainConsumerConfigs(applicationId, ClientUtils.consumerClientId(threadId), threadIdx);
        consumerConfigs.put("__reference.container.instance__", referenceContainer);
        String originalReset = (String)consumerConfigs.get("auto.offset.reset");
        if (topologyMetadata.hasOffsetResetOverrides()) {
            consumerConfigs.put("auto.offset.reset", "none");
        }
        Consumer<byte[], byte[]> mainConsumer = clientSupplier.getConsumer(consumerConfigs);
        taskManager.setMainConsumer(mainConsumer);
        referenceContainer.mainConsumer = mainConsumer;
        StreamsThreadMetricsDelegatingReporter reporter = new StreamsThreadMetricsDelegatingReporter(mainConsumer, threadId, stateUpdaterId);
        streamsMetrics.metricsRegistry().addReporter((MetricsReporter)reporter);
        StreamThread streamThread = new StreamThread(time, config, adminClient, mainConsumer, restoreConsumer, changelogReader, originalReset, taskManager, stateUpdater, streamsMetrics, topologyMetadata, processId, threadId, logContext, referenceContainer.assignmentErrorCode, referenceContainer.nextScheduledRebalanceMs, referenceContainer.nonFatalExceptionsToHandle, shutdownErrorHook, streamsUncaughtExceptionHandler, cache::resize);
        return streamThread.updateThreadMetadata(ClientUtils.adminClientId(clientId));
    }

    private static DefaultTaskManager maybeCreateSchedulingTaskManager(boolean processingThreadsEnabled, boolean stateUpdaterEnabled, TopologyMetadata topologyMetadata, Time time, String threadId, Tasks tasks) {
        if (processingThreadsEnabled) {
            if (!stateUpdaterEnabled) {
                throw new IllegalStateException("Processing threads require the state updater to be enabled");
            }
            DefaultTaskManager defaultTaskManager = new DefaultTaskManager(time, threadId, tasks, new DefaultTaskManager.DefaultTaskExecutorCreator(), topologyMetadata.taskExecutionMetadata(), 1);
            defaultTaskManager.startTaskExecutors();
            return defaultTaskManager;
        }
        return null;
    }

    private static StateUpdater maybeCreateAndStartStateUpdater(boolean stateUpdaterEnabled, StreamsMetricsImpl streamsMetrics, StreamsConfig streamsConfig, Consumer<byte[], byte[]> restoreConsumer, ChangelogReader changelogReader, TopologyMetadata topologyMetadata, Time time, String clientId, int threadIdx) {
        if (stateUpdaterEnabled) {
            String name = clientId + STATE_UPDATER_ID_SUBSTRING + threadIdx;
            DefaultStateUpdater stateUpdater = new DefaultStateUpdater(name, streamsMetrics, streamsConfig, restoreConsumer, changelogReader, topologyMetadata, time);
            stateUpdater.start();
            return stateUpdater;
        }
        return null;
    }

    public StreamThread(Time time, StreamsConfig config, Admin adminClient, Consumer<byte[], byte[]> mainConsumer, Consumer<byte[], byte[]> restoreConsumer, ChangelogReader changelogReader, String originalReset, TaskManager taskManager, StateUpdater stateUpdater, StreamsMetricsImpl streamsMetrics, TopologyMetadata topologyMetadata, UUID processId, String threadId, LogContext logContext, AtomicInteger assignmentErrorCode, AtomicLong nextProbingRebalanceMs, Queue<StreamsException> nonFatalExceptionsToHandle, Runnable shutdownErrorHook, BiConsumer<Throwable, Boolean> streamsUncaughtExceptionHandler, java.util.function.Consumer<Long> cacheResizer) {
        super(threadId);
        this.stateLock = new Object();
        this.adminClient = adminClient;
        this.streamsMetrics = streamsMetrics;
        this.commitSensor = ThreadMetrics.commitSensor(threadId, streamsMetrics);
        this.pollSensor = ThreadMetrics.pollSensor(threadId, streamsMetrics);
        this.pollRecordsSensor = ThreadMetrics.pollRecordsSensor(threadId, streamsMetrics);
        this.pollRatioSensor = ThreadMetrics.pollRatioSensor(threadId, streamsMetrics);
        this.processLatencySensor = ThreadMetrics.processLatencySensor(threadId, streamsMetrics);
        this.processRecordsSensor = ThreadMetrics.processRecordsSensor(threadId, streamsMetrics);
        this.processRateSensor = ThreadMetrics.processRateSensor(threadId, streamsMetrics);
        this.processRatioSensor = ThreadMetrics.processRatioSensor(threadId, streamsMetrics);
        this.punctuateSensor = ThreadMetrics.punctuateSensor(threadId, streamsMetrics);
        this.punctuateRatioSensor = ThreadMetrics.punctuateRatioSensor(threadId, streamsMetrics);
        this.commitRatioSensor = ThreadMetrics.commitRatioSensor(threadId, streamsMetrics);
        this.failedStreamThreadSensor = ClientMetrics.failedStreamThreadSensor(streamsMetrics);
        this.assignmentErrorCode = assignmentErrorCode;
        this.shutdownErrorHook = shutdownErrorHook;
        this.streamsUncaughtExceptionHandler = streamsUncaughtExceptionHandler;
        this.cacheResizer = cacheResizer;
        ThreadMetrics.createTaskSensor(threadId, streamsMetrics);
        ThreadMetrics.closeTaskSensor(threadId, streamsMetrics);
        ThreadMetrics.addThreadStartTimeMetric(threadId, streamsMetrics, time.milliseconds());
        ThreadMetrics.addThreadStateTelemetryMetric(processId.toString(), threadId, streamsMetrics, (Gauge<Integer>)((Gauge)(metricConfig, now) -> this.state().ordinal()));
        ThreadMetrics.addThreadStateMetric(threadId, streamsMetrics, (Gauge<String>)((Gauge)(metricConfig, now) -> this.state().name()));
        ThreadMetrics.addThreadBlockedTimeMetric(threadId, new StreamThreadTotalBlockedTime(mainConsumer, restoreConsumer, taskManager::totalProducerBlockedTime), streamsMetrics);
        this.time = time;
        this.topologyMetadata = topologyMetadata;
        this.topologyMetadata.registerThread(this.getName());
        this.logPrefix = logContext.logPrefix();
        this.log = logContext.logger(StreamThread.class);
        this.rebalanceListener = new StreamsRebalanceListener(time, taskManager, this, this.log, this.assignmentErrorCode);
        this.taskManager = taskManager;
        this.stateUpdater = stateUpdater;
        this.restoreConsumer = restoreConsumer;
        this.mainConsumer = mainConsumer;
        this.changelogReader = changelogReader;
        this.originalReset = originalReset;
        this.nextProbingRebalanceMs = nextProbingRebalanceMs;
        this.nonFatalExceptionsToHandle = nonFatalExceptionsToHandle;
        this.groupInstanceID = mainConsumer.groupMetadata().groupInstanceId();
        this.pollTime = Duration.ofMillis(config.getLong("poll.ms"));
        boolean dummyThreadIdx = true;
        this.maxPollTimeMs = new InternalConsumerConfig(config.getMainConsumerConfigs("dummyGroupId", "dummyClientId", 1)).getInt("max.poll.interval.ms");
        this.commitTimeMs = config.getLong("commit.interval.ms");
        this.purgeTimeMs = config.getLong("repartition.purge.interval.ms");
        this.numIterations = 1;
        this.eosEnabled = StreamsConfigUtils.eosEnabled(config);
        this.stateUpdaterEnabled = StreamsConfig.InternalConfig.stateUpdaterEnabled(config.originals());
        this.processingThreadsEnabled = StreamsConfig.InternalConfig.processingThreadsEnabled(config.originals());
        this.logSummaryIntervalMs = config.getLong("log.summary.interval.ms");
    }

    @Override
    public void run() {
        this.log.info("Starting");
        if (this.setState(State.STARTING) == null) {
            this.log.info("StreamThread already shutdown. Not running");
            return;
        }
        boolean cleanRun = false;
        try {
            cleanRun = this.runLoop();
        }
        catch (Throwable e) {
            this.failedStreamThreadSensor.record();
            this.requestLeaveGroupDuringShutdown();
            this.streamsUncaughtExceptionHandler.accept(e, false);
        }
        finally {
            this.completeShutdown(cleanRun);
        }
    }

    boolean runLoop() {
        this.subscribeConsumer();
        while (this.isRunning() || this.taskManager.rebalanceInProgress()) {
            try {
                this.checkForTopologyUpdates();
                if (!this.isRunning() && this.topologyMetadata.isEmpty()) {
                    this.log.info("Shutting down thread with empty topology.");
                    break;
                }
                this.maybeSendShutdown();
                long size = this.cacheResizeSize.getAndSet(-1L);
                if (size != -1L) {
                    this.cacheResizer.accept(size);
                }
                if (this.processingThreadsEnabled) {
                    this.runOnceWithProcessingThreads();
                } else {
                    this.runOnceWithoutProcessingThreads();
                }
                this.maybeGetClientInstanceIds();
                if (this.taskManager.rebalanceInProgress() || this.nextProbingRebalanceMs.get() >= this.time.milliseconds()) continue;
                this.log.info("Triggering the followup rebalance scheduled for {}.", (Object)Utils.toLogDateTimeFormat((long)this.nextProbingRebalanceMs.get()));
                this.mainConsumer.enforceRebalance("triggered followup rebalance scheduled for " + this.nextProbingRebalanceMs.get());
                this.nextProbingRebalanceMs.set(Long.MAX_VALUE);
            }
            catch (TaskCorruptedException e) {
                this.log.warn("Detected the states of tasks " + String.valueOf(e.corruptedTasks()) + " are corrupted. Will close the task as dirty and re-create and bootstrap from scratch.", (Throwable)((Object)e));
                try {
                    boolean enforceRebalance = this.taskManager.handleCorruption(e.corruptedTasks());
                    if (!enforceRebalance || !this.eosEnabled) continue;
                    this.log.info("Active task(s) got corrupted. Triggering a rebalance.");
                    this.mainConsumer.enforceRebalance("Active tasks corrupted");
                }
                catch (TaskMigratedException taskMigrated) {
                    this.handleTaskMigrated(taskMigrated);
                }
            }
            catch (TaskMigratedException e) {
                this.handleTaskMigrated(e);
            }
            catch (UnsupportedVersionException e) {
                String errorMessage = e.getMessage();
                if (errorMessage != null && errorMessage.startsWith("Broker unexpectedly doesn't support requireStable flag on version ")) {
                    this.log.error("Shutting down because the Kafka cluster seems to be on a too old version. Setting {}=\"{}\" requires broker version 2.5 or higher.", (Object)"processing.guarantee", (Object)"exactly_once_v2");
                }
                this.failedStreamThreadSensor.record();
                this.streamsUncaughtExceptionHandler.accept((Throwable)((Object)new StreamsException(e)), false);
                return false;
            }
            catch (StreamsException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StreamsException(e);
            }
        }
        return true;
    }

    void maybeGetClientInstanceIds() {
        if (this.fetchDeadlineClientInstanceId != -1L) {
            if (!this.mainConsumerInstanceIdFuture.isDone()) {
                if (this.fetchDeadlineClientInstanceId >= this.time.milliseconds()) {
                    try {
                        this.mainConsumerInstanceIdFuture.complete((Object)this.mainConsumer.clientInstanceId(Duration.ZERO));
                    }
                    catch (IllegalStateException disabledError) {
                        this.mainConsumerInstanceIdFuture.complete(null);
                    }
                    catch (TimeoutException disabledError) {
                    }
                    catch (Exception error) {
                        this.mainConsumerInstanceIdFuture.completeExceptionally((Throwable)error);
                    }
                } else {
                    this.mainConsumerInstanceIdFuture.completeExceptionally((Throwable)new TimeoutException("Could not retrieve main consumer client instance id."));
                }
            }
            if (!this.stateUpdaterEnabled && !this.restoreConsumerInstanceIdFuture.isDone()) {
                if (this.fetchDeadlineClientInstanceId >= this.time.milliseconds()) {
                    try {
                        this.restoreConsumerInstanceIdFuture.complete((Object)this.restoreConsumer.clientInstanceId(Duration.ZERO));
                    }
                    catch (IllegalStateException disabledError) {
                        this.restoreConsumerInstanceIdFuture.complete(null);
                    }
                    catch (TimeoutException disabledError) {
                    }
                    catch (Exception error) {
                        this.restoreConsumerInstanceIdFuture.completeExceptionally((Throwable)error);
                    }
                } else {
                    this.restoreConsumerInstanceIdFuture.completeExceptionally((Throwable)new TimeoutException("Could not retrieve restore consumer client instance id."));
                }
            }
            if (!this.producerInstanceIdFuture.isDone()) {
                if (this.fetchDeadlineClientInstanceId >= this.time.milliseconds()) {
                    try {
                        this.producerInstanceIdFuture.complete((Object)this.taskManager.streamsProducer().kafkaProducer().clientInstanceId(Duration.ZERO));
                    }
                    catch (IllegalStateException disabledError) {
                        this.producerInstanceIdFuture.complete(null);
                    }
                    catch (TimeoutException disabledError) {
                    }
                    catch (Exception error) {
                        this.producerInstanceIdFuture.completeExceptionally((Throwable)error);
                    }
                } else {
                    this.producerInstanceIdFuture.completeExceptionally((Throwable)new TimeoutException("Could not retrieve thread producer client instance id."));
                }
            }
            if (this.mainConsumerInstanceIdFuture.isDone() && !this.stateUpdaterEnabled && this.restoreConsumerInstanceIdFuture.isDone() && this.producerInstanceIdFuture.isDone()) {
                this.fetchDeadlineClientInstanceId = -1L;
            }
        }
    }

    public void setStreamsUncaughtExceptionHandler(BiConsumer<Throwable, Boolean> streamsUncaughtExceptionHandler) {
        this.streamsUncaughtExceptionHandler = streamsUncaughtExceptionHandler;
    }

    public void maybeSendShutdown() {
        if (this.assignmentErrorCode.get() == AssignorError.SHUTDOWN_REQUESTED.code()) {
            long lastLogged;
            long now = this.time.milliseconds();
            if (now - (lastLogged = this.lastShutdownWarningTimestamp.get()) >= 10000L && this.lastShutdownWarningTimestamp.compareAndSet(lastLogged, now)) {
                this.log.warn("Detected that shutdown was requested. All clients in this app will now begin to shutdown");
            }
            this.mainConsumer.enforceRebalance("Shutdown requested");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitOnThreadState(State targetState, long timeoutMs) {
        long begin = this.time.milliseconds();
        Object object = this.stateLock;
        synchronized (object) {
            boolean interrupted = false;
            long elapsedMs = 0L;
            try {
                while (this.state != targetState) {
                    if (timeoutMs < elapsedMs) {
                        this.log.debug("Cannot transit to {} within {}ms", (Object)targetState, (Object)timeoutMs);
                        boolean bl = false;
                        return bl;
                    }
                    long remainingMs = timeoutMs - elapsedMs;
                    try {
                        this.stateLock.wait(remainingMs);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    elapsedMs = this.time.milliseconds() - begin;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void shutdownToError() {
        this.shutdownErrorHook.run();
    }

    public void sendShutdownRequest(AssignorError assignorError) {
        this.assignmentErrorCode.set(assignorError.code());
    }

    private void handleTaskMigrated(TaskMigratedException e) {
        this.log.warn("Detected that the thread is being fenced. This implies that this thread missed a rebalance and dropped out of the consumer group. Will close out all assigned tasks and rejoin the consumer group.", (Throwable)((Object)e));
        this.taskManager.handleLostAll();
        this.mainConsumer.unsubscribe();
        this.subscribeConsumer();
    }

    private void subscribeConsumer() {
        if (this.topologyMetadata.usesPatternSubscription()) {
            this.mainConsumer.subscribe(this.topologyMetadata.sourceTopicPattern(), this.rebalanceListener);
        } else {
            this.mainConsumer.subscribe(this.topologyMetadata.allFullSourceTopicNames(), this.rebalanceListener);
        }
    }

    public void resizeCache(long size) {
        this.cacheResizeSize.set(size);
    }

    void runOnceWithoutProcessingThreads() {
        long startMs;
        this.now = startMs = this.time.milliseconds();
        this.taskManager.resumePollingForPartitionsWithAvailableSpace();
        long pollLatency = this.pollPhase();
        ++this.totalPolledSinceLastSummary;
        if (!this.isRunning()) {
            this.log.debug("Thread state is already {}, skipping the run once call after poll request", (Object)this.state);
            return;
        }
        if (!this.stateUpdaterEnabled) {
            this.initializeAndRestorePhase();
        }
        this.advanceNowAndComputeLatency();
        int totalProcessed = 0;
        long totalCommitLatency = 0L;
        long totalProcessLatency = 0L;
        long totalPunctuateLatency = 0L;
        if (this.state == State.RUNNING || this.stateUpdaterEnabled && this.isStartingRunningOrPartitionAssigned()) {
            this.taskManager.updateLags();
            while (true) {
                if (this.stateUpdaterEnabled) {
                    this.checkStateUpdater();
                }
                this.log.debug("Processing tasks with {} iterations.", (Object)this.numIterations);
                int processed = this.taskManager.process(this.numIterations, this.time);
                long processLatency = this.advanceNowAndComputeLatency();
                totalProcessLatency += processLatency;
                if (processed > 0) {
                    this.processRateSensor.record((double)processed, this.now);
                    this.processLatencySensor.record((double)processLatency / (double)processed, this.now);
                    totalProcessed += processed;
                    this.totalRecordsProcessedSinceLastSummary += (long)processed;
                }
                this.log.debug("Processed {} records with {} iterations; invoking punctuators if necessary", (Object)processed, (Object)this.numIterations);
                int punctuated = this.taskManager.punctuate();
                this.totalPunctuatorsSinceLastSummary += (long)punctuated;
                long punctuateLatency = this.advanceNowAndComputeLatency();
                totalPunctuateLatency += punctuateLatency;
                if (punctuated > 0) {
                    this.punctuateSensor.record((double)punctuateLatency / (double)punctuated, this.now);
                }
                this.log.debug("{} punctuators ran.", (Object)punctuated);
                long beforeCommitMs = this.now;
                int committed = this.maybeCommit();
                long commitLatency = Math.max(this.now - beforeCommitMs, 0L);
                totalCommitLatency += commitLatency;
                if (committed > 0) {
                    this.totalCommittedSinceLastSummary += (long)committed;
                    this.commitSensor.record((double)commitLatency / (double)committed, this.now);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Committed all active tasks {} and standby tasks {} in {}ms", new Object[]{this.taskManager.activeRunningTaskIds(), this.taskManager.standbyTaskIds(), commitLatency});
                    }
                }
                if (processed == 0) break;
                if (Math.max(this.now - this.lastPollMs, 0L) > (long)(this.maxPollTimeMs / 2)) {
                    this.numIterations = this.numIterations > 1 ? this.numIterations / 2 : this.numIterations;
                    break;
                }
                if (punctuated > 0 || committed > 0) {
                    this.numIterations = this.numIterations > 1 ? this.numIterations / 2 : this.numIterations;
                    continue;
                }
                ++this.numIterations;
            }
            this.taskManager.recordTaskProcessRatio(totalProcessLatency, this.now);
        }
        this.now = this.time.milliseconds();
        long runOnceLatency = this.now - startMs;
        this.processRecordsSensor.record((double)totalProcessed, this.now);
        this.processRatioSensor.record((double)totalProcessLatency / (double)runOnceLatency, this.now);
        this.punctuateRatioSensor.record((double)totalPunctuateLatency / (double)runOnceLatency, this.now);
        this.pollRatioSensor.record((double)pollLatency / (double)runOnceLatency, this.now);
        this.commitRatioSensor.record((double)totalCommitLatency / (double)runOnceLatency, this.now);
        long timeSinceLastLog = this.now - this.lastLogSummaryMs;
        if (this.logSummaryIntervalMs > 0L && timeSinceLastLog > this.logSummaryIntervalMs) {
            this.log.info("Processed {} total records, ran {} punctuators, polled {} times and committed {} total tasks since the last update {}ms ago", new Object[]{this.totalRecordsProcessedSinceLastSummary, this.totalPunctuatorsSinceLastSummary, this.totalPolledSinceLastSummary, this.totalCommittedSinceLastSummary, timeSinceLastLog});
            this.totalRecordsProcessedSinceLastSummary = 0L;
            this.totalPunctuatorsSinceLastSummary = 0L;
            this.totalPolledSinceLastSummary = 0L;
            this.totalCommittedSinceLastSummary = 0L;
            this.lastLogSummaryMs = this.now;
        }
    }

    void runOnceWithProcessingThreads() {
        long startMs;
        this.now = startMs = this.time.milliseconds();
        this.taskManager.resumePollingForPartitionsWithAvailableSpace();
        long pollLatency = this.pollPhase();
        if (!this.isRunning()) {
            this.log.debug("Thread state is already {}, skipping the run once call after poll request", (Object)this.state);
            return;
        }
        long totalCommitLatency = 0L;
        if (this.isRunning()) {
            this.taskManager.updateLags();
            this.checkStateUpdater();
            this.taskManager.maybeThrowTaskExceptionsFromProcessingThreads();
            this.taskManager.signalTaskExecutors();
            long beforeCommitMs = this.now;
            int committed = this.maybeCommit();
            long commitLatency = Math.max(this.now - beforeCommitMs, 0L);
            totalCommitLatency += commitLatency;
            if (committed > 0) {
                this.totalCommittedSinceLastSummary += (long)committed;
                this.commitSensor.record((double)commitLatency / (double)committed, this.now);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Committed all active tasks {} and standby tasks {} in {}ms", new Object[]{this.taskManager.activeTaskIds(), this.taskManager.standbyTaskIds(), commitLatency});
                }
            }
        }
        this.now = this.time.milliseconds();
        long runOnceLatency = this.now - startMs;
        this.pollRatioSensor.record((double)pollLatency / (double)runOnceLatency, this.now);
        this.commitRatioSensor.record((double)totalCommitLatency / (double)runOnceLatency, this.now);
        if (this.logSummaryIntervalMs > 0L && this.now - this.lastLogSummaryMs > this.logSummaryIntervalMs) {
            this.log.info("Committed {} total tasks since the last update", (Object)this.totalCommittedSinceLastSummary);
            this.totalCommittedSinceLastSummary = 0L;
            this.lastLogSummaryMs = this.now;
        }
    }

    private void initializeAndRestorePhase() {
        java.util.function.Consumer<Set<TopicPartition>> offsetResetter = partitions -> this.resetOffsets((Set<TopicPartition>)partitions, null);
        State stateSnapshot = this.state;
        if (stateSnapshot == State.PARTITIONS_ASSIGNED || stateSnapshot == State.RUNNING && this.taskManager.needsInitializationOrRestoration()) {
            this.log.debug("State is {}; initializing tasks if necessary", (Object)stateSnapshot);
            if (this.taskManager.tryToCompleteRestoration(this.now, offsetResetter)) {
                this.log.info("Restoration took {} ms for all active tasks {}", (Object)(this.time.milliseconds() - this.lastPartitionAssignedMs), this.taskManager.activeTaskIds());
                this.setState(State.RUNNING);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialization call done. State is {}", (Object)this.state);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Idempotently invoking restoration logic in state {}", (Object)this.state);
        }
        this.changelogReader.restore(this.taskManager.notPausedTasks());
        this.log.debug("Idempotent restore call done. Thread state has not changed.");
    }

    private void checkStateUpdater() {
        java.util.function.Consumer<Set<TopicPartition>> offsetResetter = partitions -> this.resetOffsets((Set<TopicPartition>)partitions, null);
        State stateSnapshot = this.state;
        boolean allRunning = this.taskManager.checkStateUpdater(this.now, offsetResetter);
        if (allRunning && stateSnapshot == State.PARTITIONS_ASSIGNED) {
            this.setState(State.RUNNING);
        }
    }

    private void checkForTopologyUpdates() {
        if (this.topologyMetadata.isEmpty() || this.topologyMetadata.needsUpdate(this.getName())) {
            this.log.info("StreamThread has detected an update to the topology");
            this.taskManager.handleTopologyUpdates();
            this.topologyMetadata.maybeWaitForNonEmptyTopology(() -> this.state);
            this.log.info("Updating consumer subscription following topology update");
            this.subscribeConsumer();
        }
    }

    private long pollPhase() {
        ConsumerRecords<byte[], byte[]> records;
        this.log.debug("Invoking poll on main Consumer");
        if (this.state == State.PARTITIONS_ASSIGNED && !this.stateUpdaterEnabled) {
            records = this.pollRequests(Duration.ZERO);
        } else if (this.state == State.PARTITIONS_REVOKED) {
            records = this.pollRequests(Duration.ZERO);
        } else if (this.state == State.RUNNING || this.state == State.STARTING || this.state == State.PARTITIONS_ASSIGNED && this.stateUpdaterEnabled) {
            records = this.pollRequests(this.pollTime);
        } else if (this.state == State.PENDING_SHUTDOWN) {
            records = this.pollRequests(Duration.ZERO);
        } else {
            this.log.error("Unexpected state {} during normal iteration", (Object)this.state);
            throw new StreamsException(this.logPrefix + "Unexpected state " + String.valueOf(this.state) + " during normal iteration");
        }
        long pollLatency = this.advanceNowAndComputeLatency();
        int numRecords = records.count();
        for (TopicPartition topicPartition : records.partitions()) {
            records.records(topicPartition).stream().max(Comparator.comparing(ConsumerRecord::offset)).ifPresent(t -> this.taskManager.updateTaskEndMetadata(topicPartition, t.offset()));
        }
        this.log.debug("Main Consumer poll completed in {} ms and fetched {} records from partitions {}", new Object[]{pollLatency, numRecords, records.partitions()});
        this.pollSensor.record((double)pollLatency, this.now);
        if (!records.isEmpty()) {
            this.pollRecordsSensor.record((double)numRecords, this.now);
            this.taskManager.addRecordsToTasks(records);
        }
        if (!records.nextOffsets().isEmpty()) {
            this.taskManager.updateNextOffsets(records.nextOffsets());
        }
        while (!this.nonFatalExceptionsToHandle.isEmpty()) {
            this.streamsUncaughtExceptionHandler.accept((Throwable)((Object)this.nonFatalExceptionsToHandle.poll()), true);
        }
        return pollLatency;
    }

    private ConsumerRecords<byte[], byte[]> pollRequests(Duration pollTime) {
        ConsumerRecords records = ConsumerRecords.empty();
        this.lastPollMs = this.now;
        try {
            records = this.mainConsumer.poll(pollTime);
        }
        catch (InvalidOffsetException e) {
            this.resetOffsets(e.partitions(), (Exception)((Object)e));
        }
        return records;
    }

    private void resetOffsets(Set<TopicPartition> partitions, Exception cause) {
        HashSet<String> loggedTopics = new HashSet<String>();
        HashSet<TopicPartition> seekToBeginning = new HashSet<TopicPartition>();
        HashSet<TopicPartition> seekToEnd = new HashSet<TopicPartition>();
        HashMap<TopicPartition, Duration> seekByDuration = new HashMap<TopicPartition, Duration>();
        HashSet<TopicPartition> notReset = new HashSet<TopicPartition>();
        for (TopicPartition partition : partitions) {
            Object resetPolicy;
            Optional<AutoOffsetResetStrategy> offsetResetStrategy = this.topologyMetadata.offsetResetStrategy(partition.topic());
            if (offsetResetStrategy == null) continue;
            if (offsetResetStrategy.isPresent()) {
                resetPolicy = offsetResetStrategy.get();
                if (resetPolicy == AutoOffsetResetStrategy.NONE) {
                    notReset.add(partition);
                    continue;
                }
                if (resetPolicy == AutoOffsetResetStrategy.EARLIEST) {
                    this.addToResetList(partition, seekToBeginning, "Setting topic '{}' to consume from earliest offset", loggedTopics);
                    continue;
                }
                if (resetPolicy == AutoOffsetResetStrategy.LATEST) {
                    this.addToResetList(partition, seekToEnd, "Setting topic '{}' to consume from latest offset", loggedTopics);
                    continue;
                }
                if (resetPolicy.type() == AutoOffsetResetStrategy.StrategyType.BY_DURATION) {
                    this.addToResetList(partition, seekByDuration, (Duration)resetPolicy.duration().get(), "Setting topic '{}' to consume from by_duration:{}", ((Duration)resetPolicy.duration().get()).toString(), loggedTopics);
                    continue;
                }
                throw new IllegalStateException("Unknown reset policy " + String.valueOf(resetPolicy));
            }
            resetPolicy = AutoOffsetResetStrategy.fromString((String)this.originalReset);
            if (resetPolicy == AutoOffsetResetStrategy.NONE) {
                notReset.add(partition);
                continue;
            }
            if (resetPolicy == AutoOffsetResetStrategy.EARLIEST) {
                this.addToResetList(partition, seekToBeginning, "No custom setting defined for topic '{}' using original config 'earliest' for offset reset", loggedTopics);
                continue;
            }
            if (resetPolicy == AutoOffsetResetStrategy.LATEST) {
                this.addToResetList(partition, seekToEnd, "No custom setting defined for topic '{}' using original config 'latest' for offset reset", loggedTopics);
                continue;
            }
            if (resetPolicy.type() == AutoOffsetResetStrategy.StrategyType.BY_DURATION) {
                this.addToResetList(partition, seekByDuration, (Duration)resetPolicy.duration().get(), "No custom setting defined for topic '{}' using original config 'by_duration:{}' for offset reset", ((Duration)resetPolicy.duration().get()).toString(), loggedTopics);
                continue;
            }
            throw new IllegalStateException("Unknown reset policy " + String.valueOf(resetPolicy));
        }
        if (notReset.isEmpty()) {
            if (!seekToBeginning.isEmpty()) {
                this.mainConsumer.seekToBeginning(seekToBeginning);
            }
            if (!seekToEnd.isEmpty()) {
                this.mainConsumer.seekToEnd(seekToEnd);
            }
            if (!seekByDuration.isEmpty()) {
                long nowMs = this.time.milliseconds();
                Map seekToTimestamps = seekByDuration.entrySet().stream().map(e -> {
                    long seekMs = nowMs - ((Duration)e.getValue()).toMillis();
                    if (seekMs < 0L) {
                        this.log.debug("Cannot reset offset to negative timestamp {} for partition {}. Seeking to timestamp 0 instead.", (Object)seekMs, e.getKey());
                        seekMs = 0L;
                    }
                    return Map.entry((TopicPartition)e.getKey(), seekMs);
                }).collect(HashMap::new, (m, e) -> m.put((TopicPartition)e.getKey(), (Long)e.getValue()), Map::putAll);
                try {
                    for (Map.Entry entry : this.mainConsumer.offsetsForTimes(seekToTimestamps).entrySet()) {
                        TopicPartition partition = (TopicPartition)entry.getKey();
                        OffsetAndTimestamp seekOffset = (OffsetAndTimestamp)entry.getValue();
                        if (seekOffset != null) {
                            this.mainConsumer.seek(partition, new OffsetAndMetadata(seekOffset.offset()));
                            continue;
                        }
                        this.log.debug("Cannot reset offset to non-existing timestamp {} (larger than timestamp of last record) for partition {}. Seeking to end instead.", seekToTimestamps.get(partition), (Object)partition);
                        this.mainConsumer.seekToEnd(Collections.singleton((TopicPartition)entry.getKey()));
                    }
                }
                catch (TimeoutException timeoutException) {
                    this.taskManager.maybeInitTaskTimeoutsOrThrow(seekByDuration.keySet(), timeoutException, this.now);
                    this.log.debug(String.format("Could not reset offset for %s due to the following exception; will retry.", seekByDuration.keySet()), (Throwable)timeoutException);
                }
            }
        } else {
            String notResetString = notReset.stream().map(TopicPartition::topic).distinct().collect(Collectors.joining(","));
            String format = String.format("No valid committed offset found for input [%s] and no valid reset policy configured. You need to set configuration parameter \"auto.offset.reset\" or specify a topic specific reset policy via StreamsBuilder#stream(..., Consumed.with(Topology.AutoOffsetReset)) or StreamsBuilder#table(..., Consumed.with(Topology.AutoOffsetReset))", notResetString);
            if (cause == null) {
                throw new StreamsException(format);
            }
            throw new StreamsException(format, cause);
        }
    }

    private void addToResetList(TopicPartition partition, Set<TopicPartition> partitions, String resetPolicy, Set<String> loggedTopics) {
        String topic = partition.topic();
        if (loggedTopics.add(topic)) {
            this.log.info("Setting topic '{}' to consume from {} offset", (Object)topic, (Object)resetPolicy);
        }
        partitions.add(partition);
    }

    private void addToResetList(TopicPartition partition, Map<TopicPartition, Duration> durationForPartitions, Duration durationTime, String logMessage, String durationString, Set<String> loggedTopics) {
        String topic = partition.topic();
        if (loggedTopics.add(topic)) {
            this.log.info(logMessage, (Object)topic, (Object)durationString);
        }
        durationForPartitions.put(partition, durationTime);
    }

    public boolean isThreadAlive() {
        return this.isAlive();
    }

    public void signalResume() {
        this.taskManager.signalResume();
    }

    int maybeCommit() {
        int committed;
        if (this.now - this.lastCommitMs > this.commitTimeMs) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Committing all active tasks {} and standby tasks {} since {}ms has elapsed (commit interval is {}ms)", new Object[]{this.taskManager.activeRunningTaskIds(), this.taskManager.standbyTaskIds(), this.now - this.lastCommitMs, this.commitTimeMs});
            }
            committed = this.taskManager.commit(this.taskManager.allOwnedTasks().values().stream().filter(t -> t.state() == Task.State.RUNNING || t.state() == Task.State.RESTORING).collect(Collectors.toSet()));
            if (this.now - this.lastPurgeMs > this.purgeTimeMs) {
                this.taskManager.maybePurgeCommittedRecords();
                this.lastPurgeMs = this.now;
            }
            if (committed == -1) {
                this.log.debug("Unable to commit as we are in the middle of a rebalance, will try again when it completes.");
            } else {
                this.lastCommitMs = this.now = this.time.milliseconds();
            }
        } else {
            committed = this.taskManager.maybeCommitActiveTasksPerUserRequested();
        }
        return committed;
    }

    private long advanceNowAndComputeLatency() {
        long previous = this.now;
        this.now = this.time.milliseconds();
        return Math.max(this.now - previous, 0L);
    }

    public void shutdown() {
        this.log.info("Informed to shut down");
        State oldState = this.setState(State.PENDING_SHUTDOWN);
        if (oldState == State.CREATED) {
            this.completeShutdown(true);
        }
    }

    private void completeShutdown(boolean cleanRun) {
        this.setState(State.PENDING_SHUTDOWN);
        this.log.info("Shutting down {}", (Object)(cleanRun ? "clean" : "unclean"));
        this.mainConsumerInstanceIdFuture.complete(null);
        try {
            this.taskManager.shutdown(cleanRun);
        }
        catch (Throwable e) {
            this.log.error("Failed to close task manager due to the following error:", e);
        }
        try {
            this.topologyMetadata.unregisterThread(this.threadMetadata.threadName());
        }
        catch (Throwable e) {
            this.log.error("Failed to unregister thread due to the following error:", e);
        }
        try {
            this.changelogReader.clear();
        }
        catch (Throwable e) {
            this.log.error("Failed to close changelog reader due to the following error:", e);
        }
        try {
            if (this.leaveGroupRequested.get()) {
                this.mainConsumer.unsubscribe();
            }
        }
        catch (Throwable e) {
            this.log.error("Failed to unsubscribe due to the following error: ", e);
        }
        try {
            this.mainConsumer.close();
        }
        catch (Throwable e) {
            this.log.error("Failed to close consumer due to the following error:", e);
        }
        try {
            this.restoreConsumer.close();
        }
        catch (Throwable e) {
            this.log.error("Failed to close restore consumer due to the following error:", e);
        }
        this.streamsMetrics.removeAllThreadLevelSensors(this.getName());
        this.streamsMetrics.removeAllThreadLevelMetrics(this.getName());
        this.setState(State.DEAD);
        this.log.info("Shutdown complete");
    }

    public final ThreadMetadata threadMetadata() {
        return this.threadMetadata;
    }

    StreamThread updateThreadMetadata(String adminClientId) {
        this.threadMetadata = new ThreadMetadataImpl(this.getName(), this.state().name(), ClientUtils.consumerClientId(this.getName()), ClientUtils.restoreConsumerClientId(this.getName()), this.taskManager.producerClientIds(), adminClientId, Collections.emptySet(), Collections.emptySet());
        return this;
    }

    private void updateThreadMetadata(Map<TaskId, Task> activeTasks, Map<TaskId, Task> standbyTasks) {
        HashSet<TaskMetadata> activeTasksMetadata = new HashSet<TaskMetadata>();
        for (Map.Entry<TaskId, Task> entry : activeTasks.entrySet()) {
            activeTasksMetadata.add(new TaskMetadataImpl(entry.getValue().id(), entry.getValue().inputPartitions(), entry.getValue().committedOffsets(), entry.getValue().highWaterMark(), entry.getValue().timeCurrentIdlingStarted()));
        }
        HashSet<TaskMetadata> standbyTasksMetadata = new HashSet<TaskMetadata>();
        for (Map.Entry<TaskId, Task> entry : standbyTasks.entrySet()) {
            standbyTasksMetadata.add(new TaskMetadataImpl(entry.getValue().id(), entry.getValue().inputPartitions(), entry.getValue().committedOffsets(), entry.getValue().highWaterMark(), entry.getValue().timeCurrentIdlingStarted()));
        }
        String string = this.threadMetadata.adminClientId();
        this.threadMetadata = new ThreadMetadataImpl(this.getName(), this.state().name(), ClientUtils.consumerClientId(this.getName()), ClientUtils.restoreConsumerClientId(this.getName()), this.taskManager.producerClientIds(), string, activeTasksMetadata, standbyTasksMetadata);
    }

    public Set<Task> readOnlyActiveTasks() {
        return this.readyOnlyAllTasks().stream().filter(Task::isActive).collect(Collectors.toSet());
    }

    public Set<Task> readyOnlyAllTasks() {
        return this.taskManager.readOnlyAllTasks();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "\tStreamsThread threadId: " + this.getName() + "\n" + this.taskManager.toString(indent);
    }

    public Optional<String> groupInstanceID() {
        return this.groupInstanceID;
    }

    public void requestLeaveGroupDuringShutdown() {
        this.leaveGroupRequested.set(true);
    }

    public Map<MetricName, Metric> producerMetrics() {
        return this.taskManager.producerMetrics();
    }

    public Map<MetricName, Metric> consumerMetrics() {
        return ClientUtils.consumerMetrics(this.mainConsumer, this.restoreConsumer);
    }

    public Map<MetricName, Metric> adminClientMetrics() {
        return ClientUtils.adminClientMetrics(this.adminClient);
    }

    public Object getStateLock() {
        return this.stateLock;
    }

    public Map<String, KafkaFuture<Uuid>> clientInstanceIds(Duration timeout) {
        boolean setDeadline = false;
        HashMap<String, KafkaFuture<Uuid>> result = new HashMap<String, KafkaFuture<Uuid>>();
        if (this.mainConsumerInstanceIdFuture.isDone()) {
            if (this.mainConsumerInstanceIdFuture.isCompletedExceptionally()) {
                this.mainConsumerInstanceIdFuture = new KafkaFutureImpl();
                setDeadline = true;
            }
        } else {
            setDeadline = true;
        }
        result.put(this.getName() + "-consumer", (KafkaFuture<Uuid>)this.mainConsumerInstanceIdFuture);
        if (this.stateUpdaterEnabled) {
            this.restoreConsumerInstanceIdFuture = this.stateUpdater.restoreConsumerInstanceId(timeout);
        } else if (this.restoreConsumerInstanceIdFuture.isDone()) {
            if (this.restoreConsumerInstanceIdFuture.isCompletedExceptionally()) {
                this.restoreConsumerInstanceIdFuture = new KafkaFutureImpl();
                setDeadline = true;
            }
        } else {
            setDeadline = true;
        }
        result.put(this.getName() + "-restore-consumer", (KafkaFuture<Uuid>)this.restoreConsumerInstanceIdFuture);
        if (this.producerInstanceIdFuture.isDone()) {
            if (this.producerInstanceIdFuture.isCompletedExceptionally()) {
                this.producerInstanceIdFuture = new KafkaFutureImpl();
                setDeadline = true;
            }
        } else {
            setDeadline = true;
        }
        result.put(this.getName() + "-producer", (KafkaFuture<Uuid>)this.producerInstanceIdFuture);
        if (setDeadline) {
            this.fetchDeadlineClientInstanceId = this.time.milliseconds() + timeout.toMillis();
        }
        return result;
    }

    void setNow(long now) {
        this.now = now;
    }

    TaskManager taskManager() {
        return this.taskManager;
    }

    int currentNumIterations() {
        return this.numIterations;
    }

    ConsumerRebalanceListener rebalanceListener() {
        return this.rebalanceListener;
    }

    Consumer<byte[], byte[]> mainConsumer() {
        return this.mainConsumer;
    }

    Consumer<byte[], byte[]> restoreConsumer() {
        return this.restoreConsumer;
    }

    Admin adminClient() {
        return this.adminClient;
    }

    public static interface StateListener {
        public void onChange(Thread var1, ThreadStateTransitionValidator var2, ThreadStateTransitionValidator var3);
    }

    public static enum State implements ThreadStateTransitionValidator
    {
        CREATED(1, 5),
        STARTING(2, 3, 5),
        PARTITIONS_REVOKED(2, 3, 5),
        PARTITIONS_ASSIGNED(2, 3, 4, 5),
        RUNNING(2, 3, 4, 5),
        PENDING_SHUTDOWN(6),
        DEAD(new Integer[0]);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isAlive() {
            return this.equals(RUNNING) || this.equals(STARTING) || this.equals(PARTITIONS_REVOKED) || this.equals(PARTITIONS_ASSIGNED);
        }

        @Override
        public boolean isValidTransition(ThreadStateTransitionValidator newState) {
            State tmpState = (State)newState;
            return this.validTransitions.contains(tmpState.ordinal());
        }
    }

    private static final class InternalConsumerConfig
    extends ConsumerConfig {
        private InternalConsumerConfig(Map<String, Object> props) {
            super(ConsumerConfig.appendDeserializerToConfig(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()), false);
        }
    }
}

