/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.Partition;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.server.ThrottleCallback;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uw!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0010\u0018\u0001mC\u0001\u0002\u0018\u0003\u0003\u0002\u0003\u0006I!\u0018\u0005\tG\u0012\u0011\t\u0011)A\u0005I\"Aq\u000e\u0002B\u0001B\u0003%\u0001\u000fC\u0003'\t\u0011\u0005\u0001\u0010C\u0003~\t\u0011\u0005a\u0010C\u0004\u0002&\u0011!\t!a\n\t\u000f\u0005UB\u0001\"\u0003\u00028!9\u00111\t\u0003\u0005\u0002\u0005\u0015\u0003bBA-\t\u0011\u0005\u00111\f\u0005\b\u0003C\"A\u0011AA2\u0011\u001d\t\t\b\u0002C\u0001\u0003gBq!!\u001f\u0005\t\u0003\tY\bC\u0004\u0002\u0000\u0011!\t!!!\t\u000f\u0005EE\u0001\"\u0001\u0002\u0014\"I\u0011q\u0016\u0003\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\b\u0003\u000f$A\u0011BAe\u0011\u001d\ty\r\u0002C\u0001\u0003#\fACU3rk\u0016\u001cH\u000fS1oI2,'\u000fS3ma\u0016\u0014(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005u\tQ\"A\f\u0003)I+\u0017/^3ti\"\u000bg\u000e\u001a7fe\"+G\u000e]3s'\t\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\t!c\u001c8MK\u0006$WM]:iSB\u001c\u0005.\u00198hKR)!&\f\u001fF3B\u0011\u0011eK\u0005\u0003Y\t\u0012A!\u00168ji\")af\u0001a\u0001_\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003aij\u0011!\r\u0006\u0003eM\nQa\u001a:pkBT!\u0001N\u001b\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u00035YR!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO&\u00111(\r\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_JDQ!P\u0002A\u0002y\na\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0002@\u00076\t\u0001I\u0003\u0002B\u0005\u0006YAO]1og\u0006\u001cG/[8o\u0015\t!\u0014$\u0003\u0002E\u0001\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fC\u0003G\u0007\u0001\u0007q)\u0001\bva\u0012\fG/\u001a3MK\u0006$WM]:\u0011\u0007!\u00036K\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011AjG\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!a\u0014\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\t\u0013R,'/\u00192mK*\u0011qJ\t\t\u0003)^k\u0011!\u0016\u0006\u0003-f\tqa\u00197vgR,'/\u0003\u0002Y+\nI\u0001+\u0019:uSRLwN\u001c\u0005\u00065\u000e\u0001\raR\u0001\u0011kB$\u0017\r^3e\r>dGn\\<feN\u001c\"\u0001\u0002\u0011\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0011a,Y\u0007\u0002?*\u0011\u0001-G\u0001\b]\u0016$xo\u001c:l\u0013\t\u0011wL\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\rE,x\u000e^1t!\t)GN\u0004\u0002gU:\u0011q-\u001b\b\u0003\u0015\"L\u0011AG\u0005\u00031eI!a[\f\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u00055t'!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002l/\u0005!A/[7f!\t\th/D\u0001s\u0015\t\u0019H/A\u0003vi&d7O\u0003\u0002vk\u000511m\\7n_:L!a\u001e:\u0003\tQKW.\u001a\u000b\u0005sj\\H\u0010\u0005\u0002\u001e\t!)A\f\u0003a\u0001;\")1\r\u0003a\u0001I\")q\u000e\u0003a\u0001a\u0006AA\u000f\u001b:piRdW\r\u0006\u0004+\u007f\u0006%\u00111\u0004\u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\ri\u0012QA\u0005\u0004\u0003\u000f9\"AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDq!a\u0003\n\u0001\u0004\ti!A\u0004sKF,Xm\u001d;\u0011\t\u0005=\u0011Q\u0003\b\u0004=\u0006E\u0011bAA\n?\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BA\f\u00033\u0011qAU3rk\u0016\u001cHOC\u0002\u0002\u0014}Cq!!\b\n\u0001\u0004\ty\"\u0001\buQJ|G\u000f\u001e7f)&lW-T:\u0011\u0007\u0005\n\t#C\u0002\u0002$\t\u00121!\u00138u\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u000b)\nI#a\u000b\t\u000f\u0005-!\u00021\u0001\u0002\u000e!9\u0011Q\u0006\u0006A\u0002\u0005=\u0012!A3\u0011\u0007!\u000b\t$C\u0002\u00024I\u0013\u0011\u0002\u00165s_^\f'\r\\3\u00025M,g\u000eZ#se>\u0014xJ]\"m_N,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000f)\nI$a\u000f\u0002@!9\u00111B\u0006A\u0002\u00055\u0001bBA\u001f\u0017\u0001\u0007\u0011qF\u0001\u0006KJ\u0014xN\u001d\u0005\b\u0003\u0003Z\u0001\u0019AA\u0010\u0003)!\bN]8ui2,Wj]\u0001\u0016g\u0016tGMR8so\u0006\u0014H-\u001a3SKN\u0004xN\\:f)\u0015Q\u0013qIA%\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001bAq!a\u0013\r\u0001\u0004\ti%\u0001\u0005sKN\u0004xN\\:f!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*i\u0006A!/Z9vKN$8/\u0003\u0003\u0002X\u0005E#\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003E\u0019XM\u001c3NCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0006U\u0005u\u0013q\f\u0005\b\u0003\u0017i\u0001\u0019AA\u0007\u0011\u001d\tY%\u0004a\u0001\u0003\u001b\n\u0011d]3oIJ+7\u000f]8og\u0016l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKR)!&!\u001a\u0002h!9\u00111\u0002\bA\u0002\u00055\u0001bBA5\u001d\u0001\u0007\u00111N\u0001\u000fGJ,\u0017\r^3SKN\u0004xN\\:f!\u001d\t\u0013QNA\u0010\u0003\u001bJ1!a\u001c#\u0005%1UO\\2uS>t\u0017'\u0001\u0010tK:$WI\u001d:peJ+7\u000f]8og\u0016l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKR)!&!\u001e\u0002x!9\u00111B\bA\u0002\u00055\u0001bBA\u001f\u001f\u0001\u0007\u0011qF\u0001 [\u0006L(-\u001a*fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bH\u0003BA\u0010\u0003{Bq!a\u0003\u0011\u0001\u0004\ti!\u0001\u0017tK:$'+Z:q_:\u001cX-T1zE\u0016$\u0006N]8ui2,w+\u001b;i\u0007>tGO]8mY\u0016\u0014\u0018+^8uCR9!&a!\u0002\u000e\u0006=\u0005bBAC#\u0001\u0007\u0011qQ\u0001\u0018G>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006\u00042!HAE\u0013\r\tYi\u0006\u0002\u0018\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006Dq!a\u0003\u0012\u0001\u0004\ti\u0001C\u0004\u0002LE\u0001\r!!\u0014\u00025M,g\u000e\u001a*fgB|gn]3Fq\u0016l\u0007\u000f\u001e+ie>$H\u000f\\3\u0015\u000f)\n)*a&\u0002\u001a\"9\u00111\u0002\nA\u0002\u00055\u0001bBA&%\u0001\u0007\u0011Q\n\u0005\n\u00037\u0013\u0002\u0013!a\u0001\u0003;\u000b!b\u001c8D_6\u0004H.\u001a;f!\u0015\t\u0013qTAR\u0013\r\t\tK\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005\ni'!*+!\u0011\t9+a+\u000e\u0005\u0005%&B\u00011u\u0013\u0011\ti+!+\u0003\tM+g\u000eZ\u0001%g\u0016tGMU3ta>t7/Z#yK6\u0004H\u000f\u00165s_R$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0017\u0016\u0005\u0003;\u000b)l\u000b\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016!C;oG\",7m[3e\u0015\r\t\tMI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003w\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}\u0019XM\u001c3FeJ|'OU3ta>t7/Z#yK6\u0004H\u000f\u00165s_R$H.\u001a\u000b\u0006U\u0005-\u0017Q\u001a\u0005\b\u0003\u0017!\u0002\u0019AA\u0007\u0011\u001d\ti\u0004\u0006a\u0001\u0003_\tad]3oI:{w\n\u001d*fgB|gn]3Fq\u0016l\u0007\u000f\u001e+ie>$H\u000f\\3\u0015\u0007)\n\u0019\u000eC\u0004\u0002\fU\u0001\r!!\u0004")
public class RequestHandlerHelper {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;

    public static void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, Iterable<Partition> updatedLeaders, Iterable<Partition> updatedFollowers) {
        RequestHandlerHelper$.MODULE$.onLeadershipChange(groupCoordinator, txnCoordinator, updatedLeaders, updatedFollowers);
    }

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$1;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$1);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        };
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        if (e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    private void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int controllerThrottleTimeMs = response.throttleTimeMs();
        int requestThrottleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        int appliedThrottleTimeMs = package$.MODULE$.max(controllerThrottleTimeMs, requestThrottleTimeMs);
        this.throttle(this.quotas.request(), request, appliedThrottleTimeMs);
        response.maybeSetThrottleTimeMs(appliedThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendMaybeThrottle(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return throttleTimeMs;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, AbstractResponse response) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle(this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        response.maybeSetThrottleTimeMs(maxThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    private void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
    }
}

