/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static final DelegationTokenManager$ MODULE$ = new DelegationTokenManager$();
    private static final String DefaultHmacAlgorithm = "HmacSHA512";
    private static final int CurrentVersion = 3;
    private static final int ErrorTimestamp = -1;

    private String DefaultHmacAlgorithm() {
        return DefaultHmacAlgorithm;
    }

    public int CurrentVersion() {
        return CurrentVersion;
    }

    public int ErrorTimestamp() {
        return ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.kafka$server$DelegationTokenManager$$createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey kafka$server$DelegationTokenManager$$createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public boolean filterToken(KafkaPrincipal requesterPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken, Function1<KafkaPrincipal, Object> authorizeRequester) {
        if (owners.isDefined() && !((List)owners.get()).exists((Function1 & Serializable)owner -> BoxesRunTime.boxToBoolean((boolean)token.ownerOrRenewer(owner)))) {
            return false;
        }
        if (token.ownerOrRenewer(requesterPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)authorizeToken.apply((Object)token.tokenId())) || BoxesRunTime.unboxToBoolean((Object)authorizeRequester.apply((Object)token.owner()));
    }

    private DelegationTokenManager$() {
    }
}

