/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.NotificationHandler;
import kafka.common.ZkNodeChangeNotificationListener$ChangeNotificationHandler$;
import kafka.common.ZkNodeChangeNotificationListener$ZkStateChangeHandler$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u001c8\u0001qB\u0001\"\u0013\u0001\u0003\u0006\u0004%IA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001BC\u0002\u0013%1\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003U\u0011!\u0001\u0007A!b\u0001\n\u0013\u0019\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011\t\u0004!Q1A\u0005\n\rD\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tS\u0002\u0011)\u0019!C\u0005U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0003q\u0011!a\bA!A!\u0002\u0013\t\b\"B?\u0001\t\u0003q\b\u0002CA\u0007\u0001\u0001\u0007I\u0011\u00026\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0001bBA\u000f\u0001\u0001\u0006Ka\u001b\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CA\u0001\"!\u0012\u0001A\u0003%\u00111\u0005\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"a\u001a\u0001A\u0003%\u00111\n\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003WB\u0001\"!\u001f\u0001A\u0003%\u0011Q\u000e\u0005\b\u0003w\u0002A\u0011AA\"\u0011\u001d\ti\b\u0001C\u0001\u0003\u0007Bq!a \u0001\t\u0013\t\u0019\u0005C\u0004\u0002\u0002\u0002!I!a!\t\u000f\u0005%\u0005\u0001\"\u0003\u0002D\u00191\u00111\b\u0001\u0005\u0003{Aa! \u000f\u0005\u0002\u0005}\u0002bBA!9\u0011\u0005\u00111\t\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K3a!!\u0014\u0001\t\u0005=\u0003\"CA0C\t\u0005\t\u0015!\u0003U\u0011\u0019i\u0018\u0005\"\u0001\u0002b!9\u0011QM\u0011\u0005B\u0005\rsaBAU\u0001!%\u00111\u0016\u0004\b\u0003[\u0003\u0001\u0012BAX\u0011\u0019ih\u0005\"\u0001\u0002>\"A\u0011q\u0018\u0014C\u0002\u0013\u00053\u000bC\u0004\u0002B\u001a\u0002\u000b\u0011\u0002+\t\u000f\u0005\rg\u0005\"\u0011\u0002D\u001d9\u0011Q\u0019\u0001\t\u0002\u0005\u001dgaBAe\u0001!\u0005\u00111\u001a\u0005\u0007{2\"\t!a5\t\u0011\u0005}CF1A\u0005BMCq!!6-A\u0003%A\u000bC\u0004\u0002X2\"\t%a\u0011\b\u0013\u0005ew'!A\t\u0002\u0005mg\u0001\u0003\u001c8\u0003\u0003E\t!!8\t\ru\u0014D\u0011AAp\u0011%\t\tOMI\u0001\n\u0003\t\u0019\u000fC\u0005\u0002zJ\n\n\u0011\"\u0001\u0002|\n\u0001#l\u001b(pI\u0016\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8MSN$XM\\3s\u0015\tA\u0014(\u0001\u0004d_6lwN\u001c\u0006\u0002u\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u001d\u0002\u000bU$\u0018\u000e\\:\n\u0005!+%a\u0002'pO\u001eLgnZ\u0001\tu.\u001cE.[3oiV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Os\u0005\u0011!p[\u0005\u0003!6\u0013QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u0003-\u0019X-\u001d(pI\u0016\u0014vn\u001c;\u0016\u0003Q\u0003\"!\u0016/\u000f\u0005YS\u0006CA,@\u001b\u0005A&BA-<\u0003\u0019a$o\\8u}%\u00111lP\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\\u007f\u0005a1/Z9O_\u0012,'k\\8uA\u0005i1/Z9O_\u0012,\u0007K]3gSb\fab]3r\u001d>$W\r\u0015:fM&D\b%A\no_RLg-[2bi&|g\u000eS1oI2,'/F\u0001e!\t)g-D\u00018\u0013\t9wGA\nO_RLg-[2bi&|g\u000eS1oI2,'/\u0001\u000bo_RLg-[2bi&|g\u000eS1oI2,'\u000fI\u0001\u0013G\"\fgnZ3FqBL'/\u0019;j_:l5/F\u0001l!\tqD.\u0003\u0002n\u007f\t!Aj\u001c8h\u0003M\u0019\u0007.\u00198hK\u0016C\b/\u001b:bi&|g.T:!\u0003\u0011!\u0018.\\3\u0016\u0003E\u0004\"A\u001d>\u000e\u0003MT!A\u0012;\u000b\u0005a*(B\u0001\u001ew\u0015\t9\b0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0006\u0019qN]4\n\u0005m\u001c(\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001P5oSRtD#D@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY\u0001\u0005\u0002f\u0001!)\u0011*\u0004a\u0001\u0017\")!+\u0004a\u0001)\")\u0001-\u0004a\u0001)\")!-\u0004a\u0001I\"9\u0011.\u0004I\u0001\u0002\u0004Y\u0007bB8\u000e!\u0003\u0005\r!]\u0001\u0013Y\u0006\u001cH/\u0012=fGV$X\rZ\"iC:<W-\u0001\fmCN$X\t_3dkR,Gm\u00115b]\u001e,w\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007y\n)\"C\u0002\u0002\u0018}\u0012A!\u00168ji\"A\u00111D\b\u0002\u0002\u0003\u00071.A\u0002yIE\n1\u0003\\1ti\u0016CXmY;uK\u0012\u001c\u0005.\u00198hK\u0002\nQ!];fk\u0016,\"!a\t\u0011\r\u0005\u0015\u00121GA\u001c\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012AC2p]\u000e,(O]3oi*!\u0011QFA\u0018\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002(\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0019\u0011\u0011\b\u000f\u000e\u0003\u0001\u0011!c\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]N\u0011A$\u0010\u000b\u0003\u0003o\tq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0002\u0002\u0014\u00051\u0011/^3vK\u0002\na\u0001\u001e5sK\u0006$WCAA&!\r\tI$\t\u0002\u0019\u0007\"\fgnZ3Fm\u0016tG\u000f\u0015:pG\u0016\u001c8\u000f\u00165sK\u0006$7cA\u0011\u0002RA!\u00111KA.\u001b\t\t)F\u0003\u0003\u0002.\u0005]#bAA-k\u000611/\u001a:wKJLA!!\u0018\u0002V\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003\u0011q\u0017-\\3\u0015\t\u0005-\u00131\r\u0005\u0007\u0003?\u001a\u0003\u0019\u0001+\u0002\r\u0011|wk\u001c:l\u0003\u001d!\bN]3bI\u0002\n\u0001\"[:DY>\u001cX\rZ\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n9#\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003o\n\tHA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\nSN\u001cEn\\:fI\u0002\nA!\u001b8ji\u0006)1\r\\8tK\u0006!\u0002O]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]N\f1\u0003\u001d:pG\u0016\u001c8OT8uS\u001aL7-\u0019;j_:$B!a\u0005\u0002\u0006\"1\u0011q\u0011\u000eA\u0002Q\u000bAB\\8uS\u001aL7-\u0019;j_:\fQ#\u00193e\u0007\"\fgnZ3O_RLg-[2bi&|g.\u0001\u000eqkJ<Wm\u00142t_2,G/\u001a(pi&4\u0017nY1uS>t7\u000f\u0006\u0004\u0002\u0014\u0005=\u00151\u0013\u0005\u0007\u0003#{\u0002\u0019A6\u0002\u00079|w\u000fC\u0004\u0002\u0016~\u0001\r!a&\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t!\u0015\tI*a(U\u001b\t\tYJC\u0002\u0002\u001e~\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a'\u0003\u0007M+\u0017/\u0001\u0007dQ\u0006tw-\u001a(v[\n,'\u000fF\u0002l\u0003OCa!a\u0018!\u0001\u0004!\u0016!G\"iC:<WMT8uS\u001aL7-\u0019;j_:D\u0015M\u001c3mKJ\u00042!!\u000f'\u0005e\u0019\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0014\t\u0019j\u0014\u0011\u0017\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011qW\u001d\u0002\u0013i|wn[3fa\u0016\u0014\u0018\u0002BA^\u0003k\u0013qC\u0017(pI\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3IC:$G.\u001a:\u0015\u0005\u0005-\u0016\u0001\u00029bi\"\fQ\u0001]1uQ\u0002\n\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f\u0003QQ6n\u0015;bi\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feB\u0019\u0011\u0011\b\u0017\u0003)i[7\u000b^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s'\u0011aS(!4\u0011\t\u0005M\u0016qZ\u0005\u0005\u0003#\f)L\u0001\nTi\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014HCAAd\u0003\u0015q\u0017-\\3!\u0003a\tg\r^3s\u0013:LG/[1mSjLgnZ*fgNLwN\\\u0001!5.tu\u000eZ3DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tG*[:uK:,'\u000f\u0005\u0002feM\u0011!'\u0010\u000b\u0003\u00037\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAAsU\rY\u0017q]\u0016\u0003\u0003S\u0004B!a;\u0002v6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0005v]\u000eDWmY6fI*\u0019\u00111_ \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002x\u00065(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!!@+\u0007E\f9\u000f")
public class ZkNodeChangeNotificationListener
implements Logging {
    private volatile ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler$module;
    private volatile ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final KafkaZkClient zkClient;
    private final String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    private final String seqNodePrefix;
    private final NotificationHandler notificationHandler;
    private final long changeExpirationMs;
    private final Time time;
    private long lastExecutedChange;
    private final LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue;
    private final ChangeEventProcessThread thread;
    private final AtomicBoolean isClosed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return Time.SYSTEM;
    }

    public static long $lessinit$greater$default$5() {
        return 900000L;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler() {
        if (this.ChangeNotificationHandler$module == null) {
            this.ChangeNotificationHandler$lzycompute$1();
        }
        return this.ChangeNotificationHandler$module;
    }

    public ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    }

    private String seqNodePrefix() {
        return this.seqNodePrefix;
    }

    private NotificationHandler notificationHandler() {
        return this.notificationHandler;
    }

    private long changeExpirationMs() {
        return this.changeExpirationMs;
    }

    private Time time() {
        return this.time;
    }

    private long lastExecutedChange() {
        return this.lastExecutedChange;
    }

    private void lastExecutedChange_$eq(long x$1) {
        this.lastExecutedChange = x$1;
    }

    public LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$queue;
    }

    private ChangeEventProcessThread thread() {
        return this.thread;
    }

    private AtomicBoolean isClosed() {
        return this.isClosed;
    }

    public void init() {
        this.zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.zkClient().registerZNodeChildChangeHandler(this.ChangeNotificationHandler());
        this.kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification();
        this.thread().start();
    }

    public void close() {
        this.isClosed().set(true);
        this.zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.zkClient().unregisterZNodeChildChangeHandler(this.ChangeNotificationHandler().path());
        this.kafka$common$ZkNodeChangeNotificationListener$$queue().clear();
        this.thread().shutdown();
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$processNotifications() {
        try {
            Seq notifications = (Seq)this.zkClient().getChildren(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).sorted((Ordering)Ordering.String$.MODULE$);
            if (notifications.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Processing notification(s) to ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString());
                long now = this.time().milliseconds();
                notifications.foreach((Function1 & Serializable)notification -> {
                    ZkNodeChangeNotificationListener.$anonfun$processNotifications$2(this, notification);
                    return BoxedUnit.UNIT;
                });
                this.purgeObsoleteNotifications(now, (Seq<String>)notifications);
            }
        }
        catch (InterruptedException e) {
            if (!this.isClosed().get()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processNotification(String notification) {
        void var4_4;
        String changeZnode = new StringBuilder(1).append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append(notification).toString();
        Tuple2<Option<byte[]>, Stat> tuple2 = this.zkClient().getDataAndStat(changeZnode);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option data = (Option)tuple2._1();
        if (var4_4 instanceof Some) {
            byte[] d = (byte[])((Some)var4_4).value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.notificationHandler().processNotification(d));
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("error processing change notification ").append(new String(d, StandardCharsets.UTF_8)).append(" from ").append(changeZnode).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(var4_4)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("read null data from ").append(changeZnode).toString());
            return;
        }
        throw new MatchError((Object)var4_4);
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification() {
        if (!this.isClosed().get() && this.kafka$common$ZkNodeChangeNotificationListener$$queue().peek() == null) {
            this.kafka$common$ZkNodeChangeNotificationListener$$queue().put(new ChangeNotification());
            return;
        }
    }

    private void purgeObsoleteNotifications(long now, Seq<String> notifications) {
        ((IterableOnceOps)notifications.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)notification -> {
            ZkNodeChangeNotificationListener.$anonfun$purgeObsoleteNotifications$1(this, now, notification);
            return BoxedUnit.UNIT;
        });
    }

    private long changeNumber(String name) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(name.substring(this.seqNodePrefix().length())));
    }

    private final void ChangeNotificationHandler$lzycompute$1() {
        synchronized (this) {
            if (this.ChangeNotificationHandler$module == null) {
                this.ChangeNotificationHandler$module = new ZkNodeChangeNotificationListener$ChangeNotificationHandler$(this);
            }
            return;
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new ZkNodeChangeNotificationListener$ZkStateChangeHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processNotifications$2(ZkNodeChangeNotificationListener $this, String notification) {
        long changeId = $this.changeNumber(notification);
        if (changeId > $this.lastExecutedChange()) {
            $this.processNotification(notification);
            $this.lastExecutedChange_$eq(changeId);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$purgeObsoleteNotifications$1(ZkNodeChangeNotificationListener $this, long now$1, String notification) {
        void var6_5;
        String notificationNode = new StringBuilder(1).append($this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append(notification).toString();
        Tuple2<Option<byte[]>, Stat> tuple2 = $this.zkClient().getDataAndStat(notificationNode);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option data = (Option)tuple2._1();
        Stat stat = (Stat)tuple2._2();
        if (var6_5.isDefined()) {
            void var7_6;
            if (now$1 - var7_6.getCtime() > $this.changeExpirationMs()) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Purging change notification ").append(notificationNode).toString());
                $this.zkClient().deletePath(notificationNode, $this.zkClient().deletePath$default$2(), $this.zkClient().deletePath$default$3());
                return;
            }
            return;
        }
    }

    public ZkNodeChangeNotificationListener(KafkaZkClient zkClient, String seqNodeRoot, String seqNodePrefix, NotificationHandler notificationHandler, long changeExpirationMs, Time time) {
        this.zkClient = zkClient;
        this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot = seqNodeRoot;
        this.seqNodePrefix = seqNodePrefix;
        this.notificationHandler = notificationHandler;
        this.changeExpirationMs = changeExpirationMs;
        this.time = time;
        this.lastExecutedChange = -1L;
        this.kafka$common$ZkNodeChangeNotificationListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeEventProcessThread(new StringBuilder(21).append(seqNodeRoot).append("-event-process-thread").toString());
        this.isClosed = new AtomicBoolean(false);
    }

    private class ChangeEventProcessThread
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer().kafka$common$ZkNodeChangeNotificationListener$$queue().take().process();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeEventProcessThread(String name) {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
            super(name);
        }
    }

    private class ChangeNotification {
        public void process() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer().kafka$common$ZkNodeChangeNotificationListener$$processNotifications();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeNotification() {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
        }
    }
}

