/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicLogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u00019<Qa\u0004\t\t\u0002U1Qa\u0006\t\t\u0002aAQaH\u0001\u0005\u0002\u0001Bq!I\u0001C\u0002\u0013\u0005!\u0005\u0003\u00045\u0003\u0001\u0006Ia\t\u0005\bk\u0005\u0011\r\u0011\"\u0001#\u0011\u00191\u0014\u0001)A\u0005G\u0019!q\u0003\u0005\u00018\u0011!\tuA!A!\u0002\u0013\u0011\u0005\u0002C\t\b\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b}9A\u0011A&\t\u000b=;A\u0011\t\u0012\t\u000bA;A\u0011I)\t\u000bi;A\u0011B.\t\u000b%<A\u0011\t6\u0002!\u0011Kh.Y7jG2{wmQ8oM&<'BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005Y\tQ\"\u0001\t\u0003!\u0011Kh.Y7jG2{wmQ8oM&<7CA\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!F\u0001\u001b\u001d>t'+Z2p]\u001aLwM]1cY\u0016dunZ\"p]\u001aLwm]\u000b\u0002GA\u0019AeJ\u0015\u000e\u0003\u0015R!AJ\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002)K\t\u00191+\u001a;\u0011\u0005)\ndBA\u00160!\ta3$D\u0001.\u0015\tqC#\u0001\u0004=e>|GOP\u0005\u0003am\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001gG\u0001\u001c\u001d>t'+Z2p]\u001aLwM]1cY\u0016dunZ\"p]\u001aLwm\u001d\u0011\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\b3aZ\u0004C\u0001\f:\u0013\tQ\u0004C\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}I\tQ!\u001e;jYNL!\u0001Q\u001f\u0003\u000f1{wmZ5oO\u0006QAn\\4NC:\fw-\u001a:\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015\u0013\u0012a\u00017pO&\u0011q\t\u0012\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bC\u0001\fJ\u0013\tQ\u0005CA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014Hc\u0001'N\u001dB\u0011ac\u0002\u0005\u0006\u0003*\u0001\rA\u0011\u0005\u0006#)\u0001\r\u0001S\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002S+B\u0011!dU\u0005\u0003)n\u0011A!\u00168ji\")a\u000b\u0004a\u0001/\u0006Ia.Z<D_:4\u0017n\u001a\t\u0003-aK!!\u0017\t\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011kB$\u0017\r^3M_\u001e\u001c8i\u001c8gS\u001e$\"A\u0015/\t\u000buk\u0001\u0019\u00010\u0002#9,wO\u0011:pW\u0016\u0014H)\u001a4bk2$8\u000f\u0005\u0003%?&\n\u0017B\u00011&\u0005\ri\u0015\r\u001d\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005\u0019y%M[3di\u0006Y!/Z2p]\u001aLw-\u001e:f)\r\u00116.\u001c\u0005\u0006Y:\u0001\raV\u0001\n_2$7i\u001c8gS\u001eDQA\u0016\bA\u0002]\u0003")
public class DynamicLogConfig
implements BrokerReconfigurable,
Logging {
    private final LogManager logManager;
    private final KafkaBroker server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    public static Set<String> NonReconfigrableLogConfigs() {
        return DynamicLogConfig$.MODULE$.NonReconfigrableLogConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        DynamicLogConfig.validateLogLocalRetentionMs$1(newConfig);
        DynamicLogConfig.validateLogLocalRetentionBytes$1(newConfig);
    }

    private void updateLogsConfig(Map<String, Object> newBrokerDefaults) {
        this.logManager.brokerConfigUpdated();
        this.logManager.allLogs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            scala.collection.mutable.Map props = Map$.MODULE$.empty();
            props.$plus$plus$eq((TraversableOnce)newBrokerDefaults);
            props.$plus$plus$eq((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(log.config().originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicLogConfig.$anonfun$updateLogsConfig$2(log, x0$1))));
            LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(props).asJava(), log.config().overriddenConfigs);
            return log.updateConfig(logConfig);
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        LogConfig originalLogConfig = this.logManager.currentDefaultConfig();
        boolean originalUncleanLeaderElectionEnable = originalLogConfig.uncleanLeaderElectionEnable;
        HashMap<String, Object> newBrokerDefaults = new HashMap<String, Object>(newConfig.extractLogConfigMap());
        java.util.Map originalLogConfigMap = originalLogConfig.originals();
        DynamicLogConfig$.MODULE$.NonReconfigrableLogConfigs().foreach((Function1 & Serializable & scala.Serializable)k -> {
            Option option = Option$.MODULE$.apply(originalLogConfigMap.get(k));
            if (None$.MODULE$.equals(option)) {
                return newBrokerDefaults.remove(k);
            }
            if (option instanceof Some) {
                Object v = ((Some)option).value();
                return newBrokerDefaults.put((String)k, v);
            }
            throw new MatchError((Object)option);
        });
        this.logManager.reconfigureDefaultLogConfig(new LogConfig(newBrokerDefaults));
        this.updateLogsConfig((Map<String, Object>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newBrokerDefaults).asScala()));
        if (this.logManager.currentDefaultConfig().uncleanLeaderElectionEnable && !originalUncleanLeaderElectionEnable) {
            KafkaBroker kafkaBroker = this.server;
            if (kafkaBroker instanceof KafkaServer) {
                ((KafkaServer)kafkaBroker).kafkaController().enableDefaultUncleanLeaderElection();
                return;
            }
            return;
        }
    }

    private static final void validateLogLocalRetentionMs$1(KafkaConfig newConfig$4) {
        long logRetentionMs = newConfig$4.logRetentionTimeMillis();
        Long logLocalRetentionMs = newConfig$4.logLocalRetentionMs();
        if (logRetentionMs != -1L && !BoxesRunTime.equalsNumObject((Number)logLocalRetentionMs, (Object)BoxesRunTime.boxToLong((long)-2L))) {
            if (BoxesRunTime.equalsNumObject((Number)logLocalRetentionMs, (Object)BoxesRunTime.boxToLong((long)-1L))) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, new StringBuilder(42).append("Value must not be -1 as ").append(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()).append(" value is set as ").append(logRetentionMs).append(".").toString());
            }
            if (Predef$.MODULE$.Long2long(logLocalRetentionMs) > logRetentionMs) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, new StringBuilder(45).append("Value must not be more than ").append(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp()).append(" property value: ").append(logRetentionMs).toString());
            }
            return;
        }
    }

    private static final void validateLogLocalRetentionBytes$1(KafkaConfig newConfig$4) {
        Long logRetentionBytes = newConfig$4.logRetentionBytes();
        Long logLocalRetentionBytes = newConfig$4.logLocalRetentionBytes();
        if (Predef$.MODULE$.Long2long(logRetentionBytes) > -1L && !BoxesRunTime.equalsNumObject((Number)logLocalRetentionBytes, (Object)BoxesRunTime.boxToInteger((int)-2))) {
            if (BoxesRunTime.equalsNumObject((Number)logLocalRetentionBytes, (Object)BoxesRunTime.boxToInteger((int)-1))) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, new StringBuilder(42).append("Value must not be -1 as ").append(KafkaConfig$.MODULE$.LogRetentionBytesProp()).append(" value is set as ").append(logRetentionBytes).append(".").toString());
            }
            if (Predef$.MODULE$.Long2long(logLocalRetentionBytes) > Predef$.MODULE$.Long2long(logRetentionBytes)) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, new StringBuilder(45).append("Value must not be more than ").append(KafkaConfig$.MODULE$.LogRetentionBytesProp()).append(" property value: ").append(logRetentionBytes).toString());
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateLogsConfig$2(UnifiedLog log$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return log$1.config().overriddenConfigs.contains(k);
        }
        throw new MatchError(null);
    }

    public DynamicLogConfig(LogManager logManager, KafkaBroker server) {
        this.logManager = logManager;
        this.server = server;
        Logging.$init$(this);
    }
}

