/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.server.util.TopicFilter;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.tools.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopicCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TopicCommand.class);

    public static void main(String ... args) {
        Exit.exit((int)TopicCommand.mainNoExit(args));
    }

    private static int mainNoExit(String ... args) {
        try {
            TopicCommand.execute(args);
            return 0;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        TopicCommandOptions opts = new TopicCommandOptions(args);
        TopicService topicService = new TopicService(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            if (opts.hasCreateOption().booleanValue()) {
                topicService.createTopic(opts);
            } else if (opts.hasAlterOption().booleanValue()) {
                topicService.alterTopic(opts);
            } else if (opts.hasListOption().booleanValue()) {
                topicService.listTopics(opts);
            } else if (opts.hasDescribeOption().booleanValue()) {
                topicService.describeTopic(opts);
            } else if (opts.hasDeleteOption().booleanValue()) {
                topicService.deleteTopic(opts);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                TopicCommand.printException(cause);
            } else {
                TopicCommand.printException(e);
            }
            exitCode = 1;
        }
        catch (Throwable e) {
            TopicCommand.printException(e);
            exitCode = 1;
        }
        finally {
            topicService.close();
            Exit.exit((int)exitCode);
        }
    }

    private static void printException(Throwable e) {
        System.out.println("Error while executing topic command : " + e.getMessage());
        LOG.error(Utils.stackTrace((Throwable)e));
    }

    static Map<Integer, List<Integer>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap<Integer, List<Integer>> ret = new LinkedHashMap<Integer, List<Integer>>();
        for (int i = 0; i < partitionList.length; ++i) {
            List brokerList = Arrays.stream(partitionList[i].split(":")).map(String::trim).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
            Set duplicateBrokers = ToolsUtils.duplicates(brokerList);
            if (!duplicateBrokers.isEmpty()) {
                throw new AdminCommandFailedException("Partition replica lists may not contain duplicate entries: " + duplicateBrokers.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
            ret.put(i, brokerList);
            if (((List)ret.get(i)).size() == ((List)ret.get(0)).size()) continue;
            throw new AdminOperationException("Partition " + i + " has different replication factor: " + brokerList);
        }
        return ret;
    }

    private static Properties parseTopicConfigsToBeAdded(TopicCommandOptions opts) {
        List configsToBeAdded = opts.topicConfig().orElse(Collections.emptyList()).stream().map(s -> Arrays.asList(s.split("\\s*=\\s*"))).collect(Collectors.toList());
        if (!configsToBeAdded.stream().allMatch(config -> config.size() == 2)) {
            throw new IllegalArgumentException("requirement failed: Invalid topic config: all configs to be added must be in the format \"key=val\".");
        }
        Properties props = new Properties();
        configsToBeAdded.stream().forEach(pair -> props.setProperty(((String)pair.get(0)).trim(), ((String)pair.get(1)).trim()));
        LogConfig.validate((Properties)props);
        if (props.containsKey("message.format.version")) {
            System.out.println("WARNING: The configuration ${TopicConfig.MESSAGE_FORMAT_VERSION_CONFIG}=${props.getProperty(TopicConfig.MESSAGE_FORMAT_VERSION_CONFIG)} is specified. This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker or if the inter.broker.protocol.version is 3.0 or newer. This configuration is deprecated and it will be removed in Apache Kafka 4.0.");
        }
        return props;
    }

    public static boolean isReassignmentInProgress(TopicPartitionInfo tpi, PartitionReassignment ra) {
        Set allReplicaIds = tpi.replicas().stream().map(Node::id).collect(Collectors.toSet());
        HashSet changingReplicaIds = new HashSet();
        if (ra != null) {
            changingReplicaIds.addAll(ra.removingReplicas());
            changingReplicaIds.addAll(ra.addingReplicas());
        }
        return allReplicaIds.stream().anyMatch(changingReplicaIds::contains);
    }

    private static Integer getReplicationFactor(TopicPartitionInfo tpi, PartitionReassignment reassignment) {
        return TopicCommand.isReassignmentInProgress(tpi, reassignment) ? reassignment.replicas().size() - reassignment.addingReplicas().size() : tpi.replicas().size();
    }

    private static void ensureTopicExists(List<String> foundTopics, String requestedTopic, Boolean requireTopicExists) {
        if (!requestedTopic.isEmpty() && Optional.ofNullable(requestedTopic).isPresent() && requireTopicExists.booleanValue() && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(String.format("Topic '%s' does not exist as expected", requestedTopic));
        }
    }

    private static List<String> doGetTopics(List<String> allTopics, Optional<String> topicIncludeList, Boolean excludeInternalTopics) {
        if (topicIncludeList.isPresent()) {
            TopicFilter.IncludeList topicsFilter = new TopicFilter.IncludeList(topicIncludeList.get());
            return allTopics.stream().filter(topic -> topicsFilter.isTopicAllowed(topic, excludeInternalTopics.booleanValue())).collect(Collectors.toList());
        }
        return allTopics.stream().filter(topic -> !Topic.isInternal((String)topic) || excludeInternalTopics == false).collect(Collectors.toList());
    }

    private static void ensureTopicIdExists(List<Uuid> foundTopicIds, Uuid requestedTopicId, Boolean requireTopicIdExists) {
        if (requestedTopicId != null && requireTopicIdExists.booleanValue() && foundTopicIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("TopicId '%s' does not exist as expected", requestedTopicId));
        }
    }

    public static final class TopicCommandOptions
    extends CommandDefaultOptions {
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt;
        private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
        private final OptionSpecBuilder listOpt;
        private final OptionSpecBuilder createOpt;
        private final OptionSpecBuilder deleteOpt;
        private final OptionSpecBuilder alterOpt;
        private final OptionSpecBuilder describeOpt;
        private final ArgumentAcceptingOptionSpec<String> topicOpt;
        private final ArgumentAcceptingOptionSpec<String> topicIdOpt;
        private final String nl;
        private static final String KAFKA_CONFIGS_CLI_SUPPORTS_ALTERING_TOPIC_CONFIGS_WITH_A_BOOTSTRAP_SERVER = " (the kafka-configs CLI supports altering topic configs with a --bootstrap-server option)";
        private final ArgumentAcceptingOptionSpec<String> configOpt;
        private final ArgumentAcceptingOptionSpec<String> deleteConfigOpt;
        private final ArgumentAcceptingOptionSpec<Integer> partitionsOpt;
        private final ArgumentAcceptingOptionSpec<Integer> replicationFactorOpt;
        private final ArgumentAcceptingOptionSpec<String> replicaAssignmentOpt;
        private final OptionSpecBuilder reportUnderReplicatedPartitionsOpt;
        private final OptionSpecBuilder reportUnavailablePartitionsOpt;
        private final OptionSpecBuilder reportUnderMinIsrPartitionsOpt;
        private final OptionSpecBuilder reportAtMinIsrPartitionsOpt;
        private final OptionSpecBuilder topicsWithOverridesOpt;
        private final OptionSpecBuilder ifExistsOpt;
        private final OptionSpecBuilder ifNotExistsOpt;
        private final OptionSpecBuilder excludeInternalTopicOpt;
        private final Set<OptionSpec<?>> allTopicLevelOpts;
        private final Set<OptionSpecBuilder> allReplicationReportOpts;

        public TopicCommandOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The Kafka server to connect to.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client. This is used only with --bootstrap-server option for describing and altering broker configs.").withRequiredArg().describedAs("command config property file").ofType(String.class);
            String kafkaConfigsCanAlterTopicConfigsViaBootstrapServer = KAFKA_CONFIGS_CLI_SUPPORTS_ALTERING_TOPIC_CONFIGS_WITH_A_BOOTSTRAP_SERVER;
            this.listOpt = this.parser.accepts("list", "List all available topics.");
            this.createOpt = this.parser.accepts("create", "Create a new topic.");
            this.deleteOpt = this.parser.accepts("delete", "Delete a topic");
            this.alterOpt = this.parser.accepts("alter", "Alter the number of partitions and replica assignment. Update the configuration of an existing topic via --alter is no longer supported here" + kafkaConfigsCanAlterTopicConfigsViaBootstrapServer + ".");
            this.describeOpt = this.parser.accepts("describe", "List details for the given topics.");
            this.topicOpt = this.parser.accepts("topic", "The topic to create, alter, describe or delete. It also accepts a regular expression, except for --create option. Put topic name in double quotes and use the '\\' prefix to escape regular expression symbols; e.g. \"test\\.topic\".").withRequiredArg().describedAs("topic").ofType(String.class);
            this.topicIdOpt = this.parser.accepts("topic-id", "The topic-id to describe.This is used only with --bootstrap-server option for describing topics.").withRequiredArg().describedAs("topic-id").ofType(String.class);
            this.nl = System.getProperty("line.separator");
            String logConfigNames = LogConfig.configNames().stream().map(config -> "\t" + config).collect(Collectors.joining(this.nl));
            this.configOpt = this.parser.accepts("config", "A topic configuration override for the topic being created. The following is a list of valid configurations: " + this.nl + logConfigNames + this.nl + "See the Kafka documentation for full details on the topic configs. It is supported only in combination with --create if --bootstrap-server option is used" + kafkaConfigsCanAlterTopicConfigsViaBootstrapServer + ".").withRequiredArg().describedAs("name=value").ofType(String.class);
            this.deleteConfigOpt = this.parser.accepts("delete-config", "A topic configuration override to be removed for an existing topic (see the list of configurations under the --config option). Not supported with the --bootstrap-server option.").withRequiredArg().describedAs("name").ofType(String.class);
            this.partitionsOpt = this.parser.accepts("partitions", "The number of partitions for the topic being created or altered (WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected). If not supplied for create, defaults to the cluster default.").withRequiredArg().describedAs("# of partitions").ofType(Integer.class);
            this.replicationFactorOpt = this.parser.accepts("replication-factor", "The replication factor for each partition in the topic being created. If not supplied, defaults to the cluster default.").withRequiredArg().describedAs("replication factor").ofType(Integer.class);
            this.replicaAssignmentOpt = this.parser.accepts("replica-assignment", "A list of manual partition-to-broker assignments for the topic being created or altered.").withRequiredArg().describedAs("broker_id_for_part1_replica1 : broker_id_for_part1_replica2 , broker_id_for_part2_replica1 : broker_id_for_part2_replica2 , ...").ofType(String.class);
            this.reportUnderReplicatedPartitionsOpt = this.parser.accepts("under-replicated-partitions", "if set when describing topics, only show under replicated partitions");
            this.reportUnavailablePartitionsOpt = this.parser.accepts("unavailable-partitions", "if set when describing topics, only show partitions whose leader is not available");
            this.reportUnderMinIsrPartitionsOpt = this.parser.accepts("under-min-isr-partitions", "if set when describing topics, only show partitions whose isr count is less than the configured minimum.");
            this.reportAtMinIsrPartitionsOpt = this.parser.accepts("at-min-isr-partitions", "if set when describing topics, only show partitions whose isr count is equal to the configured minimum.");
            this.topicsWithOverridesOpt = this.parser.accepts("topics-with-overrides", "if set when describing topics, only show topics that have overridden configs");
            this.ifExistsOpt = this.parser.accepts("if-exists", "if set when altering or deleting or describing topics, the action will only execute if the topic exists.");
            this.ifNotExistsOpt = this.parser.accepts("if-not-exists", "if set when creating topics, the action will only execute if the topic does not already exist.");
            this.excludeInternalTopicOpt = this.parser.accepts("exclude-internal", "exclude internal topics when running list or describe command. The internal topics will be listed by default");
            this.options = this.parser.parse(args);
            this.allTopicLevelOpts = new HashSet<OptionSpecBuilder>(Arrays.asList(this.alterOpt, this.createOpt, this.describeOpt, this.listOpt, this.deleteOpt));
            this.allReplicationReportOpts = new HashSet<OptionSpecBuilder>(Arrays.asList(this.reportUnderReplicatedPartitionsOpt, this.reportUnderMinIsrPartitionsOpt, this.reportAtMinIsrPartitionsOpt, this.reportUnavailablePartitionsOpt));
            this.checkArgs();
        }

        public Boolean has(OptionSpec<?> builder) {
            return this.options.has(builder);
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option) {
            return this.valueAsOption(option, Optional.empty());
        }

        public <A> Optional<List<A>> valuesAsOption(OptionSpec<A> option) {
            return this.valuesAsOption(option, Collections.emptyList());
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option, Optional<A> defaultValue) {
            if (this.has(option).booleanValue()) {
                return Optional.of(this.options.valueOf(option));
            }
            return defaultValue;
        }

        public <A> Optional<List<A>> valuesAsOption(OptionSpec<A> option, List<A> defaultValue) {
            return this.options.has(option) ? Optional.of(this.options.valuesOf(option)) : Optional.of(defaultValue);
        }

        public Boolean hasCreateOption() {
            return this.has((OptionSpec<?>)this.createOpt);
        }

        public Boolean hasAlterOption() {
            return this.has((OptionSpec<?>)this.alterOpt);
        }

        public Boolean hasListOption() {
            return this.has((OptionSpec<?>)this.listOpt);
        }

        public Boolean hasDescribeOption() {
            return this.has((OptionSpec<?>)this.describeOpt);
        }

        public Boolean hasDeleteOption() {
            return this.has((OptionSpec<?>)this.deleteOpt);
        }

        public Optional<String> bootstrapServer() {
            return this.valueAsOption((OptionSpec)this.bootstrapServerOpt);
        }

        public Properties commandConfig() throws IOException {
            if (this.has((OptionSpec<?>)this.commandConfigOpt).booleanValue()) {
                return Utils.loadProps((String)((String)this.options.valueOf(this.commandConfigOpt)));
            }
            return new Properties();
        }

        public Optional<String> topic() {
            return this.valueAsOption((OptionSpec)this.topicOpt);
        }

        public Optional<String> topicId() {
            return this.valueAsOption((OptionSpec)this.topicIdOpt);
        }

        public Optional<Integer> partitions() {
            return this.valueAsOption((OptionSpec)this.partitionsOpt);
        }

        public Optional<Integer> replicationFactor() {
            return this.valueAsOption((OptionSpec)this.replicationFactorOpt);
        }

        public Optional<Map<Integer, List<Integer>>> replicaAssignment() {
            if (this.has((OptionSpec<?>)this.replicaAssignmentOpt).booleanValue() && !((String)Optional.of(this.options.valueOf(this.replicaAssignmentOpt)).orElse("")).isEmpty()) {
                return Optional.of(TopicCommand.parseReplicaAssignment((String)this.options.valueOf(this.replicaAssignmentOpt)));
            }
            return Optional.empty();
        }

        public Boolean reportUnderReplicatedPartitions() {
            return this.has((OptionSpec<?>)this.reportUnderReplicatedPartitionsOpt);
        }

        public Boolean reportUnavailablePartitions() {
            return this.has((OptionSpec<?>)this.reportUnavailablePartitionsOpt);
        }

        public Boolean reportUnderMinIsrPartitions() {
            return this.has((OptionSpec<?>)this.reportUnderMinIsrPartitionsOpt);
        }

        public Boolean reportAtMinIsrPartitions() {
            return this.has((OptionSpec<?>)this.reportAtMinIsrPartitionsOpt);
        }

        public Boolean reportOverriddenConfigs() {
            return this.has((OptionSpec<?>)this.topicsWithOverridesOpt);
        }

        public Boolean ifExists() {
            return this.has((OptionSpec<?>)this.ifExistsOpt);
        }

        public Boolean ifNotExists() {
            return this.has((OptionSpec<?>)this.ifNotExistsOpt);
        }

        public Boolean excludeInternalTopics() {
            return this.has((OptionSpec<?>)this.excludeInternalTopicOpt);
        }

        public Optional<List<String>> topicConfig() {
            return this.valuesAsOption((OptionSpec)this.configOpt);
        }

        public void checkArgs() {
            if (this.args.length == 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Create, delete, describe, or change a topic.");
            }
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to create, delete, describe, or change a topic.");
            long actions = Arrays.asList(this.createOpt, this.listOpt, this.alterOpt, this.describeOpt, this.deleteOpt).stream().filter(arg_0 -> ((OptionSet)this.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Command must include exactly one action: --list, --describe, --create, --alter or --delete");
            }
            this.checkRequiredArgs();
            this.checkInvalidArgs();
        }

        private void checkRequiredArgs() {
            if (!this.has((OptionSpec<?>)this.bootstrapServerOpt).booleanValue()) {
                throw new IllegalArgumentException("--bootstrap-server must be specified");
            }
            if (this.has((OptionSpec<?>)this.describeOpt).booleanValue() && this.has((OptionSpec<?>)this.ifExistsOpt).booleanValue()) {
                if (!this.has((OptionSpec<?>)this.topicOpt).booleanValue() && !this.has((OptionSpec<?>)this.topicIdOpt).booleanValue()) {
                    CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"--topic or --topic-id is required to describe a topic");
                }
                if (this.has((OptionSpec<?>)this.topicOpt).booleanValue() && this.has((OptionSpec<?>)this.topicIdOpt).booleanValue()) {
                    System.out.println("Only topic id will be used when both --topic and --topic-id are specified and topicId is not Uuid.ZERO_UUID");
                }
            }
            if (!this.has((OptionSpec<?>)this.listOpt).booleanValue() && !this.has((OptionSpec<?>)this.describeOpt).booleanValue()) {
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.topicOpt});
            }
            if (this.has((OptionSpec<?>)this.alterOpt).booleanValue()) {
                HashSet<ArgumentAcceptingOptionSpec> usedOptions = new HashSet<ArgumentAcceptingOptionSpec>(Arrays.asList(this.bootstrapServerOpt, this.configOpt));
                HashSet<OptionSpecBuilder> invalidOptions = new HashSet<OptionSpecBuilder>(Arrays.asList(this.alterOpt));
                CommandLineUtils.checkInvalidArgsSet((OptionParser)this.parser, (OptionSet)this.options, usedOptions, invalidOptions, Optional.of(KAFKA_CONFIGS_CLI_SUPPORTS_ALTERING_TOPIC_CONFIGS_WITH_A_BOOTSTRAP_SERVER));
                CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.partitionsOpt});
            }
        }

        private void checkInvalidArgs() {
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.configOpt, this.invalidOptions(Arrays.asList(this.alterOpt, this.createOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.deleteConfigOpt, this.invalidOptions(new HashSet<ArgumentAcceptingOptionSpec>(Arrays.asList(this.bootstrapServerOpt)), Arrays.asList(this.alterOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.partitionsOpt, this.invalidOptions(Arrays.asList(this.alterOpt, this.createOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.replicationFactorOpt, this.invalidOptions(Arrays.asList(this.createOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.replicaAssignmentOpt, this.invalidOptions(Arrays.asList(this.alterOpt, this.createOpt)));
            if (this.options.has((OptionSpec)this.createOpt)) {
                CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.replicaAssignmentOpt, (OptionSpec[])new OptionSpec[]{this.partitionsOpt, this.replicationFactorOpt});
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.reportUnderReplicatedPartitionsOpt, this.invalidOptions(Collections.singleton(this.topicsWithOverridesOpt), Arrays.asList(this.describeOpt, this.reportUnderReplicatedPartitionsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.reportUnderMinIsrPartitionsOpt, this.invalidOptions(Collections.singleton(this.topicsWithOverridesOpt), Arrays.asList(this.describeOpt, this.reportUnderMinIsrPartitionsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.reportAtMinIsrPartitionsOpt, this.invalidOptions(Collections.singleton(this.topicsWithOverridesOpt), Arrays.asList(this.describeOpt, this.reportAtMinIsrPartitionsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.reportUnavailablePartitionsOpt, this.invalidOptions(Collections.singleton(this.topicsWithOverridesOpt), Arrays.asList(this.describeOpt, this.reportUnavailablePartitionsOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.topicsWithOverridesOpt, this.invalidOptions(new HashSet<OptionSpecBuilder>(this.allReplicationReportOpts), Arrays.asList(this.describeOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.ifExistsOpt, this.invalidOptions(Arrays.asList(this.alterOpt, this.deleteOpt, this.describeOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.ifNotExistsOpt, this.invalidOptions(Arrays.asList(this.createOpt)));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.excludeInternalTopicOpt, this.invalidOptions(Arrays.asList(this.listOpt, this.describeOpt)));
        }

        private Set<OptionSpec<?>> invalidOptions(List<OptionSpec<?>> removeOptions) {
            return this.invalidOptions(new HashSet(), removeOptions);
        }

        private LinkedHashSet<OptionSpec<?>> invalidOptions(Set<OptionSpec<?>> addOptions, List<OptionSpec<?>> removeOptions) {
            LinkedHashSet finalOptions = new LinkedHashSet(this.allTopicLevelOpts);
            finalOptions.removeAll(removeOptions);
            finalOptions.addAll(addOptions);
            return finalOptions;
        }
    }

    public static class TopicService
    implements AutoCloseable {
        private Admin adminClient;

        public TopicService(Properties commandConfig, Optional<String> bootstrapServer) {
            this.adminClient = TopicService.createAdminClient(commandConfig, bootstrapServer);
        }

        public TopicService(Admin admin) {
            this.adminClient = admin;
        }

        private static Admin createAdminClient(Properties commandConfig, Optional<String> bootstrapServer) {
            if (bootstrapServer.isPresent()) {
                commandConfig.put("bootstrap.servers", bootstrapServer.get());
            }
            return Admin.create((Properties)commandConfig);
        }

        public void createTopic(TopicCommandOptions opts) throws Exception {
            CommandTopicPartition topic = new CommandTopicPartition(opts);
            if (Topic.hasCollisionChars((String)topic.name)) {
                System.out.println("WARNING: Due to limitations in metric names, topics with a period ('.') or underscore ('_') could collide. To avoid issues it is best to use either, but not both.");
            }
            this.createTopic(topic);
        }

        public void createTopic(CommandTopicPartition topic) throws Exception {
            block5: {
                if (topic.replicationFactor.filter(rf -> rf > Short.MAX_VALUE || rf < 1).isPresent()) {
                    throw new IllegalArgumentException("The replication factor must be between 1 and 32767 inclusive");
                }
                if (topic.partitions.filter(p -> p < 1).isPresent()) {
                    throw new IllegalArgumentException("The partitions must be greater than 0");
                }
                try {
                    NewTopic newTopic = topic.hasReplicaAssignment() != false ? new NewTopic(topic.name, topic.replicaAssignment) : new NewTopic(topic.name, topic.partitions, topic.replicationFactor.map(Integer::shortValue));
                    Map<String, String> configsMap = topic.configsToAdd.stringPropertyNames().stream().collect(Collectors.toMap(name -> name, name -> topic.configsToAdd.getProperty((String)name)));
                    newTopic.configs(configsMap);
                    CreateTopicsResult createResult = this.adminClient.createTopics(Collections.singleton(newTopic), new CreateTopicsOptions().retryOnQuotaViolation(false));
                    createResult.all().get();
                    System.out.println("Created topic " + topic.name + ".");
                }
                catch (ExecutionException e) {
                    if (e.getCause() == null) {
                        throw e;
                    }
                    if (e.getCause() instanceof TopicExistsException && topic.ifTopicDoesntExist().booleanValue()) break block5;
                    throw (Exception)e.getCause();
                }
            }
        }

        public void listTopics(TopicCommandOptions opts) throws ExecutionException, InterruptedException {
            String results = this.getTopics(opts.topic(), opts.excludeInternalTopics()).stream().collect(Collectors.joining("\n"));
            System.out.println(results);
        }

        public void alterTopic(TopicCommandOptions opts) throws ExecutionException, InterruptedException {
            CommandTopicPartition topic = new CommandTopicPartition(opts);
            List<String> topics = this.getTopics(opts.topic(), opts.excludeInternalTopics());
            TopicCommand.ensureTopicExists(topics, opts.topic().orElse(""), opts.ifExists() == false);
            if (!topics.isEmpty()) {
                Map topicsInfo = this.adminClient.describeTopics(topics).topicNameValues();
                Map<String, NewPartitions> newPartitions = topics.stream().map(topicName -> this.topicNewPartitions(topic, topicsInfo, (String)topicName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                this.adminClient.createPartitions(newPartitions, new CreatePartitionsOptions().retryOnQuotaViolation(false)).all().get();
            }
        }

        private AbstractMap.SimpleEntry<String, NewPartitions> topicNewPartitions(CommandTopicPartition topic, Map<String, KafkaFuture<org.apache.kafka.clients.admin.TopicDescription>> topicsInfo, String topicName) {
            if (topic.hasReplicaAssignment().booleanValue()) {
                try {
                    Integer startPartitionId = ((org.apache.kafka.clients.admin.TopicDescription)topicsInfo.get(topicName).get()).partitions().size();
                    Map<Integer, List> replicaMap = topic.replicaAssignment.entrySet().stream().skip(startPartitionId.intValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    ArrayList<List> newAssignment = new ArrayList<List>(replicaMap.values());
                    return new AbstractMap.SimpleEntry<String, NewPartitions>(topicName, NewPartitions.increaseTo((int)((Integer)topic.partitions.get()), newAssignment));
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return new AbstractMap.SimpleEntry<String, NewPartitions>(topicName, NewPartitions.increaseTo((int)((Integer)topic.partitions.get())));
        }

        public Map<TopicPartition, PartitionReassignment> listAllReassignments(Set<TopicPartition> topicPartitions) {
            try {
                return (Map)this.adminClient.listPartitionReassignments(topicPartitions).reassignments().get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnsupportedVersionException || cause instanceof ClusterAuthorizationException) {
                    LOG.debug("Couldn't query reassignments through the AdminClient API: " + cause.getMessage(), cause);
                    return Collections.emptyMap();
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void describeTopic(TopicCommandOptions opts) throws ExecutionException, InterruptedException {
            Map descTopics;
            List<String> topics;
            List<Object> topicIds;
            Optional<Uuid> inputTopicId = opts.topicId().map(Uuid::fromString).filter(uuid -> uuid != Uuid.ZERO_UUID);
            Boolean useTopicId = inputTopicId.isPresent();
            if (useTopicId.booleanValue()) {
                topicIds = this.getTopicIds(inputTopicId.get(), opts.excludeInternalTopics());
                topics = Collections.emptyList();
            } else {
                topicIds = Collections.emptyList();
                topics = this.getTopics(opts.topic(), opts.excludeInternalTopics());
            }
            if (useTopicId.booleanValue()) {
                TopicCommand.ensureTopicIdExists(topicIds, inputTopicId.get(), opts.ifExists() == false);
            } else {
                TopicCommand.ensureTopicExists(topics, opts.topic().orElse(""), opts.ifExists() == false);
            }
            ArrayList<Object> topicDescriptions = new ArrayList();
            if (!topicIds.isEmpty()) {
                descTopics = (Map)this.adminClient.describeTopics((TopicCollection)TopicCollection.ofTopicIds(topicIds)).allTopicIds().get();
                topicDescriptions = new ArrayList(descTopics.values());
            }
            if (!topics.isEmpty()) {
                descTopics = (Map)this.adminClient.describeTopics((TopicCollection)TopicCollection.ofTopicNames(topics)).allTopicNames().get();
                topicDescriptions = new ArrayList(descTopics.values());
            }
            List topicNames = topicDescriptions.stream().map(org.apache.kafka.clients.admin.TopicDescription::name).collect(Collectors.toList());
            Map allConfigs = this.adminClient.describeConfigs((Collection)topicNames.stream().map(name -> new ConfigResource(ConfigResource.Type.TOPIC, name)).collect(Collectors.toList())).values();
            List liveBrokers = ((Collection)this.adminClient.describeCluster().nodes().get()).stream().map(Node::id).collect(Collectors.toList());
            DescribeOptions describeOptions = new DescribeOptions(opts, new HashSet<Integer>(liveBrokers));
            Set<TopicPartition> topicPartitions = topicDescriptions.stream().flatMap(td -> td.partitions().stream().map(p -> new TopicPartition(td.name(), p.partition()))).collect(Collectors.toSet());
            Map<TopicPartition, PartitionReassignment> reassignments = this.listAllReassignments(topicPartitions);
            for (org.apache.kafka.clients.admin.TopicDescription topicDescription : topicDescriptions) {
                String topicName = topicDescription.name();
                Uuid topicId = topicDescription.topicId();
                Config config = (Config)((KafkaFuture)allConfigs.get(new ConfigResource(ConfigResource.Type.TOPIC, topicName))).get();
                ArrayList<TopicPartitionInfo> sortedPartitions = new ArrayList<TopicPartitionInfo>(topicDescription.partitions());
                sortedPartitions.sort(Comparator.comparingInt(TopicPartitionInfo::partition));
                this.printDescribeConfig(opts, describeOptions, reassignments, topicDescription, topicName, topicId, config, sortedPartitions);
                this.printPartitionDescription(describeOptions, reassignments, topicDescription, topicName, config, sortedPartitions);
            }
        }

        private void printPartitionDescription(DescribeOptions describeOptions, Map<TopicPartition, PartitionReassignment> reassignments, org.apache.kafka.clients.admin.TopicDescription td, String topicName, Config config, ArrayList<TopicPartitionInfo> sortedPartitions) {
            if (describeOptions.describePartitions) {
                for (TopicPartitionInfo partition : sortedPartitions) {
                    PartitionReassignment reassignment = reassignments.get(new TopicPartition(td.name(), partition.partition()));
                    PartitionDescription partitionDesc = new PartitionDescription(topicName, partition, config, false, reassignment);
                    describeOptions.maybePrintPartitionDescription(partitionDesc);
                }
            }
        }

        private void printDescribeConfig(TopicCommandOptions opts, DescribeOptions describeOptions, Map<TopicPartition, PartitionReassignment> reassignments, org.apache.kafka.clients.admin.TopicDescription td, String topicName, Uuid topicId, Config config, ArrayList<TopicPartitionInfo> sortedPartitions) {
            if (describeOptions.describeConfigs) {
                ArrayList entries = new ArrayList(config.entries());
                boolean hasNonDefault = entries.stream().anyMatch(e -> !e.isDefault());
                if (!opts.reportOverriddenConfigs().booleanValue() || hasNonDefault) {
                    int numPartitions = td.partitions().size();
                    TopicPartitionInfo firstPartition = sortedPartitions.get(0);
                    PartitionReassignment reassignment = reassignments.get(new TopicPartition(td.name(), firstPartition.partition()));
                    TopicDescription topicDesc = new TopicDescription(topicName, topicId, numPartitions, TopicCommand.getReplicationFactor(firstPartition, reassignment), config, false);
                    topicDesc.printDescription();
                }
            }
        }

        public void deleteTopic(TopicCommandOptions opts) throws ExecutionException, InterruptedException {
            List<String> topics = this.getTopics(opts.topic(), opts.excludeInternalTopics());
            TopicCommand.ensureTopicExists(topics, opts.topic().orElse(""), opts.ifExists() == false);
            this.adminClient.deleteTopics(Collections.unmodifiableList(topics), new DeleteTopicsOptions().retryOnQuotaViolation(false)).all().get();
        }

        public List<String> getTopics(Optional<String> topicIncludeList, boolean excludeInternalTopics) throws ExecutionException, InterruptedException {
            ListTopicsOptions listTopicsOptions = new ListTopicsOptions();
            if (!excludeInternalTopics) {
                listTopicsOptions.listInternal(true);
            }
            Set allTopics = (Set)this.adminClient.listTopics(listTopicsOptions).names().get();
            return TopicCommand.doGetTopics(allTopics.stream().sorted().collect(Collectors.toList()), topicIncludeList, excludeInternalTopics);
        }

        public List<Uuid> getTopicIds(Uuid topicIdIncludeList, boolean excludeInternalTopics) throws ExecutionException, InterruptedException {
            ListTopicsResult allTopics = excludeInternalTopics ? this.adminClient.listTopics() : this.adminClient.listTopics(new ListTopicsOptions().listInternal(true));
            List allTopicIds = ((Collection)allTopics.listings().get()).stream().map(TopicListing::topicId).sorted().collect(Collectors.toList());
            return allTopicIds.contains(topicIdIncludeList) ? Collections.singletonList(topicIdIncludeList) : Collections.emptyList();
        }

        @Override
        public void close() throws Exception {
            this.adminClient.close();
        }
    }

    static class DescribeOptions {
        private final TopicCommandOptions opts;
        private final Set<Integer> liveBrokers;
        private final boolean describeConfigs;
        private final boolean describePartitions;

        public DescribeOptions(TopicCommandOptions opts, Set<Integer> liveBrokers) {
            this.opts = opts;
            this.liveBrokers = liveBrokers;
            this.describeConfigs = opts.reportUnavailablePartitions() == false && opts.reportUnderReplicatedPartitions() == false && opts.reportUnderMinIsrPartitions() == false && opts.reportAtMinIsrPartitions() == false;
            this.describePartitions = opts.reportOverriddenConfigs() == false;
        }

        private boolean shouldPrintUnderReplicatedPartitions(PartitionDescription partitionDescription) {
            return this.opts.reportUnderReplicatedPartitions() != false && partitionDescription.isUnderReplicated() != false;
        }

        private boolean shouldPrintUnavailablePartitions(PartitionDescription partitionDescription) {
            return this.opts.reportUnavailablePartitions() != false && partitionDescription.hasUnavailablePartitions(this.liveBrokers) != false;
        }

        private boolean shouldPrintUnderMinIsrPartitions(PartitionDescription partitionDescription) {
            return this.opts.reportUnderMinIsrPartitions() != false && partitionDescription.isUnderMinIsr() != false;
        }

        private boolean shouldPrintAtMinIsrPartitions(PartitionDescription partitionDescription) {
            return this.opts.reportAtMinIsrPartitions() != false && partitionDescription.isAtMinIsrPartitions() != false;
        }

        private boolean shouldPrintTopicPartition(PartitionDescription partitionDesc) {
            return this.describeConfigs || this.shouldPrintUnderReplicatedPartitions(partitionDesc) || this.shouldPrintUnavailablePartitions(partitionDesc) || this.shouldPrintUnderMinIsrPartitions(partitionDesc) || this.shouldPrintAtMinIsrPartitions(partitionDesc);
        }

        public void maybePrintPartitionDescription(PartitionDescription desc) {
            if (this.shouldPrintTopicPartition(desc)) {
                desc.printDescription();
            }
        }
    }

    static class PartitionDescription {
        private final String topic;
        private final TopicPartitionInfo info;
        private final Config config;
        private final Boolean markedForDeletion;
        private final PartitionReassignment reassignment;

        PartitionDescription(String topic, TopicPartitionInfo info, Config config, Boolean markedForDeletion, PartitionReassignment reassignment) {
            this.topic = topic;
            this.info = info;
            this.config = config;
            this.markedForDeletion = markedForDeletion;
            this.reassignment = reassignment;
        }

        public Integer minIsrCount() {
            return Integer.parseInt(this.config.get("min.insync.replicas").value());
        }

        public Boolean isUnderReplicated() {
            return TopicCommand.getReplicationFactor(this.info, this.reassignment) - this.info.isr().size() > 0;
        }

        public boolean hasLeader() {
            return this.info.leader() != null;
        }

        public Boolean isUnderMinIsr() {
            return !this.hasLeader() || this.info.isr().size() < this.minIsrCount();
        }

        public Boolean isAtMinIsrPartitions() {
            return this.minIsrCount().intValue() == this.info.isr().size();
        }

        public Boolean hasUnavailablePartitions(Set<Integer> liveBrokers) {
            return !this.hasLeader() || !liveBrokers.contains(this.info.leader().id());
        }

        public void printDescription() {
            System.out.print("\tTopic: " + this.topic);
            System.out.print("\tPartition: " + this.info.partition());
            System.out.print("\tLeader: " + (this.hasLeader() ? Integer.valueOf(this.info.leader().id()) : "none"));
            System.out.print("\tReplicas: " + this.info.replicas().stream().map(node -> Integer.toString(node.id())).collect(Collectors.joining(",")));
            System.out.print("\tIsr: " + this.info.isr().stream().map(node -> Integer.toString(node.id())).collect(Collectors.joining(",")));
            if (this.reassignment != null) {
                System.out.print("\tAdding Replicas: " + this.reassignment.addingReplicas().stream().map(node -> node.toString()).collect(Collectors.joining(",")));
                System.out.print("\tRemoving Replicas: " + this.reassignment.removingReplicas().stream().map(node -> node.toString()).collect(Collectors.joining(",")));
            }
            System.out.print(this.markedForDeletion != false ? "\tMarkedForDeletion: true" : "");
            System.out.println();
        }
    }

    static class TopicDescription {
        private final String topic;
        private final Uuid topicId;
        private final Integer numPartitions;
        private final Integer replicationFactor;
        private final Config config;
        private final Boolean markedForDeletion;

        public TopicDescription(String topic, Uuid topicId, Integer numPartitions, Integer replicationFactor, Config config, Boolean markedForDeletion) {
            this.topic = topic;
            this.topicId = topicId;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.config = config;
            this.markedForDeletion = markedForDeletion;
        }

        public void printDescription() {
            String configsAsString = this.config.entries().stream().filter(config -> !config.isDefault()).map(ce -> ce.name() + "=" + ce.value()).collect(Collectors.joining(","));
            System.out.print("Topic: " + this.topic);
            if (this.topicId != Uuid.ZERO_UUID) {
                System.out.print("\tTopicId: " + this.topicId);
            }
            System.out.print("\tPartitionCount: " + this.numPartitions);
            System.out.print("\tReplicationFactor: " + this.replicationFactor);
            System.out.print("\tConfigs: " + configsAsString);
            System.out.print(this.markedForDeletion != false ? "\tMarkedForDeletion: true" : "");
            System.out.println();
        }
    }

    static class CommandTopicPartition {
        private final String name;
        private final Optional<Integer> partitions;
        private final Optional<Integer> replicationFactor;
        private final Map<Integer, List<Integer>> replicaAssignment;
        private final Properties configsToAdd;
        private final TopicCommandOptions opts;

        public CommandTopicPartition(TopicCommandOptions options) {
            this.opts = options;
            this.name = options.topic().get();
            this.partitions = options.partitions();
            this.replicationFactor = options.replicationFactor();
            this.replicaAssignment = options.replicaAssignment().orElse(Collections.emptyMap());
            this.configsToAdd = TopicCommand.parseTopicConfigsToBeAdded(options);
        }

        public Boolean hasReplicaAssignment() {
            return !this.replicaAssignment.isEmpty();
        }

        public Boolean ifTopicDoesntExist() {
            return this.opts.ifNotExists();
        }
    }
}

