/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;

public class ClusterTool {
    public static void main(String ... args) {
        Exit.exit((int)ClusterTool.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            ClusterTool.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void execute(String ... args) throws Exception {
        parser = ArgumentParsers.newArgumentParser((String)"kafka-cluster").defaultHelp(true).description("The Kafka cluster tool.");
        subparsers = parser.addSubparsers().dest("command");
        clusterIdParser = subparsers.addParser("cluster-id").help("Get information about the ID of a cluster.");
        unregisterParser = subparsers.addParser("unregister").help("Unregister a broker.");
        for (Subparser subpparser : Arrays.asList(new Subparser[]{clusterIdParser, unregisterParser})) {
            connectionOptions = subpparser.addMutuallyExclusiveGroup().required(true);
            connectionOptions.addArgument(new String[]{"--bootstrap-server", "-b"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the Kafka cluster.");
            connectionOptions.addArgument(new String[]{"--bootstrap-controller", "-C"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the KRaft controllers.");
            subpparser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).help("A property file containing configurations for the Admin client.");
        }
        unregisterParser.addArgument(new String[]{"--id", "-i"}).type(Integer.class).action((ArgumentAction)Arguments.store()).required(true).help("The ID of the broker to unregister.");
        namespace = parser.parseArgsOrFail(args);
        command = namespace.getString("command");
        configPath = namespace.getString("config");
        properties = configPath == null ? new Properties() : Utils.loadProps((String)configPath);
        CommandLineUtils.initializeBootstrapProperties((Properties)properties, Optional.ofNullable(namespace.getString("bootstrap_server")), Optional.ofNullable(namespace.getString("bootstrap_controller")));
        var9_9 = command;
        var10_10 = -1;
        switch (var9_9.hashCode()) {
            case 240232910: {
                if (!var9_9.equals("cluster-id")) break;
                var10_10 = 0;
                break;
            }
            case 836015164: {
                if (!var9_9.equals("unregister")) break;
                var10_10 = 1;
            }
        }
        switch (var10_10) {
            case 0: {
                adminClient = Admin.create((Properties)properties);
                var12_13 = null;
                ClusterTool.clusterIdCommand(System.out, adminClient);
                if (adminClient == null) break;
                if (var12_13 == null) ** GOTO lbl45
                try {
                    adminClient.close();
                }
                catch (Throwable var13_15) {
                    var12_13.addSuppressed(var13_15);
                }
                break;
lbl45:
                // 1 sources

                adminClient.close();
                break;
                catch (Throwable var13_16) {
                    try {
                        var12_13 = var13_16;
                        throw var13_16;
                    }
                    catch (Throwable var14_19) {
                        if (adminClient != null) {
                            if (var12_13 != null) {
                                try {
                                    adminClient.close();
                                }
                                catch (Throwable var15_20) {
                                    var12_13.addSuppressed(var15_20);
                                }
                            } else {
                                adminClient.close();
                            }
                        }
                        throw var14_19;
                    }
                }
            }
            case 1: {
                adminClient = Admin.create((Properties)properties);
                var12_14 = null;
                ClusterTool.unregisterCommand(System.out, adminClient, namespace.getInt("id"));
                if (adminClient == null) break;
                if (var12_14 == null) ** GOTO lbl75
                try {
                    adminClient.close();
                }
                catch (Throwable var13_17) {
                    var12_14.addSuppressed(var13_17);
                }
                break;
lbl75:
                // 1 sources

                adminClient.close();
                break;
                catch (Throwable var13_18) {
                    try {
                        var12_14 = var13_18;
                        throw var13_18;
                    }
                    catch (Throwable var16_21) {
                        if (adminClient != null) {
                            if (var12_14 != null) {
                                try {
                                    adminClient.close();
                                }
                                catch (Throwable var17_22) {
                                    var12_14.addSuppressed(var17_22);
                                }
                            } else {
                                adminClient.close();
                            }
                        }
                        throw var16_21;
                    }
                }
            }
            default: {
                throw new RuntimeException("Unknown command " + command);
            }
        }
    }

    static void clusterIdCommand(PrintStream stream, Admin adminClient) throws Exception {
        String clusterId = (String)adminClient.describeCluster().clusterId().get();
        if (clusterId != null) {
            stream.println("Cluster ID: " + clusterId);
        } else {
            stream.println("No cluster ID found. The Kafka version is probably too old.");
        }
    }

    static void unregisterCommand(PrintStream stream, Admin adminClient, int id) throws Exception {
        try {
            adminClient.unregisterBroker(id).all().get();
            stream.println("Broker " + id + " is no longer registered.");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof UnsupportedVersionException) {
                stream.println("The target cluster does not support the broker unregistration API.");
            }
            throw ee;
        }
    }
}

