/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.config.Config;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.remote.RemoteInterfaceMeta;
import org.apache.juneau.remote.RemoteInterfaceMethod;
import org.apache.juneau.rest.BasicRestCallHandler;
import org.apache.juneau.rest.BasicRestCallLogger;
import org.apache.juneau.rest.BasicRestInfoProvider;
import org.apache.juneau.rest.BasicRestResourceResolver;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.MessageBundleLocation;
import org.apache.juneau.rest.NoOpRestLogger;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestCallRouter;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestContextStats;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodContextBuilder;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamDefaults;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.StaticFiles;
import org.apache.juneau.rest.annotation.Attr;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.RestInfoVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.rest.vars.WidgetVar;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceFinderBasic;
import org.apache.juneau.utils.ClasspathResourceManager;
import org.apache.juneau.utils.ExtendedMimetypesFileTypeMap;
import org.apache.juneau.utils.MessageBundle;
import org.apache.juneau.utils.MethodExecStats;
import org.apache.juneau.utils.MethodInvoker;
import org.apache.juneau.utils.StackTraceDatabase;
import org.apache.juneau.xml.XmlParser;

@ConfigurableContext(nocache=true)
public final class RestContext
extends BeanContext {
    static final String PREFIX = "RestContext";
    public static final String REST_allowBodyParam = "RestContext.allowBodyParam.b";
    public static final String REST_allowedHeaderParams = "RestContext.allowedHeaderParams.s";
    public static final String REST_allowedMethodHeaders = "RestContext.allowedMethodHeaders.s";
    public static final String REST_allowedMethodParams = "RestContext.allowedMethodParams.s";
    @Deprecated
    public static final String REST_allowHeaderParams = "RestContext.allowHeaderParams.b";
    public static final String REST_callHandler = "RestContext.callHandler.o";
    public static final String REST_callLogger = "RestContext.callLogger.o";
    public static final String REST_callLoggerConfig = "RestContext.callLoggerConfig.o";
    public static final String REST_children = "RestContext.children.lo";
    public static final String REST_classpathResourceFinder = "RestContext.classpathResourceFinder.o";
    public static final String REST_clientVersionHeader = "RestContext.clientVersionHeader.s";
    public static final String REST_converters = "RestContext.converters.lo";
    public static final String REST_debug = "RestContext.debug.s";
    public static final String REST_defaultCharset = "RestContext.defaultCharset.s";
    @Deprecated
    public static final String REST_attrs = "RestContext.reqAttrs.smo";
    @Deprecated
    public static final String REST_defaultRequestHeaders = "RestContext.reqHeaders.smo";
    @Deprecated
    public static final String REST_defaultResponseHeaders = "RestContext.resHeaders.omo";
    public static final String REST_encoders = "RestContext.encoders.lo";
    public static final String REST_guards = "RestContext.guards.lo";
    public static final String REST_infoProvider = "RestContext.infoProvider.o";
    @Deprecated
    public static final String REST_logger = "RestContext.logger.o";
    public static final String REST_maxInput = "RestContext.maxInput.s";
    public static final String REST_messages = "RestContext.messages.lo";
    public static final String REST_mimeTypes = "RestContext.mimeTypes.ss";
    public static final String REST_paramResolvers = "RestContext.paramResolvers.lo";
    public static final String REST_parsers = "RestContext.parsers.lo";
    public static final String REST_partParser = "RestContext.partParser.o";
    public static final String REST_partSerializer = "RestContext.partSerializer.o";
    public static final String REST_path = "RestContext.path.s";
    public static final String REST_renderResponseStackTraces = "RestContext.renderResponseStackTraces.b";
    public static final String REST_reqAttrs = "RestContext.reqAttrs.smo";
    public static final String REST_reqHeaders = "RestContext.reqHeaders.smo";
    public static final String REST_resHeaders = "RestContext.resHeaders.omo";
    public static final String REST_resourceResolver = "RestContext.resourceResolver.o";
    public static final String REST_responseHandlers = "RestContext.responseHandlers.lo";
    public static final String REST_rolesDeclared = "RestContext.rolesDeclared.ss";
    public static final String REST_roleGuard = "RestContext.roleGuard.ss";
    public static final String REST_serializers = "RestContext.serializers.lo";
    public static final String REST_staticFileResponseHeaders = "RestContext.staticFileResponseHeaders.omo";
    public static final String REST_staticFiles = "RestContext.staticFiles.lo";
    public static final String REST_produces = "RestContext.produces.ls";
    public static final String REST_properties = "RestContext.properties.sms";
    public static final String REST_consumes = "RestContext.consumes.ls";
    public static final String REST_useClasspathResourceCaching = "RestContext.useClasspathResourceCaching.b";
    @Deprecated
    public static final String REST_useStackTraceHashes = "RestContext.useStackTraceHashes.b";
    public static final String REST_uriAuthority = "RestContext.uriAuthority.s";
    public static final String REST_uriContext = "RestContext.uriContext.s";
    public static final String REST_uriRelativity = "RestContext.uriRelativity.s";
    public static final String REST_uriResolution = "RestContext.uriResolution.s";
    @Deprecated
    public static final String REST_widgets = "RestContext.widgets.lo";
    private final Object resource;
    final RestContextBuilder builder;
    private final boolean allowBodyParam;
    private final boolean renderResponseStackTraces;
    private final boolean useClasspathResourceCaching;
    private final Enablement debug;
    @Deprecated
    private final boolean useStackTraceHashes;
    private final String clientVersionHeader;
    private final String uriAuthority;
    private final String uriContext;
    final String fullPath;
    final UrlPathPattern pathPattern;
    private final Set<String> allowedMethodParams;
    private final Set<String> allowedHeaderParams;
    private final Set<String> allowedMethodHeaders;
    private final RestContextProperties properties;
    private final Map<Class<?>, RestMethodParam> paramResolvers;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final Map<String, Object> reqHeaders;
    private final Map<String, Object> resHeaders;
    private final Map<String, Object> staticFileResponseHeaders;
    private final ObjectMap reqAttrs;
    private final ResponseHandler[] responseHandlers;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final StaticFiles[] staticFiles;
    private final String[] staticFilesPaths;
    private final MessageBundle msgs;
    private final Config config;
    private final VarResolver varResolver;
    private final Map<String, RestCallRouter> callRouters;
    private final Map<String, RestMethodContext> callMethods;
    private final Map<String, RestContext> childResources;
    private final RestLogger logger;
    private final RestCallLogger callLogger;
    private final RestCallLoggerConfig callLoggerConfig;
    private final StackTraceDatabase stackTraceDb;
    private final RestCallHandler callHandler;
    private final RestInfoProvider infoProvider;
    private final HttpException initException;
    private final RestContext parentContext;
    private final RestResourceResolver resourceResolver;
    private final UriResolution uriResolution;
    private final UriRelativity uriRelativity;
    private final ConcurrentHashMap<String, MethodExecStats> methodExecStats = new ConcurrentHashMap();
    private final Instant startTime;
    private final MethodInvoker[] postInitMethods;
    private final MethodInvoker[] postInitChildFirstMethods;
    private final MethodInvoker[] preCallMethods;
    private final MethodInvoker[] postCallMethods;
    private final MethodInvoker[] startCallMethods;
    private final MethodInvoker[] endCallMethods;
    private final MethodInvoker[] destroyMethods;
    private final RestMethodParam[][] preCallMethodParams;
    private final RestMethodParam[][] postCallMethodParams;
    private final Class<?>[][] postInitMethodParams;
    private final Class<?>[][] postInitChildFirstMethodParams;
    private final Class<?>[][] startCallMethodParams;
    private final Class<?>[][] endCallMethodParams;
    private final Class<?>[][] destroyMethodParams;
    private final Map<String, StaticFile> staticFilesCache = new ConcurrentHashMap<String, StaticFile>();
    private final ClasspathResourceManager staticResourceManager;
    @Deprecated
    private final ConcurrentHashMap<Integer, AtomicInteger> stackTraceHashes = new ConcurrentHashMap();
    private final ThreadLocal<RestRequest> req = new ThreadLocal();
    private final ThreadLocal<RestResponse> res = new ThreadLocal();

    public static RestContextBuilder create(Object resource) throws ServletException {
        return new RestContextBuilder(null, resource.getClass(), null).init(resource);
    }

    static RestContextBuilder create(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        return new RestContextBuilder(servletConfig, resourceClass, parentContext);
    }

    RestContext(RestContextBuilder builder) throws Exception {
        super(builder.getPropertyStore());
        this.startTime = Instant.now();
        HttpException _initException = null;
        try {
            Object clc;
            ServletContext servletContext = builder.servletContext;
            this.resource = builder.resource;
            this.builder = builder;
            this.parentContext = builder.parentContext;
            this.resourceResolver = (RestResourceResolver)this.getInstanceProperty(REST_resourceResolver, this.resource, RestResourceResolver.class, this.parentContext == null ? BasicRestResourceResolver.class : this.parentContext.resourceResolver, ResourceResolver.FUZZY, new Object[]{this});
            this.varResolver = builder.varResolverBuilder.vars(new Class[]{FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RestInfoVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, WidgetVar.class}).build();
            VarResolverSession vrs = this.varResolver.createSession();
            this.config = builder.config.resolving(vrs);
            ClassInfo rci = ClassInfo.of((Object)this.resource);
            PropertyStore ps = this.getPropertyStore();
            this.uriContext = StringUtils.nullIfEmpty((String)this.getStringProperty(REST_uriContext, null));
            this.uriAuthority = StringUtils.nullIfEmpty((String)this.getStringProperty(REST_uriAuthority, null));
            this.uriResolution = (UriResolution)this.getProperty(REST_uriResolution, UriResolution.class, UriResolution.ROOT_RELATIVE);
            this.uriRelativity = (UriRelativity)this.getProperty(REST_uriRelativity, UriRelativity.class, UriRelativity.RESOURCE);
            this.allowBodyParam = this.getBooleanProperty(REST_allowBodyParam, true);
            this.allowedHeaderParams = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet((String)this.getStringPropertyWithNone(REST_allowedHeaderParams, "Accept,Content-Type"));
            this.allowedMethodParams = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet((String)this.getStringPropertyWithNone(REST_allowedMethodParams, "HEAD,OPTIONS"));
            this.allowedMethodHeaders = CollectionUtils.newUnmodifiableSortedCaseInsensitiveSet((String)this.getStringPropertyWithNone(REST_allowedMethodHeaders, ""));
            this.renderResponseStackTraces = this.getBooleanProperty(REST_renderResponseStackTraces, false);
            this.useStackTraceHashes = this.getBooleanProperty(REST_useStackTraceHashes, true);
            this.debug = (Enablement)((Object)this.getInstanceProperty(REST_debug, Enablement.class, (Object)Enablement.FALSE));
            this.clientVersionHeader = this.getStringProperty(REST_clientVersionHeader, "X-Client-Version");
            this.responseHandlers = (ResponseHandler[])this.getInstanceArrayProperty(REST_responseHandlers, this.resource, ResponseHandler.class, new ResponseHandler[0], this.resourceResolver, new Object[]{this});
            HashMap _paramResolvers = new HashMap();
            for (RestMethodParam rp : (RestMethodParam[])this.getInstanceArrayProperty(REST_paramResolvers, RestMethodParam.class, new RestMethodParam[0], this.resourceResolver, new Object[]{this})) {
                _paramResolvers.put(rp.forClass(), rp);
            }
            this.paramResolvers = CollectionUtils.unmodifiableMap(_paramResolvers);
            TreeMap _reqHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            _reqHeaders.putAll(this.getMapProperty("RestContext.reqHeaders.smo", String.class));
            this.reqHeaders = CollectionUtils.unmodifiableMap(new LinkedHashMap(_reqHeaders));
            this.reqAttrs = new ObjectMap(this.getMapProperty("RestContext.reqAttrs.smo", Object.class)).unmodifiable();
            this.resHeaders = this.getMapProperty("RestContext.resHeaders.omo", Object.class);
            this.staticFileResponseHeaders = this.getMapProperty(REST_staticFileResponseHeaders, Object.class);
            this.logger = (RestLogger)this.getInstanceProperty(REST_logger, this.resource, RestLogger.class, NoOpRestLogger.class, this.resourceResolver, new Object[]{this});
            this.callLoggerConfig = this.debug == Enablement.TRUE ? RestCallLoggerConfig.DEFAULT_DEBUG : ((clc = this.getProperty(REST_callLoggerConfig)) instanceof RestCallLoggerConfig ? (RestCallLoggerConfig)clc : (clc instanceof ObjectMap ? RestCallLoggerConfig.create().apply((ObjectMap)clc).build() : RestCallLoggerConfig.DEFAULT));
            this.stackTraceDb = new StackTraceDatabase((long)this.callLoggerConfig.getStackTraceHashingTimeout(), RestMethodContext.class);
            this.callLogger = (RestCallLogger)this.getInstanceProperty(REST_callLogger, this.resource, RestCallLogger.class, BasicRestCallLogger.class, this.resourceResolver, new Object[]{this});
            this.properties = builder.properties;
            this.serializers = SerializerGroup.create().append((Serializer[])this.getInstanceArrayProperty(REST_serializers, Serializer.class, new Serializer[0], this.resourceResolver, new Object[]{this.resource, ps})).build();
            this.parsers = ParserGroup.create().append((Parser[])this.getInstanceArrayProperty(REST_parsers, Parser.class, new Parser[0], this.resourceResolver, new Object[]{this.resource, ps})).build();
            this.partSerializer = (HttpPartSerializer)SerializerGroup.create().append(new Object[]{this.getInstanceProperty(REST_partSerializer, HttpPartSerializer.class, OpenApiSerializer.class, this.resourceResolver, new Object[]{this.resource, ps})}).build().getSerializers().get(0);
            this.partParser = (HttpPartParser)ParserGroup.create().append(new Object[]{this.getInstanceProperty(REST_partParser, HttpPartParser.class, OpenApiParser.class, this.resourceResolver, new Object[]{this.resource, ps})}).build().getParsers().get(0);
            this.jsonSchemaGenerator = JsonSchemaGenerator.create().apply(ps).build();
            this.mimetypesFileTypeMap = new ExtendedMimetypesFileTypeMap();
            for (String string : (String[])this.getArrayProperty(REST_mimeTypes, String.class)) {
                this.mimetypesFileTypeMap.addMimeTypes(string);
            }
            ClasspathResourceFinder rf = (ClasspathResourceFinder)this.getInstanceProperty(REST_classpathResourceFinder, ClasspathResourceFinder.class, ClasspathResourceFinderBasic.class, this.resourceResolver, new Object[]{this});
            this.useClasspathResourceCaching = (Boolean)this.getProperty(REST_useClasspathResourceCaching, Boolean.TYPE, true);
            this.staticResourceManager = new ClasspathResourceManager(rci.getProxiedClass(), rf, this.useClasspathResourceCaching);
            this.consumes = this.getListProperty(REST_consumes, MediaType.class, this.parsers.getSupportedMediaTypes());
            this.produces = this.getListProperty(REST_produces, MediaType.class, this.serializers.getSupportedMediaTypes());
            StaticFileMapping[] staticFileMappings = (StaticFileMapping[])this.getArrayProperty(REST_staticFiles, StaticFileMapping.class, new StaticFileMapping[0]);
            this.staticFiles = new StaticFiles[staticFileMappings.length];
            for (int i = 0; i < this.staticFiles.length; ++i) {
                this.staticFiles[i] = new StaticFiles(staticFileMappings[i], this.staticResourceManager, this.mimetypesFileTypeMap, this.staticFileResponseHeaders);
            }
            TreeSet<String> s = new TreeSet<String>();
            for (StaticFiles sf : this.staticFiles) {
                s.add(sf.getPath());
            }
            this.staticFilesPaths = s.toArray(new String[s.size()]);
            MessageBundleLocation[] messageBundleLocationArray = (MessageBundleLocation[])this.getInstanceArrayProperty(REST_messages, MessageBundleLocation.class, new MessageBundleLocation[0]);
            if (messageBundleLocationArray.length == 0) {
                this.msgs = new MessageBundle(rci.getProxiedClass(), "");
            } else {
                this.msgs = new MessageBundle(messageBundleLocationArray[0] != null ? messageBundleLocationArray[0].baseClass : rci.getProxiedClass(), messageBundleLocationArray[0].bundlePath);
                for (int i = 1; i < messageBundleLocationArray.length; ++i) {
                    this.msgs.addSearchPath(messageBundleLocationArray[i] != null ? messageBundleLocationArray[i].baseClass : rci.getProxiedClass(), messageBundleLocationArray[i].bundlePath);
                }
            }
            this.fullPath = (builder.parentContext == null ? "" : builder.parentContext.fullPath + '/') + builder.getPath();
            String p = builder.getPath();
            if (!p.endsWith("/*")) {
                p = p + "/*";
            }
            this.pathPattern = new UrlPathPattern(p);
            this.childResources = Collections.synchronizedMap(new LinkedHashMap());
            LinkedList<String> methodsFound = new LinkedList<String>();
            LinkedHashMap<String, RestCallRouter.Builder> routers = new LinkedHashMap<String, RestCallRouter.Builder>();
            LinkedHashMap<String, RestMethodContext> _javaRestMethods = new LinkedHashMap<String, RestMethodContext>();
            LinkedHashMap<String, java.lang.reflect.Method> _startCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _preCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _endCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitChildFirstMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _destroyMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            ArrayList<RestMethodParam[]> _preCallMethodParams = new ArrayList<RestMethodParam[]>();
            ArrayList<RestMethodParam[]> _postCallMethodParams = new ArrayList<RestMethodParam[]>();
            ArrayList<Class[]> _startCallMethodParams = new ArrayList<Class[]>();
            ArrayList<Class[]> _endCallMethodParams = new ArrayList<Class[]>();
            ArrayList<Class[]> _postInitMethodParams = new ArrayList<Class[]>();
            ArrayList<Class[]> _postInitChildFirstMethodParams = new ArrayList<Class[]>();
            ArrayList<Class[]> _destroyMethodParams = new ArrayList<Class[]>();
            for (MethodInfo mi : rci.getPublicMethods()) {
                RestMethod a = (RestMethod)mi.getAnnotation(RestMethod.class);
                if (a == null) continue;
                methodsFound.add(mi.getSimpleName() + "," + StringUtils.emptyIfNull((String)StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.method()})) + "," + RestUtils.fixMethodPath(a.path()));
                try {
                    if (mi.isNotPublic()) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", rci.getProxiedClass().getName(), mi.getSimpleName());
                    }
                    RestMethodContextBuilder rmcb = new RestMethodContextBuilder(this.resource, mi.inner(), this);
                    RestMethodContext sm = new RestMethodContext(rmcb);
                    String httpMethod = sm.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        ClassMeta interfaceClass = this.getClassMeta(mi.inner().getGenericReturnType(), new Type[0]);
                        final RemoteInterfaceMeta rim = new RemoteInterfaceMeta(interfaceClass.getInnerClass(), null);
                        if (rim.getMethodsByPath().isEmpty()) {
                            throw new RestException(500, "Method {0} returns an interface {1} that doesn't define any remote methods.", mi.getSignature(), interfaceClass.getFullName());
                        }
                        RestMethodContextBuilder smb = new RestMethodContextBuilder(this.resource, mi.inner(), this);
                        sm = new RestMethodContext(smb){

                            @Override
                            int invoke(RestCall call) throws Throwable {
                                int rc = super.invoke(call);
                                if (rc != 200) {
                                    return rc;
                                }
                                Object o = call.getOutput();
                                if ("GET".equals(call.getMethod())) {
                                    call.output(rim.getMethodsByPath().keySet());
                                    return 200;
                                }
                                if ("POST".equals(call.getMethod())) {
                                    RemoteInterfaceMethod rmm;
                                    String pip = call.getUrlPathInfo().getPath();
                                    if (pip.indexOf(47) != -1) {
                                        pip = pip.substring(pip.lastIndexOf(47) + 1);
                                    }
                                    if ((rmm = rim.getMethodMetaByPath(pip = StringUtils.urlDecode((String)pip))) != null) {
                                        java.lang.reflect.Method m = rmm.getJavaMethod();
                                        try {
                                            RestRequest req = call.getRestRequest();
                                            Parser p = req.getBody().getParser();
                                            Object[] args = null;
                                            if (m.getGenericParameterTypes().length == 0) {
                                                args = new Object[]{};
                                            } else {
                                                try (BufferedReader in = p.isReaderParser() ? req.getReader() : req.getInputStream();){
                                                    args = p.parseArgs((Object)in, m.getGenericParameterTypes());
                                                }
                                            }
                                            Object output = m.invoke(o, args);
                                            call.output(output);
                                            return 200;
                                        }
                                        catch (Exception e) {
                                            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
                                        }
                                    }
                                }
                                return 404;
                            }
                        };
                        _javaRestMethods.put(mi.getSimpleName(), sm);
                        RestContext.addToRouter(routers, "GET", sm);
                        RestContext.addToRouter(routers, "POST", sm);
                        continue;
                    }
                    _javaRestMethods.put(mi.getSimpleName(), sm);
                    RestContext.addToRouter(routers, httpMethod, sm);
                }
                catch (Throwable e) {
                    throw new RestServletException("Problem occurred trying to serialize methods on class {0}, methods={1}", rci.getProxiedClass().getName(), SimpleJsonSerializer.DEFAULT.serialize(methodsFound)).initCause(e);
                }
            }
            for (MethodInfo m : rci.getAllMethodsParentFirst()) {
                if (!m.isPublic() || !m.hasAnnotation(RestHook.class)) continue;
                HookEvent he = ((RestHook)m.getAnnotation(RestHook.class)).value();
                String sig = m.getSignature();
                switch (he) {
                    case PRE_CALL: {
                        if (_preCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _preCallMethods.put(sig, m.inner());
                        _preCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case POST_CALL: {
                        if (_postCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postCallMethods.put(sig, m.inner());
                        _postCallMethodParams.add(this.findParams(m, true, null));
                        break;
                    }
                    case START_CALL: {
                        if (_startCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _startCallMethods.put(sig, m.inner());
                        _startCallMethodParams.add(m.getRawParamTypes());
                        FormattedIllegalArgumentException.assertArgsOnlyOfType((MethodInfo)m, (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
                        break;
                    }
                    case END_CALL: {
                        if (_endCallMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _endCallMethods.put(sig, m.inner());
                        _endCallMethodParams.add(m.getRawParamTypes());
                        FormattedIllegalArgumentException.assertArgsOnlyOfType((MethodInfo)m, (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
                        break;
                    }
                    case POST_INIT: {
                        if (_postInitMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postInitMethods.put(sig, m.inner());
                        _postInitMethodParams.add(m.getRawParamTypes());
                        FormattedIllegalArgumentException.assertArgsOnlyOfType((MethodInfo)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                    case POST_INIT_CHILD_FIRST: {
                        if (_postInitChildFirstMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _postInitChildFirstMethods.put(sig, m.inner());
                        _postInitChildFirstMethodParams.add(m.getRawParamTypes());
                        FormattedIllegalArgumentException.assertArgsOnlyOfType((MethodInfo)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                    case DESTROY: {
                        if (_destroyMethods.containsKey(sig)) break;
                        m.setAccessible();
                        _destroyMethods.put(sig, m.inner());
                        _destroyMethodParams.add(m.getRawParamTypes());
                        FormattedIllegalArgumentException.assertArgsOnlyOfType((MethodInfo)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                }
            }
            this.callMethods = CollectionUtils.unmodifiableMap(_javaRestMethods);
            this.preCallMethods = _preCallMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_preCallMethods.size()]);
            this.postCallMethods = _postCallMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postCallMethods.size()]);
            this.startCallMethods = _startCallMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_startCallMethods.size()]);
            this.endCallMethods = _endCallMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_endCallMethods.size()]);
            this.postInitMethods = _postInitMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postInitMethods.size()]);
            this.postInitChildFirstMethods = _postInitChildFirstMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_postInitChildFirstMethods.size()]);
            this.destroyMethods = _destroyMethods.values().stream().map(x -> new MethodInvoker(x, this.getMethodExecStats((java.lang.reflect.Method)x))).collect(Collectors.toList()).toArray(new MethodInvoker[_destroyMethods.size()]);
            this.preCallMethodParams = (RestMethodParam[][])_preCallMethodParams.toArray((T[])new RestMethodParam[_preCallMethodParams.size()][]);
            this.postCallMethodParams = (RestMethodParam[][])_postCallMethodParams.toArray((T[])new RestMethodParam[_postCallMethodParams.size()][]);
            this.startCallMethodParams = (Class[][])_startCallMethodParams.toArray((T[])new Class[_startCallMethodParams.size()][]);
            this.endCallMethodParams = (Class[][])_endCallMethodParams.toArray((T[])new Class[_endCallMethodParams.size()][]);
            this.postInitMethodParams = (Class[][])_postInitMethodParams.toArray((T[])new Class[_postInitMethodParams.size()][]);
            this.postInitChildFirstMethodParams = (Class[][])_postInitChildFirstMethodParams.toArray((T[])new Class[_postInitChildFirstMethodParams.size()][]);
            this.destroyMethodParams = (Class[][])_destroyMethodParams.toArray((T[])new Class[_destroyMethodParams.size()][]);
            LinkedHashMap<String, RestCallRouter> _callRouters = new LinkedHashMap<String, RestCallRouter>();
            for (RestCallRouter.Builder crb : routers.values()) {
                _callRouters.put(crb.getHttpMethodName(), crb.build());
            }
            this.callRouters = CollectionUtils.unmodifiableMap(_callRouters);
            for (Object o : this.getArrayProperty(REST_children, Object.class)) {
                String path = null;
                Object r = null;
                if (o instanceof RestChild) {
                    RestChild rc = (RestChild)o;
                    path = rc.path;
                    r = rc.resource;
                } else if (o instanceof Class) {
                    Class c = (Class)o;
                    if (c == builder.resourceClass) continue;
                    r = c;
                } else {
                    r = o;
                }
                RestContextBuilder childBuilder = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    childBuilder = RestContext.create(builder.inner, oc, this);
                    r = this.resourceResolver.resolve(this.resource, oc, childBuilder, new Object[0]);
                } else {
                    r = o;
                    childBuilder = RestContext.create(builder.inner, o.getClass(), this);
                }
                childBuilder.init(r);
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).innerInit(childBuilder);
                }
                childBuilder.servletContext(servletContext);
                RestContext rc2 = childBuilder.build();
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).setContext(rc2);
                }
                path = childBuilder.getPath();
                this.childResources.put(path, rc2);
            }
            this.callHandler = (RestCallHandler)this.getInstanceProperty(REST_callHandler, this.resource, RestCallHandler.class, BasicRestCallHandler.class, this.resourceResolver, new Object[]{this});
            this.infoProvider = (RestInfoProvider)this.getInstanceProperty(REST_infoProvider, this.resource, RestInfoProvider.class, BasicRestInfoProvider.class, this.resourceResolver, new Object[]{this});
        }
        catch (HttpException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new InternalServerError((Throwable)e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private static void addToRouter(Map<String, RestCallRouter.Builder> routers, String httpMethodName, RestMethodContext cm) {
        if (!routers.containsKey(httpMethodName)) {
            routers.put(httpMethodName, new RestCallRouter.Builder(httpMethodName));
        }
        routers.get(httpMethodName).add(cm);
    }

    protected RestResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    protected MethodExecStats getMethodExecStats(java.lang.reflect.Method m) {
        String n = MethodInfo.of((java.lang.reflect.Method)m).getSimpleName();
        MethodExecStats ts = this.methodExecStats.get(n);
        if (ts == null) {
            this.methodExecStats.putIfAbsent(n, new MethodExecStats(m));
            ts = this.methodExecStats.get(n);
        }
        return ts;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Config getConfig() {
        return this.config;
    }

    protected StaticFile resolveStaticFile(String pathInfo) throws NotFound, IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            StaticFiles sf;
            String p = StringUtils.urlDecode((String)StringUtils.trimSlashes((String)pathInfo));
            if (p.indexOf("..") != -1) {
                throw new NotFound("Invalid path");
            }
            StreamResource sr = null;
            StaticFiles[] staticFilesArray = this.staticFiles;
            int n = staticFilesArray.length;
            for (int i = 0; i < n && (sr = (sf = staticFilesArray[i]).resolve(p)) == null; ++i) {
            }
            StaticFile sf2 = new StaticFile(sr);
            if (this.useClasspathResourceCaching) {
                if (this.staticFilesCache.size() > 100) {
                    this.staticFilesCache.clear();
                }
                this.staticFilesCache.put(pathInfo, sf2);
            }
            return sf2;
        }
        return this.staticFilesCache.get(pathInfo);
    }

    public InputStream getClasspathResource(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getStream(name, locale);
    }

    public InputStream getClasspathResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.staticResourceManager.getStream(baseClass, name, locale);
    }

    public String getClasspathResourceAsString(String name, Locale locale) throws IOException {
        return this.staticResourceManager.getString(name, locale);
    }

    public String getClasspathResourceAsString(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.staticResourceManager.getString(baseClass, name, locale);
    }

    public <T> T getClasspathResource(Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        return this.getClasspathResource(null, c, mediaType, name, locale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getClasspathResource(Class<?> baseClass, Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getClasspathResource(baseClass, name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.parsers.getParser(mediaType);
            if (p == null) {
                if (mediaType == MediaType.JSON) {
                    p = JsonParser.DEFAULT;
                }
                if (mediaType == MediaType.XML) {
                    p = XmlParser.DEFAULT;
                }
                if (mediaType == MediaType.HTML) {
                    p = HtmlParser.DEFAULT;
                }
                if (mediaType == MediaType.UON) {
                    p = UonParser.DEFAULT;
                }
                if (mediaType == MediaType.URLENCODING) {
                    p = UrlEncodingParser.DEFAULT;
                }
                if (mediaType == MediaType.MSGPACK) {
                    p = MsgPackParser.DEFAULT;
                }
            }
            if (p == null) throw new ServletException("Unknown media type '" + mediaType + "'");
            try (Closeable in = p.isReaderParser() ? new InputStreamReader(is, IOUtils.UTF8) : is;){
                Object object = p.parse((Object)in, c);
                return (T)object;
            }
            catch (ParseException e) {
                throw new ServletException("Could not parse resource '" + name + " as media type '" + mediaType + "'.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    @Deprecated
    public RestLogger getLogger() {
        return this.logger;
    }

    public RestCallLogger getCallLogger() {
        return this.callLogger;
    }

    public RestCallLoggerConfig getCallLoggerConfig() {
        return this.callLoggerConfig;
    }

    public MessageBundle getMessages() {
        return this.msgs;
    }

    public RestInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    public RestCallHandler getCallHandler() {
        return this.callHandler;
    }

    protected Map<String, RestCallRouter> getCallRouters() {
        return this.callRouters;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServlet getRestServlet() {
        return this.resource instanceof RestServlet ? (RestServlet)((Object)this.resource) : null;
    }

    protected void checkForInitException() throws HttpException {
        if (this.initException != null) {
            throw this.initException;
        }
    }

    public RestContext getParentContext() {
        return this.parentContext;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public Map<String, RestContext> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    @Deprecated
    public int getStackTraceOccurrence(Throwable e) {
        if (!this.useStackTraceHashes) {
            return 0;
        }
        int h = e.hashCode();
        this.stackTraceHashes.putIfAbsent(h, new AtomicInteger());
        return this.stackTraceHashes.get(h).incrementAndGet();
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public boolean isAllowBodyParam() {
        return this.allowBodyParam;
    }

    public Set<String> getAllowedHeaderParams() {
        return this.allowedHeaderParams;
    }

    public Set<String> getAllowedMethodHeaders() {
        return this.allowedMethodHeaders;
    }

    public Set<String> getAllowedMethodParams() {
        return this.allowedMethodParams;
    }

    @Deprecated
    public boolean isDebug() {
        return this.debug == Enablement.TRUE;
    }

    public Enablement getDebug() {
        return this.debug;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Map<String, Object> getReqHeaders() {
        return this.reqHeaders;
    }

    public ObjectMap getReqAttrs() {
        return this.reqAttrs;
    }

    public Map<String, Object> getResHeaders() {
        return this.resHeaders;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    public boolean hasChildResources() {
        return !this.childResources.isEmpty();
    }

    public RestContext getChildResource(String path) {
        return this.childResources.get(path);
    }

    public String getUriAuthority() {
        if (this.uriAuthority != null) {
            return this.uriAuthority;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (this.uriContext != null) {
            return this.uriContext;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public RestMethodParam[] getRestMethodParams(java.lang.reflect.Method method) {
        return this.callMethods.get((Object)method.getName()).methodParams;
    }

    public String getMediaTypeForName(String name) {
        return this.mimetypesFileTypeMap.getContentType(name);
    }

    public boolean isStaticFile(String p) {
        return StringUtils.pathStartsWith((String)p, (String[])this.staticFilesPaths);
    }

    public Map<String, RestMethodContext> getCallMethods() {
        return this.callMethods;
    }

    public StackTraceDatabase getStackTraceDb() {
        return this.stackTraceDb;
    }

    public List<MethodExecStats> getMethodExecStats() {
        return this.methodExecStats.values().stream().sorted().collect(Collectors.toList());
    }

    public RestContextStats getStats() {
        return new RestContextStats(this.startTime, this.getMethodExecStats());
    }

    public String getMethodExecStatsReport() {
        StringBuilder sb = new StringBuilder().append(" Method                         Runs      Running   Errors   Avg          Total     \n").append("------------------------------ --------- --------- -------- ------------ -----------\n");
        this.getMethodExecStats().stream().sorted(Comparator.comparingDouble(MethodExecStats::getTotalTime).reversed()).forEach(x -> sb.append(String.format("%30s %9d %9d %9d %10dms %10dms\n", x.getMethod(), x.getRuns(), x.getRunning(), x.getErrors(), x.getAvgTime(), x.getTotalTime())));
        return sb.toString();
    }

    protected RestMethodParam[] findParams(MethodInfo mi, boolean isPreOrPost, UrlPathPattern pathPattern) throws ServletException {
        List pt = mi.getParamTypes();
        RestMethodParam[] rp = new RestMethodParam[pt.size()];
        PropertyStore ps = this.getPropertyStore();
        for (int i = 0; i < pt.size(); ++i) {
            ParamInfo mpi;
            ClassInfo t = (ClassInfo)pt.get(i);
            if (t.inner() != null) {
                Class c = t.inner();
                rp[i] = this.paramResolvers.get(c);
                if (rp[i] == null) {
                    rp[i] = RestParamDefaults.STANDARD_RESOLVERS.get(c);
                }
            }
            if ((mpi = mi.getParam(i)).hasAnnotation(Header.class)) {
                rp[i] = new RestParamDefaults.HeaderObject(mpi, ps);
            } else if (mpi.hasAnnotation(Attr.class)) {
                rp[i] = new RestParamDefaults.AttributeObject(mpi, ps);
            } else if (mpi.hasAnnotation(Query.class)) {
                rp[i] = new RestParamDefaults.QueryObject(mpi, ps);
            } else if (mpi.hasAnnotation(FormData.class)) {
                rp[i] = new RestParamDefaults.FormDataObject(mpi, ps);
            } else if (mpi.hasAnnotation(Path.class)) {
                rp[i] = new RestParamDefaults.PathObject(mpi, ps, pathPattern);
            } else if (mpi.hasAnnotation(Body.class)) {
                rp[i] = new RestParamDefaults.BodyObject(mpi, ps);
            } else if (mpi.hasAnnotation(Request.class)) {
                rp[i] = new RestParamDefaults.RequestObject(mpi, ps);
            } else if (mpi.hasAnnotation(Response.class)) {
                rp[i] = new RestParamDefaults.ResponseObject(mpi, ps);
            } else if (mpi.hasAnnotation(ResponseHeader.class)) {
                rp[i] = new RestParamDefaults.ResponseHeaderObject(mpi, ps);
            } else if (mpi.hasAnnotation(ResponseStatus.class)) {
                rp[i] = new RestParamDefaults.ResponseStatusObject(t);
            } else if (mpi.hasAnnotation(HasFormData.class)) {
                rp[i] = new RestParamDefaults.HasFormDataObject(mpi);
            } else if (mpi.hasAnnotation(HasQuery.class)) {
                rp[i] = new RestParamDefaults.HasQueryObject(mpi);
            } else if (mpi.hasAnnotation(Method.class)) {
                rp[i] = new RestParamDefaults.MethodObject(mi, t);
            }
            if (rp[i] != null || isPreOrPost) continue;
            throw new RestServletException("Invalid parameter specified for method ''{0}'' at index position {1}", mi.inner(), i);
        }
        return rp;
    }

    void preCall(RestRequest req, RestResponse res) throws HttpException {
        for (int i = 0; i < this.preCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.preCallMethods[i], this.preCallMethodParams[i], req, res);
        }
    }

    void postCall(RestRequest req, RestResponse res) throws HttpException {
        for (int i = 0; i < this.postCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.postCallMethods[i], this.postCallMethodParams[i], req, res);
        }
    }

    private static void preOrPost(Object resource, MethodInvoker m, RestMethodParam[] mp, RestRequest req, RestResponse res) throws HttpException {
        if (m != null) {
            Object[] args = new Object[mp.length];
            for (int i = 0; i < mp.length; ++i) {
                try {
                    args[i] = mp[i].resolve(req, res);
                    continue;
                }
                catch (Exception e) {
                    throw HttpRuntimeException.toHttpException(e, BadRequest.class, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", mp[i].getParamType().name(), mp[i].getName(), mp[i].getType(), m.getDeclaringClass().getName(), m.getName());
                }
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }
    }

    void startCall(RestCall call) {
        for (int i = 0; i < this.startCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.startCallMethods[i], this.startCallMethodParams[i], call.getRequest(), call.getResponse());
        }
    }

    void finishCall(RestCall call) {
        for (int i = 0; i < this.endCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.endCallMethods[i], this.endCallMethodParams[i], call.getRequest(), call.getResponse());
        }
    }

    private static void startOrFinish(Object resource, MethodInvoker m, Class<?>[] p, HttpServletRequest req, HttpServletResponse res) throws HttpException, InternalServerError {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == HttpServletRequest.class) {
                    args[i] = req;
                    continue;
                }
                if (p[i] != HttpServletResponse.class) continue;
                args[i] = res;
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }
    }

    public RestContext postInit() throws ServletException {
        for (int i = 0; i < this.postInitMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitMethods[i], this.postInitMethodParams[i]);
        }
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInit();
        }
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInitChildFirst();
        }
        for (int i = 0; i < this.postInitChildFirstMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitChildFirstMethods[i], this.postInitChildFirstMethodParams[i]);
        }
        return this;
    }

    private void postInitOrDestroy(Object r, MethodInvoker m, Class<?>[] p) {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == RestContext.class) {
                    args[i] = this;
                    continue;
                }
                if (p[i] == RestContextBuilder.class) {
                    args[i] = this.builder;
                    continue;
                }
                if (p[i] != ServletConfig.class) continue;
                args[i] = this.builder.inner;
            }
            try {
                m.invoke(r, args);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && ClassInfo.of((Object)e).hasAnnotation(Response.class)) {
                    throw (RuntimeException)e;
                }
                throw new InternalServerError((Throwable)e);
            }
        }
    }

    protected void destroy() {
        for (int i = 0; i < this.destroyMethods.length; ++i) {
            try {
                this.postInitOrDestroy(this.resource, this.destroyMethods[i], this.destroyMethodParams[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (RestContext r : this.childResources.values()) {
            r.destroy();
            if (!(r.resource instanceof Servlet)) continue;
            ((Servlet)r.resource).destroy();
        }
    }

    public RestRequest getRequest() {
        return this.req.get();
    }

    void setRequest(RestRequest req) {
        if (this.req.get() != null) {
            System.err.println("WARNING:  Thread-local request object was not cleaned up from previous request.  " + (Object)((Object)this) + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        this.req.set(req);
    }

    public RestResponse getResponse() {
        return this.res.get();
    }

    void setResponse(RestResponse res) {
        if (this.res.get() != null) {
            System.err.println("WARNING:  Thread-local response object was not cleaned up from previous request.  " + (Object)((Object)this) + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        this.res.set(res);
    }

    void clearState() {
        this.req.remove();
        this.res.remove();
    }

    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, (Object)new DefaultFilteringObjectMap().append("allowBodyParam", (Object)this.allowBodyParam).append("allowedMethodHeader", this.allowedMethodHeaders).append("allowedMethodParams", this.allowedMethodParams).append("allowedHeaderParams", this.allowedHeaderParams).append("callHandler", (Object)this.callHandler).append("clientVersionHeader", (Object)this.clientVersionHeader).append("consumes", this.consumes).append("infoProvider", (Object)this.infoProvider).append("logger", (Object)this.logger).append("paramResolvers", this.paramResolvers).append("parsers", (Object)this.parsers).append("partParser", (Object)this.partParser).append("partSerializer", (Object)this.partSerializer).append("produces", this.produces).append("properties", (Object)this.properties).append("renderResponseStackTraces", (Object)this.renderResponseStackTraces).append("reqHeaders", this.reqHeaders).append("resHeaders", this.resHeaders).append("resourceResolver", (Object)this.resourceResolver).append("responseHandlers", (Object)this.responseHandlers).append("serializers", (Object)this.serializers).append("staticFileResponseHeaders", this.staticFileResponseHeaders).append("staticFiles", (Object)this.staticFiles).append("uriAuthority", (Object)this.uriAuthority).append("uriContext", (Object)this.uriContext).append("uriRelativity", (Object)this.uriRelativity).append("uriResolution", (Object)this.uriResolution).append("useClasspathResourceCaching", (Object)this.useClasspathResourceCaching));
    }

    class StaticFile {
        StreamResource resource;
        ResponseBeanMeta meta;

        StaticFile(StreamResource resource) {
            this.resource = resource;
            this.meta = resource == null ? null : ResponseBeanMeta.create(resource.getClass(), (PropertyStore)RestContext.this.getPropertyStore());
        }
    }
}

