/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class SetPaginationTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final int ALLITEMS = -1;
    private int m_start;
    private int m_total;
    private int m_pagesize;
    private int m_maxlinks;
    private String m_fmtkey;
    private String m_href;
    private String m_onclick;

    @Override
    public void initTag() {
        super.initTag();
        this.m_start = 0;
        this.m_total = 0;
        this.m_pagesize = 20;
        this.m_maxlinks = 9;
        this.m_fmtkey = null;
        this.m_href = null;
        this.m_onclick = null;
    }

    public void setStart(int arg) {
        this.m_start = arg;
    }

    public void setTotal(int arg) {
        this.m_total = arg;
    }

    public void setPagesize(int arg) {
        this.m_pagesize = arg;
    }

    public void setMaxlinks(int arg) {
        this.m_maxlinks = arg;
        if (this.m_maxlinks % 2 == 0) {
            --this.m_maxlinks;
        }
    }

    public void setFmtkey(String arg) {
        this.m_fmtkey = arg;
    }

    public void setHref(String arg) {
        this.m_href = arg;
    }

    public void setOnclick(String arg) {
        this.m_onclick = arg;
    }

    @Override
    public int doWikiStartTag() throws IOException {
        if (this.m_total <= this.m_pagesize) {
            return 0;
        }
        StringBuilder pagination = new StringBuilder();
        if (this.m_start > this.m_total) {
            this.m_start = this.m_total;
        }
        if (this.m_start < -1) {
            this.m_start = 0;
        }
        int maxs = this.m_pagesize * this.m_maxlinks;
        int mids = this.m_pagesize * (this.m_maxlinks / 2);
        pagination.append("<div class='pagination'>");
        pagination.append(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)this.m_fmtkey)).append(" ");
        int cursor = 0;
        int cursormax = this.m_total;
        if (this.m_total > maxs) {
            if (this.m_start > mids) {
                cursor = this.m_start - mids;
            }
            if (cursor + maxs > this.m_total) {
                cursor = (1 + this.m_total / this.m_pagesize) * this.m_pagesize - maxs;
            }
            cursormax = cursor + maxs;
        }
        if (this.m_start == -1 || cursor > 0) {
            this.appendLink(pagination, 0, this.m_fmtkey + ".first");
        }
        if (this.m_start != -1 && this.m_start - this.m_pagesize >= 0) {
            this.appendLink(pagination, this.m_start - this.m_pagesize, this.m_fmtkey + ".previous");
        }
        if (this.m_start != -1) {
            while (cursor < cursormax) {
                if (cursor == this.m_start) {
                    pagination.append("<span class='cursor'>");
                    pagination.append(1 + cursor / this.m_pagesize);
                    pagination.append("</span>");
                } else {
                    this.appendLink(pagination, cursor, 1 + cursor / this.m_pagesize);
                }
                cursor += this.m_pagesize;
            }
        }
        if (this.m_start != -1 && this.m_start + this.m_pagesize < this.m_total) {
            this.appendLink(pagination, this.m_start + this.m_pagesize, this.m_fmtkey + ".next");
            if (this.m_start == -1 || cursormax < this.m_total) {
                this.appendLink(pagination, this.m_total / this.m_pagesize * this.m_pagesize, this.m_fmtkey + ".last");
            }
        }
        if (this.m_start == -1) {
            pagination.append("<span class='cursor'>");
            pagination.append(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)(this.m_fmtkey + ".all")));
            pagination.append("</span>&nbsp;&nbsp;");
        } else {
            this.appendLink(pagination, -1, this.m_fmtkey + ".all");
        }
        pagination.append(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)(this.m_fmtkey + ".total"), (Object[])new Object[]{this.m_total}));
        pagination.append("</div>");
        String p = pagination.toString();
        this.pageContext.getOut().println(p);
        this.pageContext.setAttribute("pagination", (Object)p);
        return 0;
    }

    private void appendLink(StringBuilder sb, int page, String fmttextkey) {
        this.appendLink2(sb, page, LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)fmttextkey));
    }

    private void appendLink(StringBuilder sb, int page, int paginationblock) {
        this.appendLink2(sb, page, Integer.toString(paginationblock));
    }

    private void appendLink2(StringBuilder sb, int page, String text) {
        sb.append("<a title=\"");
        if (page == -1) {
            sb.append(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)(this.m_fmtkey + ".showall.title")));
        } else {
            sb.append(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)(this.m_fmtkey + ".show.title"), (Object[])new Object[]{page + 1, page + this.m_pagesize}));
        }
        sb.append("\" ");
        if (this.m_href != null) {
            sb.append("href=\"");
            sb.append(TextUtil.replaceString((String)this.m_href, (String)"%s", (String)Integer.toString(page)));
            sb.append("\" ");
        }
        if (this.m_onclick != null) {
            sb.append("onclick=\"");
            sb.append(TextUtil.replaceString((String)this.m_onclick, (String)"%s", (String)Integer.toString(page)));
            sb.append("\" ");
        }
        sb.append(">");
        sb.append(text);
        sb.append("</a>");
    }
}

