/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import org.apache.commons.text.StringEscapeUtils;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.variables.VariableManager;
import org.jdom2.Text;

public class VariableContent
extends Text {
    private static final long serialVersionUID = 1L;
    private final String m_varName;

    public VariableContent(String varName) {
        this.m_varName = varName;
    }

    public String getValue() {
        Object result;
        WikiDocument root = (WikiDocument)this.getDocument();
        if (root == null) {
            return this.m_varName;
        }
        Context context = root.getContext();
        if (context == null) {
            return "No WikiContext available: INTERNAL ERROR";
        }
        Boolean wysiwygEditorMode = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
        if (wysiwygEditorMode != null && wysiwygEditorMode.booleanValue()) {
            result = "[" + this.m_varName + "]";
        } else {
            try {
                result = ((VariableManager)context.getEngine().getManager(VariableManager.class)).parseAndGetValue(context, this.m_varName);
            }
            catch (NoSuchVariableException e) {
                result = MarkupParser.makeError("No such variable: " + e.getMessage()).getText();
            }
        }
        return StringEscapeUtils.escapeXml11((String)result);
    }

    public String getText() {
        return this.getValue();
    }

    public String toString() {
        return "VariableElement[\"" + this.m_varName + "\"]";
    }
}

